/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassFileUtilities {
    public static final byte CONSTANT_UTF8_INFO = 1;
    public static final byte CONSTANT_INTEGER_INFO = 3;
    public static final byte CONSTANT_FLOAT_INFO = 4;
    public static final byte CONSTANT_LONG_INFO = 5;
    public static final byte CONSTANT_DOUBLE_INFO = 6;
    public static final byte CONSTANT_CLASS_INFO = 7;
    public static final byte CONSTANT_STRING_INFO = 8;
    public static final byte CONSTANT_FIELDREF_INFO = 9;
    public static final byte CONSTANT_METHODREF_INFO = 10;
    public static final byte CONSTANT_INTERFACEMETHODREF_INFO = 11;
    public static final byte CONSTANT_NAMEANDTYPE_INFO = 12;

    protected ClassFileUtilities() {
    }

    public static void main(String[] stringArray) {
        boolean bl2 = false;
        if (stringArray.length == 1 && stringArray[0].equals("-f")) {
            bl2 = true;
        } else if (stringArray.length != 0) {
            System.err.println("usage: org.apache.batik.util.ClassFileUtilities [-f]");
            System.err.println();
            System.err.println("  -f    list files that cause each jar file dependency");
            System.exit(1);
        }
        File file = new File(".");
        File file2 = null;
        String[] stringArray2 = file.list();
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            if (!stringArray2[i2].startsWith("batik-")) continue;
            file2 = new File(stringArray2[i2]);
            if (file2.isDirectory()) break;
            file2 = null;
        }
        if (file2 == null || !file2.isDirectory()) {
            System.out.println("Directory 'batik-xxx' not found in current directory!");
            return;
        }
        try {
            Iterator iterator;
            Object object5;
            Object object22;
            Object object32;
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            ClassFileUtilities.collectJars(file2, hashMap2, hashMap);
            HashSet<JarFile> hashSet = new HashSet<JarFile>();
            Iterator<Object> iterator2 = hashMap2.values().iterator();
            while (iterator2.hasNext()) {
                hashSet.add(((Jar)iterator2.next()).jarFile);
            }
            for (Object object32 : hashMap.values()) {
                object22 = ClassFileUtilities.getClassDependencies(((ClassFile)object32).getInputStream(), hashSet, false);
                Iterator<Object> iterator3 = object22.iterator();
                while (iterator3.hasNext()) {
                    object5 = (ClassFile)hashMap.get(iterator3.next());
                    if (object32 == object5 || object5 == null) continue;
                    ((ClassFile)object32).deps.add(object5);
                }
            }
            for (Object object32 : hashMap.values()) {
                for (Iterator<Object> iterator3 : ((ClassFile)object32).deps) {
                    object5 = ((ClassFile)object32).jar;
                    iterator = ((ClassFile)((Object)iterator3)).jar;
                    if (((ClassFile)object32).name.equals(((ClassFile)((Object)iterator3)).name) || iterator == object5 || ((Jar)object5).files.contains(((ClassFile)((Object)iterator3)).name)) continue;
                    Object object4 = (Integer)((Jar)object5).deps.get(iterator);
                    if (object4 == null) {
                        ((Jar)object5).deps.put(iterator, new Integer(1));
                        continue;
                    }
                    ((Jar)object5).deps.put(iterator, new Integer((Integer)object4 + 1));
                }
            }
            object32 = new ArrayList(10);
            for (Object object22 : hashMap2.values()) {
                for (Object object5 : ((Jar)object22).deps.keySet()) {
                    iterator = new Triple();
                    ((Triple)((Object)iterator)).from = object22;
                    ((Triple)((Object)iterator)).to = object5;
                    ((Triple)((Object)iterator)).count = (Integer)((Jar)object22).deps.get(object5);
                    object32.add(iterator);
                }
            }
            Collections.sort(object32);
            iterator2 = object32.iterator();
            while (iterator2.hasNext()) {
                object22 = (Triple)iterator2.next();
                System.out.println(((Triple)object22).count + "," + ((Triple)object22).from.name + "," + ((Triple)object22).to.name);
                if (!bl2) continue;
                for (Object object5 : ((Triple)object22).from.files) {
                    for (Object object4 : ((ClassFile)object5).deps) {
                        if (((ClassFile)object4).jar != ((Triple)object22).to || ((Triple)object22).from.files.contains(((ClassFile)object4).name)) continue;
                        System.out.println("\t" + ((ClassFile)object5).name + " --> " + ((ClassFile)object4).name);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void collectJars(File file, Map map, Map map2) throws IOException {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            String string2 = fileArray[i2].getName();
            if (string2.endsWith(".jar") && fileArray[i2].isFile()) {
                Jar jar = new Jar();
                jar.name = fileArray[i2].getPath();
                jar.file = fileArray[i2];
                jar.jarFile = new JarFile(fileArray[i2]);
                map.put(jar.name, jar);
                Enumeration<JarEntry> enumeration = jar.jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string3 = zipEntry.getName();
                    if (!string3.endsWith(".class")) continue;
                    ClassFile classFile = new ClassFile();
                    classFile.name = string3;
                    classFile.jar = jar;
                    map2.put(jar.name + '!' + classFile.name, classFile);
                    jar.files.add(classFile);
                }
                continue;
            }
            if (!fileArray[i2].isDirectory()) continue;
            ClassFileUtilities.collectJars(fileArray[i2], map, map2);
        }
    }

    public static Set getClassDependencies(String string2, Set set, boolean bl2) throws IOException {
        return ClassFileUtilities.getClassDependencies(new FileInputStream(string2), set, bl2);
    }

    public static Set getClassDependencies(InputStream inputStream, Set set, boolean bl2) throws IOException {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        ClassFileUtilities.computeClassDependencies(inputStream, set, hashSet2, hashSet, bl2);
        return hashSet;
    }

    private static void computeClassDependencies(InputStream inputStream, Set set, Set set2, Set set3, boolean bl2) throws IOException {
        for (String string2 : ClassFileUtilities.getClassDependencies(inputStream)) {
            if (set2.contains(string2)) continue;
            set2.add(string2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object;
                InputStream inputStream2 = null;
                String string3 = null;
                Object e2 = iterator.next();
                if (e2 instanceof JarFile) {
                    object = (JarFile)e2;
                    String string4 = string2 + ".class";
                    ZipEntry zipEntry = ((JarFile)object).getEntry(string4);
                    if (zipEntry != null) {
                        string3 = ((ZipFile)object).getName() + '!' + string4;
                        inputStream2 = ((JarFile)object).getInputStream(zipEntry);
                    }
                } else {
                    string3 = (String)e2 + '/' + string2 + ".class";
                    object = new File(string3);
                    if (((File)object).isFile()) {
                        inputStream2 = new FileInputStream((File)object);
                    }
                }
                if (inputStream2 == null) continue;
                set3.add(string3);
                if (!bl2) continue;
                ClassFileUtilities.computeClassDependencies(inputStream2, set, set2, set3, bl2);
            }
        }
    }

    public static Set getClassDependencies(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (dataInputStream.readInt() != -889275714) {
            throw new IOException("Invalid classfile");
        }
        dataInputStream.readInt();
        int n2 = dataInputStream.readShort();
        String[] stringArray = new String[n2];
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        block8: for (int i2 = 1; i2 < n2; ++i2) {
            int n3 = dataInputStream.readByte() & 0xFF;
            switch (n3) {
                case 5: 
                case 6: {
                    dataInputStream.readLong();
                    ++i2;
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    dataInputStream.readInt();
                    continue block8;
                }
                case 7: {
                    hashSet.add(new Integer(dataInputStream.readShort() & 0xFFFF));
                    continue block8;
                }
                case 8: {
                    dataInputStream.readShort();
                    continue block8;
                }
                case 12: {
                    dataInputStream.readShort();
                    hashSet2.add(new Integer(dataInputStream.readShort() & 0xFFFF));
                    continue block8;
                }
                case 1: {
                    stringArray[i2] = dataInputStream.readUTF();
                    continue block8;
                }
                default: {
                    throw new RuntimeException("unexpected data in constant-pool:" + n3);
                }
            }
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            hashSet3.add(stringArray[(Integer)iterator.next()]);
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            hashSet3.addAll(ClassFileUtilities.getDescriptorClasses(stringArray[(Integer)iterator.next()]));
        }
        return hashSet3;
    }

    protected static Set getDescriptorClasses(String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        char c2 = string2.charAt(n2);
        switch (c2) {
            case '(': {
                StringBuffer stringBuffer;
                block14: while (true) {
                    c2 = string2.charAt(++n2);
                    switch (c2) {
                        case '[': {
                            while ((c2 = string2.charAt(++n2)) == '[') {
                            }
                            if (c2 != 'L') continue block14;
                        }
                        case 'L': {
                            c2 = string2.charAt(++n2);
                            stringBuffer = new StringBuffer();
                            while (c2 != ';') {
                                stringBuffer.append(c2);
                                c2 = string2.charAt(++n2);
                            }
                            hashSet.add(stringBuffer.toString());
                            break;
                        }
                        default: {
                            break;
                        }
                        case ')': {
                            break block14;
                        }
                    }
                }
                c2 = string2.charAt(++n2);
                switch (c2) {
                    case '[': {
                        while ((c2 = string2.charAt(++n2)) == '[') {
                        }
                        if (c2 != 'L') break;
                    }
                    case 'L': {
                        c2 = string2.charAt(++n2);
                        stringBuffer = new StringBuffer();
                        while (c2 != ';') {
                            stringBuffer.append(c2);
                            c2 = string2.charAt(++n2);
                        }
                        hashSet.add(stringBuffer.toString());
                        break;
                    }
                }
                break;
            }
            case '[': {
                while ((c2 = string2.charAt(++n2)) == '[') {
                }
                if (c2 != 'L') break;
            }
            case 'L': {
                c2 = string2.charAt(++n2);
                StringBuffer stringBuffer = new StringBuffer();
                while (c2 != ';') {
                    stringBuffer.append(c2);
                    c2 = string2.charAt(++n2);
                }
                hashSet.add(stringBuffer.toString());
                break;
            }
        }
        return hashSet;
    }

    protected static class Triple
    implements Comparable {
        public Jar from;
        public Jar to;
        public int count;

        protected Triple() {
        }

        public int compareTo(Object object) {
            return ((Triple)object).count - this.count;
        }
    }

    protected static class Jar {
        public String name;
        public File file;
        public JarFile jarFile;
        public Map deps = new HashMap();
        public Set files = new HashSet();

        protected Jar() {
        }
    }

    protected static class ClassFile {
        public String name;
        public List deps = new ArrayList(10);
        public Jar jar;

        protected ClassFile() {
        }

        public InputStream getInputStream() throws IOException {
            return this.jar.jarFile.getInputStream(this.jar.jarFile.getEntry(this.name));
        }
    }
}

