/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat0;
import org.apache.batik.svggen.font.table.CmapFormat2;
import org.apache.batik.svggen.font.table.CmapFormat4;
import org.apache.batik.svggen.font.table.CmapFormat6;

public abstract class CmapFormat {
    protected int format;
    protected int length;
    protected int version;

    protected CmapFormat(RandomAccessFile randomAccessFile) throws IOException {
        this.length = randomAccessFile.readUnsignedShort();
        this.version = randomAccessFile.readUnsignedShort();
    }

    protected static CmapFormat create(int n2, RandomAccessFile randomAccessFile) throws IOException {
        switch (n2) {
            case 0: {
                return new CmapFormat0(randomAccessFile);
            }
            case 2: {
                return new CmapFormat2(randomAccessFile);
            }
            case 4: {
                return new CmapFormat4(randomAccessFile);
            }
            case 6: {
                return new CmapFormat6(randomAccessFile);
            }
        }
        return null;
    }

    public int getFormat() {
        return this.format;
    }

    public int getLength() {
        return this.length;
    }

    public int getVersion() {
        return this.version;
    }

    public abstract int mapCharCode(int var1);

    public abstract int getFirst();

    public abstract int getLast();

    public String toString() {
        return new StringBuffer().append("format: ").append(this.format).append(", length: ").append(this.length).append(", version: ").append(this.version).toString();
    }
}

