/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.util.Stack;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.ext.awt.g2d.TransformStackElement;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGTransformDescriptor;

public class SVGTransform
extends AbstractSVGConverter {
    private static double radiansToDegrees = 57.29577951308232;

    public SVGTransform(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return new SVGTransformDescriptor(this.toSVGTransform(graphicContext));
    }

    public final String toSVGTransform(GraphicContext graphicContext) {
        return this.toSVGTransform(graphicContext.getTransformStack());
    }

    public final String toSVGTransform(TransformStackElement[] transformStackElementArray) {
        int n2 = transformStackElementArray.length;
        Stack stack = new Stack(){

            public Object push(Object object) {
                Object object2;
                if (((TransformStackElement)object).isIdentity()) {
                    object2 = this.pop();
                } else {
                    super.push(object);
                    object2 = null;
                }
                return object2;
            }

            public Object pop() {
                Object var1_1 = null;
                if (!super.empty()) {
                    var1_1 = super.pop();
                }
                return var1_1;
            }
        };
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        TransformStackElement transformStackElement = null;
        while (n3 < n2) {
            n5 = n3;
            if (transformStackElement == null) {
                transformStackElement = (TransformStackElement)transformStackElementArray[n3].clone();
            }
            bl2 = true;
            for (n4 = ++n5; n4 < n2 && (bl2 = transformStackElement.concatenate(transformStackElementArray[n4])); ++n4) {
            }
            n3 = n4;
            transformStackElement = stack.push(transformStackElement);
        }
        if (transformStackElement != null) {
            stack.push(transformStackElement);
        }
        int n6 = stack.size();
        StringBuffer stringBuffer = new StringBuffer(n6 * 8);
        for (n3 = 0; n3 < n6; ++n3) {
            stringBuffer.append(this.convertTransform((TransformStackElement)stack.get(n3)));
            stringBuffer.append(" ");
        }
        String string2 = stringBuffer.toString().trim();
        return string2;
    }

    final String convertTransform(TransformStackElement transformStackElement) {
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = transformStackElement.getTransformParameters();
        switch (transformStackElement.getType().toInt()) {
            case 0: {
                if (transformStackElement.isIdentity()) break;
                stringBuffer.append("translate");
                stringBuffer.append("(");
                stringBuffer.append(this.doubleString(dArray[0]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[1]));
                stringBuffer.append(")");
                break;
            }
            case 1: {
                if (transformStackElement.isIdentity()) break;
                stringBuffer.append("rotate");
                stringBuffer.append("(");
                stringBuffer.append(this.doubleString(radiansToDegrees * dArray[0]));
                stringBuffer.append(")");
                break;
            }
            case 2: {
                if (transformStackElement.isIdentity()) break;
                stringBuffer.append("scale");
                stringBuffer.append("(");
                stringBuffer.append(this.doubleString(dArray[0]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[1]));
                stringBuffer.append(")");
                break;
            }
            case 3: {
                if (transformStackElement.isIdentity()) break;
                stringBuffer.append("matrix");
                stringBuffer.append("(");
                stringBuffer.append(1);
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[1]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[0]));
                stringBuffer.append(",");
                stringBuffer.append(1);
                stringBuffer.append(",");
                stringBuffer.append(0);
                stringBuffer.append(",");
                stringBuffer.append(0);
                stringBuffer.append(")");
                break;
            }
            case 4: {
                if (transformStackElement.isIdentity()) break;
                stringBuffer.append("matrix");
                stringBuffer.append("(");
                stringBuffer.append(this.doubleString(dArray[0]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[1]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[2]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[3]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[4]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[5]));
                stringBuffer.append(")");
                break;
            }
            default: {
                throw new Error();
            }
        }
        return stringBuffer.toString();
    }
}

