/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGTexturePaint
extends AbstractSVGConverter {
    public SVGTexturePaint(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return this.toSVG((TexturePaint)graphicContext.getPaint());
    }

    public SVGPaintDescriptor toSVG(TexturePaint texturePaint) {
        SVGPaintDescriptor sVGPaintDescriptor = (SVGPaintDescriptor)this.descMap.get(texturePaint);
        Document document = this.generatorContext.domFactory;
        if (sVGPaintDescriptor == null) {
            Rectangle2D rectangle2D = texturePaint.getAnchorRect();
            Element element = document.createElementNS("http://www.w3.org/2000/svg", "pattern");
            element.setAttributeNS(null, "patternUnits", "userSpaceOnUse");
            element.setAttributeNS(null, "x", this.doubleString(rectangle2D.getX()));
            element.setAttributeNS(null, "y", this.doubleString(rectangle2D.getY()));
            element.setAttributeNS(null, "width", this.doubleString(rectangle2D.getWidth()));
            element.setAttributeNS(null, "height", this.doubleString(rectangle2D.getHeight()));
            BufferedImage bufferedImage = texturePaint.getImage();
            if (bufferedImage.getWidth() > 0 && bufferedImage.getHeight() > 0 && ((double)bufferedImage.getWidth() != rectangle2D.getWidth() || (double)bufferedImage.getHeight() != rectangle2D.getHeight()) && rectangle2D.getWidth() > 0.0 && rectangle2D.getHeight() > 0.0) {
                double d2 = rectangle2D.getWidth() / (double)bufferedImage.getWidth();
                double d3 = rectangle2D.getHeight() / (double)bufferedImage.getHeight();
                BufferedImage bufferedImage2 = new BufferedImage((int)(d2 * (double)bufferedImage.getWidth()), (int)(d3 * (double)bufferedImage.getHeight()), 2);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.scale(d2, d3);
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                graphics2D.dispose();
                bufferedImage = bufferedImage2;
            }
            Element element2 = this.generatorContext.genericImageHandler.createElement(this.generatorContext);
            this.generatorContext.genericImageHandler.handleImage(bufferedImage, element2, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), this.generatorContext);
            element.appendChild(element2);
            element.setAttributeNS(null, "id", this.generatorContext.idGenerator.generateID("pattern"));
            String string2 = "url(#" + element.getAttributeNS(null, "id") + ")";
            sVGPaintDescriptor = new SVGPaintDescriptor(string2, "1", element);
            this.descMap.put(texturePaint, sVGPaintDescriptor);
            this.defSet.add(element);
        }
        return sVGPaintDescriptor;
    }
}

