/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.BasicStroke;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGStrokeDescriptor;

public class SVGBasicStroke
extends AbstractSVGConverter {
    public SVGBasicStroke(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        if (graphicContext.getStroke() instanceof BasicStroke) {
            return this.toSVG((BasicStroke)graphicContext.getStroke());
        }
        return null;
    }

    public final SVGStrokeDescriptor toSVG(BasicStroke basicStroke) {
        String string2 = this.doubleString(basicStroke.getLineWidth());
        String string3 = SVGBasicStroke.endCapToSVG(basicStroke.getEndCap());
        String string4 = SVGBasicStroke.joinToSVG(basicStroke.getLineJoin());
        String string5 = this.doubleString(basicStroke.getMiterLimit());
        float[] fArray = basicStroke.getDashArray();
        String string6 = null;
        string6 = fArray != null ? this.dashArrayToSVG(fArray) : "none";
        String string7 = this.doubleString(basicStroke.getDashPhase());
        return new SVGStrokeDescriptor(string2, string3, string4, string5, string6, string7);
    }

    private final String dashArrayToSVG(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer(fArray.length * 8);
        if (fArray.length > 0) {
            stringBuffer.append(this.doubleString(fArray[0]));
        }
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            stringBuffer.append(",");
            stringBuffer.append(this.doubleString(fArray[i2]));
        }
        return stringBuffer.toString();
    }

    private static String joinToSVG(int n2) {
        switch (n2) {
            case 2: {
                return "bevel";
            }
            case 1: {
                return "round";
            }
        }
        return "miter";
    }

    private static String endCapToSVG(int n2) {
        switch (n2) {
            case 0: {
                return "butt";
            }
            case 1: {
                return "round";
            }
        }
        return "square";
    }
}

