/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.AlphaComposite;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGCompositeDescriptor;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.w3c.dom.Element;

public class SVGAlphaComposite
extends AbstractSVGConverter {
    private Map compositeDefsMap = new HashMap();
    private boolean backgroundAccessRequired = false;

    public SVGAlphaComposite(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
        this.compositeDefsMap.put(AlphaComposite.Src, this.compositeToSVG(AlphaComposite.Src));
        this.compositeDefsMap.put(AlphaComposite.SrcIn, this.compositeToSVG(AlphaComposite.SrcIn));
        this.compositeDefsMap.put(AlphaComposite.SrcOut, this.compositeToSVG(AlphaComposite.SrcOut));
        this.compositeDefsMap.put(AlphaComposite.DstIn, this.compositeToSVG(AlphaComposite.DstIn));
        this.compositeDefsMap.put(AlphaComposite.DstOut, this.compositeToSVG(AlphaComposite.DstOut));
        this.compositeDefsMap.put(AlphaComposite.DstOver, this.compositeToSVG(AlphaComposite.DstOver));
        this.compositeDefsMap.put(AlphaComposite.Clear, this.compositeToSVG(AlphaComposite.Clear));
    }

    public List getAlphaCompositeFilterSet() {
        return new LinkedList(this.compositeDefsMap.values());
    }

    public boolean requiresBackgroundAccess() {
        return this.backgroundAccessRequired;
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return this.toSVG((AlphaComposite)graphicContext.getComposite());
    }

    public SVGCompositeDescriptor toSVG(AlphaComposite alphaComposite) {
        SVGCompositeDescriptor sVGCompositeDescriptor = (SVGCompositeDescriptor)this.descMap.get(alphaComposite);
        if (sVGCompositeDescriptor == null) {
            String string2 = this.doubleString(alphaComposite.getAlpha());
            String string3 = null;
            Element element = null;
            if (alphaComposite.getRule() != 3) {
                AlphaComposite alphaComposite2 = AlphaComposite.getInstance(alphaComposite.getRule());
                element = (Element)this.compositeDefsMap.get(alphaComposite2);
                this.defSet.add(element);
                StringBuffer stringBuffer = new StringBuffer("url(");
                stringBuffer.append("#");
                stringBuffer.append(element.getAttributeNS(null, "id"));
                stringBuffer.append(")");
                string3 = stringBuffer.toString();
            } else {
                string3 = "none";
            }
            sVGCompositeDescriptor = new SVGCompositeDescriptor(string2, string3, element);
            this.descMap.put(alphaComposite, sVGCompositeDescriptor);
        }
        if (alphaComposite.getRule() != 3) {
            this.backgroundAccessRequired = true;
        }
        return sVGCompositeDescriptor;
    }

    private Element compositeToSVG(AlphaComposite alphaComposite) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "0";
        String string6 = null;
        switch (alphaComposite.getRule()) {
            case 1: {
                string2 = "arithmetic";
                string3 = "SourceGraphic";
                string4 = "BackgroundImage";
                string6 = "alphaCompositeClear";
                break;
            }
            case 2: {
                string2 = "arithmetic";
                string3 = "SourceGraphic";
                string4 = "BackgroundImage";
                string6 = "alphaCompositeSrc";
                string5 = "1";
                break;
            }
            case 5: {
                string2 = "in";
                string3 = "SourceGraphic";
                string4 = "BackgroundImage";
                string6 = "alphaCompositeSrcIn";
                break;
            }
            case 7: {
                string2 = "out";
                string3 = "SourceGraphic";
                string4 = "BackgroundImage";
                string6 = "alphaCompositeSrcOut";
                break;
            }
            case 6: {
                string2 = "in";
                string4 = "SourceGraphic";
                string3 = "BackgroundImage";
                string6 = "alphaCompositeDstIn";
                break;
            }
            case 8: {
                string2 = "out";
                string4 = "SourceGraphic";
                string3 = "BackgroundImage";
                string6 = "alphaCompositeDstOut";
                break;
            }
            case 4: {
                string2 = "over";
                string4 = "SourceGraphic";
                string3 = "BackgroundImage";
                string6 = "alphaCompositeDstOver";
                break;
            }
            default: {
                throw new Error("invalid rule:" + alphaComposite.getRule());
            }
        }
        Element element = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "filter");
        element.setAttributeNS(null, "id", string6);
        element.setAttributeNS(null, "filterUnits", "objectBoundingBox");
        element.setAttributeNS(null, "x", "0%");
        element.setAttributeNS(null, "y", "0%");
        element.setAttributeNS(null, "width", "100%");
        element.setAttributeNS(null, "height", "100%");
        Element element2 = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "feComposite");
        element2.setAttributeNS(null, "operator", string2);
        element2.setAttributeNS(null, "in", string3);
        element2.setAttributeNS(null, "in2", string4);
        element2.setAttributeNS(null, "k2", string5);
        element2.setAttributeNS(null, "result", "composite");
        Element element3 = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "feFlood");
        element3.setAttributeNS(null, "flood-color", "white");
        element3.setAttributeNS(null, "flood-opacity", "1");
        element3.setAttributeNS(null, "result", "flood");
        Element element4 = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "feMerge");
        Element element5 = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "feMergeNode");
        element5.setAttributeNS(null, "in", "flood");
        Element element6 = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "feMergeNode");
        element6.setAttributeNS(null, "in", "composite");
        element4.appendChild(element5);
        element4.appendChild(element6);
        element.appendChild(element3);
        element.appendChild(element2);
        element.appendChild(element4);
        return element;
    }
}

