/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ImageCacher
implements SVGSyntax,
ErrorConstants {
    DOMTreeManager domTreeManager = null;
    Map imageCache = new HashMap();
    Checksum checkSum = new Adler32();

    public ImageCacher() {
    }

    public ImageCacher(DOMTreeManager dOMTreeManager) {
        this();
        this.setDOMTreeManager(dOMTreeManager);
    }

    public void setDOMTreeManager(DOMTreeManager dOMTreeManager) {
        if (dOMTreeManager == null) {
            throw new IllegalArgumentException();
        }
        this.domTreeManager = dOMTreeManager;
    }

    public DOMTreeManager getDOMTreeManager() {
        return this.domTreeManager;
    }

    public String lookup(ByteArrayOutputStream byteArrayOutputStream, int n2, int n3, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        Object object;
        int n4 = this.getChecksum(byteArrayOutputStream.toByteArray());
        Integer n5 = new Integer(n4);
        String string2 = null;
        Object object2 = this.getCacheableData(byteArrayOutputStream);
        LinkedList<Object> linkedList = (LinkedList<Object>)this.imageCache.get(n5);
        if (linkedList == null) {
            linkedList = new LinkedList<Object>();
            this.imageCache.put(n5, linkedList);
        } else {
            object = linkedList.listIterator(0);
            while (object.hasNext()) {
                ImageCacheEntry imageCacheEntry = (ImageCacheEntry)object.next();
                if (imageCacheEntry.checksum != n4 || !this.imagesMatch(imageCacheEntry.src, object2)) continue;
                string2 = imageCacheEntry.href;
                break;
            }
        }
        if (string2 == null) {
            object = this.createEntry(n4, object2, n2, n3, sVGGeneratorContext);
            linkedList.add(object);
            string2 = ((ImageCacheEntry)object).href;
        }
        return string2;
    }

    abstract Object getCacheableData(ByteArrayOutputStream var1);

    abstract boolean imagesMatch(Object var1, Object var2) throws SVGGraphics2DIOException;

    abstract ImageCacheEntry createEntry(int var1, Object var2, int var3, int var4, SVGGeneratorContext var5) throws SVGGraphics2DIOException;

    int getChecksum(byte[] byArray) {
        this.checkSum.reset();
        this.checkSum.update(byArray, 0, byArray.length);
        return (int)this.checkSum.getValue();
    }

    public static class External
    extends ImageCacher {
        private String imageDir;
        private String prefix;
        private String suffix;

        public External(String string2, String string3, String string4) {
            this.imageDir = string2;
            this.prefix = string3;
            this.suffix = string4;
        }

        @Override
        Object getCacheableData(ByteArrayOutputStream byteArrayOutputStream) {
            return byteArrayOutputStream;
        }

        @Override
        boolean imagesMatch(Object object, Object object2) throws SVGGraphics2DIOException {
            boolean bl2 = false;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream((File)object);
                int n2 = fileInputStream.available();
                byte[] byArray = new byte[n2];
                byte[] byArray2 = ((ByteArrayOutputStream)object2).toByteArray();
                for (int i2 = 0; i2 != n2; i2 += fileInputStream.read(byArray, i2, n2 - i2)) {
                }
                bl2 = Arrays.equals(byArray, byArray2);
            }
            catch (IOException iOException) {
                throw new SVGGraphics2DIOException("could not read image File " + ((File)object).getName());
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return bl2;
        }

        @Override
        ImageCacheEntry createEntry(int n2, Object object, int n3, int n4, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
            File file = null;
            try {
                Object object2;
                while (file == null) {
                    object2 = sVGGeneratorContext.idGenerator.generateID(this.prefix);
                    file = new File(this.imageDir, (String)object2 + this.suffix);
                    if (!file.exists()) continue;
                    file = null;
                }
                object2 = new FileOutputStream(file);
                ((ByteArrayOutputStream)object).writeTo((OutputStream)object2);
                ((ByteArrayOutputStream)object).close();
            }
            catch (IOException iOException) {
                throw new SVGGraphics2DIOException("could not write image File " + file.getName());
            }
            return new ImageCacheEntry(n2, file, file.getName());
        }
    }

    public static class Embedded
    extends ImageCacher {
        @Override
        public void setDOMTreeManager(DOMTreeManager dOMTreeManager) {
            if (this.domTreeManager != dOMTreeManager) {
                this.domTreeManager = dOMTreeManager;
                this.imageCache = new HashMap();
            }
        }

        @Override
        Object getCacheableData(ByteArrayOutputStream byteArrayOutputStream) {
            return "data:image/png;base64," + byteArrayOutputStream.toString();
        }

        @Override
        boolean imagesMatch(Object object, Object object2) {
            return object.equals(object2);
        }

        @Override
        ImageCacheEntry createEntry(int n2, Object object, int n3, int n4, SVGGeneratorContext sVGGeneratorContext) {
            String string2 = sVGGeneratorContext.idGenerator.generateID("image");
            this.addToTree(string2, (String)object, n3, n4, sVGGeneratorContext);
            return new ImageCacheEntry(n2, object, "#" + string2);
        }

        private void addToTree(String string2, String string3, int n2, int n3, SVGGeneratorContext sVGGeneratorContext) {
            Document document = this.domTreeManager.getDOMFactory();
            Element element = document.createElementNS("http://www.w3.org/2000/svg", "image");
            element.setAttributeNS(null, "id", string2);
            element.setAttributeNS(null, "width", Integer.toString(n2));
            element.setAttributeNS(null, "height", Integer.toString(n3));
            element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", string3);
            this.domTreeManager.addOtherDef(element);
        }
    }

    private static class ImageCacheEntry {
        public int checksum;
        public Object src;
        public String href;

        ImageCacheEntry(int n2, Object object, String string2) {
            this.checksum = n2;
            this.src = object;
            this.href = string2;
        }
    }
}

