/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.i18n;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.batik.i18n.LocaleGroup;
import org.apache.batik.i18n.Localizable;

public class LocalizableSupport
implements Localizable {
    protected LocaleGroup localeGroup = LocaleGroup.DEFAULT;
    protected String bundleName;
    protected ClassLoader classLoader;
    protected Locale locale;
    protected Locale usedLocale;
    List resourceBundles = new ArrayList();
    Class lastResourceClass;
    Class cls;

    public LocalizableSupport(String string2, Class clazz) {
        this(string2, clazz, null);
    }

    public LocalizableSupport(String string2, Class clazz, ClassLoader classLoader) {
        this.bundleName = string2;
        this.cls = clazz;
        this.classLoader = classLoader;
    }

    public LocalizableSupport(String string2) {
        this(string2, (ClassLoader)null);
    }

    public LocalizableSupport(String string2, ClassLoader classLoader) {
        this.bundleName = string2;
        this.classLoader = classLoader;
    }

    @Override
    public void setLocale(Locale locale2) {
        if (this.locale != locale2) {
            this.locale = locale2;
            this.resourceBundles.clear();
            this.lastResourceClass = null;
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocaleGroup(LocaleGroup localeGroup) {
        this.localeGroup = localeGroup;
    }

    public LocaleGroup getLocaleGroup() {
        return this.localeGroup;
    }

    public void setDefaultLocale(Locale locale2) {
        this.localeGroup.setLocale(locale2);
    }

    public Locale getDefaultLocale() {
        return this.localeGroup.getLocale();
    }

    @Override
    public String formatMessage(String string2, Object[] objectArray) {
        return MessageFormat.format(this.getString(string2), objectArray);
    }

    protected Locale getCurrentLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        Locale locale2 = this.localeGroup.getLocale();
        if (locale2 != null) {
            return locale2;
        }
        return Locale.getDefault();
    }

    protected boolean setUsedLocale() {
        Locale locale2 = this.getCurrentLocale();
        if (this.usedLocale == locale2) {
            return false;
        }
        this.usedLocale = locale2;
        this.resourceBundles.clear();
        this.lastResourceClass = null;
        return true;
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(0);
    }

    protected boolean hasNextResourceBundle(int n2) {
        if (n2 == 0) {
            return true;
        }
        if (n2 < this.resourceBundles.size()) {
            return true;
        }
        if (this.lastResourceClass == null) {
            return false;
        }
        return this.lastResourceClass != Object.class;
    }

    protected ResourceBundle lookupResourceBundle(String string2, Class clazz) {
        ClassLoader classLoader = this.classLoader;
        ResourceBundle resourceBundle = null;
        if (classLoader != null) {
            try {
                resourceBundle = ResourceBundle.getBundle(string2, this.usedLocale, classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resourceBundle != null) {
                return resourceBundle;
            }
        }
        if (clazz != null) {
            try {
                classLoader = clazz.getClassLoader();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            resourceBundle = ResourceBundle.getBundle(string2, this.usedLocale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return resourceBundle;
    }

    protected ResourceBundle getResourceBundle(int n2) {
        this.setUsedLocale();
        ResourceBundle resourceBundle = null;
        if (this.cls == null) {
            if (this.resourceBundles.size() == 0) {
                resourceBundle = this.lookupResourceBundle(this.bundleName, null);
                this.resourceBundles.add(resourceBundle);
            }
            return (ResourceBundle)this.resourceBundles.get(0);
        }
        while (n2 >= this.resourceBundles.size()) {
            if (this.lastResourceClass == Object.class) {
                return null;
            }
            this.lastResourceClass = this.lastResourceClass == null ? this.cls : this.lastResourceClass.getSuperclass();
            Class clazz = this.lastResourceClass;
            String string2 = clazz.getPackage().getName() + "." + this.bundleName;
            this.resourceBundles.add(this.lookupResourceBundle(string2, clazz));
        }
        return (ResourceBundle)this.resourceBundles.get(n2);
    }

    public String getString(String string2) throws MissingResourceException {
        this.setUsedLocale();
        int n2 = 0;
        while (this.hasNextResourceBundle(n2)) {
            ResourceBundle resourceBundle = this.getResourceBundle(n2);
            if (resourceBundle != null) {
                try {
                    String string3 = resourceBundle.getString(string2);
                    if (string3 != null) {
                        return string3;
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        String string4 = this.cls != null ? this.cls.toString() : this.bundleName;
        throw new MissingResourceException("Unable to find resource: " + string2, string4, string2);
    }

    public int getInteger(String string2) throws MissingResourceException {
        String string3 = this.getString(string2);
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MissingResourceException("Malformed integer", this.bundleName, string2);
        }
    }

    public int getCharacter(String string2) throws MissingResourceException {
        String string3 = this.getString(string2);
        if (string3 == null || string3.length() == 0) {
            throw new MissingResourceException("Malformed character", this.bundleName, string2);
        }
        return string3.charAt(0);
    }
}

