/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class TranslateRed
extends AbstractRed {
    protected int deltaX;
    protected int deltaY;

    public TranslateRed(CachableRed cachableRed, int n2, int n3) {
        super(cachableRed, new Rectangle(n2, n3, cachableRed.getWidth(), cachableRed.getHeight()), cachableRed.getColorModel(), cachableRed.getSampleModel(), cachableRed.getTileGridXOffset() + n2 - cachableRed.getMinX(), cachableRed.getTileGridYOffset() + n3 - cachableRed.getMinY(), null);
        this.deltaX = n2 - cachableRed.getMinX();
        this.deltaY = n3 - cachableRed.getMinY();
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public CachableRed getSource() {
        return (CachableRed)this.getSources().get(0);
    }

    @Override
    public Object getProperty(String string2) {
        return this.getSource().getProperty(string2);
    }

    @Override
    public String[] getPropertyNames() {
        return this.getSource().getPropertyNames();
    }

    @Override
    public Raster getTile(int n2, int n3) {
        Raster raster = this.getSource().getTile(n2, n3);
        return raster.createTranslatedChild(raster.getMinX() + this.deltaX, raster.getMinY() + this.deltaY);
    }

    @Override
    public Raster getData() {
        Raster raster = this.getSource().getData();
        return raster.createTranslatedChild(raster.getMinX() + this.deltaX, raster.getMinY() + this.deltaY);
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        Rectangle rectangle2 = (Rectangle)rectangle.clone();
        rectangle2.translate(-this.deltaX, -this.deltaY);
        Raster raster = this.getSource().getData(rectangle2);
        return raster.createTranslatedChild(raster.getMinX() + this.deltaX, raster.getMinY() + this.deltaY);
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        WritableRaster writableRaster2 = writableRaster.createWritableTranslatedChild(writableRaster.getMinX() - this.deltaX, writableRaster.getMinY() - this.deltaY);
        this.getSource().copyData(writableRaster2);
        return writableRaster;
    }
}

