/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.util.ArrayList;

public class TileBlock {
    int occX;
    int occY;
    int occW;
    int occH;
    int xOff;
    int yOff;
    int w;
    int h;
    int benefit;
    boolean[] occupied;

    TileBlock(int n2, int n3, int n4, int n5, boolean[] blArray, int n6, int n7, int n8, int n9) {
        this.occX = n2;
        this.occY = n3;
        this.occW = n4;
        this.occH = n5;
        this.xOff = n6;
        this.yOff = n7;
        this.w = n8;
        this.h = n9;
        this.occupied = blArray;
        for (int i2 = 0; i2 < n9; ++i2) {
            for (int i3 = 0; i3 < n8; ++i3) {
                if (blArray[i3 + n6 + n4 * (i2 + n7)]) continue;
                ++this.benefit;
            }
        }
    }

    public String toString() {
        String string2 = "";
        for (int i2 = 0; i2 < this.occH; ++i2) {
            for (int i3 = 0; i3 < this.occW + 1; ++i3) {
                string2 = i3 == this.xOff || i3 == this.xOff + this.w ? (i2 == this.yOff || i2 == this.yOff + this.h - 1 ? string2 + "+" : (i2 > this.yOff && i2 < this.yOff + this.h - 1 ? string2 + "|" : string2 + " ")) : (i2 == this.yOff && i3 > this.xOff && i3 < this.xOff + this.w ? string2 + "-" : (i2 == this.yOff + this.h - 1 && i3 > this.xOff && i3 < this.xOff + this.w ? string2 + "_" : string2 + " "));
                if (i3 == this.occW) continue;
                string2 = this.occupied[i3 + i2 * this.occW] ? string2 + "*" : string2 + ".";
            }
            string2 = string2 + "\n";
        }
        return string2;
    }

    int getXLoc() {
        return this.occX + this.xOff;
    }

    int getYLoc() {
        return this.occY + this.yOff;
    }

    int getWidth() {
        return this.w;
    }

    int getHeight() {
        return this.h;
    }

    int getBenefit() {
        return this.benefit;
    }

    int getWork() {
        return this.w * this.h + 1;
    }

    static int getWork(TileBlock[] tileBlockArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < tileBlockArray.length; ++i2) {
            n2 += tileBlockArray[i2].getWork();
        }
        return n2;
    }

    TileBlock[] getBestSplit() {
        if (this.simplify()) {
            return null;
        }
        if (this.benefit == this.w * this.h) {
            return new TileBlock[]{this};
        }
        return this.splitOneGo();
    }

    public TileBlock[] splitOneGo() {
        boolean[] blArray = (boolean[])this.occupied.clone();
        ArrayList<TileBlock> arrayList = new ArrayList<TileBlock>();
        for (int i2 = this.yOff; i2 < this.yOff + this.h; ++i2) {
            for (int i3 = this.xOff; i3 < this.xOff + this.w; ++i3) {
                int n2;
                if (blArray[i3 + i2 * this.occW]) continue;
                int n3 = this.xOff + this.w - i3;
                for (n2 = i3; n2 < i3 + n3; ++n2) {
                    if (blArray[n2 + i2 * this.occW]) {
                        n3 = n2 - i3;
                        continue;
                    }
                    blArray[n2 + i2 * this.occW] = true;
                }
                n2 = 1;
                for (int i4 = i2 + 1; i4 < this.yOff + this.h; ++i4) {
                    int n4;
                    for (n4 = i3; n4 < i3 + n3 && !blArray[n4 + i4 * this.occW]; ++n4) {
                    }
                    if (n4 != i3 + n3) break;
                    for (n4 = i3; n4 < i3 + n3; ++n4) {
                        blArray[n4 + i4 * this.occW] = true;
                    }
                    ++n2;
                }
                arrayList.add(new TileBlock(this.occX, this.occY, this.occW, this.occH, this.occupied, i3, i2, n3, n2));
                i3 += n3 - 1;
            }
        }
        TileBlock[] tileBlockArray = new TileBlock[arrayList.size()];
        arrayList.toArray(tileBlockArray);
        return tileBlockArray;
    }

    public boolean simplify() {
        int n2;
        int n3;
        boolean[] blArray = this.occupied;
        for (n3 = 0; n3 < this.h; ++n3) {
            for (n2 = 0; n2 < this.w && blArray[n2 + this.xOff + this.occW * (n3 + this.yOff)]; ++n2) {
            }
            if (n2 != this.w) break;
            ++this.yOff;
            --n3;
            --this.h;
        }
        if (this.h == 0) {
            return true;
        }
        for (n3 = this.h - 1; n3 >= 0; --n3) {
            for (n2 = 0; n2 < this.w && blArray[n2 + this.xOff + this.occW * (n3 + this.yOff)]; ++n2) {
            }
            if (n2 != this.w) break;
            --this.h;
        }
        for (n3 = 0; n3 < this.w; ++n3) {
            for (n2 = 0; n2 < this.h && blArray[n3 + this.xOff + this.occW * (n2 + this.yOff)]; ++n2) {
            }
            if (n2 != this.h) break;
            ++this.xOff;
            --n3;
            --this.w;
        }
        for (n3 = this.w - 1; n3 >= 0; --n3) {
            for (n2 = 0; n2 < this.h && blArray[n3 + this.xOff + this.occW * (n2 + this.yOff)]; ++n2) {
            }
            if (n2 != this.h) break;
            --this.w;
        }
        return false;
    }
}

