/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.xmlgraphics.java2d.color.ICCColorSpaceWithIntent;

public class ProfileRed
extends AbstractRed {
    private static final ColorSpace sRGBCS = ColorSpace.getInstance(1000);
    private static final ColorModel sRGBCM = new DirectColorModel(sRGBCS, 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    private ICCColorSpaceWithIntent colorSpace;

    public ProfileRed(CachableRed cachableRed, ICCColorSpaceWithIntent iCCColorSpaceWithIntent) {
        this.colorSpace = iCCColorSpaceWithIntent;
        this.init(cachableRed, cachableRed.getBounds(), sRGBCM, sRGBCM.createCompatibleSampleModel(cachableRed.getWidth(), cachableRed.getHeight()), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
    }

    public CachableRed getSource() {
        return (CachableRed)this.getSources().get(0);
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        try {
            Object object;
            Object object2;
            Object object3;
            Transparency transparency;
            BufferedImage bufferedImage;
            Object object4;
            ComponentColorModel componentColorModel;
            RenderedImage renderedImage = this.getSource();
            ColorModel colorModel = renderedImage.getColorModel();
            ColorSpace colorSpace = colorModel.getColorSpace();
            int n2 = colorSpace.getNumComponents();
            int n3 = this.colorSpace.getNumComponents();
            if (n2 != n3) {
                System.err.println("Input image and associated color profile have mismatching number of color components: conversion is not possible");
                return writableRaster;
            }
            int n4 = writableRaster.getWidth();
            int n5 = writableRaster.getHeight();
            int n6 = writableRaster.getMinX();
            int n7 = writableRaster.getMinY();
            WritableRaster writableRaster2 = colorModel.createCompatibleWritableRaster(n4, n5);
            writableRaster2 = writableRaster2.createWritableTranslatedChild(n6, n7);
            renderedImage.copyData(writableRaster2);
            if (!(colorModel instanceof ComponentColorModel) || !(renderedImage.getSampleModel() instanceof BandedSampleModel) || colorModel.hasAlpha() && colorModel.isAlphaPremultiplied()) {
                componentColorModel = new ComponentColorModel(colorSpace, colorModel.getComponentSize(), colorModel.hasAlpha(), false, colorModel.getTransparency(), 0);
                object4 = Raster.createBandedRaster(0, writableRaster.getWidth(), writableRaster.getHeight(), componentColorModel.getNumComponents(), new Point(0, 0));
                bufferedImage = new BufferedImage(componentColorModel, (WritableRaster)object4, componentColorModel.isAlphaPremultiplied(), null);
                transparency = new BufferedImage(colorModel, writableRaster2.createWritableTranslatedChild(0, 0), colorModel.isAlphaPremultiplied(), null);
                object3 = bufferedImage.createGraphics();
                ((Graphics2D)object3).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                ((Graphics)object3).drawImage((Image)((Object)transparency), 0, 0, null);
                renderedImage = bufferedImage;
                colorModel = componentColorModel;
                writableRaster2 = ((WritableRaster)object4).createWritableTranslatedChild(n6, n7);
            }
            componentColorModel = new ComponentColorModel((ColorSpace)this.colorSpace, colorModel.getComponentSize(), false, false, 1, 0);
            object4 = (DataBufferByte)writableRaster2.getDataBuffer();
            writableRaster2 = Raster.createBandedRaster((DataBuffer)object4, writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getWidth(), new int[]{0, 1, 2}, new int[]{0, 0, 0}, new Point(0, 0));
            bufferedImage = new BufferedImage(componentColorModel, writableRaster2, componentColorModel.isAlphaPremultiplied(), null);
            transparency = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
            object3 = Raster.createBandedRaster(0, writableRaster.getWidth(), writableRaster.getHeight(), ((ColorModel)transparency).getNumComponents(), new Point(0, 0));
            BufferedImage bufferedImage2 = new BufferedImage((ColorModel)transparency, (WritableRaster)object3, false, null);
            ColorConvertOp colorConvertOp = new ColorConvertOp(null);
            colorConvertOp.filter(bufferedImage, bufferedImage2);
            if (colorModel.hasAlpha()) {
                object2 = (DataBufferByte)((Raster)object3).getDataBuffer();
                object = ((DataBufferByte)object4).getBankData();
                byte[][] byArray = ((DataBufferByte)object2).getBankData();
                byte[][] byArrayArray = new byte[][]{byArray[0], byArray[1], byArray[2], (byte[])object[3]};
                DataBufferByte dataBufferByte = new DataBufferByte(byArrayArray, ((Object)object[0]).length);
                writableRaster2 = Raster.createBandedRaster(dataBufferByte, writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getWidth(), new int[]{0, 1, 2, 3}, new int[]{0, 0, 0, 0}, new Point(0, 0));
                transparency = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
                bufferedImage2 = new BufferedImage((ColorModel)transparency, writableRaster2, false, null);
            }
            object2 = new BufferedImage(sRGBCM, writableRaster.createWritableTranslatedChild(0, 0), false, null);
            object = ((BufferedImage)object2).createGraphics();
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            ((Graphics)object).drawImage(bufferedImage2, 0, 0, null);
            ((Graphics)object).dispose();
            return writableRaster;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error(exception.getMessage());
        }
    }
}

