/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class PadRed
extends AbstractRed {
    static final boolean DEBUG = false;
    PadMode padMode;
    RenderingHints hints;

    public PadRed(CachableRed cachableRed, Rectangle rectangle, PadMode padMode, RenderingHints renderingHints) {
        super(cachableRed, rectangle, cachableRed.getColorModel(), PadRed.fixSampleModel(cachableRed, rectangle), rectangle.x, rectangle.y, null);
        this.padMode = padMode;
        this.hints = renderingHints;
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        if (rectangle2.intersects(rectangle)) {
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
            cachableRed.copyData(writableRaster2);
        }
        if (this.padMode == PadMode.ZERO_PAD) {
            this.handleZero(writableRaster);
        } else if (this.padMode == PadMode.REPLICATE) {
            this.handleReplicate(writableRaster);
        } else if (this.padMode == PadMode.WRAP) {
            this.handleWrap(writableRaster);
        }
        return writableRaster;
    }

    protected void handleZero(WritableRaster writableRaster) {
        int n2;
        int n3;
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        ZeroRecter zeroRecter = ZeroRecter.getZeroRecter(writableRaster);
        Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        Rectangle rectangle4 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        if (rectangle3.x < rectangle.x) {
            n3 = rectangle.x - rectangle3.x;
            if (n3 > rectangle3.width) {
                n3 = rectangle3.width;
            }
            rectangle4.width = n3;
            zeroRecter.zeroRect(rectangle4);
            rectangle3.x += n3;
            rectangle3.width -= n3;
        }
        if (rectangle3.y < rectangle.y) {
            n3 = rectangle.y - rectangle3.y;
            if (n3 > rectangle3.height) {
                n3 = rectangle3.height;
            }
            rectangle4.x = rectangle3.x;
            rectangle4.y = rectangle3.y;
            rectangle4.width = rectangle3.width;
            rectangle4.height = n3;
            zeroRecter.zeroRect(rectangle4);
            rectangle3.y += n3;
            rectangle3.height -= n3;
        }
        if (rectangle3.y + rectangle3.height > rectangle.y + rectangle.height) {
            n3 = rectangle3.y + rectangle3.height - (rectangle.y + rectangle.height);
            if (n3 > rectangle3.height) {
                n3 = rectangle3.height;
            }
            n2 = rectangle3.y + rectangle3.height - n3;
            rectangle4.x = rectangle3.x;
            rectangle4.y = n2;
            rectangle4.width = rectangle3.width;
            rectangle4.height = n3;
            zeroRecter.zeroRect(rectangle4);
            rectangle3.height -= n3;
        }
        if (rectangle3.x + rectangle3.width > rectangle.x + rectangle.width) {
            n3 = rectangle3.x + rectangle3.width - (rectangle.x + rectangle.width);
            if (n3 > rectangle3.width) {
                n3 = rectangle3.width;
            }
            rectangle4.x = n2 = rectangle3.x + rectangle3.width - n3;
            rectangle4.y = rectangle3.y;
            rectangle4.width = n3;
            rectangle4.height = rectangle3.height;
            zeroRecter.zeroRect(rectangle4);
            rectangle3.width -= n3;
        }
    }

    protected void handleReplicate(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        int n2 = rectangle2.x;
        int n3 = rectangle2.y;
        int n4 = rectangle2.width;
        int n5 = rectangle2.height;
        int n6 = rectangle.x > n2 ? rectangle.x : n2;
        int n7 = rectangle.x + rectangle.width - 1 < n2 + n4 - 1 ? rectangle.x + rectangle.width - 1 : n2 + n4 - 1;
        int n8 = rectangle.y > n3 ? rectangle.y : n3;
        int n9 = rectangle.y + rectangle.height - 1 < n3 + n5 - 1 ? rectangle.y + rectangle.height - 1 : n3 + n5 - 1;
        int n10 = n6;
        int n11 = n7 - n6 + 1;
        int n12 = n8;
        int n13 = n9 - n8 + 1;
        if (n11 < 0) {
            n10 = 0;
            n11 = 0;
        }
        if (n13 < 0) {
            n12 = 0;
            n13 = 0;
        }
        Rectangle rectangle3 = new Rectangle(n10, n12, n11, n13);
        if (n3 < rectangle.y) {
            n6 = rectangle3.width;
            n7 = rectangle3.x;
            n8 = rectangle3.x;
            n9 = n3;
            if (n2 + n4 - 1 <= rectangle.x) {
                n6 = 1;
                n7 = rectangle.x;
                n8 = n2 + n4 - 1;
            } else if (n2 >= rectangle.x + rectangle.width) {
                n6 = 1;
                n7 = rectangle.x + rectangle.width - 1;
                n8 = n2;
            }
            WritableRaster writableRaster2 = writableRaster.createWritableChild(n8, n9, n6, 1, n7, rectangle.y, null);
            cachableRed.copyData(writableRaster2);
            ++n9;
            n11 = rectangle.y;
            if (n3 + n5 < n11) {
                n11 = n3 + n5;
            }
            if (n9 < n11) {
                int[] nArray = writableRaster.getPixels(n8, n9 - 1, n6, 1, (int[])null);
                while (n9 < rectangle.y) {
                    writableRaster.setPixels(n8, n9, n6, 1, nArray);
                    ++n9;
                }
            }
        }
        if (n3 + n5 > rectangle.y + rectangle.height) {
            n6 = rectangle3.width;
            n7 = rectangle3.x;
            n8 = rectangle.y + rectangle.height - 1;
            n9 = rectangle3.x;
            int n14 = rectangle.y + rectangle.height;
            if (n14 < n3) {
                n14 = n3;
            }
            if (n2 + n4 <= rectangle.x) {
                n6 = 1;
                n7 = rectangle.x;
                n9 = n2 + n4 - 1;
            } else if (n2 >= rectangle.x + rectangle.width) {
                n6 = 1;
                n7 = rectangle.x + rectangle.width - 1;
                n9 = n2;
            }
            WritableRaster writableRaster3 = writableRaster.createWritableChild(n9, n14, n6, 1, n7, n8, null);
            cachableRed.copyData(writableRaster3);
            int n15 = n3 + n5;
            if (++n14 < n15) {
                int[] nArray = writableRaster.getPixels(n9, n14 - 1, n6, 1, (int[])null);
                while (n14 < n15) {
                    writableRaster.setPixels(n9, n14, n6, 1, nArray);
                    ++n14;
                }
            }
        }
        if (n2 < rectangle.x) {
            n6 = rectangle.x;
            if (n2 + n4 <= rectangle.x) {
                n6 = n2 + n4 - 1;
            }
            int[] nArray = writableRaster.getPixels(n6, n3, 1, n5, (int[])null);
            for (n7 = n2; n7 < n6; ++n7) {
                writableRaster.setPixels(n7, n3, 1, n5, nArray);
            }
        }
        if (n2 + n4 > rectangle.x + rectangle.width) {
            n6 = rectangle.x + rectangle.width - 1;
            if (n2 >= rectangle.x + rectangle.width) {
                n6 = n2;
            }
            int n16 = n2 + n4 - 1;
            int[] nArray = writableRaster.getPixels(n6, n3, 1, n5, (int[])null);
            for (n7 = n6 + 1; n7 < n16; ++n7) {
                writableRaster.setPixels(n7, n3, 1, n5, nArray);
            }
        }
    }

    protected void handleWrap(WritableRaster writableRaster) {
        this.handleZero(writableRaster);
    }

    protected static SampleModel fixSampleModel(CachableRed cachableRed, Rectangle rectangle) {
        int n2;
        int n3 = AbstractTiledRed.getDefaultTileSize();
        SampleModel sampleModel = cachableRed.getSampleModel();
        int n4 = sampleModel.getWidth();
        if (n4 < n3) {
            n4 = n3;
        }
        if (n4 > rectangle.width) {
            n4 = rectangle.width;
        }
        if ((n2 = sampleModel.getHeight()) < n3) {
            n2 = n3;
        }
        if (n2 > rectangle.height) {
            n2 = rectangle.height;
        }
        return sampleModel.createCompatibleSampleModel(n4, n2);
    }

    protected static class ZeroRecter_INT_PACK
    extends ZeroRecter {
        final int base;
        final int scanStride;
        final int[] pixels;
        final int[] zeros;
        final int x0;
        final int y0;

        public ZeroRecter_INT_PACK(WritableRaster writableRaster) {
            super(writableRaster);
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
            this.scanStride = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            this.x0 = writableRaster.getMinY();
            this.y0 = writableRaster.getMinX();
            this.base = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(this.x0 - writableRaster.getSampleModelTranslateX(), this.y0 - writableRaster.getSampleModelTranslateY());
            this.pixels = dataBufferInt.getBankData()[0];
            this.zeros = (int[])(writableRaster.getWidth() > 10 ? new int[writableRaster.getWidth()] : null);
        }

        @Override
        public void zeroRect(Rectangle rectangle) {
            int n2 = this.base + (rectangle.x - this.x0) + (rectangle.y - this.y0) * this.scanStride;
            if (rectangle.width > 10) {
                for (int i2 = 0; i2 < rectangle.height; ++i2) {
                    int n3 = n2 + i2 * this.scanStride;
                    System.arraycopy(this.zeros, 0, this.pixels, n3, rectangle.width);
                }
            } else {
                int n4 = n2;
                int n5 = n4 + rectangle.width;
                int n6 = this.scanStride - rectangle.width;
                for (int i3 = 0; i3 < rectangle.height; ++i3) {
                    while (n4 < n5) {
                        this.pixels[n4++] = 0;
                    }
                    n4 += n6;
                    n5 += this.scanStride;
                }
            }
        }
    }

    protected static class ZeroRecter {
        WritableRaster wr;
        int bands;
        static int[] zeros = null;

        public ZeroRecter(WritableRaster writableRaster) {
            this.wr = writableRaster;
            this.bands = writableRaster.getSampleModel().getNumBands();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zeroRect(Rectangle rectangle) {
            ZeroRecter zeroRecter = this;
            synchronized (zeroRecter) {
                if (zeros == null || zeros.length < rectangle.width * this.bands) {
                    zeros = new int[rectangle.width * this.bands];
                }
            }
            for (int i2 = 0; i2 < rectangle.height; ++i2) {
                this.wr.setPixels(rectangle.x, rectangle.y + i2, rectangle.width, 1, zeros);
            }
        }

        public static ZeroRecter getZeroRecter(WritableRaster writableRaster) {
            if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), false)) {
                return new ZeroRecter_INT_PACK(writableRaster);
            }
            return new ZeroRecter(writableRaster);
        }

        public static void zeroRect(WritableRaster writableRaster) {
            ZeroRecter zeroRecter = ZeroRecter.getZeroRecter(writableRaster);
            zeroRecter.zeroRect(writableRaster.getBounds());
        }
    }
}

