/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.ColorSpaceHintKey;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.Any2LumRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class FilterAsAlphaRed
extends AbstractRed {
    public FilterAsAlphaRed(CachableRed cachableRed) {
        super(new Any2LumRed(cachableRed), cachableRed.getBounds(), (ColorModel)new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0), (SampleModel)new PixelInterleavedSampleModel(0, cachableRed.getSampleModel().getWidth(), cachableRed.getSampleModel().getHeight(), 1, cachableRed.getSampleModel().getWidth(), new int[]{0}), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
        this.props.put("org.apache.batik.gvt.filter.Colorspace", ColorSpaceHintKey.VALUE_COLORSPACE_ALPHA);
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        SampleModel sampleModel = cachableRed.getSampleModel();
        if (sampleModel.getNumBands() == 1) {
            return cachableRed.copyData(writableRaster);
        }
        Raster raster = cachableRed.getData(writableRaster.getBounds());
        PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        PixelInterleavedSampleModel pixelInterleavedSampleModel2 = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray2 = dataBufferByte2.getData();
        int n2 = raster.getMinX() - raster.getSampleModelTranslateX();
        int n3 = raster.getMinY() - raster.getSampleModelTranslateY();
        int n4 = writableRaster.getMinX() - writableRaster.getSampleModelTranslateX();
        int n5 = n4 + writableRaster.getWidth() - 1;
        int n6 = writableRaster.getMinY() - writableRaster.getSampleModelTranslateY();
        int n7 = pixelInterleavedSampleModel.getPixelStride();
        int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
        int n8 = nArray[0];
        int n9 = nArray[1];
        if (cachableRed.getColorModel().isAlphaPremultiplied()) {
            for (int i2 = 0; i2 < raster.getHeight(); ++i2) {
                int n10 = dataBufferByte.getOffset() + pixelInterleavedSampleModel.getOffset(n2, n3);
                int n11 = dataBufferByte2.getOffset() + pixelInterleavedSampleModel2.getOffset(n4, n6);
                int n12 = dataBufferByte2.getOffset() + pixelInterleavedSampleModel2.getOffset(n5 + 1, n6);
                n10 += n8;
                while (n11 < n12) {
                    byArray2[n11++] = byArray[n10];
                    n10 += n7;
                }
                ++n3;
                ++n6;
            }
        } else {
            n9 -= n8;
            for (int i3 = 0; i3 < raster.getHeight(); ++i3) {
                int n13 = dataBufferByte.getOffset() + pixelInterleavedSampleModel.getOffset(n2, n3);
                int n14 = dataBufferByte2.getOffset() + pixelInterleavedSampleModel2.getOffset(n4, n6);
                int n15 = dataBufferByte2.getOffset() + pixelInterleavedSampleModel2.getOffset(n5 + 1, n6);
                n13 += n8;
                while (n14 < n15) {
                    int n16 = byArray[n13] & 0xFF;
                    int n17 = byArray[n13 + n9] & 0xFF;
                    byArray2[n14++] = (byte)(n16 * n17 + 128 >> 8);
                    n13 += n7;
                }
                ++n3;
                ++n6;
            }
        }
        return writableRaster;
    }
}

