/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.ARGBChannel;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;
import org.apache.batik.ext.awt.image.rendered.TileCacheRed;

public class DisplacementMapRed
extends AbstractRed {
    private static final boolean TIME = false;
    private static final boolean USE_NN = false;
    private float scaleX;
    private float scaleY;
    private ARGBChannel xChannel;
    private ARGBChannel yChannel;
    CachableRed image;
    CachableRed offsets;
    int maxOffX;
    int maxOffY;
    RenderingHints hints;
    TileOffsets[] xOffsets;
    TileOffsets[] yOffsets;

    public DisplacementMapRed(CachableRed cachableRed, CachableRed cachableRed2, ARGBChannel aRGBChannel, ARGBChannel aRGBChannel2, float f2, float f3, RenderingHints renderingHints) {
        if (aRGBChannel == null) {
            throw new IllegalArgumentException("Must provide xChannel");
        }
        if (aRGBChannel2 == null) {
            throw new IllegalArgumentException("Must provide yChannel");
        }
        this.offsets = cachableRed2;
        this.scaleX = f2;
        this.scaleY = f3;
        this.xChannel = aRGBChannel;
        this.yChannel = aRGBChannel2;
        this.hints = renderingHints;
        this.maxOffX = (int)Math.ceil(f2 / 2.0f);
        this.maxOffY = (int)Math.ceil(f3 / 2.0f);
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = cachableRed.getBounds();
        rectangle2.x -= this.maxOffX;
        rectangle2.width += 2 * this.maxOffX;
        rectangle2.y -= this.maxOffY;
        rectangle2.height += 2 * this.maxOffY;
        cachableRed = new PadRed(cachableRed, rectangle2, PadMode.ZERO_PAD, null);
        this.image = cachableRed = new TileCacheRed(cachableRed);
        ColorModel colorModel = cachableRed.getColorModel();
        colorModel = GraphicsUtil.coerceColorModel(colorModel, true);
        this.init(cachableRed, rectangle, colorModel, cachableRed.getSampleModel(), rectangle.x, rectangle.y, null);
        this.xOffsets = new TileOffsets[this.getNumXTiles()];
        this.yOffsets = new TileOffsets[this.getNumYTiles()];
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRaster(writableRaster);
        return writableRaster;
    }

    @Override
    public Raster getTile(int n2, int n3) {
        WritableRaster writableRaster = this.makeTile(n2, n3);
        Rectangle rectangle = writableRaster.getBounds();
        Raster raster = this.offsets.getData(rectangle);
        ColorModel colorModel = this.offsets.getColorModel();
        GraphicsUtil.coerceData((WritableRaster)raster, colorModel, false);
        TileOffsets tileOffsets = this.getXOffsets(n2);
        TileOffsets tileOffsets2 = this.getYOffsets(n3);
        if (this.image.getColorModel().isAlphaPremultiplied()) {
            this.filterBL(raster, writableRaster, tileOffsets.tile, tileOffsets.off, tileOffsets2.tile, tileOffsets2.off);
        } else {
            this.filterBLPre(raster, writableRaster, tileOffsets.tile, tileOffsets.off, tileOffsets2.tile, tileOffsets2.off);
        }
        return writableRaster;
    }

    public TileOffsets getXOffsets(int n2) {
        TileOffsets tileOffsets = this.xOffsets[n2 - this.getMinTileX()];
        if (tileOffsets != null) {
            return tileOffsets;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.getSampleModel();
        int n3 = singlePixelPackedSampleModel.getOffset(0, 0);
        int n4 = singlePixelPackedSampleModel.getWidth();
        int n5 = n4 + 2 * this.maxOffX;
        int n6 = this.getTileGridXOffset() + n2 * n4 - this.maxOffX - this.image.getTileGridXOffset();
        int n7 = n6 + n5 - 1;
        int n8 = (int)Math.floor((double)n6 / (double)n4);
        int n9 = (int)Math.floor((double)n7 / (double)n4);
        int n10 = n6 - n8 * n4;
        int n11 = n4;
        int n12 = (n9 + 1) * n4 - 1 - n7;
        this.xOffsets[n2 - this.getMinTileX()] = tileOffsets = new TileOffsets(n5, n3, 1, n10, n11, n12, n8, n9);
        return tileOffsets;
    }

    public TileOffsets getYOffsets(int n2) {
        TileOffsets tileOffsets = this.yOffsets[n2 - this.getMinTileY()];
        if (tileOffsets != null) {
            return tileOffsets;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.getSampleModel();
        int n3 = singlePixelPackedSampleModel.getScanlineStride();
        int n4 = singlePixelPackedSampleModel.getHeight();
        int n5 = n4 + 2 * this.maxOffY;
        int n6 = this.getTileGridYOffset() + n2 * n4 - this.maxOffY - this.image.getTileGridYOffset();
        int n7 = n6 + n5 - 1;
        int n8 = (int)Math.floor((double)n6 / (double)n4);
        int n9 = (int)Math.floor((double)n7 / (double)n4);
        int n10 = n6 - n8 * n4;
        int n11 = n4;
        int n12 = (n9 + 1) * n4 - 1 - n7;
        this.yOffsets[n2 - this.getMinTileY()] = tileOffsets = new TileOffsets(n5, 0, n3, n10, n11, n12, n8, n9);
        return tileOffsets;
    }

    public void filterBL(Raster raster, WritableRaster writableRaster, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        int n4 = this.maxOffX;
        int n5 = this.maxOffY;
        int n6 = n4 + n2;
        int n7 = n5 + n3;
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)raster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n8 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n9 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - raster.getSampleModelTranslateX(), writableRaster.getMinY() - raster.getSampleModelTranslateY());
        int n10 = singlePixelPackedSampleModel.getScanlineStride();
        int n11 = singlePixelPackedSampleModel2.getScanlineStride();
        int n12 = n10 - n2;
        int n13 = n11 - n2;
        int[] nArray5 = dataBufferInt.getBankData()[0];
        int[] nArray6 = dataBufferInt2.getBankData()[0];
        int n14 = this.xChannel.toInt() * 8;
        int n15 = this.yChannel.toInt() * 8;
        int n16 = n8;
        int n17 = n9;
        int n18 = (int)((double)this.scaleX / 255.0 * 32768.0 + 0.5);
        int n19 = (int)(-127.5 * (double)n18 - 0.5);
        int n20 = (int)((double)this.scaleY / 255.0 * 32768.0 + 0.5);
        int n21 = (int)(-127.5 * (double)n20 - 0.5);
        long l2 = System.currentTimeMillis();
        int n22 = nArray[0] - 1;
        int n23 = nArray3[0] - 1;
        int[] nArray7 = null;
        for (int i2 = n5; i2 < n7; ++i2) {
            int n24 = n4;
            while (n24 < n6) {
                int n25;
                int n26;
                int n27;
                int n28 = nArray6[n17];
                int n29 = n18 * (n28 >> n14 & 0xFF) + n19;
                int n30 = n20 * (n28 >> n15 & 0xFF) + n21;
                int n31 = n24 + (n29 >> 15);
                int n32 = i2 + (n30 >> 15);
                if (n22 != nArray[n31] || n23 != nArray3[n32]) {
                    n22 = nArray[n31];
                    n23 = nArray3[n32];
                    nArray7 = ((DataBufferInt)this.image.getTile(n22, n23).getDataBuffer()).getBankData()[0];
                }
                void var35_38 = nArray7[nArray2[n31] + nArray4[n32]];
                int n33 = nArray[n31 + 1];
                int n34 = nArray3[n32 + 1];
                if (n23 == n34) {
                    if (n22 == n33) {
                        n27 = nArray7[nArray2[n31 + 1] + nArray4[n32]];
                        n26 = nArray7[nArray2[n31] + nArray4[n32 + 1]];
                        n25 = nArray7[nArray2[n31 + 1] + nArray4[n32 + 1]];
                    } else {
                        n26 = nArray7[nArray2[n31] + nArray4[n32 + 1]];
                        nArray7 = ((DataBufferInt)this.image.getTile(n33, n23).getDataBuffer()).getBankData()[0];
                        n27 = nArray7[nArray2[n31 + 1] + nArray4[n32]];
                        n25 = nArray7[nArray2[n31 + 1] + nArray4[n32 + 1]];
                        n22 = n33;
                    }
                } else if (n22 == n33) {
                    n27 = nArray7[nArray2[n31 + 1] + nArray4[n32]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n22, n34).getDataBuffer()).getBankData()[0];
                    n26 = nArray7[nArray2[n31] + nArray4[n32 + 1]];
                    n25 = nArray7[nArray2[n31 + 1] + nArray4[n32 + 1]];
                    n23 = n34;
                } else {
                    nArray7 = ((DataBufferInt)this.image.getTile(n22, n34).getDataBuffer()).getBankData()[0];
                    n26 = nArray7[nArray2[n31] + nArray4[n32 + 1]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n33, n34).getDataBuffer()).getBankData()[0];
                    n25 = nArray7[nArray2[n31 + 1] + nArray4[n32 + 1]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n33, n23).getDataBuffer()).getBankData()[0];
                    n27 = nArray7[nArray2[n31 + 1] + nArray4[n32]];
                    n22 = n33;
                }
                int n35 = n29 & Short.MAX_VALUE;
                int n36 = n30 & Short.MAX_VALUE;
                int n37 = var35_38 >>> 16 & 0xFF00;
                int n38 = n27 >>> 16 & 0xFF00;
                int n39 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                n37 = n26 >>> 16 & 0xFF00;
                n38 = n25 >>> 16 & 0xFF00;
                int n40 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                int n41 = ((n39 << 15) + (n40 - n39) * n36 + 0x400000 & 0x7F800000) << 1;
                n37 = var35_38 >> 8 & 0xFF00;
                n38 = n27 >> 8 & 0xFF00;
                n39 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                n37 = n26 >> 8 & 0xFF00;
                n38 = n25 >> 8 & 0xFF00;
                n40 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                n41 |= ((n39 << 15) + (n40 - n39) * n36 + 0x400000 & 0x7F800000) >>> 7;
                n37 = var35_38 & 0xFF00;
                n38 = n27 & 0xFF00;
                n39 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                n37 = n26 & 0xFF00;
                n38 = n25 & 0xFF00;
                n40 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                n41 |= ((n39 << 15) + (n40 - n39) * n36 + 0x400000 & 0x7F800000) >>> 15;
                n37 = var35_38 << 8 & 0xFF00;
                n38 = n27 << 8 & 0xFF00;
                n39 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                n37 = n26 << 8 & 0xFF00;
                n38 = n25 << 8 & 0xFF00;
                n40 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                nArray5[n16] = n41 |= ((n39 << 15) + (n40 - n39) * n36 + 0x400000 & 0x7F800000) >>> 23;
                ++n24;
                ++n16;
                ++n17;
            }
            n16 += n12;
            n17 += n13;
        }
    }

    public void filterBLPre(Raster raster, WritableRaster writableRaster, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        int n4 = this.maxOffX;
        int n5 = this.maxOffY;
        int n6 = n4 + n2;
        int n7 = n5 + n3;
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)raster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n8 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n9 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - raster.getSampleModelTranslateX(), writableRaster.getMinY() - raster.getSampleModelTranslateY());
        int n10 = singlePixelPackedSampleModel.getScanlineStride();
        int n11 = singlePixelPackedSampleModel2.getScanlineStride();
        int n12 = n10 - n2;
        int n13 = n11 - n2;
        int[] nArray5 = dataBufferInt.getBankData()[0];
        int[] nArray6 = dataBufferInt2.getBankData()[0];
        int n14 = this.xChannel.toInt() * 8;
        int n15 = this.yChannel.toInt() * 8;
        int n16 = n8;
        int n17 = n9;
        int n18 = (int)((double)this.scaleX / 255.0 * 32768.0 + 0.5);
        int n19 = (int)(-127.5 * (double)n18 - 0.5);
        int n20 = (int)((double)this.scaleY / 255.0 * 32768.0 + 0.5);
        int n21 = (int)(-127.5 * (double)n20 - 0.5);
        long l2 = System.currentTimeMillis();
        int n22 = nArray[0] - 1;
        int n23 = nArray3[0] - 1;
        int[] nArray7 = null;
        for (int i2 = n5; i2 < n7; ++i2) {
            int n24 = n4;
            while (n24 < n6) {
                int n25;
                int n26;
                int n27;
                int n28 = nArray6[n17];
                int n29 = n18 * (n28 >> n14 & 0xFF) + n19;
                int n30 = n20 * (n28 >> n15 & 0xFF) + n21;
                int n31 = n24 + (n29 >> 15);
                int n32 = i2 + (n30 >> 15);
                if (n22 != nArray[n31] || n23 != nArray3[n32]) {
                    n22 = nArray[n31];
                    n23 = nArray3[n32];
                    nArray7 = ((DataBufferInt)this.image.getTile(n22, n23).getDataBuffer()).getBankData()[0];
                }
                void var35_38 = nArray7[nArray2[n31] + nArray4[n32]];
                int n33 = nArray[n31 + 1];
                int n34 = nArray3[n32 + 1];
                if (n23 == n34) {
                    if (n22 == n33) {
                        n27 = nArray7[nArray2[n31 + 1] + nArray4[n32]];
                        n26 = nArray7[nArray2[n31] + nArray4[n32 + 1]];
                        n25 = nArray7[nArray2[n31 + 1] + nArray4[n32 + 1]];
                    } else {
                        n26 = nArray7[nArray2[n31] + nArray4[n32 + 1]];
                        nArray7 = ((DataBufferInt)this.image.getTile(n33, n23).getDataBuffer()).getBankData()[0];
                        n27 = nArray7[nArray2[n31 + 1] + nArray4[n32]];
                        n25 = nArray7[nArray2[n31 + 1] + nArray4[n32 + 1]];
                        n22 = n33;
                    }
                } else if (n22 == n33) {
                    n27 = nArray7[nArray2[n31 + 1] + nArray4[n32]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n22, n34).getDataBuffer()).getBankData()[0];
                    n26 = nArray7[nArray2[n31] + nArray4[n32 + 1]];
                    n25 = nArray7[nArray2[n31 + 1] + nArray4[n32 + 1]];
                    n23 = n34;
                } else {
                    nArray7 = ((DataBufferInt)this.image.getTile(n22, n34).getDataBuffer()).getBankData()[0];
                    n26 = nArray7[nArray2[n31] + nArray4[n32 + 1]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n33, n34).getDataBuffer()).getBankData()[0];
                    n25 = nArray7[nArray2[n31 + 1] + nArray4[n32 + 1]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n33, n23).getDataBuffer()).getBankData()[0];
                    n27 = nArray7[nArray2[n31 + 1] + nArray4[n32]];
                    n22 = n33;
                }
                int n35 = n29 & Short.MAX_VALUE;
                int n36 = n30 & Short.MAX_VALUE;
                int n37 = var35_38 >>> 16 & 0xFF00;
                int n38 = n27 >>> 16 & 0xFF00;
                int n39 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                int n40 = (n37 >> 8) * 65793 + 128 >> 8;
                int n41 = (n38 >> 8) * 65793 + 128 >> 8;
                n37 = n26 >>> 16 & 0xFF00;
                n38 = n25 >>> 16 & 0xFF00;
                int n42 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                int n43 = (n37 >> 8) * 65793 + 128 >> 8;
                int n44 = (n38 >> 8) * 65793 + 128 >> 8;
                int n45 = ((n39 << 15) + (n42 - n39) * n36 + 0x400000 & 0x7F800000) << 1;
                n37 = (var35_38 >> 16 & 0xFF) * n40 + 128 >> 8;
                n38 = (n27 >> 16 & 0xFF) * n41 + 128 >> 8;
                n39 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                n37 = (n26 >> 16 & 0xFF) * n43 + 128 >> 8;
                n38 = (n25 >> 16 & 0xFF) * n44 + 128 >> 8;
                n42 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                n45 |= ((n39 << 15) + (n42 - n39) * n36 + 0x400000 & 0x7F800000) >>> 7;
                n37 = (var35_38 >> 8 & 0xFF) * n40 + 128 >> 8;
                n38 = (n27 >> 8 & 0xFF) * n41 + 128 >> 8;
                n39 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                n37 = (n26 >> 8 & 0xFF) * n43 + 128 >> 8;
                n38 = (n25 >> 8 & 0xFF) * n44 + 128 >> 8;
                n42 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                n45 |= ((n39 << 15) + (n42 - n39) * n36 + 0x400000 & 0x7F800000) >>> 15;
                n37 = (var35_38 & 0xFF) * n40 + 128 >> 8;
                n38 = (n27 & 0xFF) * n41 + 128 >> 8;
                n39 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                n37 = (n26 & 0xFF) * n43 + 128 >> 8;
                n38 = (n25 & 0xFF) * n44 + 128 >> 8;
                n42 = n37 + ((n38 - n37) * n35 + 16384 >> 15) & 0xFFFF;
                nArray5[n16] = n45 |= ((n39 << 15) + (n42 - n39) * n36 + 0x400000 & 0x7F800000) >>> 23;
                ++n24;
                ++n16;
                ++n17;
            }
            n16 += n12;
            n17 += n13;
        }
    }

    public void filterNN(Raster raster, WritableRaster writableRaster, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        int n4 = this.maxOffX;
        int n5 = this.maxOffY;
        int n6 = n4 + n2;
        int n7 = n5 + n3;
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)raster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n8 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n9 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        int n10 = singlePixelPackedSampleModel.getScanlineStride();
        int n11 = singlePixelPackedSampleModel2.getScanlineStride();
        int n12 = n10 - n2;
        int n13 = n11 - n2;
        int[] nArray5 = dataBufferInt.getBankData()[0];
        int[] nArray6 = dataBufferInt2.getBankData()[0];
        int n14 = this.xChannel.toInt() * 8;
        int n15 = this.yChannel.toInt() * 8;
        int n16 = (int)((double)this.scaleX / 255.0 * 32768.0 + 0.5);
        int n17 = (int)((double)this.scaleY / 255.0 * 32768.0 + 0.5);
        int n18 = (int)(-127.5 * (double)n16 - 0.5) + 16384;
        int n19 = (int)(-127.5 * (double)n17 - 0.5) + 16384;
        int n20 = n8;
        int n21 = n9;
        long l2 = System.currentTimeMillis();
        int n22 = nArray[0] - 1;
        int n23 = nArray3[0] - 1;
        int[] nArray7 = null;
        for (int i2 = n5; i2 < n7; ++i2) {
            for (int i3 = n4; i3 < n6; ++i3) {
                int n24 = nArray6[n21];
                int n25 = n16 * (n24 >> n14 & 0xFF) + n18;
                int n26 = n17 * (n24 >> n15 & 0xFF) + n19;
                int n27 = i3 + (n25 >> 15);
                int n28 = i2 + (n26 >> 15);
                if (n22 != nArray[n27] || n23 != nArray3[n28]) {
                    n22 = nArray[n27];
                    n23 = nArray3[n28];
                    nArray7 = ((DataBufferInt)this.image.getTile(n22, n23).getDataBuffer()).getBankData()[0];
                }
                nArray5[n20] = nArray7[nArray2[n27] + nArray4[n28]];
                ++n20;
                ++n21;
            }
            n20 += n12;
            n21 += n13;
        }
    }

    static class TileOffsets {
        int[] tile;
        int[] off;

        TileOffsets(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            this.tile = new int[n2 + 1];
            this.off = new int[n2 + 1];
            if (n8 == n9) {
                n6 -= n7;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                this.tile[i2] = n8++;
                this.off[i2] = n3 + n5 * n4;
                if (++n5 != n6) continue;
                n5 = 0;
                if (n8 != n9) continue;
                n6 -= n7;
            }
            this.tile[n2] = this.tile[n2 - 1];
            this.off[n2] = this.off[n2 - 1];
        }
    }
}

