/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.List;
import java.util.Map;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileBlock;
import org.apache.batik.ext.awt.image.rendered.TileCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileStore;
import org.apache.batik.util.HaltingThread;

public abstract class AbstractTiledRed
extends AbstractRed
implements TileGenerator {
    private TileStore tiles;
    private static int defaultTileSize = 128;

    public static int getDefaultTileSize() {
        return defaultTileSize;
    }

    protected AbstractTiledRed() {
    }

    protected AbstractTiledRed(Rectangle rectangle, Map map) {
        super(rectangle, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Map map) {
        super(cachableRed, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, Map map) {
        super(cachableRed, rectangle, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, Map map) {
        super(cachableRed, rectangle, colorModel, sampleModel, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n2, int n3, Map map) {
        super(cachableRed, rectangle, colorModel, sampleModel, n2, n3, map);
    }

    @Override
    protected void init(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n2, int n3, Map map) {
        this.init(cachableRed, rectangle, colorModel, sampleModel, n2, n3, null, map);
    }

    protected void init(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n2, int n3, TileStore tileStore, Map map) {
        super.init(cachableRed, rectangle, colorModel, sampleModel, n2, n3, map);
        this.tiles = tileStore;
        if (this.tiles == null) {
            this.tiles = this.createTileStore();
        }
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, Map map) {
        super(list, rectangle, map);
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, Map map) {
        super(list, rectangle, colorModel, sampleModel, map);
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n2, int n3, Map map) {
        super(list, rectangle, colorModel, sampleModel, n2, n3, map);
    }

    @Override
    protected void init(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n2, int n3, Map map) {
        super.init(list, rectangle, colorModel, sampleModel, n2, n3, map);
        this.tiles = this.createTileStore();
    }

    public TileStore getTileStore() {
        return this.tiles;
    }

    protected void setTileStore(TileStore tileStore) {
        this.tiles = tileStore;
    }

    protected TileStore createTileStore() {
        return TileCache.getTileMap(this);
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRasterByBlocks(writableRaster);
        return writableRaster;
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        int n2 = this.getXTile(rectangle.x);
        int n3 = this.getXTile(rectangle.x + rectangle.width - 1);
        int n4 = this.getYTile(rectangle.y);
        int n5 = this.getYTile(rectangle.y + rectangle.height - 1);
        if (n2 == n3 && n4 == n5) {
            Raster raster = this.getTile(n2, n4);
            return raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        }
        return super.getData(rectangle);
    }

    @Override
    public Raster getTile(int n2, int n3) {
        return this.tiles.getTile(n2, n3);
    }

    @Override
    public Raster genTile(int n2, int n3) {
        WritableRaster writableRaster = this.makeTile(n2, n3);
        this.genRect(writableRaster);
        return writableRaster;
    }

    public abstract void genRect(WritableRaster var1);

    public void setTile(int n2, int n3, Raster raster) {
        this.tiles.setTile(n2, n3, raster);
    }

    public void copyToRasterByBlocks(WritableRaster writableRaster) {
        Raster raster;
        int n2;
        boolean bl2 = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        int n3 = this.getXTile(rectangle2.x);
        int n4 = this.getYTile(rectangle2.y);
        int n5 = this.getXTile(rectangle2.x + rectangle2.width - 1);
        int n6 = this.getYTile(rectangle2.y + rectangle2.height - 1);
        if (n3 < this.minTileX) {
            n3 = this.minTileX;
        }
        if (n4 < this.minTileY) {
            n4 = this.minTileY;
        }
        if (n5 >= this.minTileX + this.numXTiles) {
            n5 = this.minTileX + this.numXTiles - 1;
        }
        if (n6 >= this.minTileY + this.numYTiles) {
            n6 = this.minTileY + this.numYTiles - 1;
        }
        if (n5 < n3 || n6 < n4) {
            return;
        }
        int n7 = n3;
        int n8 = n5;
        int n9 = n4;
        int n10 = n6;
        int n11 = n3 * this.tileWidth + this.tileGridXOff;
        if (n11 < rectangle2.x && rectangle.x != rectangle2.x) {
            ++n7;
        }
        if ((n2 = n4 * this.tileHeight + this.tileGridYOff) < rectangle2.y && rectangle.y != rectangle2.y) {
            ++n9;
        }
        if ((n11 = (n5 + 1) * this.tileWidth + this.tileGridXOff - 1) >= rectangle2.x + rectangle2.width && rectangle.x + rectangle.width != rectangle2.x + rectangle2.width) {
            --n8;
        }
        if ((n2 = (n6 + 1) * this.tileHeight + this.tileGridYOff - 1) >= rectangle2.y + rectangle2.height && rectangle.y + rectangle.height != rectangle2.y + rectangle2.height) {
            --n10;
        }
        int n12 = n8 - n7 + 1;
        int n13 = n10 - n9 + 1;
        boolean[] blArray = null;
        if (n12 > 0 && n13 > 0) {
            blArray = new boolean[n12 * n13];
        }
        boolean[] blArray2 = new boolean[2 * (n5 - n3 + 1) + 2 * (n6 - n4 + 1)];
        int n14 = 0;
        int n15 = 0;
        for (int i2 = n4; i2 <= n6; ++i2) {
            for (int i3 = n3; i3 <= n5; ++i3) {
                boolean bl3;
                raster = this.tiles.getTileNoCompute(i3, i2);
                boolean bl4 = bl3 = raster != null;
                if (i2 >= n9 && i2 <= n10 && i3 >= n7 && i3 <= n8) {
                    blArray[i3 - n7 + (i2 - n9) * n12] = bl3;
                } else {
                    blArray2[n14++] = bl3;
                }
                if (!bl3) continue;
                ++n15;
                if (bl2) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
            }
        }
        if (n12 > 0 && n13 > 0) {
            TileBlock tileBlock = new TileBlock(n7, n9, n12, n13, blArray, 0, 0, n12, n13);
            this.drawBlock(tileBlock, writableRaster);
        }
        Thread thread2 = Thread.currentThread();
        if (HaltingThread.hasBeenHalted()) {
            return;
        }
        n14 = 0;
        for (n2 = n4; n2 <= n6; ++n2) {
            for (n11 = n3; n11 <= n5; ++n11) {
                Raster raster2 = this.tiles.getTileNoCompute(n11, n2);
                if (n2 >= n9 && n2 <= n10 && n11 >= n7 && n11 <= n8) {
                    if (raster2 != null) continue;
                    raster = this.makeTile(n11, n2);
                    if (bl2) {
                        GraphicsUtil.copyData_INT_PACK(writableRaster, (WritableRaster)raster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(writableRaster, (WritableRaster)raster);
                    }
                    this.tiles.setTile(n11, n2, raster);
                    continue;
                }
                if (blArray2[n14++]) continue;
                raster2 = this.getTile(n11, n2);
                if (HaltingThread.hasBeenHalted(thread2)) {
                    return;
                }
                if (bl2) {
                    GraphicsUtil.copyData_INT_PACK(raster2, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster2, writableRaster);
            }
        }
    }

    @Override
    public void copyToRaster(WritableRaster writableRaster) {
        Raster raster;
        int n2;
        int n3;
        Rectangle rectangle = writableRaster.getBounds();
        int n4 = this.getXTile(rectangle.x);
        int n5 = this.getYTile(rectangle.y);
        int n6 = this.getXTile(rectangle.x + rectangle.width - 1);
        int n7 = this.getYTile(rectangle.y + rectangle.height - 1);
        if (n4 < this.minTileX) {
            n4 = this.minTileX;
        }
        if (n5 < this.minTileY) {
            n5 = this.minTileY;
        }
        if (n6 >= this.minTileX + this.numXTiles) {
            n6 = this.minTileX + this.numXTiles - 1;
        }
        if (n7 >= this.minTileY + this.numYTiles) {
            n7 = this.minTileY + this.numYTiles - 1;
        }
        boolean bl2 = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        int n8 = n6 - n4 + 1;
        boolean[] blArray = new boolean[n8 * (n7 - n5 + 1)];
        for (n3 = n5; n3 <= n7; ++n3) {
            for (n2 = n4; n2 <= n6; ++n2) {
                raster = this.tiles.getTileNoCompute(n2, n3);
                if (raster == null) continue;
                blArray[n2 - n4 + (n3 - n5) * n8] = true;
                if (bl2) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
            }
        }
        for (n3 = n5; n3 <= n7; ++n3) {
            for (n2 = n4; n2 <= n6; ++n2) {
                if (blArray[n2 - n4 + (n3 - n5) * n8]) continue;
                raster = this.getTile(n2, n3);
                if (bl2) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
            }
        }
    }

    protected void drawBlock(TileBlock tileBlock, WritableRaster writableRaster) {
        TileBlock[] tileBlockArray = tileBlock.getBestSplit();
        if (tileBlockArray == null) {
            return;
        }
        this.drawBlockInPlace(tileBlockArray, writableRaster);
    }

    protected void drawBlockAndCopy(TileBlock[] tileBlockArray, WritableRaster writableRaster) {
        int n2;
        Object object;
        int n3;
        int n4;
        if (tileBlockArray.length == 1) {
            TileBlock tileBlock = tileBlockArray[0];
            n4 = tileBlock.getXLoc() * this.tileWidth + this.tileGridXOff;
            n3 = tileBlock.getYLoc() * this.tileHeight + this.tileGridYOff;
            if (n4 == writableRaster.getMinX() && n3 == writableRaster.getMinY()) {
                this.drawBlockInPlace(tileBlockArray, writableRaster);
                return;
            }
        }
        int n5 = this.tileWidth;
        n4 = this.tileHeight;
        n3 = 0;
        for (int i2 = 0; i2 < tileBlockArray.length; ++i2) {
            object = tileBlockArray[i2];
            n2 = ((TileBlock)object).getWidth() * n5 * (((TileBlock)object).getHeight() * n4);
            if (n2 <= n3) continue;
            n3 = n2;
        }
        DataBufferInt dataBufferInt = new DataBufferInt(n3);
        object = new int[]{0xFF0000, 65280, 255, -16777216};
        n2 = GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), false) ? 1 : 0;
        Thread thread2 = Thread.currentThread();
        for (int i3 = 0; i3 < tileBlockArray.length; ++i3) {
            TileBlock tileBlock = tileBlockArray[i3];
            int n6 = tileBlock.getXLoc() * n5 + this.tileGridXOff;
            int n7 = tileBlock.getYLoc() * n4 + this.tileGridYOff;
            Rectangle rectangle = new Rectangle(n6, n7, tileBlock.getWidth() * n5, tileBlock.getHeight() * n4);
            rectangle = rectangle.intersection(this.bounds);
            Point point = new Point(rectangle.x, rectangle.y);
            WritableRaster writableRaster2 = Raster.createPackedRaster(dataBufferInt, rectangle.width, rectangle.height, rectangle.width, (int[])object, point);
            this.genRect(writableRaster2);
            if (n2 != 0) {
                GraphicsUtil.copyData_INT_PACK(writableRaster2, writableRaster);
            } else {
                GraphicsUtil.copyData_FALLBACK(writableRaster2, writableRaster);
            }
            if (!HaltingThread.hasBeenHalted(thread2)) continue;
            return;
        }
    }

    protected void drawBlockInPlace(TileBlock[] tileBlockArray, WritableRaster writableRaster) {
        Thread thread2 = Thread.currentThread();
        int n2 = this.tileWidth;
        int n3 = this.tileHeight;
        for (int i2 = 0; i2 < tileBlockArray.length; ++i2) {
            TileBlock tileBlock = tileBlockArray[i2];
            int n4 = tileBlock.getXLoc() * n2 + this.tileGridXOff;
            int n5 = tileBlock.getYLoc() * n3 + this.tileGridYOff;
            Rectangle rectangle = new Rectangle(n4, n5, tileBlock.getWidth() * n2, tileBlock.getHeight() * n3);
            rectangle = rectangle.intersection(this.bounds);
            WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
            this.genRect(writableRaster2);
            if (!HaltingThread.hasBeenHalted(thread2)) continue;
            return;
        }
    }
}

