/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.batik.ext.awt.image.CompositeRule;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.SVGComposite;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.CompositeRable;
import org.apache.batik.ext.awt.image.renderable.CompositeRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.FilterResRable;
import org.apache.batik.ext.awt.image.renderable.PadRable;
import org.apache.batik.ext.awt.image.renderable.PaintRable;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.TileCacheRed;

public class FilterResRable8Bit
extends AbstractRable
implements FilterResRable,
PaintRable {
    private int filterResolutionX = -1;
    private int filterResolutionY = -1;
    Reference resRed = null;
    float resScale = 0.0f;

    public FilterResRable8Bit() {
    }

    public FilterResRable8Bit(Filter filter, int n2, int n3) {
        this.init(filter, null);
        this.setFilterResolutionX(n2);
        this.setFilterResolutionY(n3);
    }

    @Override
    public Filter getSource() {
        return (Filter)this.srcs.get(0);
    }

    @Override
    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    @Override
    public int getFilterResolutionX() {
        return this.filterResolutionX;
    }

    @Override
    public void setFilterResolutionX(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.filterResolutionX = n2;
    }

    @Override
    public int getFilterResolutionY() {
        return this.filterResolutionY;
    }

    @Override
    public void setFilterResolutionY(int n2) {
        this.touch();
        this.filterResolutionY = n2;
    }

    public boolean allPaintRable(RenderableImage renderableImage) {
        if (!(renderableImage instanceof PaintRable)) {
            return false;
        }
        Vector<RenderableImage> vector = renderableImage.getSources();
        if (vector == null) {
            return true;
        }
        for (RenderableImage renderableImage2 : vector) {
            if (this.allPaintRable(renderableImage2)) continue;
            return false;
        }
        return true;
    }

    public boolean distributeAcross(RenderableImage renderableImage, Graphics2D graphics2D) {
        if (renderableImage instanceof PadRable) {
            PadRable padRable = (PadRable)renderableImage;
            Shape shape = graphics2D.getClip();
            graphics2D.clip(padRable.getPadRect());
            boolean bl2 = this.distributeAcross(padRable.getSource(), graphics2D);
            graphics2D.setClip(shape);
            return bl2;
        }
        if (renderableImage instanceof CompositeRable) {
            CompositeRable compositeRable = (CompositeRable)renderableImage;
            if (compositeRable.getCompositeRule() != CompositeRule.OVER) {
                return false;
            }
            Vector<RenderableImage> vector = compositeRable.getSources();
            if (vector == null) {
                return true;
            }
            ListIterator listIterator = vector.listIterator(vector.size());
            while (listIterator.hasPrevious()) {
                RenderableImage renderableImage2 = (RenderableImage)listIterator.previous();
                if (this.allPaintRable(renderableImage2)) continue;
                listIterator.next();
                break;
            }
            if (!listIterator.hasPrevious()) {
                GraphicsUtil.drawImage(graphics2D, compositeRable);
                return true;
            }
            if (!listIterator.hasNext()) {
                return false;
            }
            int n2 = listIterator.nextIndex();
            AbstractRable abstractRable = new CompositeRable8Bit(vector.subList(0, n2), compositeRable.getCompositeRule(), compositeRable.isColorSpaceLinear());
            abstractRable = new FilterResRable8Bit(abstractRable, this.getFilterResolutionX(), this.getFilterResolutionY());
            GraphicsUtil.drawImage(graphics2D, abstractRable);
            while (listIterator.hasNext()) {
                PaintRable paintRable = (PaintRable)listIterator.next();
                if (paintRable.paintRable(graphics2D)) continue;
                Filter filter = (Filter)((Object)paintRable);
                filter = new FilterResRable8Bit(filter, this.getFilterResolutionX(), this.getFilterResolutionY());
                GraphicsUtil.drawImage(graphics2D, filter);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean paintRable(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        if (!SVGComposite.OVER.equals(composite)) {
            return false;
        }
        Filter filter = this.getSource();
        return this.distributeAcross(filter, graphics2D);
    }

    private float getResScale() {
        return this.resScale;
    }

    private RenderedImage getResRed(RenderingHints renderingHints) {
        RenderedImage renderedImage;
        double d2;
        Rectangle2D rectangle2D = this.getBounds2D();
        double d3 = (double)this.getFilterResolutionX() / rectangle2D.getWidth();
        float f2 = (float)Math.min(d3, d2 = (double)this.getFilterResolutionY() / rectangle2D.getHeight());
        if (f2 == this.resScale && (renderedImage = (RenderedImage)this.resRed.get()) != null) {
            return renderedImage;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f2, f2);
        RenderContext renderContext = new RenderContext(affineTransform, null, renderingHints);
        renderedImage = this.getSource().createRendering(renderContext);
        renderedImage = new TileCacheRed(GraphicsUtil.wrap(renderedImage));
        this.resScale = f2;
        this.resRed = new SoftReference<RenderedImage>(renderedImage);
        return renderedImage;
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        AffineTransform affineTransform = renderContext.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        RenderingHints renderingHints = renderContext.getRenderingHints();
        int n2 = this.getFilterResolutionX();
        int n3 = this.getFilterResolutionY();
        if (n2 <= 0 || n3 == 0) {
            return null;
        }
        Rectangle2D rectangle2D = this.getBounds2D();
        Rectangle rectangle = affineTransform.createTransformedShape(rectangle2D).getBounds();
        float f2 = 1.0f;
        if (n2 < rectangle.width) {
            f2 = (float)n2 / (float)rectangle.width;
        }
        float f3 = 1.0f;
        if (n3 < 0) {
            f3 = f2;
        } else if (n3 < rectangle.height) {
            f3 = (float)n3 / (float)rectangle.height;
        }
        if (f2 >= 1.0f && f3 >= 1.0f) {
            return this.getSource().createRendering(renderContext);
        }
        RenderedImage renderedImage = this.getResRed(renderingHints);
        float f4 = this.getResScale();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform.getScaleX() / (double)f4, affineTransform.getShearY() / (double)f4, affineTransform.getShearX() / (double)f4, affineTransform.getScaleY() / (double)f4, affineTransform.getTranslateX(), affineTransform.getTranslateY());
        return new AffineRed(GraphicsUtil.wrap(renderedImage), affineTransform2, renderingHints);
    }
}

