/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import org.apache.batik.ext.awt.image.TransferFunction;

public class LinearTransfer
implements TransferFunction {
    public byte[] lutData;
    public float slope;
    public float intercept;

    public LinearTransfer(float f2, float f3) {
        this.slope = f2;
        this.intercept = f3;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        float f2 = this.intercept * 255.0f + 0.5f;
        for (int i2 = 0; i2 <= 255; ++i2) {
            int n2 = (int)(this.slope * (float)i2 + f2);
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            this.lutData[i2] = (byte)(0xFF & n2);
        }
    }

    @Override
    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

