/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import org.apache.batik.ext.awt.image.TransferFunction;

public class GammaTransfer
implements TransferFunction {
    public byte[] lutData;
    public float amplitude;
    public float exponent;
    public float offset;

    public GammaTransfer(float f2, float f3, float f4) {
        this.amplitude = f2;
        this.exponent = f3;
        this.offset = f4;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        for (int i2 = 0; i2 <= 255; ++i2) {
            int n2 = (int)Math.round(255.0 * ((double)this.amplitude * Math.pow((float)i2 / 255.0f, this.exponent) + (double)this.offset));
            if (n2 > 255) {
                n2 = -1;
            } else if (n2 < 0) {
                n2 = 0;
            }
            this.lutData[i2] = (byte)(n2 & 0xFF);
        }
    }

    @Override
    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

