/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Color;
import org.apache.batik.ext.awt.image.AbstractLight;

public class DistantLight
extends AbstractLight {
    private double azimuth;
    private double elevation;
    private double Lx;
    private double Ly;
    private double Lz;

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getElevation() {
        return this.elevation;
    }

    public DistantLight(double d2, double d3, Color color) {
        super(color);
        this.azimuth = d2;
        this.elevation = d3;
        this.Lx = Math.cos(Math.toRadians(d2)) * Math.cos(Math.toRadians(d3));
        this.Ly = Math.sin(Math.toRadians(d2)) * Math.cos(Math.toRadians(d3));
        this.Lz = Math.sin(Math.toRadians(d3));
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public void getLight(double d2, double d3, double d4, double[] dArray) {
        dArray[0] = this.Lx;
        dArray[1] = this.Ly;
        dArray[2] = this.Lz;
    }

    @Override
    public double[][] getLightRow(double d2, double d3, double d4, int n2, double[][] dArray, double[][] dArray2) {
        Object object = dArray2;
        if (object == null) {
            object = new double[n2][];
            double[] dArray3 = new double[]{this.Lx, this.Ly, this.Lz};
            for (int i2 = 0; i2 < n2; ++i2) {
                object[i2] = dArray3;
            }
        } else {
            double d5 = this.Lx;
            double d6 = this.Ly;
            double d7 = this.Lz;
            for (int i3 = 0; i3 < n2; ++i3) {
                object[i3][0] = d5;
                object[i3][1] = d6;
                object[i3][2] = d7;
            }
        }
        return object;
    }
}

