/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;

public class ICCColorSpaceExt
extends ICC_ColorSpace {
    public static final int PERCEPTUAL = 0;
    public static final int RELATIVE_COLORIMETRIC = 1;
    public static final int ABSOLUTE_COLORIMETRIC = 2;
    public static final int SATURATION = 3;
    public static final int AUTO = 4;
    static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    int intent;

    public ICCColorSpaceExt(ICC_Profile iCC_Profile, int n2) {
        super(iCC_Profile);
        this.intent = n2;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (n2 != 4) {
            byte[] byArray = iCC_Profile.getData(1751474532);
            byArray[64] = (byte)n2;
        }
    }

    public float[] intendedToRGB(float[] fArray) {
        switch (this.intent) {
            case 2: {
                return this.absoluteColorimetricToRGB(fArray);
            }
            case 0: 
            case 4: {
                return this.perceptualToRGB(fArray);
            }
            case 1: {
                return this.relativeColorimetricToRGB(fArray);
            }
            case 3: {
                return this.saturationToRGB(fArray);
            }
        }
        throw new Error("invalid intent:" + this.intent);
    }

    public float[] perceptualToRGB(float[] fArray) {
        return this.toRGB(fArray);
    }

    public float[] relativeColorimetricToRGB(float[] fArray) {
        float[] fArray2 = this.toCIEXYZ(fArray);
        return sRGB.fromCIEXYZ(fArray2);
    }

    public float[] absoluteColorimetricToRGB(float[] fArray) {
        return this.perceptualToRGB(fArray);
    }

    public float[] saturationToRGB(float[] fArray) {
        return this.perceptualToRGB(fArray);
    }
}

