/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaintContext;

final class LinearGradientPaintContext
extends MultipleGradientPaintContext {
    private float dgdX;
    private float dgdY;
    private float gc;
    private float pixSz;
    private static final int DEFAULT_IMPL = 1;
    private static final int ANTI_ALIAS_IMPL = 3;
    private int fillMethod;

    public LinearGradientPaintContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints, Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) throws NoninvertibleTransformException {
        super(colorModel, rectangle, rectangle2D, affineTransform, renderingHints, fArray, colorArray, cycleMethodEnum, colorSpaceEnum);
        Point2D.Float float_ = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        Point2D.Float float_2 = new Point2D.Float((float)point2D2.getX(), (float)point2D2.getY());
        float f2 = float_2.x - float_.x;
        float f3 = float_2.y - float_.y;
        float f4 = f2 * f2 + f3 * f3;
        float f5 = f2 / f4;
        float f6 = f3 / f4;
        this.dgdX = this.a00 * f5 + this.a10 * f6;
        this.dgdY = this.a01 * f5 + this.a11 * f6;
        float f7 = Math.abs(this.dgdX);
        float f8 = Math.abs(this.dgdY);
        this.pixSz = f7 > f8 ? f7 : f8;
        this.gc = (this.a02 - float_.x) * f5 + (this.a12 - float_.y) * f6;
        Object object = renderingHints.get(RenderingHints.KEY_COLOR_RENDERING);
        Object object2 = renderingHints.get(RenderingHints.KEY_RENDERING);
        this.fillMethod = 1;
        if (cycleMethodEnum == MultipleGradientPaint.REPEAT || this.hasDiscontinuity) {
            if (object2 == RenderingHints.VALUE_RENDER_QUALITY) {
                this.fillMethod = 3;
            }
            if (object == RenderingHints.VALUE_COLOR_RENDER_SPEED) {
                this.fillMethod = 1;
            } else if (object == RenderingHints.VALUE_COLOR_RENDER_QUALITY) {
                this.fillMethod = 3;
            }
        }
    }

    protected void fillHardNoCycle(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2 = this.dgdX * (float)n4 + this.gc;
        for (int i2 = 0; i2 < n7; ++i2) {
            int n8;
            int n9;
            float f3 = f2 + this.dgdY * (float)(n5 + i2);
            int n10 = n2 + n6;
            if (this.dgdX == 0.0f) {
                if (f3 <= 0.0f) {
                    n9 = this.gradientUnderflow;
                } else if (f3 >= 1.0f) {
                    n9 = this.gradientOverflow;
                } else {
                    for (n8 = 0; n8 < this.gradientsLength - 1 && !(f3 < this.fractions[n8 + 1]); ++n8) {
                    }
                    float f4 = f3 - this.fractions[n8];
                    float f5 = f4 * 255.0f / this.normalizedIntervals[n8] + 0.5f;
                    n9 = this.gradients[n8][(int)f5];
                }
                while (n2 < n10) {
                    nArray[n2++] = n9;
                }
            } else {
                int n11;
                int n12;
                int n13;
                int n14;
                double d2;
                int[] nArray2;
                float f6;
                int n15;
                int n16;
                int n17;
                float f7;
                float f8;
                if (this.dgdX >= 0.0f) {
                    f8 = (1.0f - f3) / this.dgdX;
                    f7 = (float)Math.ceil((0.0f - f3) / this.dgdX);
                    n17 = this.gradientUnderflow;
                    n16 = this.gradientOverflow;
                } else {
                    f8 = (0.0f - f3) / this.dgdX;
                    f7 = (float)Math.ceil((1.0f - f3) / this.dgdX);
                    n17 = this.gradientOverflow;
                    n16 = this.gradientUnderflow;
                }
                n9 = f8 > (float)n6 ? n6 : (int)f8;
                n8 = f7 > (float)n6 ? n6 : (int)f7;
                int n18 = n2 + n9;
                if (n8 > 0) {
                    n15 = n2 + n8;
                    while (n2 < n15) {
                        nArray[n2++] = n17;
                    }
                    f3 += this.dgdX * (float)n8;
                }
                if (this.dgdX > 0.0f) {
                    for (n15 = 0; n15 < this.gradientsLength - 1 && !(f3 < this.fractions[n15 + 1]); ++n15) {
                    }
                    while (n2 < n18) {
                        f6 = f3 - this.fractions[n15];
                        nArray2 = this.gradients[n15];
                        d2 = Math.ceil((this.fractions[n15 + 1] - f3) / this.dgdX);
                        n14 = d2 > (double)n6 ? n6 : (int)d2;
                        n13 = n2 + n14;
                        if (n13 > n18) {
                            n13 = n18;
                        }
                        n12 = (int)(f6 * 255.0f / this.normalizedIntervals[n15] * 65536.0f) + 32768;
                        n11 = (int)(this.dgdX * 255.0f / this.normalizedIntervals[n15] * 65536.0f);
                        while (n2 < n13) {
                            nArray[n2++] = nArray2[n12 >> 16];
                            n12 += n11;
                        }
                        f3 = (float)((double)f3 + (double)this.dgdX * d2);
                        ++n15;
                    }
                } else {
                    for (n15 = this.gradientsLength - 1; n15 > 0 && !(f3 > this.fractions[n15]); --n15) {
                    }
                    while (n2 < n18) {
                        f6 = f3 - this.fractions[n15];
                        nArray2 = this.gradients[n15];
                        d2 = Math.ceil(f6 / -this.dgdX);
                        n14 = d2 > (double)n6 ? n6 : (int)d2;
                        n13 = n2 + n14;
                        if (n13 > n18) {
                            n13 = n18;
                        }
                        n12 = (int)(f6 * 255.0f / this.normalizedIntervals[n15] * 65536.0f) + 32768;
                        n11 = (int)(this.dgdX * 255.0f / this.normalizedIntervals[n15] * 65536.0f);
                        while (n2 < n13) {
                            nArray[n2++] = nArray2[n12 >> 16];
                            n12 += n11;
                        }
                        f3 = (float)((double)f3 + (double)this.dgdX * d2);
                        --n15;
                    }
                }
                while (n2 < n10) {
                    nArray[n2++] = n16;
                }
            }
            n2 += n3;
        }
    }

    protected void fillSimpleNoCycle(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2 = this.dgdX * (float)n4 + this.gc;
        float f3 = this.dgdX * (float)this.fastGradientArraySize;
        int n8 = (int)(f3 * 65536.0f);
        int[] nArray2 = this.gradient;
        for (int i2 = 0; i2 < n7; ++i2) {
            int n9;
            float f4 = f2 + this.dgdY * (float)(n5 + i2);
            f4 *= (float)this.fastGradientArraySize;
            f4 = (float)((double)f4 + 0.5);
            int n10 = n2 + n6;
            float f5 = this.dgdX * (float)this.fastGradientArraySize * (float)n6;
            if (f5 < 0.0f) {
                f5 = -f5;
            }
            if ((double)f5 < 0.3) {
                n9 = f4 <= 0.0f ? this.gradientUnderflow : (f4 >= (float)this.fastGradientArraySize ? this.gradientOverflow : nArray2[(int)f4]);
                while (n2 < n10) {
                    nArray[n2++] = n9;
                }
            } else {
                int n11;
                int n12;
                int n13;
                int n14;
                if (this.dgdX > 0.0f) {
                    n9 = (int)(((float)this.fastGradientArraySize - f4) / f3);
                    n14 = (int)Math.ceil(0.0f - f4 / f3);
                    n13 = this.gradientUnderflow;
                    n12 = this.gradientOverflow;
                } else {
                    n9 = (int)((0.0f - f4) / f3);
                    n14 = (int)Math.ceil(((float)this.fastGradientArraySize - f4) / f3);
                    n13 = this.gradientOverflow;
                    n12 = this.gradientUnderflow;
                }
                if (n9 > n6) {
                    n9 = n6;
                }
                int n15 = n2 + n9;
                if (n14 > 0) {
                    if (n14 > n6) {
                        n14 = n6;
                    }
                    n11 = n2 + n14;
                    while (n2 < n11) {
                        nArray[n2++] = n13;
                    }
                    f4 += f3 * (float)n14;
                }
                n11 = (int)(f4 * 65536.0f);
                while (n2 < n15) {
                    nArray[n2++] = nArray2[n11 >> 16];
                    n11 += n8;
                }
                while (n2 < n10) {
                    nArray[n2++] = n12;
                }
            }
            n2 += n3;
        }
    }

    protected void fillSimpleRepeat(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2 = this.dgdX * (float)n4 + this.gc;
        float f3 = (this.dgdX - (float)((int)this.dgdX)) * (float)this.fastGradientArraySize;
        if (f3 < 0.0f) {
            f3 += (float)this.fastGradientArraySize;
        }
        int[] nArray2 = this.gradient;
        for (int i2 = 0; i2 < n7; ++i2) {
            float f4 = f2 + this.dgdY * (float)(n5 + i2);
            if ((f4 -= (float)((int)f4)) < 0.0f) {
                f4 += 1.0f;
            }
            f4 *= (float)this.fastGradientArraySize;
            f4 = (float)((double)f4 + 0.5);
            int n8 = n2 + n6;
            while (n2 < n8) {
                int n9 = (int)f4;
                if (n9 >= this.fastGradientArraySize) {
                    f4 -= (float)this.fastGradientArraySize;
                    n9 -= this.fastGradientArraySize;
                }
                nArray[n2++] = nArray2[n9];
                f4 += f3;
            }
            n2 += n3;
        }
    }

    protected void fillSimpleReflect(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2 = this.dgdX * (float)n4 + this.gc;
        int[] nArray2 = this.gradient;
        for (int i2 = 0; i2 < n7; ++i2) {
            float f3 = f2 + this.dgdY * (float)(n5 + i2);
            f3 -= (float)(2 * (int)(f3 / 2.0f));
            float f4 = this.dgdX;
            if (f3 < 0.0f) {
                f3 = -f3;
                f4 = -f4;
            }
            if ((f4 -= 2.0f * ((float)((int)f4) / 2.0f)) < 0.0f) {
                f4 = (float)((double)f4 + 2.0);
            }
            int n8 = 2 * this.fastGradientArraySize;
            f3 *= (float)this.fastGradientArraySize;
            f3 = (float)((double)f3 + 0.5);
            f4 *= (float)this.fastGradientArraySize;
            int n9 = n2 + n6;
            while (n2 < n9) {
                int n10 = (int)f3;
                if (n10 >= n8) {
                    f3 -= (float)n8;
                    n10 -= n8;
                }
                nArray[n2++] = n10 <= this.fastGradientArraySize ? nArray2[n10] : nArray2[n8 - n10];
                f3 += f4;
            }
            n2 += n3;
        }
    }

    @Override
    protected void fillRaster(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2 = this.dgdX * (float)n4 + this.gc;
        if (this.fillMethod == 3) {
            for (int i2 = 0; i2 < n7; ++i2) {
                float f3 = f2 + this.dgdY * (float)(n5 + i2);
                int n8 = n2 + n6;
                while (n2 < n8) {
                    nArray[n2++] = this.indexGradientAntiAlias(f3, this.pixSz);
                    f3 += this.dgdX;
                }
                n2 += n3;
            }
        } else if (!this.isSimpleLookup) {
            if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
                this.fillHardNoCycle(nArray, n2, n3, n4, n5, n6, n7);
            } else {
                for (int i3 = 0; i3 < n7; ++i3) {
                    float f4 = f2 + this.dgdY * (float)(n5 + i3);
                    int n9 = n2 + n6;
                    while (n2 < n9) {
                        nArray[n2++] = this.indexIntoGradientsArrays(f4);
                        f4 += this.dgdX;
                    }
                    n2 += n3;
                }
            }
        } else if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            this.fillSimpleNoCycle(nArray, n2, n3, n4, n5, n6, n7);
        } else if (this.cycleMethod == MultipleGradientPaint.REPEAT) {
            this.fillSimpleRepeat(nArray, n2, n3, n4, n5, n6, n7);
        } else {
            this.fillSimpleReflect(nArray, n2, n3, n4, n5, n6, n7);
        }
    }
}

