/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import java.util.HashSet;
import java.util.List;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.events.EventListenerList;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;

public class EventSupport {
    protected HashTable capturingListeners;
    protected HashTable bubblingListeners;
    protected AbstractNode node;

    public EventSupport(AbstractNode abstractNode) {
        this.node = abstractNode;
    }

    public void addEventListener(String string2, EventListener eventListener, boolean bl2) {
        this.addEventListenerNS(null, string2, eventListener, bl2, null);
    }

    public void addEventListenerNS(String string2, String string3, EventListener eventListener, boolean bl2, Object object) {
        HashTable hashTable;
        if (bl2) {
            if (this.capturingListeners == null) {
                this.capturingListeners = new HashTable();
            }
            hashTable = this.capturingListeners;
        } else {
            if (this.bubblingListeners == null) {
                this.bubblingListeners = new HashTable();
            }
            hashTable = this.bubblingListeners;
        }
        EventListenerList eventListenerList = (EventListenerList)hashTable.get(string3);
        if (eventListenerList == null) {
            eventListenerList = new EventListenerList();
            hashTable.put(string3, eventListenerList);
        }
        eventListenerList.addListener(string2, object, eventListener);
    }

    public void removeEventListener(String string2, EventListener eventListener, boolean bl2) {
        this.removeEventListenerNS(null, string2, eventListener, bl2);
    }

    public void removeEventListenerNS(String string2, String string3, EventListener eventListener, boolean bl2) {
        HashTable hashTable = bl2 ? this.capturingListeners : this.bubblingListeners;
        if (hashTable == null) {
            return;
        }
        EventListenerList eventListenerList = (EventListenerList)hashTable.get(string3);
        if (eventListenerList != null) {
            eventListenerList.removeListener(string2, eventListener);
            if (eventListenerList.size() == 0) {
                hashTable.remove(string3);
            }
        }
    }

    public void moveEventListeners(EventSupport eventSupport) {
        eventSupport.capturingListeners = this.capturingListeners;
        eventSupport.bubblingListeners = this.bubblingListeners;
        this.capturingListeners = null;
        this.bubblingListeners = null;
    }

    public boolean dispatchEvent(NodeEventTarget nodeEventTarget, Event event) throws EventException {
        NodeEventTarget nodeEventTarget2;
        int n2;
        if (event == null) {
            return false;
        }
        if (!(event instanceof AbstractEvent)) {
            throw this.createEventException((short)9, "unsupported.event", new Object[0]);
        }
        AbstractEvent abstractEvent = (AbstractEvent)event;
        String string2 = abstractEvent.getType();
        if (string2 == null || string2.length() == 0) {
            throw this.createEventException((short)0, "unspecified.event", new Object[0]);
        }
        abstractEvent.setTarget(nodeEventTarget);
        abstractEvent.stopPropagation(false);
        abstractEvent.stopImmediatePropagation(false);
        abstractEvent.preventDefault(false);
        NodeEventTarget[] nodeEventTargetArray = this.getAncestors(nodeEventTarget);
        abstractEvent.setEventPhase((short)1);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (n2 = 0; n2 < nodeEventTargetArray.length; ++n2) {
            nodeEventTarget2 = nodeEventTargetArray[n2];
            abstractEvent.setCurrentTarget(nodeEventTarget2);
            this.fireEventListeners(nodeEventTarget2, abstractEvent, true, hashSet, hashSet2);
            hashSet.addAll(hashSet2);
            hashSet2.clear();
        }
        abstractEvent.setEventPhase((short)2);
        abstractEvent.setCurrentTarget(nodeEventTarget);
        this.fireEventListeners(nodeEventTarget, abstractEvent, false, hashSet, hashSet2);
        hashSet.addAll(hashSet2);
        hashSet2.clear();
        if (abstractEvent.getBubbles()) {
            abstractEvent.setEventPhase((short)3);
            for (n2 = nodeEventTargetArray.length - 1; n2 >= 0; --n2) {
                nodeEventTarget2 = nodeEventTargetArray[n2];
                abstractEvent.setCurrentTarget(nodeEventTarget2);
                this.fireEventListeners(nodeEventTarget2, abstractEvent, false, hashSet, hashSet2);
                hashSet.addAll(hashSet2);
                hashSet2.clear();
            }
        }
        if (!abstractEvent.getDefaultPrevented()) {
            this.runDefaultActions(abstractEvent);
        }
        return abstractEvent.getDefaultPrevented();
    }

    protected void runDefaultActions(AbstractEvent abstractEvent) {
        List list = abstractEvent.getDefaultActions();
        if (list != null) {
            for (Runnable runnable : list) {
                runnable.run();
            }
        }
    }

    protected void fireEventListeners(NodeEventTarget nodeEventTarget, AbstractEvent abstractEvent, EventListenerList.Entry[] entryArray, HashSet hashSet, HashSet hashSet2) {
        if (entryArray == null) {
            return;
        }
        String string2 = abstractEvent.getNamespaceURI();
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            try {
                String string3 = entryArray[i2].getNamespaceURI();
                if (string3 != null && string2 != null && !string3.equals(string2)) continue;
                Object object = entryArray[i2].getGroup();
                if (hashSet != null && hashSet.contains(object)) continue;
                entryArray[i2].getListener().handleEvent(abstractEvent);
                if (abstractEvent.getStopImmediatePropagation()) {
                    if (hashSet != null) {
                        hashSet.add(object);
                    }
                    abstractEvent.stopImmediatePropagation(false);
                    continue;
                }
                if (!abstractEvent.getStopPropagation()) continue;
                if (hashSet2 != null) {
                    hashSet2.add(object);
                }
                abstractEvent.stopPropagation(false);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void fireEventListeners(NodeEventTarget nodeEventTarget, AbstractEvent abstractEvent, boolean bl2, HashSet hashSet, HashSet hashSet2) {
        String string2 = abstractEvent.getType();
        EventSupport eventSupport = nodeEventTarget.getEventSupport();
        if (eventSupport == null) {
            return;
        }
        EventListenerList eventListenerList = eventSupport.getEventListeners(string2, bl2);
        if (eventListenerList == null) {
            return;
        }
        EventListenerList.Entry[] entryArray = eventListenerList.getEventListeners();
        this.fireEventListeners(nodeEventTarget, abstractEvent, entryArray, hashSet, hashSet2);
    }

    protected NodeEventTarget[] getAncestors(NodeEventTarget object) {
        object = object.getParentNodeEventTarget();
        int n2 = 0;
        NodeEventTarget[] nodeEventTargetArray = object;
        while (nodeEventTargetArray != null) {
            nodeEventTargetArray = nodeEventTargetArray.getParentNodeEventTarget();
            ++n2;
        }
        nodeEventTargetArray = new NodeEventTarget[n2];
        int n3 = n2 - 1;
        while (n3 >= 0) {
            nodeEventTargetArray[n3] = object;
            --n3;
            object = object.getParentNodeEventTarget();
        }
        return nodeEventTargetArray;
    }

    public boolean hasEventListenerNS(String string2, String string3) {
        EventListenerList eventListenerList;
        if (this.capturingListeners != null && (eventListenerList = (EventListenerList)this.capturingListeners.get(string3)) != null && eventListenerList.hasEventListener(string2)) {
            return true;
        }
        if (this.bubblingListeners != null && (eventListenerList = (EventListenerList)this.capturingListeners.get(string3)) != null) {
            return eventListenerList.hasEventListener(string2);
        }
        return false;
    }

    public EventListenerList getEventListeners(String string2, boolean bl2) {
        HashTable hashTable;
        HashTable hashTable2 = hashTable = bl2 ? this.capturingListeners : this.bubblingListeners;
        if (hashTable == null) {
            return null;
        }
        return (EventListenerList)hashTable.get(string2);
    }

    protected EventException createEventException(short s2, String string2, Object[] objectArray) {
        try {
            AbstractDocument abstractDocument = (AbstractDocument)this.node.getOwnerDocument();
            return new EventException(s2, abstractDocument.formatMessage(string2, objectArray));
        }
        catch (Exception exception) {
            return new EventException(s2, string2);
        }
    }

    protected void setTarget(AbstractEvent abstractEvent, NodeEventTarget nodeEventTarget) {
        abstractEvent.setTarget(nodeEventTarget);
    }

    protected void stopPropagation(AbstractEvent abstractEvent, boolean bl2) {
        abstractEvent.stopPropagation(bl2);
    }

    protected void stopImmediatePropagation(AbstractEvent abstractEvent, boolean bl2) {
        abstractEvent.stopImmediatePropagation(bl2);
    }

    protected void preventDefault(AbstractEvent abstractEvent, boolean bl2) {
        abstractEvent.preventDefault(bl2);
    }

    protected void setCurrentTarget(AbstractEvent abstractEvent, NodeEventTarget nodeEventTarget) {
        abstractEvent.setCurrentTarget(nodeEventTarget);
    }

    protected void setEventPhase(AbstractEvent abstractEvent, short s2) {
        abstractEvent.setEventPhase(s2);
    }

    public static Event getUltimateOriginalEvent(Event event) {
        AbstractEvent abstractEvent;
        AbstractEvent abstractEvent2 = (AbstractEvent)event;
        while ((abstractEvent = (AbstractEvent)abstractEvent2.getOriginalEvent()) != null) {
            abstractEvent2 = abstractEvent;
        }
        return abstractEvent2;
    }
}

