/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.batik.dom.xbl.OriginalEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public abstract class AbstractEvent
implements Event,
OriginalEvent,
Cloneable {
    protected String type;
    protected boolean isBubbling;
    protected boolean cancelable;
    protected EventTarget currentTarget;
    protected EventTarget target;
    protected short eventPhase;
    protected long timeStamp = System.currentTimeMillis();
    protected boolean stopPropagation = false;
    protected boolean stopImmediatePropagation = false;
    protected boolean preventDefault = false;
    protected String namespaceURI;
    protected Event originalEvent;
    protected List defaultActions;
    protected int bubbleLimit = 0;

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public EventTarget getCurrentTarget() {
        return this.currentTarget;
    }

    @Override
    public EventTarget getTarget() {
        return this.target;
    }

    @Override
    public short getEventPhase() {
        return this.eventPhase;
    }

    @Override
    public boolean getBubbles() {
        return this.isBubbling;
    }

    @Override
    public boolean getCancelable() {
        return this.cancelable;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public Event getOriginalEvent() {
        return this.originalEvent;
    }

    @Override
    public void stopPropagation() {
        this.stopPropagation = true;
    }

    @Override
    public void preventDefault() {
        this.preventDefault = true;
    }

    @Override
    public boolean getDefaultPrevented() {
        return this.preventDefault;
    }

    public List getDefaultActions() {
        return this.defaultActions;
    }

    public void addDefaultAction(Runnable runnable) {
        if (this.defaultActions == null) {
            this.defaultActions = new ArrayList();
        }
        this.defaultActions.add(runnable);
    }

    @Override
    public void stopImmediatePropagation() {
        this.stopImmediatePropagation = true;
    }

    @Override
    public void initEvent(String string2, boolean bl2, boolean bl3) {
        this.type = string2;
        this.isBubbling = bl2;
        this.cancelable = bl3;
    }

    @Override
    public void initEventNS(String string2, String string3, boolean bl2, boolean bl3) {
        if (this.namespaceURI != null && this.namespaceURI.length() == 0) {
            this.namespaceURI = null;
        }
        this.namespaceURI = string2;
        this.type = string3;
        this.isBubbling = bl2;
        this.cancelable = bl3;
    }

    boolean getStopPropagation() {
        return this.stopPropagation;
    }

    boolean getStopImmediatePropagation() {
        return this.stopImmediatePropagation;
    }

    void setEventPhase(short s2) {
        this.eventPhase = s2;
    }

    void stopPropagation(boolean bl2) {
        this.stopPropagation = bl2;
    }

    void stopImmediatePropagation(boolean bl2) {
        this.stopImmediatePropagation = bl2;
    }

    void preventDefault(boolean bl2) {
        this.preventDefault = bl2;
    }

    void setCurrentTarget(EventTarget eventTarget) {
        this.currentTarget = eventTarget;
    }

    void setTarget(EventTarget eventTarget) {
        this.target = eventTarget;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractEvent abstractEvent = (AbstractEvent)super.clone();
        abstractEvent.timeStamp = System.currentTimeMillis();
        return abstractEvent;
    }

    public AbstractEvent cloneEvent() {
        try {
            AbstractEvent abstractEvent = (AbstractEvent)this.clone();
            abstractEvent.originalEvent = this;
            return abstractEvent;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int getBubbleLimit() {
        return this.bubbleLimit;
    }

    public void setBubbleLimit(int n2) {
        this.bubbleLimit = n2;
    }
}

