/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.css.parser.ExtendedParserWrapper;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.DomExtension;
import org.apache.batik.dom.GenericDocumentType;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.DoublyIndexedTable;
import org.apache.batik.util.Service;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.css.DOMImplementationCSS;
import org.w3c.dom.css.ViewCSS;

public abstract class ExtensibleDOMImplementation
extends AbstractDOMImplementation
implements DOMImplementationCSS,
StyleSheetFactory {
    protected DoublyIndexedTable customFactories;
    protected List customValueManagers;
    protected List customShorthandManagers;
    protected static List extensions = null;

    public ExtensibleDOMImplementation() {
        for (DomExtension domExtension : ExtensibleDOMImplementation.getDomExtensions()) {
            domExtension.registerTags(this);
        }
    }

    public void registerCustomElementFactory(String string2, String string3, ElementFactory elementFactory) {
        if (this.customFactories == null) {
            this.customFactories = new DoublyIndexedTable();
        }
        this.customFactories.put(string2, string3, elementFactory);
    }

    public void registerCustomCSSValueManager(ValueManager valueManager) {
        if (this.customValueManagers == null) {
            this.customValueManagers = new LinkedList();
        }
        this.customValueManagers.add(valueManager);
    }

    public void registerCustomCSSShorthandManager(ShorthandManager shorthandManager) {
        if (this.customShorthandManagers == null) {
            this.customShorthandManagers = new LinkedList();
        }
        this.customShorthandManagers.add(shorthandManager);
    }

    public CSSEngine createCSSEngine(AbstractStylableDocument abstractStylableDocument, CSSContext cSSContext) {
        ShorthandManager[] shorthandManagerArray;
        ValueManager[] valueManagerArray;
        Parser parser2;
        String string2 = XMLResourceDescriptor.getCSSParserClassName();
        try {
            parser2 = (Parser)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DOMException(15, this.formatMessage("css.parser.class", new Object[]{string2}));
        }
        catch (InstantiationException instantiationException) {
            throw new DOMException(15, this.formatMessage("css.parser.creation", new Object[]{string2}));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DOMException(15, this.formatMessage("css.parser.access", new Object[]{string2}));
        }
        ExtendedParser extendedParser = ExtendedParserWrapper.wrap(parser2);
        if (this.customValueManagers == null) {
            valueManagerArray = new ValueManager[]{};
        } else {
            valueManagerArray = new ValueManager[this.customValueManagers.size()];
            shorthandManagerArray = this.customValueManagers.iterator();
            int n2 = 0;
            while (shorthandManagerArray.hasNext()) {
                valueManagerArray[n2++] = (ValueManager)shorthandManagerArray.next();
            }
        }
        if (this.customShorthandManagers == null) {
            shorthandManagerArray = new ShorthandManager[]{};
        } else {
            shorthandManagerArray = new ShorthandManager[this.customShorthandManagers.size()];
            Iterator iterator = this.customShorthandManagers.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                shorthandManagerArray[n3++] = (ShorthandManager)iterator.next();
            }
        }
        CSSEngine cSSEngine = this.createCSSEngine(abstractStylableDocument, cSSContext, extendedParser, valueManagerArray, shorthandManagerArray);
        abstractStylableDocument.setCSSEngine(cSSEngine);
        return cSSEngine;
    }

    public abstract CSSEngine createCSSEngine(AbstractStylableDocument var1, CSSContext var2, ExtendedParser var3, ValueManager[] var4, ShorthandManager[] var5);

    public abstract ViewCSS createViewCSS(AbstractStylableDocument var1);

    public Element createElementNS(AbstractDocument abstractDocument, String string2, String string3) {
        String string4;
        ElementFactory elementFactory;
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string2 == null) {
            return new GenericElement(string3.intern(), abstractDocument);
        }
        if (this.customFactories != null && (elementFactory = (ElementFactory)this.customFactories.get(string2, string4 = DOMUtilities.getLocalName(string3))) != null) {
            return elementFactory.create(DOMUtilities.getPrefix(string3), abstractDocument);
        }
        return new GenericElementNS(string2.intern(), string3.intern(), abstractDocument);
    }

    @Override
    public DocumentType createDocumentType(String string2, String string3, String string4) {
        int n2;
        if (string2 == null) {
            string2 = "";
        }
        if (((n2 = XMLUtilities.testXMLQName(string2)) & 1) == 0) {
            throw new DOMException(5, this.formatMessage("xml.name", new Object[]{string2}));
        }
        if ((n2 & 2) == 0) {
            throw new DOMException(5, this.formatMessage("invalid.qname", new Object[]{string2}));
        }
        return new GenericDocumentType(string2, string3, string4);
    }

    protected static synchronized List getDomExtensions() {
        if (extensions != null) {
            return extensions;
        }
        extensions = new LinkedList();
        Iterator iterator = Service.providers(DomExtension.class);
        block0: while (iterator.hasNext()) {
            DomExtension domExtension;
            DomExtension domExtension2 = (DomExtension)iterator.next();
            float f2 = domExtension2.getPriority();
            ListIterator<DomExtension> listIterator = extensions.listIterator();
            do {
                if (listIterator.hasNext()) continue;
                listIterator.add(domExtension2);
                continue block0;
            } while (!((domExtension = (DomExtension)listIterator.next()).getPriority() > f2));
            listIterator.previous();
            listIterator.add(domExtension2);
        }
        return extensions;
    }

    public static interface ElementFactory {
        public Element create(String var1, Document var2);
    }
}

