/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.w3c.dom.DOMImplementation;

public abstract class AbstractDOMImplementation
implements DOMImplementation,
Localizable,
Serializable {
    protected static final String RESOURCES = "org.apache.batik.dom.resources.Messages";
    protected LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.resources.Messages", this.getClass().getClassLoader());
    protected final HashTable features = new HashTable();

    protected void registerFeature(String string2, Object object) {
        this.features.put(string2.toLowerCase(), object);
    }

    protected AbstractDOMImplementation() {
        this.registerFeature("Core", new String[]{"2.0", "3.0"});
        this.registerFeature("XML", new String[]{"1.0", "2.0", "3.0"});
        this.registerFeature("Events", new String[]{"2.0", "3.0"});
        this.registerFeature("UIEvents", new String[]{"2.0", "3.0"});
        this.registerFeature("MouseEvents", new String[]{"2.0", "3.0"});
        this.registerFeature("TextEvents", "3.0");
        this.registerFeature("KeyboardEvents", "3.0");
        this.registerFeature("MutationEvents", new String[]{"2.0", "3.0"});
        this.registerFeature("MutationNameEvents", "3.0");
        this.registerFeature("Traversal", "2.0");
        this.registerFeature("XPath", "3.0");
    }

    @Override
    public boolean hasFeature(String string2, String string3) {
        Object object;
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (string2.charAt(0) == '+') {
            string2 = string2.substring(1);
        }
        if ((object = this.features.get(string2.toLowerCase())) == null) {
            return false;
        }
        if (string3 == null || string3.length() == 0) {
            return true;
        }
        if (object instanceof String) {
            return string3.equals(object);
        }
        String[] stringArray = (String[])object;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string3.equals(stringArray[i2])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getFeature(String string2, String string3) {
        if (this.hasFeature(string2, string3)) {
            return this;
        }
        return null;
    }

    public DocumentEventSupport createDocumentEventSupport() {
        return new DocumentEventSupport();
    }

    public EventSupport createEventSupport(AbstractNode abstractNode) {
        return new EventSupport(abstractNode);
    }

    @Override
    public void setLocale(Locale locale2) {
        this.localizableSupport.setLocale(locale2);
    }

    @Override
    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    protected void initLocalizable() {
    }

    @Override
    public String formatMessage(String string2, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string2, objectArray);
    }
}

