/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractChildNode;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractParentNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class AbstractCharacterData
extends AbstractChildNode
implements CharacterData {
    protected String nodeValue = "";

    @Override
    public String getNodeValue() throws DOMException {
        return this.nodeValue;
    }

    @Override
    public void setNodeValue(String string2) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        String string3 = this.nodeValue;
        this.nodeValue = string2 == null ? "" : string2;
        this.fireDOMCharacterDataModifiedEvent(string3, this.nodeValue);
        if (this.getParentNode() != null) {
            ((AbstractParentNode)this.getParentNode()).fireDOMSubtreeModifiedEvent();
        }
    }

    @Override
    public String getData() throws DOMException {
        return this.getNodeValue();
    }

    @Override
    public void setData(String string2) throws DOMException {
        this.setNodeValue(string2);
    }

    @Override
    public int getLength() {
        return this.nodeValue.length();
    }

    @Override
    public String substringData(int n2, int n3) throws DOMException {
        this.checkOffsetCount(n2, n3);
        String string2 = this.getNodeValue();
        return string2.substring(n2, Math.min(string2.length(), n2 + n3));
    }

    @Override
    public void appendData(String string2) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        this.setNodeValue(this.getNodeValue() + (string2 == null ? "" : string2));
    }

    @Override
    public void insertData(int n2, String string2) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (n2 < 0 || n2 > this.getLength()) {
            throw this.createDOMException((short)1, "offset", new Object[]{new Integer(n2)});
        }
        String string3 = this.getNodeValue();
        this.setNodeValue(string3.substring(0, n2) + string2 + string3.substring(n2, string3.length()));
    }

    @Override
    public void deleteData(int n2, int n3) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        this.checkOffsetCount(n2, n3);
        String string2 = this.getNodeValue();
        this.setNodeValue(string2.substring(0, n2) + string2.substring(Math.min(string2.length(), n2 + n3), string2.length()));
    }

    @Override
    public void replaceData(int n2, int n3, String string2) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        this.checkOffsetCount(n2, n3);
        String string3 = this.getNodeValue();
        this.setNodeValue(string3.substring(0, n2) + string2 + string3.substring(Math.min(string3.length(), n2 + n3), string3.length()));
    }

    protected void checkOffsetCount(int n2, int n3) throws DOMException {
        if (n2 < 0 || n2 >= this.getLength()) {
            throw this.createDOMException((short)1, "offset", new Object[]{new Integer(n2)});
        }
        if (n3 < 0) {
            throw this.createDOMException((short)1, "negative.count", new Object[]{new Integer(n3)});
        }
    }

    @Override
    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        AbstractCharacterData abstractCharacterData = (AbstractCharacterData)node;
        abstractCharacterData.nodeValue = this.nodeValue;
        return node;
    }

    @Override
    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        AbstractCharacterData abstractCharacterData = (AbstractCharacterData)node;
        abstractCharacterData.nodeValue = this.nodeValue;
        return node;
    }

    @Override
    protected Node copyInto(Node node) {
        super.copyInto(node);
        AbstractCharacterData abstractCharacterData = (AbstractCharacterData)node;
        abstractCharacterData.nodeValue = this.nodeValue;
        return node;
    }

    @Override
    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        AbstractCharacterData abstractCharacterData = (AbstractCharacterData)node;
        abstractCharacterData.nodeValue = this.nodeValue;
        return node;
    }
}

