/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg12;

import org.apache.batik.css.engine.value.AbstractValue;
import org.w3c.dom.DOMException;

public class DeviceColor
extends AbstractValue {
    public static final String DEVICE_GRAY_COLOR_FUNCTION = "device-gray";
    public static final String DEVICE_RGB_COLOR_FUNCTION = "device-rgb";
    public static final String DEVICE_CMYK_COLOR_FUNCTION = "device-cmyk";
    public static final String DEVICE_NCHANNEL_COLOR_FUNCTION = "device-nchannel";
    protected boolean nChannel;
    protected int count;
    protected float[] colors = new float[5];

    public DeviceColor(boolean bl2) {
        this.nChannel = bl2;
    }

    @Override
    public short getCssValueType() {
        return 3;
    }

    public boolean isNChannel() {
        return this.nChannel;
    }

    public int getNumberOfColors() throws DOMException {
        return this.count;
    }

    public float getColor(int n2) throws DOMException {
        return this.colors[n2];
    }

    @Override
    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer(this.count * 8);
        if (this.nChannel) {
            stringBuffer.append(DEVICE_NCHANNEL_COLOR_FUNCTION);
        } else {
            switch (this.count) {
                case 1: {
                    stringBuffer.append(DEVICE_GRAY_COLOR_FUNCTION);
                    break;
                }
                case 3: {
                    stringBuffer.append(DEVICE_RGB_COLOR_FUNCTION);
                    break;
                }
                case 4: {
                    stringBuffer.append(DEVICE_CMYK_COLOR_FUNCTION);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid number of components encountered");
                }
            }
        }
        stringBuffer.append('(');
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.colors[i2]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void append(float f2) {
        if (this.count == this.colors.length) {
            float[] fArray = new float[this.count * 2];
            System.arraycopy(this.colors, 0, fArray, 0, this.count);
            this.colors = fArray;
        }
        this.colors[this.count++] = f2;
    }

    public String toString() {
        return this.getCssText();
    }
}

