/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.ColorManager;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.apache.batik.css.engine.value.svg12.CIELCHColor;
import org.apache.batik.css.engine.value.svg12.CIELabColor;
import org.apache.batik.css.engine.value.svg12.DeviceColor;
import org.apache.batik.css.engine.value.svg12.ICCNamedColor;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class SVGColorManager
extends ColorManager {
    protected String property;
    protected Value defaultValue;

    public SVGColorManager(String string2) {
        this(string2, SVGValueConstants.BLACK_RGB_VALUE);
    }

    public SVGColorManager(String string2, Value value) {
        this.property = string2;
        this.defaultValue = value;
    }

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 6;
    }

    @Override
    public String getPropertyName() {
        return this.property;
    }

    @Override
    public Value getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        if (lexicalUnit.getLexicalUnitType() == 35 && lexicalUnit.getStringValue().equalsIgnoreCase("currentcolor")) {
            return SVGValueConstants.CURRENTCOLOR_VALUE;
        }
        Value value = super.createValue(lexicalUnit, cSSEngine);
        if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
            return value;
        }
        if (lexicalUnit.getLexicalUnitType() != 41) {
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        }
        ListValue listValue = new ListValue(' ');
        listValue.append(value);
        Value value2 = this.parseColorFunction(lexicalUnit, value);
        if (value2 == null) {
            return value;
        }
        listValue.append(value2);
        return listValue;
    }

    private Value parseColorFunction(LexicalUnit lexicalUnit, Value value) {
        String string2 = lexicalUnit.getFunctionName();
        if (string2.equalsIgnoreCase("icc-color")) {
            return this.createICCColorValue(lexicalUnit, value);
        }
        return this.parseColor12Function(lexicalUnit, value);
    }

    private Value parseColor12Function(LexicalUnit lexicalUnit, Value value) {
        String string2 = lexicalUnit.getFunctionName();
        if (string2.equalsIgnoreCase("icc-named-color")) {
            return this.createICCNamedColorValue(lexicalUnit, value);
        }
        if (string2.equalsIgnoreCase("cielab")) {
            return this.createCIELabColorValue(lexicalUnit, value);
        }
        if (string2.equalsIgnoreCase("cielch")) {
            return this.createCIELCHColorValue(lexicalUnit, value);
        }
        if (string2.equalsIgnoreCase("device-cmyk")) {
            return this.createDeviceColorValue(lexicalUnit, value, 4);
        }
        if (string2.equalsIgnoreCase("device-rgb")) {
            return this.createDeviceColorValue(lexicalUnit, value, 3);
        }
        if (string2.equalsIgnoreCase("device-gray")) {
            return this.createDeviceColorValue(lexicalUnit, value, 1);
        }
        if (string2.equalsIgnoreCase("device-nchannel")) {
            return this.createDeviceColorValue(lexicalUnit, value, 0);
        }
        return null;
    }

    private Value createICCColorValue(LexicalUnit lexicalUnit, Value value) {
        lexicalUnit = lexicalUnit.getParameters();
        this.expectIdent(lexicalUnit);
        ICCColor iCCColor = new ICCColor(lexicalUnit.getStringValue());
        for (lexicalUnit = lexicalUnit.getNextLexicalUnit(); lexicalUnit != null; lexicalUnit = lexicalUnit.getNextLexicalUnit()) {
            this.expectComma(lexicalUnit);
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
            iCCColor.append(this.getColorValue(lexicalUnit));
        }
        return iCCColor;
    }

    private Value createICCNamedColorValue(LexicalUnit lexicalUnit, Value value) {
        lexicalUnit = lexicalUnit.getParameters();
        this.expectIdent(lexicalUnit);
        String string2 = lexicalUnit.getStringValue();
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        this.expectComma(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        this.expectIdent(lexicalUnit);
        String string3 = lexicalUnit.getStringValue();
        ICCNamedColor iCCNamedColor = new ICCNamedColor(string2, string3);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        return iCCNamedColor;
    }

    private Value createCIELabColorValue(LexicalUnit lexicalUnit, Value value) {
        lexicalUnit = lexicalUnit.getParameters();
        float f2 = this.getColorValue(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        this.expectComma(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        float f3 = this.getColorValue(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        this.expectComma(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        float f4 = this.getColorValue(lexicalUnit);
        CIELabColor cIELabColor = new CIELabColor(f2, f3, f4);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        return cIELabColor;
    }

    private Value createCIELCHColorValue(LexicalUnit lexicalUnit, Value value) {
        lexicalUnit = lexicalUnit.getParameters();
        float f2 = this.getColorValue(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        this.expectComma(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        float f3 = this.getColorValue(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        this.expectComma(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        float f4 = this.getColorValue(lexicalUnit);
        CIELCHColor cIELCHColor = new CIELCHColor(f2, f3, f4);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        return cIELCHColor;
    }

    private Value createDeviceColorValue(LexicalUnit lexicalUnit, Value value, int n2) {
        lexicalUnit = lexicalUnit.getParameters();
        boolean bl2 = n2 <= 0;
        DeviceColor deviceColor = new DeviceColor(bl2);
        deviceColor.append(this.getColorValue(lexicalUnit));
        LexicalUnit lexicalUnit2 = lexicalUnit;
        for (lexicalUnit = lexicalUnit.getNextLexicalUnit(); lexicalUnit != null; lexicalUnit = lexicalUnit.getNextLexicalUnit()) {
            this.expectComma(lexicalUnit);
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
            deviceColor.append(this.getColorValue(lexicalUnit));
            lexicalUnit2 = lexicalUnit;
        }
        if (!bl2 && n2 != deviceColor.getNumberOfColors()) {
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit2.getLexicalUnitType());
        }
        return deviceColor;
    }

    private void expectIdent(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() != 35) {
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        }
    }

    private void expectComma(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() != 0) {
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        }
    }

    private void expectNonNull(LexicalUnit lexicalUnit) {
        if (lexicalUnit == null) {
            throw this.createInvalidLexicalUnitDOMException((short)-1);
        }
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string2, CSSEngine cSSEngine, int n2, StyleMap styleMap, Value value) {
        if (value == SVGValueConstants.CURRENTCOLOR_VALUE) {
            styleMap.putColorRelative(n2, true);
            int n3 = cSSEngine.getColorIndex();
            return cSSEngine.getComputedStyle(cSSStylableElement, string2, n3);
        }
        if (value.getCssValueType() == 2) {
            ListValue listValue = (ListValue)value;
            Value value2 = listValue.item(0);
            Value value3 = super.computeValue(cSSStylableElement, string2, cSSEngine, n2, styleMap, value2);
            if (value3 != value2) {
                ListValue listValue2 = new ListValue(' ');
                listValue2.append(value3);
                listValue2.append(listValue.item(1));
                return listValue2;
            }
            return value;
        }
        return super.computeValue(cSSStylableElement, string2, cSSEngine, n2, styleMap, value);
    }

    protected float getColorValue(LexicalUnit lexicalUnit) {
        this.expectNonNull(lexicalUnit);
        switch (lexicalUnit.getLexicalUnitType()) {
            case 13: {
                return lexicalUnit.getIntegerValue();
            }
            case 14: {
                return lexicalUnit.getFloatValue();
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }
}

