/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.URIValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class MarkerManager
extends AbstractValueManager {
    protected String property;

    public MarkerManager(String string2) {
        this.property = string2;
    }

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 20;
    }

    @Override
    public String getPropertyName() {
        return this.property;
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 24: {
                return new URIValue(lexicalUnit.getStringValue(), MarkerManager.resolveURI(cSSEngine.getCSSBaseURI(), lexicalUnit.getStringValue()));
            }
            case 35: {
                if (!lexicalUnit.getStringValue().equalsIgnoreCase("none")) break;
                return ValueConstants.NONE_VALUE;
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createStringValue(short s2, String string2, CSSEngine cSSEngine) throws DOMException {
        switch (s2) {
            case 21: {
                if (!string2.equalsIgnoreCase("none")) break;
                return ValueConstants.NONE_VALUE;
            }
            case 20: {
                return new URIValue(string2, MarkerManager.resolveURI(cSSEngine.getCSSBaseURI(), string2));
            }
        }
        throw this.createInvalidStringTypeDOMException(s2);
    }
}

