/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import org.apache.batik.css.engine.value.Messages;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.DOMException;

public abstract class AbstractValueFactory {
    public abstract String getPropertyName();

    protected static String resolveURI(ParsedURL parsedURL, String string2) {
        return new ParsedURL(parsedURL, string2).toString();
    }

    protected DOMException createInvalidIdentifierDOMException(String string2) {
        Object[] objectArray = new Object[]{this.getPropertyName(), string2};
        String string3 = Messages.formatMessage("invalid.identifier", objectArray);
        return new DOMException(12, string3);
    }

    protected DOMException createInvalidLexicalUnitDOMException(short s2) {
        Object[] objectArray = new Object[]{this.getPropertyName(), new Integer(s2)};
        String string2 = Messages.formatMessage("invalid.lexical.unit", objectArray);
        return new DOMException(9, string2);
    }

    protected DOMException createInvalidFloatTypeDOMException(short s2) {
        Object[] objectArray = new Object[]{this.getPropertyName(), new Integer(s2)};
        String string2 = Messages.formatMessage("invalid.float.type", objectArray);
        return new DOMException(15, string2);
    }

    protected DOMException createInvalidFloatValueDOMException(float f2) {
        Object[] objectArray = new Object[]{this.getPropertyName(), new Float(f2)};
        String string2 = Messages.formatMessage("invalid.float.value", objectArray);
        return new DOMException(15, string2);
    }

    protected DOMException createInvalidStringTypeDOMException(short s2) {
        Object[] objectArray = new Object[]{this.getPropertyName(), new Integer(s2)};
        String string2 = Messages.formatMessage("invalid.string.type", objectArray);
        return new DOMException(15, string2);
    }

    protected DOMException createMalformedLexicalUnitDOMException() {
        Object[] objectArray = new Object[]{this.getPropertyName()};
        String string2 = Messages.formatMessage("malformed.lexical.unit", objectArray);
        return new DOMException(15, string2);
    }

    protected DOMException createDOMException() {
        Object[] objectArray = new Object[]{this.getPropertyName()};
        String string2 = Messages.formatMessage("invalid.access", objectArray);
        return new DOMException(9, string2);
    }
}

