/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.sac;

import java.util.Set;
import org.apache.batik.css.engine.sac.ExtendedCondition;
import org.w3c.css.sac.LangCondition;
import org.w3c.dom.Element;

public class CSSLangCondition
implements LangCondition,
ExtendedCondition {
    protected String lang;
    protected String langHyphen;

    public CSSLangCondition(String string2) {
        this.lang = string2.toLowerCase();
        this.langHyphen = string2 + '-';
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        CSSLangCondition cSSLangCondition = (CSSLangCondition)object;
        return cSSLangCondition.lang.equals(this.lang);
    }

    public short getConditionType() {
        return 6;
    }

    public String getLang() {
        return this.lang;
    }

    @Override
    public int getSpecificity() {
        return 256;
    }

    @Override
    public boolean match(Element element, String string2) {
        String string3 = element.getAttribute("lang").toLowerCase();
        if (string3.equals(this.lang) || string3.startsWith(this.langHyphen)) {
            return true;
        }
        string3 = element.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang").toLowerCase();
        return string3.equals(this.lang) || string3.startsWith(this.langHyphen);
    }

    @Override
    public void fillAttributeSet(Set set) {
        set.add("lang");
    }

    public String toString() {
        return ":lang(" + this.lang + ')';
    }
}

