/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.Value;

public class StyleMap {
    public static final short IMPORTANT_MASK = 1;
    public static final short COMPUTED_MASK = 2;
    public static final short NULL_CASCADED_MASK = 4;
    public static final short INHERITED_MASK = 8;
    public static final short LINE_HEIGHT_RELATIVE_MASK = 16;
    public static final short FONT_SIZE_RELATIVE_MASK = 32;
    public static final short COLOR_RELATIVE_MASK = 64;
    public static final short PARENT_RELATIVE_MASK = 128;
    public static final short BLOCK_WIDTH_RELATIVE_MASK = 256;
    public static final short BLOCK_HEIGHT_RELATIVE_MASK = 512;
    public static final short BOX_RELATIVE_MASK = 1024;
    public static final short ORIGIN_MASK = -8192;
    public static final short USER_AGENT_ORIGIN = 0;
    public static final short USER_ORIGIN = 8192;
    public static final short NON_CSS_ORIGIN = 16384;
    public static final short AUTHOR_ORIGIN = 24576;
    public static final short INLINE_AUTHOR_ORIGIN = Short.MIN_VALUE;
    public static final short OVERRIDE_ORIGIN = -24576;
    protected Value[] values;
    protected short[] masks;
    protected boolean fixedCascadedValues;

    public StyleMap(int n2) {
        this.values = new Value[n2];
        this.masks = new short[n2];
    }

    public boolean hasFixedCascadedValues() {
        return this.fixedCascadedValues;
    }

    public void setFixedCascadedStyle(boolean bl2) {
        this.fixedCascadedValues = bl2;
    }

    public Value getValue(int n2) {
        return this.values[n2];
    }

    public short getMask(int n2) {
        return this.masks[n2];
    }

    public boolean isImportant(int n2) {
        return (this.masks[n2] & 1) != 0;
    }

    public boolean isComputed(int n2) {
        return (this.masks[n2] & 2) != 0;
    }

    public boolean isNullCascaded(int n2) {
        return (this.masks[n2] & 4) != 0;
    }

    public boolean isInherited(int n2) {
        return (this.masks[n2] & 8) != 0;
    }

    public short getOrigin(int n2) {
        return (short)(this.masks[n2] & 0xFFFFE000);
    }

    public boolean isColorRelative(int n2) {
        return (this.masks[n2] & 0x40) != 0;
    }

    public boolean isParentRelative(int n2) {
        return (this.masks[n2] & 0x80) != 0;
    }

    public boolean isLineHeightRelative(int n2) {
        return (this.masks[n2] & 0x10) != 0;
    }

    public boolean isFontSizeRelative(int n2) {
        return (this.masks[n2] & 0x20) != 0;
    }

    public boolean isBlockWidthRelative(int n2) {
        return (this.masks[n2] & 0x100) != 0;
    }

    public boolean isBlockHeightRelative(int n2) {
        return (this.masks[n2] & 0x200) != 0;
    }

    public void putValue(int n2, Value value) {
        this.values[n2] = value;
    }

    public void putMask(int n2, short s2) {
        this.masks[n2] = s2;
    }

    public void putImportant(int n2, boolean bl2) {
        if (bl2) {
            int n3 = n2;
            this.masks[n3] = (short)(this.masks[n3] | 1);
        } else {
            int n4 = n2;
            this.masks[n4] = (short)(this.masks[n4] & 0xFFFFFFFE);
        }
    }

    public void putOrigin(int n2, short s2) {
        int n3 = n2;
        this.masks[n3] = (short)(this.masks[n3] & 0x1FFF);
        int n4 = n2;
        this.masks[n4] = (short)(this.masks[n4] | (short)(s2 & 0xFFFFE000));
    }

    public void putComputed(int n2, boolean bl2) {
        if (bl2) {
            int n3 = n2;
            this.masks[n3] = (short)(this.masks[n3] | 2);
        } else {
            int n4 = n2;
            this.masks[n4] = (short)(this.masks[n4] & 0xFFFFFFFD);
        }
    }

    public void putNullCascaded(int n2, boolean bl2) {
        if (bl2) {
            int n3 = n2;
            this.masks[n3] = (short)(this.masks[n3] | 4);
        } else {
            int n4 = n2;
            this.masks[n4] = (short)(this.masks[n4] & 0xFFFFFFFB);
        }
    }

    public void putInherited(int n2, boolean bl2) {
        if (bl2) {
            int n3 = n2;
            this.masks[n3] = (short)(this.masks[n3] | 8);
        } else {
            int n4 = n2;
            this.masks[n4] = (short)(this.masks[n4] & 0xFFFFFFF7);
        }
    }

    public void putColorRelative(int n2, boolean bl2) {
        if (bl2) {
            int n3 = n2;
            this.masks[n3] = (short)(this.masks[n3] | 0x40);
        } else {
            int n4 = n2;
            this.masks[n4] = (short)(this.masks[n4] & 0xFFFFFFBF);
        }
    }

    public void putParentRelative(int n2, boolean bl2) {
        if (bl2) {
            int n3 = n2;
            this.masks[n3] = (short)(this.masks[n3] | 0x80);
        } else {
            int n4 = n2;
            this.masks[n4] = (short)(this.masks[n4] & 0xFFFFFF7F);
        }
    }

    public void putLineHeightRelative(int n2, boolean bl2) {
        if (bl2) {
            int n3 = n2;
            this.masks[n3] = (short)(this.masks[n3] | 0x10);
        } else {
            int n4 = n2;
            this.masks[n4] = (short)(this.masks[n4] & 0xFFFFFFEF);
        }
    }

    public void putFontSizeRelative(int n2, boolean bl2) {
        if (bl2) {
            int n3 = n2;
            this.masks[n3] = (short)(this.masks[n3] | 0x20);
        } else {
            int n4 = n2;
            this.masks[n4] = (short)(this.masks[n4] & 0xFFFFFFDF);
        }
    }

    public void putBlockWidthRelative(int n2, boolean bl2) {
        if (bl2) {
            int n3 = n2;
            this.masks[n3] = (short)(this.masks[n3] | 0x100);
        } else {
            int n4 = n2;
            this.masks[n4] = (short)(this.masks[n4] & 0xFFFFFEFF);
        }
    }

    public void putBlockHeightRelative(int n2, boolean bl2) {
        if (bl2) {
            int n3 = n2;
            this.masks[n3] = (short)(this.masks[n3] | 0x200);
        } else {
            int n4 = n2;
            this.masks[n4] = (short)(this.masks[n4] & 0xFFFFFDFF);
        }
    }

    public String toString(CSSEngine cSSEngine) {
        int n2 = this.values.length;
        StringBuffer stringBuffer = new StringBuffer(n2 * 8);
        for (int i2 = 0; i2 < n2; ++i2) {
            Value value = this.values[i2];
            if (value == null) continue;
            stringBuffer.append(cSSEngine.getPropertyName(i2));
            stringBuffer.append(": ");
            stringBuffer.append(value);
            if (this.isImportant(i2)) {
                stringBuffer.append(" !important");
            }
            stringBuffer.append(";\n");
        }
        return stringBuffer.toString();
    }
}

