/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.Value;

public class StyleDeclaration {
    protected static final int INITIAL_LENGTH = 8;
    protected Value[] values = new Value[8];
    protected int[] indexes = new int[8];
    protected boolean[] priorities = new boolean[8];
    protected int count;

    public int size() {
        return this.count;
    }

    public Value getValue(int n2) {
        return this.values[n2];
    }

    public int getIndex(int n2) {
        return this.indexes[n2];
    }

    public boolean getPriority(int n2) {
        return this.priorities[n2];
    }

    public void remove(int n2) {
        --this.count;
        int n3 = n2 + 1;
        int n4 = n2;
        int n5 = this.count - n2;
        System.arraycopy(this.values, n3, this.values, n4, n5);
        System.arraycopy(this.indexes, n3, this.indexes, n4, n5);
        System.arraycopy(this.priorities, n3, this.priorities, n4, n5);
        this.values[this.count] = null;
        this.indexes[this.count] = 0;
        this.priorities[this.count] = false;
    }

    public void put(int n2, Value value, int n3, boolean bl2) {
        this.values[n2] = value;
        this.indexes[n2] = n3;
        this.priorities[n2] = bl2;
    }

    public void append(Value value, int n2, boolean bl2) {
        if (this.values.length == this.count) {
            Value[] valueArray = new Value[this.count * 2];
            int[] nArray = new int[this.count * 2];
            boolean[] blArray = new boolean[this.count * 2];
            System.arraycopy(this.values, 0, valueArray, 0, this.count);
            System.arraycopy(this.indexes, 0, nArray, 0, this.count);
            System.arraycopy(this.priorities, 0, blArray, 0, this.count);
            this.values = valueArray;
            this.indexes = nArray;
            this.priorities = blArray;
        }
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (this.indexes[i2] != n2) continue;
            if (bl2 || this.priorities[i2] == bl2) {
                this.values[i2] = value;
                this.priorities[i2] = bl2;
            }
            return;
        }
        this.values[this.count] = value;
        this.indexes[this.count] = n2;
        this.priorities[this.count] = bl2;
        ++this.count;
    }

    public String toString(CSSEngine cSSEngine) {
        StringBuffer stringBuffer = new StringBuffer(this.count * 8);
        for (int i2 = 0; i2 < this.count; ++i2) {
            stringBuffer.append(cSSEngine.getPropertyName(this.indexes[i2]));
            stringBuffer.append(": ");
            stringBuffer.append(this.values[i2]);
            stringBuffer.append(";\n");
        }
        return stringBuffer.toString();
    }
}

