/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSEngineListener;
import org.apache.batik.css.engine.CSSEngineUserAgent;
import org.apache.batik.css.engine.CSSNavigableDocument;
import org.apache.batik.css.engine.CSSNavigableDocumentListener;
import org.apache.batik.css.engine.CSSNavigableNode;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.CSSStyleSheetNode;
import org.apache.batik.css.engine.FontFaceRule;
import org.apache.batik.css.engine.ImportRule;
import org.apache.batik.css.engine.MediaRule;
import org.apache.batik.css.engine.Messages;
import org.apache.batik.css.engine.Rule;
import org.apache.batik.css.engine.StringIntMap;
import org.apache.batik.css.engine.StyleDeclaration;
import org.apache.batik.css.engine.StyleDeclarationProvider;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.StyleRule;
import org.apache.batik.css.engine.StyleSheet;
import org.apache.batik.css.engine.sac.CSSConditionFactory;
import org.apache.batik.css.engine.sac.CSSSelectorFactory;
import org.apache.batik.css.engine.sac.ExtendedSelector;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.InheritValue;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.util.ParsedURL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public abstract class CSSEngine {
    protected CSSEngineUserAgent userAgent;
    protected CSSContext cssContext;
    protected Document document;
    protected ParsedURL documentURI;
    protected boolean isCSSNavigableDocument;
    protected StringIntMap indexes;
    protected StringIntMap shorthandIndexes;
    protected ValueManager[] valueManagers;
    protected ShorthandManager[] shorthandManagers;
    protected ExtendedParser parser;
    protected String[] pseudoElementNames;
    protected int fontSizeIndex = -1;
    protected int lineHeightIndex = -1;
    protected int colorIndex = -1;
    protected StyleSheet userAgentStyleSheet;
    protected StyleSheet userStyleSheet;
    protected SACMediaList media;
    protected List styleSheetNodes;
    protected List fontFaces = new LinkedList();
    protected String styleNamespaceURI;
    protected String styleLocalName;
    protected String classNamespaceURI;
    protected String classLocalName;
    protected Set nonCSSPresentationalHints;
    protected String nonCSSPresentationalHintsNamespaceURI;
    protected StyleDeclarationDocumentHandler styleDeclarationDocumentHandler = new StyleDeclarationDocumentHandler();
    protected StyleDeclarationUpdateHandler styleDeclarationUpdateHandler;
    protected StyleSheetDocumentHandler styleSheetDocumentHandler = new StyleSheetDocumentHandler();
    protected StyleDeclarationBuilder styleDeclarationBuilder = new StyleDeclarationBuilder();
    protected CSSStylableElement element;
    protected ParsedURL cssBaseURI;
    protected String alternateStyleSheet;
    protected CSSNavigableDocumentHandler cssNavigableDocumentListener;
    protected EventListener domAttrModifiedListener;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener domSubtreeModifiedListener;
    protected EventListener domCharacterDataModifiedListener;
    protected boolean styleSheetRemoved;
    protected Node removedStylableElementSibling;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Set selectorAttributes;
    protected final int[] ALL_PROPERTIES;
    protected CSSConditionFactory cssConditionFactory;
    protected static final CSSEngineListener[] LISTENER_ARRAY = new CSSEngineListener[0];

    public static Node getCSSParentNode(Node node) {
        if (node instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)node)).getCSSParentNode();
        }
        return node.getParentNode();
    }

    protected static Node getCSSFirstChild(Node node) {
        if (node instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)node)).getCSSFirstChild();
        }
        return node.getFirstChild();
    }

    protected static Node getCSSNextSibling(Node node) {
        if (node instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)node)).getCSSNextSibling();
        }
        return node.getNextSibling();
    }

    protected static Node getCSSPreviousSibling(Node node) {
        if (node instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)node)).getCSSPreviousSibling();
        }
        return node.getPreviousSibling();
    }

    public static CSSStylableElement getParentCSSStylableElement(Element element) {
        Node node = CSSEngine.getCSSParentNode(element);
        while (node != null) {
            if (node instanceof CSSStylableElement) {
                return (CSSStylableElement)node;
            }
            node = CSSEngine.getCSSParentNode(node);
        }
        return null;
    }

    protected CSSEngine(Document document, ParsedURL parsedURL, ExtendedParser extendedParser, ValueManager[] valueManagerArray, ShorthandManager[] shorthandManagerArray, String[] stringArray, String string2, String string3, String string4, String string5, boolean bl2, String string6, CSSContext cSSContext) {
        String string7;
        int n2;
        this.document = document;
        this.documentURI = parsedURL;
        this.parser = extendedParser;
        this.pseudoElementNames = stringArray;
        this.styleNamespaceURI = string2;
        this.styleLocalName = string3;
        this.classNamespaceURI = string4;
        this.classLocalName = string5;
        this.cssContext = cSSContext;
        this.isCSSNavigableDocument = document instanceof CSSNavigableDocument;
        this.cssConditionFactory = new CSSConditionFactory(string4, string5, null, "id");
        int n3 = valueManagerArray.length;
        this.indexes = new StringIntMap(n3);
        this.valueManagers = valueManagerArray;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            string7 = valueManagerArray[n2].getPropertyName();
            this.indexes.put(string7, n2);
            if (this.fontSizeIndex == -1 && string7.equals("font-size")) {
                this.fontSizeIndex = n2;
            }
            if (this.lineHeightIndex == -1 && string7.equals("line-height")) {
                this.lineHeightIndex = n2;
            }
            if (this.colorIndex != -1 || !string7.equals("color")) continue;
            this.colorIndex = n2;
        }
        n3 = shorthandManagerArray.length;
        this.shorthandIndexes = new StringIntMap(n3);
        this.shorthandManagers = shorthandManagerArray;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            this.shorthandIndexes.put(shorthandManagerArray[n2].getPropertyName(), n2);
        }
        if (bl2) {
            this.nonCSSPresentationalHints = new HashSet(valueManagerArray.length + shorthandManagerArray.length);
            this.nonCSSPresentationalHintsNamespaceURI = string6;
            n3 = valueManagerArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                string7 = valueManagerArray[n2].getPropertyName();
                this.nonCSSPresentationalHints.add(string7);
            }
            n3 = shorthandManagerArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                string7 = shorthandManagerArray[n2].getPropertyName();
                this.nonCSSPresentationalHints.add(string7);
            }
        }
        if (this.cssContext.isDynamic() && this.document instanceof EventTarget) {
            this.addEventListeners((EventTarget)((Object)this.document));
            this.styleDeclarationUpdateHandler = new StyleDeclarationUpdateHandler();
        }
        this.ALL_PROPERTIES = new int[this.getNumberOfProperties()];
        for (n2 = this.getNumberOfProperties() - 1; n2 >= 0; --n2) {
            this.ALL_PROPERTIES[n2] = n2;
        }
    }

    protected void addEventListeners(EventTarget eventTarget) {
        if (this.isCSSNavigableDocument) {
            this.cssNavigableDocumentListener = new CSSNavigableDocumentHandler();
            CSSNavigableDocument cSSNavigableDocument = (CSSNavigableDocument)((Object)eventTarget);
            cSSNavigableDocument.addCSSNavigableDocumentListener(this.cssNavigableDocumentListener);
        } else {
            this.domAttrModifiedListener = new DOMAttrModifiedListener();
            eventTarget.addEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            this.domNodeInsertedListener = new DOMNodeInsertedListener();
            eventTarget.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            this.domNodeRemovedListener = new DOMNodeRemovedListener();
            eventTarget.addEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            this.domSubtreeModifiedListener = new DOMSubtreeModifiedListener();
            eventTarget.addEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            this.domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();
            eventTarget.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    protected void removeEventListeners(EventTarget eventTarget) {
        if (this.isCSSNavigableDocument) {
            CSSNavigableDocument cSSNavigableDocument = (CSSNavigableDocument)((Object)eventTarget);
            cSSNavigableDocument.removeCSSNavigableDocumentListener(this.cssNavigableDocumentListener);
        } else {
            eventTarget.removeEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            eventTarget.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            eventTarget.removeEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            eventTarget.removeEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            eventTarget.removeEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    public void dispose() {
        this.setCSSEngineUserAgent(null);
        this.disposeStyleMaps(this.document.getDocumentElement());
        if (this.document instanceof EventTarget) {
            this.removeEventListeners((EventTarget)((Object)this.document));
        }
    }

    protected void disposeStyleMaps(Node node) {
        if (node instanceof CSSStylableElement) {
            ((CSSStylableElement)node).setComputedStyleMap(null, null);
        }
        Node node2 = CSSEngine.getCSSFirstChild(node);
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                this.disposeStyleMaps(node2);
            }
            node2 = CSSEngine.getCSSNextSibling(node2);
        }
    }

    public CSSContext getCSSContext() {
        return this.cssContext;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getFontSizeIndex() {
        return this.fontSizeIndex;
    }

    public int getLineHeightIndex() {
        return this.lineHeightIndex;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getNumberOfProperties() {
        return this.valueManagers.length;
    }

    public int getPropertyIndex(String string2) {
        return this.indexes.get(string2);
    }

    public int getShorthandIndex(String string2) {
        return this.shorthandIndexes.get(string2);
    }

    public String getPropertyName(int n2) {
        return this.valueManagers[n2].getPropertyName();
    }

    public void setCSSEngineUserAgent(CSSEngineUserAgent cSSEngineUserAgent) {
        this.userAgent = cSSEngineUserAgent;
    }

    public CSSEngineUserAgent getCSSEngineUserAgent() {
        return this.userAgent;
    }

    public void setUserAgentStyleSheet(StyleSheet styleSheet) {
        this.userAgentStyleSheet = styleSheet;
    }

    public void setUserStyleSheet(StyleSheet styleSheet) {
        this.userStyleSheet = styleSheet;
    }

    public ValueManager[] getValueManagers() {
        return this.valueManagers;
    }

    public ShorthandManager[] getShorthandManagers() {
        return this.shorthandManagers;
    }

    public List getFontFaces() {
        return this.fontFaces;
    }

    public void setMedia(String string2) {
        try {
            this.media = this.parser.parseMedia(string2);
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = Messages.formatMessage("media.error", new Object[]{string2, string3});
            throw new DOMException(12, string4);
        }
    }

    public void setAlternateStyleSheet(String string2) {
        this.alternateStyleSheet = string2;
    }

    public void importCascadedStyleMaps(Element element, CSSEngine cSSEngine, Element element2) {
        Node node;
        Node node2;
        if (element instanceof CSSStylableElement) {
            node2 = (CSSStylableElement)element;
            node = (CSSStylableElement)element2;
            StyleMap styleMap = cSSEngine.getCascadedStyleMap((CSSStylableElement)node2, null);
            styleMap.setFixedCascadedStyle(true);
            node.setComputedStyleMap(null, styleMap);
            if (this.pseudoElementNames != null) {
                for (String string2 : this.pseudoElementNames) {
                    styleMap = cSSEngine.getCascadedStyleMap((CSSStylableElement)node2, string2);
                    node.setComputedStyleMap(string2, styleMap);
                }
            }
        }
        node2 = CSSEngine.getCSSFirstChild(element2);
        node = CSSEngine.getCSSFirstChild(element);
        while (node2 != null) {
            if (node.getNodeType() == 1) {
                this.importCascadedStyleMaps((Element)node, cSSEngine, (Element)node2);
            }
            node2 = CSSEngine.getCSSNextSibling(node2);
            node = CSSEngine.getCSSNextSibling(node);
        }
    }

    public ParsedURL getCSSBaseURI() {
        if (this.cssBaseURI == null) {
            this.cssBaseURI = this.element.getCSSBase();
        }
        return this.cssBaseURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleMap getCascadedStyleMap(CSSStylableElement cSSStylableElement, String string2) {
        Object object;
        int n2 = this.getNumberOfProperties();
        final StyleMap styleMap = new StyleMap(n2);
        if (this.userAgentStyleSheet != null) {
            object = new ArrayList();
            this.addMatchingRules((List)object, this.userAgentStyleSheet, cSSStylableElement, string2);
            this.addRules(cSSStylableElement, string2, styleMap, (ArrayList)object, (short)0);
        }
        if (this.userStyleSheet != null) {
            object = new ArrayList();
            this.addMatchingRules((List)object, this.userStyleSheet, cSSStylableElement, string2);
            this.addRules(cSSStylableElement, string2, styleMap, (ArrayList)object, (short)8192);
        }
        this.element = cSSStylableElement;
        try {
            StyleDeclaration styleDeclaration;
            StyleDeclarationProvider styleDeclarationProvider;
            String string3;
            Object object2;
            String string4;
            Object object3;
            Object object4;
            int n3;
            Object object5;
            if (this.nonCSSPresentationalHints != null) {
                object = new ShorthandManager.PropertyHandler(){

                    @Override
                    public void property(String string2, LexicalUnit lexicalUnit, boolean bl2) {
                        int n2 = CSSEngine.this.getPropertyIndex(string2);
                        if (n2 != -1) {
                            ValueManager valueManager = CSSEngine.this.valueManagers[n2];
                            Value value = valueManager.createValue(lexicalUnit, CSSEngine.this);
                            CSSEngine.this.putAuthorProperty(styleMap, n2, value, bl2, (short)16384);
                            return;
                        }
                        n2 = CSSEngine.this.getShorthandIndex(string2);
                        if (n2 == -1) {
                            return;
                        }
                        CSSEngine.this.shorthandManagers[n2].setValues(CSSEngine.this, this, lexicalUnit, bl2);
                    }
                };
                object5 = cSSStylableElement.getAttributes();
                n3 = object5.getLength();
                for (int i2 = 0; i2 < n3; ++i2) {
                    Node node = object5.item(i2);
                    object4 = node.getNodeName();
                    if (!this.nonCSSPresentationalHints.contains(object4)) continue;
                    try {
                        object3 = this.parser.parsePropertyValue(node.getNodeValue());
                        object.property((String)object4, (LexicalUnit)object3, false);
                        continue;
                    }
                    catch (Exception exception) {
                        string4 = exception.getMessage();
                        if (string4 == null) {
                            string4 = "";
                        }
                        object2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                        String string5 = Messages.formatMessage("property.syntax.error.at", new Object[]{object2, object4, node.getNodeValue(), string4});
                        DOMException dOMException = new DOMException(12, string5);
                        if (this.userAgent == null) {
                            throw dOMException;
                        }
                        this.userAgent.displayError(dOMException);
                    }
                }
            }
            if ((n3 = (object5 = ((CSSEngine)(object = this.cssContext.getCSSEngineForElement(cSSStylableElement))).getStyleSheetNodes()).size()) > 0) {
                ArrayList arrayList = new ArrayList();
                for (int i3 = 0; i3 < n3; ++i3) {
                    object4 = (CSSStyleSheetNode)object5.get(i3);
                    object3 = object4.getCSSStyleSheet();
                    if (object3 == null || ((StyleSheet)object3).isAlternate() && ((StyleSheet)object3).getTitle() != null && !((StyleSheet)object3).getTitle().equals(this.alternateStyleSheet) || !this.mediaMatch(((StyleSheet)object3).getMedia())) continue;
                    this.addMatchingRules(arrayList, (StyleSheet)object3, cSSStylableElement, string2);
                }
                this.addRules(cSSStylableElement, string2, styleMap, arrayList, (short)24576);
            }
            if (this.styleLocalName != null && (string3 = cSSStylableElement.getAttributeNS(this.styleNamespaceURI, this.styleLocalName)).length() > 0) {
                try {
                    this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                    this.parser.setConditionFactory(this.cssConditionFactory);
                    this.styleDeclarationDocumentHandler.styleMap = styleMap;
                    this.parser.setDocumentHandler(this.styleDeclarationDocumentHandler);
                    this.parser.parseStyleDeclaration(string3);
                    this.styleDeclarationDocumentHandler.styleMap = null;
                }
                catch (Exception exception) {
                    object4 = exception.getMessage();
                    if (object4 == null) {
                        object4 = exception.getClass().getName();
                    }
                    object3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    string4 = Messages.formatMessage("style.syntax.error.at", new Object[]{object3, this.styleLocalName, string3, object4});
                    object2 = new DOMException(12, string4);
                    if (this.userAgent == null) {
                        throw object2;
                    }
                    this.userAgent.displayError((Exception)object2);
                }
            }
            if ((styleDeclarationProvider = cSSStylableElement.getOverrideStyleDeclarationProvider()) != null && (styleDeclaration = styleDeclarationProvider.getStyleDeclaration()) != null) {
                int n4 = styleDeclaration.size();
                for (int i4 = 0; i4 < n4; ++i4) {
                    int n5 = styleDeclaration.getIndex(i4);
                    object2 = styleDeclaration.getValue(i4);
                    boolean bl2 = styleDeclaration.getPriority(i4);
                    if (styleMap.isImportant(n5) && !bl2) continue;
                    styleMap.putValue(n5, (Value)object2);
                    styleMap.putImportant(n5, bl2);
                    styleMap.putOrigin(n5, (short)-24576);
                }
            }
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return styleMap;
    }

    public Value getComputedStyle(CSSStylableElement cSSStylableElement, String string2, int n2) {
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(string2);
        if (styleMap == null) {
            styleMap = this.getCascadedStyleMap(cSSStylableElement, string2);
            cSSStylableElement.setComputedStyleMap(string2, styleMap);
        }
        Value value = styleMap.getValue(n2);
        if (styleMap.isComputed(n2)) {
            return value;
        }
        Value value2 = value;
        ValueManager valueManager = this.valueManagers[n2];
        CSSStylableElement cSSStylableElement2 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
        if (value == null) {
            if (cSSStylableElement2 == null || !valueManager.isInheritedProperty()) {
                value2 = valueManager.getDefaultValue();
            }
        } else if (cSSStylableElement2 != null && value == InheritValue.INSTANCE) {
            value2 = null;
        }
        if (value2 == null) {
            value2 = this.getComputedStyle(cSSStylableElement2, null, n2);
            styleMap.putParentRelative(n2, true);
            styleMap.putInherited(n2, true);
        } else {
            value2 = valueManager.computeValue(cSSStylableElement, string2, this, n2, styleMap, value2);
        }
        if (value == null) {
            styleMap.putValue(n2, value2);
            styleMap.putNullCascaded(n2, true);
        } else if (value2 != value) {
            ComputedValue computedValue = new ComputedValue(value);
            computedValue.setComputedValue(value2);
            styleMap.putValue(n2, computedValue);
            value2 = computedValue;
        }
        styleMap.putComputed(n2, true);
        return value2;
    }

    public List getStyleSheetNodes() {
        if (this.styleSheetNodes == null) {
            this.styleSheetNodes = new ArrayList();
            this.selectorAttributes = new HashSet();
            this.findStyleSheetNodes(this.document);
            int n2 = this.styleSheetNodes.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                CSSStyleSheetNode cSSStyleSheetNode = (CSSStyleSheetNode)this.styleSheetNodes.get(i2);
                StyleSheet styleSheet = cSSStyleSheetNode.getCSSStyleSheet();
                if (styleSheet == null) continue;
                this.findSelectorAttributes(this.selectorAttributes, styleSheet);
            }
        }
        return this.styleSheetNodes;
    }

    protected void findStyleSheetNodes(Node node) {
        if (node instanceof CSSStyleSheetNode) {
            this.styleSheetNodes.add(node);
        }
        Node node2 = CSSEngine.getCSSFirstChild(node);
        while (node2 != null) {
            this.findStyleSheetNodes(node2);
            node2 = CSSEngine.getCSSNextSibling(node2);
        }
    }

    protected void findSelectorAttributes(Set set, StyleSheet styleSheet) {
        int n2 = styleSheet.getSize();
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            Rule rule = styleSheet.getRule(i2);
            switch (rule.getType()) {
                case 0: {
                    StyleRule styleRule = (StyleRule)rule;
                    SelectorList selectorList = styleRule.getSelectorList();
                    int n3 = selectorList.getLength();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        ExtendedSelector extendedSelector = (ExtendedSelector)selectorList.item(i3);
                        extendedSelector.fillAttributeSet(set);
                    }
                    continue block4;
                }
                case 1: 
                case 2: {
                    MediaRule mediaRule = (MediaRule)rule;
                    if (!this.mediaMatch(mediaRule.getMediaList())) continue block4;
                    this.findSelectorAttributes(set, mediaRule);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainProperties(CSSStylableElement cSSStylableElement, final MainPropertyReceiver mainPropertyReceiver, String string2, String string3, boolean bl2) {
        try {
            this.element = cSSStylableElement;
            LexicalUnit lexicalUnit = this.parser.parsePropertyValue(string3);
            ShorthandManager.PropertyHandler propertyHandler = new ShorthandManager.PropertyHandler(){

                @Override
                public void property(String string2, LexicalUnit lexicalUnit, boolean bl2) {
                    int n2 = CSSEngine.this.getPropertyIndex(string2);
                    if (n2 != -1) {
                        ValueManager valueManager = CSSEngine.this.valueManagers[n2];
                        Value value = valueManager.createValue(lexicalUnit, CSSEngine.this);
                        mainPropertyReceiver.setMainProperty(string2, value, bl2);
                        return;
                    }
                    n2 = CSSEngine.this.getShorthandIndex(string2);
                    if (n2 == -1) {
                        return;
                    }
                    CSSEngine.this.shorthandManagers[n2].setValues(CSSEngine.this, this, lexicalUnit, bl2);
                }
            };
            propertyHandler.property(string2, lexicalUnit, bl2);
        }
        catch (Exception exception) {
            String string4 = exception.getMessage();
            if (string4 == null) {
                string4 = "";
            }
            String string5 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string6 = Messages.formatMessage("property.syntax.error.at", new Object[]{string5, string2, string3, string4});
            DOMException dOMException = new DOMException(12, string6);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value parsePropertyValue(CSSStylableElement cSSStylableElement, String string2, String string3) {
        int n2 = this.getPropertyIndex(string2);
        if (n2 == -1) {
            return null;
        }
        ValueManager valueManager = this.valueManagers[n2];
        try {
            this.element = cSSStylableElement;
            LexicalUnit lexicalUnit = this.parser.parsePropertyValue(string3);
            Value value = valueManager.createValue(lexicalUnit, this);
            return value;
        }
        catch (Exception exception) {
            String string4 = exception.getMessage();
            if (string4 == null) {
                string4 = "";
            }
            String string5 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string6 = Messages.formatMessage("property.syntax.error.at", new Object[]{string5, string2, string3, string4});
            DOMException dOMException = new DOMException(12, string6);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return valueManager.getDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleDeclaration parseStyleDeclaration(CSSStylableElement cSSStylableElement, String string2) {
        this.styleDeclarationBuilder.styleDeclaration = new StyleDeclaration();
        try {
            this.element = cSSStylableElement;
            this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
            this.parser.setConditionFactory(this.cssConditionFactory);
            this.parser.setDocumentHandler(this.styleDeclarationBuilder);
            this.parser.parseStyleDeclaration(string2);
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string5 = Messages.formatMessage("syntax.error.at", new Object[]{string4, string3});
            DOMException dOMException = new DOMException(12, string5);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return this.styleDeclarationBuilder.styleDeclaration;
    }

    public StyleSheet parseStyleSheet(ParsedURL parsedURL, String string2) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMedia(string2));
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string5 = Messages.formatMessage("syntax.error.at", new Object[]{string4, string3});
            DOMException dOMException = new DOMException(12, string5);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
            return styleSheet;
        }
        this.parseStyleSheet(styleSheet, parsedURL);
        return styleSheet;
    }

    public StyleSheet parseStyleSheet(InputSource inputSource, ParsedURL parsedURL, String string2) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMedia(string2));
            this.parseStyleSheet(styleSheet, inputSource, parsedURL);
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string5 = Messages.formatMessage("syntax.error.at", new Object[]{string4, string3});
            DOMException dOMException = new DOMException(12, string5);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        return styleSheet;
    }

    public void parseStyleSheet(StyleSheet styleSheet, ParsedURL parsedURL) throws DOMException {
        if (parsedURL == null) {
            String string2 = Messages.formatMessage("syntax.error.at", new Object[]{"Null Document reference", ""});
            DOMException dOMException = new DOMException(12, string2);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
            return;
        }
        try {
            this.cssContext.checkLoadExternalResource(parsedURL, this.documentURI);
            this.parseStyleSheet(styleSheet, new InputSource(parsedURL.toString()), parsedURL);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = exception.getClass().getName();
            }
            String string4 = Messages.formatMessage("syntax.error.at", new Object[]{parsedURL.toString(), string3});
            DOMException dOMException = new DOMException(12, string4);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
    }

    public StyleSheet parseStyleSheet(String string2, ParsedURL parsedURL, String string3) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMedia(string3));
        }
        catch (Exception exception) {
            String string4 = exception.getMessage();
            if (string4 == null) {
                string4 = "";
            }
            String string5 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string6 = Messages.formatMessage("syntax.error.at", new Object[]{string5, string4});
            DOMException dOMException = new DOMException(12, string6);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
            return styleSheet;
        }
        this.parseStyleSheet(styleSheet, string2, parsedURL);
        return styleSheet;
    }

    public void parseStyleSheet(StyleSheet styleSheet, String string2, ParsedURL parsedURL) throws DOMException {
        try {
            this.parseStyleSheet(styleSheet, new InputSource((Reader)new StringReader(string2)), parsedURL);
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = Messages.formatMessage("stylesheet.syntax.error", new Object[]{parsedURL.toString(), string2, string3});
            DOMException dOMException = new DOMException(12, string4);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseStyleSheet(StyleSheet styleSheet, InputSource inputSource, ParsedURL parsedURL) throws IOException {
        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
        this.parser.setConditionFactory(this.cssConditionFactory);
        try {
            this.cssBaseURI = parsedURL;
            this.styleSheetDocumentHandler.styleSheet = styleSheet;
            this.parser.setDocumentHandler(this.styleSheetDocumentHandler);
            this.parser.parseStyleSheet(inputSource);
            int n2 = styleSheet.getSize();
            for (int i2 = 0; i2 < n2; ++i2) {
                Rule rule = styleSheet.getRule(i2);
                if (rule.getType() != 2) {
                    break;
                }
                ImportRule importRule = (ImportRule)rule;
                this.parseStyleSheet(importRule, importRule.getURI());
            }
        }
        finally {
            this.cssBaseURI = null;
        }
    }

    protected void putAuthorProperty(StyleMap styleMap, int n2, Value value, boolean bl2, short s2) {
        boolean bl3;
        Value value2 = styleMap.getValue(n2);
        short s3 = styleMap.getOrigin(n2);
        boolean bl4 = styleMap.isImportant(n2);
        boolean bl5 = bl3 = value2 == null;
        if (!bl3) {
            switch (s3) {
                case 8192: {
                    bl3 = !bl4;
                    break;
                }
                case 24576: {
                    bl3 = !bl4 || bl2;
                    break;
                }
                case -24576: {
                    bl3 = false;
                    break;
                }
                default: {
                    bl3 = true;
                }
            }
        }
        if (bl3) {
            styleMap.putValue(n2, value);
            styleMap.putImportant(n2, bl2);
            styleMap.putOrigin(n2, s2);
        }
    }

    protected void addMatchingRules(List list, StyleSheet styleSheet, Element element, String string2) {
        int n2 = styleSheet.getSize();
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            Rule rule = styleSheet.getRule(i2);
            switch (rule.getType()) {
                case 0: {
                    StyleRule styleRule = (StyleRule)rule;
                    SelectorList selectorList = styleRule.getSelectorList();
                    int n3 = selectorList.getLength();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        ExtendedSelector extendedSelector = (ExtendedSelector)selectorList.item(i3);
                        if (!extendedSelector.match(element, string2)) continue;
                        list.add(styleRule);
                    }
                    continue block4;
                }
                case 1: 
                case 2: {
                    MediaRule mediaRule = (MediaRule)rule;
                    if (!this.mediaMatch(mediaRule.getMediaList())) continue block4;
                    this.addMatchingRules(list, mediaRule, element, string2);
                }
            }
        }
    }

    protected void addRules(Element element, String string2, StyleMap styleMap, ArrayList arrayList, short s2) {
        this.sortRules(arrayList, element, string2);
        int n2 = arrayList.size();
        if (s2 == 24576) {
            for (int i2 = 0; i2 < n2; ++i2) {
                StyleRule styleRule = (StyleRule)arrayList.get(i2);
                StyleDeclaration styleDeclaration = styleRule.getStyleDeclaration();
                int n3 = styleDeclaration.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    this.putAuthorProperty(styleMap, styleDeclaration.getIndex(i3), styleDeclaration.getValue(i3), styleDeclaration.getPriority(i3), s2);
                }
            }
        } else {
            for (int i4 = 0; i4 < n2; ++i4) {
                StyleRule styleRule = (StyleRule)arrayList.get(i4);
                StyleDeclaration styleDeclaration = styleRule.getStyleDeclaration();
                int n4 = styleDeclaration.size();
                for (int i5 = 0; i5 < n4; ++i5) {
                    int n5 = styleDeclaration.getIndex(i5);
                    styleMap.putValue(n5, styleDeclaration.getValue(i5));
                    styleMap.putImportant(n5, styleDeclaration.getPriority(i5));
                    styleMap.putOrigin(n5, s2);
                }
            }
        }
    }

    protected void sortRules(ArrayList arrayList, Element element, String string2) {
        int n2;
        StyleRule styleRule;
        int n3;
        int n4 = arrayList.size();
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            styleRule = (StyleRule)arrayList.get(n3);
            SelectorList selectorList = styleRule.getSelectorList();
            n2 = 0;
            int n5 = selectorList.getLength();
            for (int i2 = 0; i2 < n5; ++i2) {
                int n6;
                ExtendedSelector extendedSelector = (ExtendedSelector)selectorList.item(i2);
                if (!extendedSelector.match(element, string2) || (n6 = extendedSelector.getSpecificity()) <= n2) continue;
                n2 = n6;
            }
            nArray[n3] = n2;
        }
        for (n3 = 1; n3 < n4; ++n3) {
            styleRule = arrayList.get(n3);
            int n7 = nArray[n3];
            for (n2 = n3 - 1; n2 >= 0 && nArray[n2] > n7; --n2) {
                arrayList.set(n2 + 1, arrayList.get(n2));
                nArray[n2 + 1] = nArray[n2];
            }
            arrayList.set(n2 + 1, styleRule);
            nArray[n2 + 1] = n7;
        }
    }

    protected boolean mediaMatch(SACMediaList sACMediaList) {
        if (this.media == null || sACMediaList == null || this.media.getLength() == 0 || sACMediaList.getLength() == 0) {
            return true;
        }
        for (int i2 = 0; i2 < sACMediaList.getLength(); ++i2) {
            if (sACMediaList.item(i2).equalsIgnoreCase("all")) {
                return true;
            }
            for (int i3 = 0; i3 < this.media.getLength(); ++i3) {
                if (!this.media.item(i3).equalsIgnoreCase("all") && !sACMediaList.item(i2).equalsIgnoreCase(this.media.item(i3))) continue;
                return true;
            }
        }
        return false;
    }

    public void addCSSEngineListener(CSSEngineListener cSSEngineListener) {
        this.listeners.add(cSSEngineListener);
    }

    public void removeCSSEngineListener(CSSEngineListener cSSEngineListener) {
        this.listeners.remove(cSSEngineListener);
    }

    protected void firePropertiesChangedEvent(Element element, int[] nArray) {
        CSSEngineListener[] cSSEngineListenerArray = this.listeners.toArray(LISTENER_ARRAY);
        int n2 = cSSEngineListenerArray.length;
        if (n2 > 0) {
            CSSEngineEvent cSSEngineEvent = new CSSEngineEvent(this, element, nArray);
            for (int i2 = 0; i2 < n2; ++i2) {
                cSSEngineListenerArray[i2].propertiesChanged(cSSEngineEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inlineStyleAttributeUpdated(CSSStylableElement cSSStylableElement, StyleMap styleMap, short s2, String string2, String string3) {
        int n2;
        boolean[] blArray = this.styleDeclarationUpdateHandler.updatedProperties;
        for (n2 = this.getNumberOfProperties() - 1; n2 >= 0; --n2) {
            blArray[n2] = false;
        }
        switch (s2) {
            case 1: 
            case 2: {
                if (string3.length() > 0) {
                    this.element = cSSStylableElement;
                    try {
                        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                        this.parser.setConditionFactory(this.cssConditionFactory);
                        this.styleDeclarationUpdateHandler.styleMap = styleMap;
                        this.parser.setDocumentHandler(this.styleDeclarationUpdateHandler);
                        this.parser.parseStyleDeclaration(string3);
                        this.styleDeclarationUpdateHandler.styleMap = null;
                    }
                    catch (Exception exception) {
                        String string4 = exception.getMessage();
                        if (string4 == null) {
                            string4 = "";
                        }
                        String string5 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                        String string6 = Messages.formatMessage("style.syntax.error.at", new Object[]{string5, this.styleLocalName, string3, string4});
                        DOMException dOMException = new DOMException(12, string6);
                        if (this.userAgent == null) {
                            throw dOMException;
                        }
                        this.userAgent.displayError(dOMException);
                    }
                    finally {
                        this.element = null;
                        this.cssBaseURI = null;
                    }
                }
            }
            case 3: {
                n2 = 0;
                if (string2 != null && string2.length() > 0) {
                    for (int i2 = this.getNumberOfProperties() - 1; i2 >= 0; --i2) {
                        short s3;
                        if (!styleMap.isComputed(i2) || blArray[i2] || (s3 = styleMap.getOrigin(i2)) < Short.MIN_VALUE) continue;
                        n2 = 1;
                        blArray[i2] = true;
                    }
                }
                if (n2 != 0) {
                    this.invalidateProperties(cSSStylableElement, null, blArray, true);
                    break;
                }
                int n3 = 0;
                boolean bl2 = this.fontSizeIndex == -1 ? false : blArray[this.fontSizeIndex];
                boolean bl3 = this.lineHeightIndex == -1 ? false : blArray[this.lineHeightIndex];
                boolean bl4 = this.colorIndex == -1 ? false : blArray[this.colorIndex];
                for (int i3 = this.getNumberOfProperties() - 1; i3 >= 0; --i3) {
                    if (blArray[i3]) {
                        ++n3;
                        continue;
                    }
                    if (!(bl2 && styleMap.isFontSizeRelative(i3) || bl3 && styleMap.isLineHeightRelative(i3)) && (!bl4 || !styleMap.isColorRelative(i3))) continue;
                    blArray[i3] = true;
                    CSSEngine.clearComputedValue(styleMap, i3);
                    ++n3;
                }
                if (n3 <= 0) break;
                int[] nArray = new int[n3];
                n3 = 0;
                for (int i4 = this.getNumberOfProperties() - 1; i4 >= 0; --i4) {
                    if (!blArray[i4]) continue;
                    nArray[n3++] = i4;
                }
                this.invalidateProperties(cSSStylableElement, nArray, null, true);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid attrChangeType");
            }
        }
    }

    private static void clearComputedValue(StyleMap styleMap, int n2) {
        if (styleMap.isNullCascaded(n2)) {
            styleMap.putValue(n2, null);
        } else {
            Value value = styleMap.getValue(n2);
            if (value instanceof ComputedValue) {
                ComputedValue computedValue = (ComputedValue)value;
                value = computedValue.getCascadedValue();
                styleMap.putValue(n2, value);
            }
        }
        styleMap.putComputed(n2, false);
    }

    protected void invalidateProperties(Node node, int[] nArray, boolean[] blArray, boolean bl2) {
        int n2;
        int n3;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement cSSStylableElement = (CSSStylableElement)node;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
        if (styleMap == null) {
            return;
        }
        boolean[] blArray2 = new boolean[this.getNumberOfProperties()];
        if (blArray != null) {
            System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        }
        if (nArray != null) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                blArray2[nArray[n3]] = true;
            }
        }
        n3 = 0;
        if (!bl2) {
            for (int i2 = 0; i2 < blArray2.length; ++i2) {
                if (!blArray2[i2]) continue;
                ++n3;
            }
        } else {
            StyleMap styleMap2 = this.getCascadedStyleMap(cSSStylableElement, null);
            cSSStylableElement.setComputedStyleMap(null, styleMap2);
            for (n2 = 0; n2 < blArray2.length; ++n2) {
                if (blArray2[n2]) {
                    ++n3;
                    continue;
                }
                Value value = styleMap2.getValue(n2);
                Value value2 = null;
                if (!styleMap.isNullCascaded(n2) && (value2 = styleMap.getValue(n2)) instanceof ComputedValue) {
                    value2 = ((ComputedValue)value2).getCascadedValue();
                }
                if (value == value2) continue;
                if (value != null && value2 != null) {
                    if (value.equals(value2)) continue;
                    String string2 = value2.getCssText();
                    String string3 = value.getCssText();
                    if (string3 == string2 || string3 != null && string3.equals(string2)) continue;
                }
                ++n3;
                blArray2[n2] = true;
            }
        }
        int[] nArray2 = null;
        if (n3 != 0) {
            nArray2 = new int[n3];
            n3 = 0;
            for (n2 = 0; n2 < blArray2.length; ++n2) {
                if (!blArray2[n2]) continue;
                nArray2[n3++] = n2;
            }
        }
        this.propagateChanges(cSSStylableElement, nArray2, bl2);
    }

    protected void propagateChanges(Node node, int[] nArray, boolean bl2) {
        int n2;
        int n3;
        Object[] objectArray;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement cSSStylableElement = (CSSStylableElement)node;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
        if (styleMap != null) {
            int n4;
            objectArray = this.styleDeclarationUpdateHandler.updatedProperties;
            for (n3 = this.getNumberOfProperties() - 1; n3 >= 0; --n3) {
                objectArray[n3] = 0;
            }
            if (nArray != null) {
                for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                    n2 = nArray[n3];
                    objectArray[n2] = 1;
                }
            }
            n3 = this.fontSizeIndex == -1 ? 0 : objectArray[this.fontSizeIndex];
            n2 = this.lineHeightIndex == -1 ? 0 : objectArray[this.lineHeightIndex];
            int n5 = this.colorIndex == -1 ? 0 : objectArray[this.colorIndex];
            int n6 = 0;
            for (n4 = this.getNumberOfProperties() - 1; n4 >= 0; --n4) {
                if (objectArray[n4] != 0) {
                    ++n6;
                    continue;
                }
                if (!(n3 != 0 && styleMap.isFontSizeRelative(n4) || n2 != 0 && styleMap.isLineHeightRelative(n4)) && (n5 == 0 || !styleMap.isColorRelative(n4))) continue;
                objectArray[n4] = 1;
                CSSEngine.clearComputedValue(styleMap, n4);
                ++n6;
            }
            if (n6 == 0) {
                nArray = null;
            } else {
                nArray = new int[n6];
                n6 = 0;
                for (n4 = this.getNumberOfProperties() - 1; n4 >= 0; --n4) {
                    if (objectArray[n4] == 0) continue;
                    nArray[n6++] = n4;
                }
                this.firePropertiesChangedEvent(cSSStylableElement, nArray);
            }
        }
        objectArray = nArray;
        if (nArray != null) {
            n3 = 0;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                ValueManager valueManager = this.valueManagers[nArray[n2]];
                if (valueManager.isInheritedProperty()) {
                    ++n3;
                    continue;
                }
                nArray[n2] = -1;
            }
            if (n3 == 0) {
                objectArray = null;
            } else {
                objectArray = new int[n3];
                n3 = 0;
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] == -1) continue;
                    objectArray[n3++] = nArray[n2];
                }
            }
        }
        Node node2 = CSSEngine.getCSSFirstChild(node);
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                this.invalidateProperties(node2, (int[])objectArray, null, bl2);
            }
            node2 = CSSEngine.getCSSNextSibling(node2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nonCSSPresentationalHintUpdated(CSSStylableElement cSSStylableElement, StyleMap styleMap, String string2, short s2, String string3) {
        int n2;
        Object object;
        int n3 = this.getPropertyIndex(string2);
        if (styleMap.isImportant(n3)) {
            return;
        }
        if (styleMap.getOrigin(n3) >= 24576) {
            return;
        }
        switch (s2) {
            case 1: 
            case 2: {
                Object object2;
                Object object3;
                this.element = cSSStylableElement;
                try {
                    object = this.parser.parsePropertyValue(string3);
                    object3 = this.valueManagers[n3];
                    object2 = object3.createValue((LexicalUnit)object, this);
                    styleMap.putMask(n3, (short)0);
                    styleMap.putValue(n3, (Value)object2);
                    styleMap.putOrigin(n3, (short)16384);
                    break;
                }
                catch (Exception exception) {
                    object3 = exception.getMessage();
                    if (object3 == null) {
                        object3 = "";
                    }
                    object2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    String string4 = Messages.formatMessage("property.syntax.error.at", new Object[]{object2, string2, string3, object3});
                    DOMException dOMException = new DOMException(12, string4);
                    if (this.userAgent == null) {
                        throw dOMException;
                    }
                    this.userAgent.displayError(dOMException);
                    break;
                }
                finally {
                    this.element = null;
                    this.cssBaseURI = null;
                }
            }
            case 3: {
                int[] nArray = new int[]{n3};
                this.invalidateProperties(cSSStylableElement, nArray, null, true);
                return;
            }
        }
        object = this.styleDeclarationUpdateHandler.updatedProperties;
        for (n2 = this.getNumberOfProperties() - 1; n2 >= 0; --n2) {
            object[n2] = false;
        }
        object[n3] = true;
        n2 = n3 == this.fontSizeIndex ? 1 : 0;
        boolean bl2 = n3 == this.lineHeightIndex;
        boolean bl3 = n3 == this.colorIndex;
        int n4 = 0;
        for (int i2 = this.getNumberOfProperties() - 1; i2 >= 0; --i2) {
            if (object[i2]) {
                ++n4;
                continue;
            }
            if (!(n2 != 0 && styleMap.isFontSizeRelative(i2) || bl2 && styleMap.isLineHeightRelative(i2)) && (!bl3 || !styleMap.isColorRelative(i2))) continue;
            object[i2] = true;
            CSSEngine.clearComputedValue(styleMap, i2);
            ++n4;
        }
        int[] nArray = new int[n4];
        n4 = 0;
        for (int i3 = this.getNumberOfProperties() - 1; i3 >= 0; --i3) {
            if (!object[i3]) continue;
            nArray[n4++] = i3;
        }
        this.invalidateProperties(cSSStylableElement, nArray, null, true);
    }

    protected boolean hasStyleSheetNode(Node node) {
        if (node instanceof CSSStyleSheetNode) {
            return true;
        }
        node = CSSEngine.getCSSFirstChild(node);
        while (node != null) {
            if (this.hasStyleSheetNode(node)) {
                return true;
            }
            node = CSSEngine.getCSSNextSibling(node);
        }
        return false;
    }

    protected void handleAttrModified(Element element, Attr attr, short s2, String string2, String string3) {
        if (!(element instanceof CSSStylableElement)) {
            return;
        }
        if (string3.equals(string2)) {
            return;
        }
        String string4 = attr.getNamespaceURI();
        String string5 = string4 == null ? attr.getNodeName() : attr.getLocalName();
        CSSStylableElement cSSStylableElement = (CSSStylableElement)element;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
        if (styleMap != null) {
            if ((string4 == this.styleNamespaceURI || string4 != null && string4.equals(this.styleNamespaceURI)) && string5.equals(this.styleLocalName)) {
                this.inlineStyleAttributeUpdated(cSSStylableElement, styleMap, s2, string2, string3);
                return;
            }
            if (this.nonCSSPresentationalHints != null && (string4 == this.nonCSSPresentationalHintsNamespaceURI || string4 != null && string4.equals(this.nonCSSPresentationalHintsNamespaceURI)) && this.nonCSSPresentationalHints.contains(string5)) {
                this.nonCSSPresentationalHintUpdated(cSSStylableElement, styleMap, string5, s2, string3);
                return;
            }
        }
        if (this.selectorAttributes != null && this.selectorAttributes.contains(string5)) {
            this.invalidateProperties(cSSStylableElement, null, null, true);
            Node node = CSSEngine.getCSSNextSibling(cSSStylableElement);
            while (node != null) {
                this.invalidateProperties(node, null, null, true);
                node = CSSEngine.getCSSNextSibling(node);
            }
        }
    }

    protected void handleNodeInserted(Node node) {
        if (this.hasStyleSheetNode(node)) {
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        } else if (node instanceof CSSStylableElement) {
            node = CSSEngine.getCSSNextSibling(node);
            while (node != null) {
                this.invalidateProperties(node, null, null, true);
                node = CSSEngine.getCSSNextSibling(node);
            }
        }
    }

    protected void handleNodeRemoved(Node node) {
        if (this.hasStyleSheetNode(node)) {
            this.styleSheetRemoved = true;
        } else if (node instanceof CSSStylableElement) {
            this.removedStylableElementSibling = CSSEngine.getCSSNextSibling(node);
        }
        this.disposeStyleMaps(node);
    }

    protected void handleSubtreeModified(Node node) {
        if (this.styleSheetRemoved) {
            this.styleSheetRemoved = false;
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        } else if (this.removedStylableElementSibling != null) {
            Node node2 = this.removedStylableElementSibling;
            while (node2 != null) {
                this.invalidateProperties(node2, null, null, true);
                node2 = CSSEngine.getCSSNextSibling(node2);
            }
            this.removedStylableElementSibling = null;
        }
    }

    protected void handleCharacterDataModified(Node node) {
        if (CSSEngine.getCSSParentNode(node) instanceof CSSStyleSheetNode) {
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        }
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            CSSEngine.this.handleAttrModified((Element)((Object)event.getTarget()), (Attr)mutationEvent.getRelatedNode(), mutationEvent.getAttrChange(), mutationEvent.getPrevValue(), mutationEvent.getNewValue());
        }
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            CSSEngine.this.handleCharacterDataModified((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMSubtreeModifiedListener
    implements EventListener {
        protected DOMSubtreeModifiedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            CSSEngine.this.handleSubtreeModified((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            CSSEngine.this.handleNodeRemoved((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            CSSEngine.this.handleNodeInserted((Node)((Object)event.getTarget()));
        }
    }

    protected class CSSNavigableDocumentHandler
    implements CSSNavigableDocumentListener,
    MainPropertyReceiver {
        protected boolean[] mainPropertiesChanged;
        protected StyleDeclaration declaration;

        protected CSSNavigableDocumentHandler() {
        }

        @Override
        public void nodeInserted(Node node) {
            CSSEngine.this.handleNodeInserted(node);
        }

        @Override
        public void nodeToBeRemoved(Node node) {
            CSSEngine.this.handleNodeRemoved(node);
        }

        @Override
        public void subtreeModified(Node node) {
            CSSEngine.this.handleSubtreeModified(node);
        }

        @Override
        public void characterDataModified(Node node) {
            CSSEngine.this.handleCharacterDataModified(node);
        }

        @Override
        public void attrModified(Element element, Attr attr, short s2, String string2, String string3) {
            CSSEngine.this.handleAttrModified(element, attr, s2, string2, string3);
        }

        @Override
        public void overrideStyleTextChanged(CSSStylableElement cSSStylableElement, String string2) {
            int n2;
            StyleDeclarationProvider styleDeclarationProvider = cSSStylableElement.getOverrideStyleDeclarationProvider();
            StyleDeclaration styleDeclaration = styleDeclarationProvider.getStyleDeclaration();
            int n3 = styleDeclaration.size();
            boolean[] blArray = new boolean[CSSEngine.this.getNumberOfProperties()];
            for (n2 = 0; n2 < n3; ++n2) {
                blArray[styleDeclaration.getIndex((int)n2)] = true;
            }
            styleDeclaration = CSSEngine.this.parseStyleDeclaration(cSSStylableElement, string2);
            styleDeclarationProvider.setStyleDeclaration(styleDeclaration);
            n3 = styleDeclaration.size();
            for (n2 = 0; n2 < n3; ++n2) {
                blArray[styleDeclaration.getIndex((int)n2)] = true;
            }
            CSSEngine.this.invalidateProperties(cSSStylableElement, null, blArray, true);
        }

        @Override
        public void overrideStylePropertyRemoved(CSSStylableElement cSSStylableElement, String string2) {
            StyleDeclarationProvider styleDeclarationProvider = cSSStylableElement.getOverrideStyleDeclarationProvider();
            StyleDeclaration styleDeclaration = styleDeclarationProvider.getStyleDeclaration();
            int n2 = CSSEngine.this.getPropertyIndex(string2);
            int n3 = styleDeclaration.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (n2 != styleDeclaration.getIndex(i2)) continue;
                styleDeclaration.remove(i2);
                StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
                if (styleMap == null || styleMap.getOrigin(n2) != -24576) break;
                CSSEngine.this.invalidateProperties(cSSStylableElement, new int[]{n2}, null, true);
                break;
            }
        }

        @Override
        public void overrideStylePropertyChanged(CSSStylableElement cSSStylableElement, String string2, String string3, String string4) {
            boolean bl2 = string4 != null && string4.length() != 0;
            StyleDeclarationProvider styleDeclarationProvider = cSSStylableElement.getOverrideStyleDeclarationProvider();
            this.declaration = styleDeclarationProvider.getStyleDeclaration();
            CSSEngine.this.setMainProperties(cSSStylableElement, this, string2, string3, bl2);
            this.declaration = null;
            CSSEngine.this.invalidateProperties(cSSStylableElement, null, this.mainPropertiesChanged, true);
        }

        @Override
        public void setMainProperty(String string2, Value value, boolean bl2) {
            int n2;
            int n3 = CSSEngine.this.getPropertyIndex(string2);
            if (n3 == -1) {
                return;
            }
            for (n2 = 0; n2 < this.declaration.size() && n3 != this.declaration.getIndex(n2); ++n2) {
            }
            if (n2 < this.declaration.size()) {
                this.declaration.put(n2, value, n3, bl2);
            } else {
                this.declaration.append(value, n3, bl2);
            }
        }
    }

    protected class StyleDeclarationUpdateHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;
        public boolean[] updatedProperties;

        protected StyleDeclarationUpdateHandler() {
            this.updatedProperties = new boolean[CSSEngine.this.getNumberOfProperties()];
        }

        @Override
        public void property(String string2, LexicalUnit lexicalUnit, boolean bl2) throws CSSException {
            int n2 = CSSEngine.this.getPropertyIndex(string2);
            if (n2 == -1) {
                n2 = CSSEngine.this.getShorthandIndex(string2);
                if (n2 == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n2].setValues(CSSEngine.this, this, lexicalUnit, bl2);
            } else {
                if (this.styleMap.isImportant(n2)) {
                    return;
                }
                this.updatedProperties[n2] = true;
                Value value = CSSEngine.this.valueManagers[n2].createValue(lexicalUnit, CSSEngine.this);
                this.styleMap.putMask(n2, (short)0);
                this.styleMap.putValue(n2, value);
                this.styleMap.putOrigin(n2, (short)Short.MIN_VALUE);
            }
        }
    }

    protected static class DocumentAdapter
    implements DocumentHandler {
        protected DocumentAdapter() {
        }

        public void startDocument(InputSource inputSource) {
            this.throwUnsupportedEx();
        }

        public void endDocument(InputSource inputSource) {
            this.throwUnsupportedEx();
        }

        public void comment(String string2) {
        }

        public void ignorableAtRule(String string2) {
            this.throwUnsupportedEx();
        }

        public void namespaceDeclaration(String string2, String string3) {
            this.throwUnsupportedEx();
        }

        public void importStyle(String string2, SACMediaList sACMediaList, String string3) {
            this.throwUnsupportedEx();
        }

        public void startMedia(SACMediaList sACMediaList) {
            this.throwUnsupportedEx();
        }

        public void endMedia(SACMediaList sACMediaList) {
            this.throwUnsupportedEx();
        }

        public void startPage(String string2, String string3) {
            this.throwUnsupportedEx();
        }

        public void endPage(String string2, String string3) {
            this.throwUnsupportedEx();
        }

        public void startFontFace() {
            this.throwUnsupportedEx();
        }

        public void endFontFace() {
            this.throwUnsupportedEx();
        }

        public void startSelector(SelectorList selectorList) {
            this.throwUnsupportedEx();
        }

        public void endSelector(SelectorList selectorList) {
            this.throwUnsupportedEx();
        }

        public void property(String string2, LexicalUnit lexicalUnit, boolean bl2) {
            this.throwUnsupportedEx();
        }

        private void throwUnsupportedEx() {
            throw new UnsupportedOperationException("you try to use an empty method in Adapter-class");
        }
    }

    protected class StyleSheetDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleSheet styleSheet;
        protected StyleRule styleRule;
        protected StyleDeclaration styleDeclaration;

        protected StyleSheetDocumentHandler() {
        }

        @Override
        public void startDocument(InputSource inputSource) throws CSSException {
        }

        @Override
        public void endDocument(InputSource inputSource) throws CSSException {
        }

        @Override
        public void ignorableAtRule(String string2) throws CSSException {
        }

        @Override
        public void importStyle(String string2, SACMediaList sACMediaList, String string3) throws CSSException {
            ImportRule importRule = new ImportRule();
            importRule.setMediaList(sACMediaList);
            importRule.setParent(this.styleSheet);
            ParsedURL parsedURL = CSSEngine.this.getCSSBaseURI();
            ParsedURL parsedURL2 = parsedURL == null ? new ParsedURL(string2) : new ParsedURL(parsedURL, string2);
            importRule.setURI(parsedURL2);
            this.styleSheet.append(importRule);
        }

        @Override
        public void startMedia(SACMediaList sACMediaList) throws CSSException {
            MediaRule mediaRule = new MediaRule();
            mediaRule.setMediaList(sACMediaList);
            mediaRule.setParent(this.styleSheet);
            this.styleSheet.append(mediaRule);
            this.styleSheet = mediaRule;
        }

        @Override
        public void endMedia(SACMediaList sACMediaList) throws CSSException {
            this.styleSheet = this.styleSheet.getParent();
        }

        @Override
        public void startPage(String string2, String string3) throws CSSException {
        }

        @Override
        public void endPage(String string2, String string3) throws CSSException {
        }

        @Override
        public void startFontFace() throws CSSException {
            this.styleDeclaration = new StyleDeclaration();
        }

        @Override
        public void endFontFace() throws CSSException {
            int n2;
            StyleMap styleMap = new StyleMap(CSSEngine.this.getNumberOfProperties());
            int n3 = this.styleDeclaration.size();
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = this.styleDeclaration.getIndex(n2);
                styleMap.putValue(n4, this.styleDeclaration.getValue(n2));
                styleMap.putImportant(n4, this.styleDeclaration.getPriority(n2));
                styleMap.putOrigin(n4, (short)24576);
            }
            this.styleDeclaration = null;
            n2 = CSSEngine.this.getPropertyIndex("font-family");
            Value value = styleMap.getValue(n2);
            if (value == null) {
                return;
            }
            ParsedURL parsedURL = CSSEngine.this.getCSSBaseURI();
            CSSEngine.this.fontFaces.add(new FontFaceRule(styleMap, parsedURL));
        }

        @Override
        public void startSelector(SelectorList selectorList) throws CSSException {
            this.styleRule = new StyleRule();
            this.styleRule.setSelectorList(selectorList);
            this.styleDeclaration = new StyleDeclaration();
            this.styleRule.setStyleDeclaration(this.styleDeclaration);
            this.styleSheet.append(this.styleRule);
        }

        @Override
        public void endSelector(SelectorList selectorList) throws CSSException {
            this.styleRule = null;
            this.styleDeclaration = null;
        }

        @Override
        public void property(String string2, LexicalUnit lexicalUnit, boolean bl2) throws CSSException {
            int n2 = CSSEngine.this.getPropertyIndex(string2);
            if (n2 == -1) {
                n2 = CSSEngine.this.getShorthandIndex(string2);
                if (n2 == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n2].setValues(CSSEngine.this, this, lexicalUnit, bl2);
            } else {
                Value value = CSSEngine.this.valueManagers[n2].createValue(lexicalUnit, CSSEngine.this);
                this.styleDeclaration.append(value, n2, bl2);
            }
        }
    }

    protected class StyleDeclarationBuilder
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleDeclaration styleDeclaration;

        protected StyleDeclarationBuilder() {
        }

        @Override
        public void property(String string2, LexicalUnit lexicalUnit, boolean bl2) throws CSSException {
            int n2 = CSSEngine.this.getPropertyIndex(string2);
            if (n2 == -1) {
                n2 = CSSEngine.this.getShorthandIndex(string2);
                if (n2 == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n2].setValues(CSSEngine.this, this, lexicalUnit, bl2);
            } else {
                Value value = CSSEngine.this.valueManagers[n2].createValue(lexicalUnit, CSSEngine.this);
                this.styleDeclaration.append(value, n2, bl2);
            }
        }
    }

    protected class StyleDeclarationDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;

        protected StyleDeclarationDocumentHandler() {
        }

        @Override
        public void property(String string2, LexicalUnit lexicalUnit, boolean bl2) throws CSSException {
            int n2 = CSSEngine.this.getPropertyIndex(string2);
            if (n2 == -1) {
                n2 = CSSEngine.this.getShorthandIndex(string2);
                if (n2 == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n2].setValues(CSSEngine.this, this, lexicalUnit, bl2);
            } else {
                Value value = CSSEngine.this.valueManagers[n2].createValue(lexicalUnit, CSSEngine.this);
                CSSEngine.this.putAuthorProperty(this.styleMap, n2, value, bl2, (short)Short.MIN_VALUE);
            }
        }
    }

    public static interface MainPropertyReceiver {
        public void setMainProperty(String var1, Value var2, boolean var3);
    }
}

