/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.dom;

import org.apache.batik.css.dom.CSSOMSVGColor;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGPaint;

public class CSSOMSVGPaint
extends CSSOMSVGColor
implements SVGPaint {
    public CSSOMSVGPaint(CSSOMSVGColor.ValueProvider valueProvider) {
        super(valueProvider);
    }

    @Override
    public void setModificationHandler(CSSOMSVGColor.ModificationHandler modificationHandler) {
        if (!(modificationHandler instanceof PaintModificationHandler)) {
            throw new IllegalArgumentException();
        }
        super.setModificationHandler(modificationHandler);
    }

    @Override
    public short getColorType() {
        throw new DOMException(15, "");
    }

    public short getPaintType() {
        Value value = this.valueProvider.getValue();
        switch (value.getCssValueType()) {
            case 1: {
                switch (value.getPrimitiveType()) {
                    case 21: {
                        String string2 = value.getStringValue();
                        if (string2.equalsIgnoreCase("none")) {
                            return 101;
                        }
                        if (string2.equalsIgnoreCase("currentcolor")) {
                            return 102;
                        }
                        return 1;
                    }
                    case 25: {
                        return 1;
                    }
                    case 20: {
                        return 107;
                    }
                }
                break;
            }
            case 2: {
                Value value2 = value.item(0);
                Value value3 = value.item(1);
                switch (value2.getPrimitiveType()) {
                    case 21: {
                        return 2;
                    }
                    case 20: {
                        if (value3.getCssValueType() == 2) {
                            return 106;
                        }
                        switch (value3.getPrimitiveType()) {
                            case 21: {
                                String string3 = value3.getStringValue();
                                if (string3.equalsIgnoreCase("none")) {
                                    return 103;
                                }
                                if (string3.equalsIgnoreCase("currentcolor")) {
                                    return 104;
                                }
                                return 105;
                            }
                            case 25: {
                                return 105;
                            }
                        }
                    }
                    case 25: {
                        return 2;
                    }
                }
            }
        }
        return 0;
    }

    public String getUri() {
        switch (this.getPaintType()) {
            case 107: {
                return this.valueProvider.getValue().getStringValue();
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return this.valueProvider.getValue().item(0).getStringValue();
            }
        }
        throw new InternalError();
    }

    public void setUri(String string2) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        ((PaintModificationHandler)this.handler).uriChanged(string2);
    }

    public void setPaint(short s2, String string2, String string3, String string4) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        ((PaintModificationHandler)this.handler).paintChanged(s2, string2, string3, string4);
    }

    public abstract class AbstractModificationHandler
    implements PaintModificationHandler {
        protected abstract Value getValue();

        @Override
        public void redTextChanged(String string2) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    string2 = "rgb(" + string2 + ", " + this.getValue().getGreen().getCssText() + ", " + this.getValue().getBlue().getCssText() + ')';
                    break;
                }
                case 2: {
                    string2 = "rgb(" + string2 + ", " + this.getValue().item(0).getGreen().getCssText() + ", " + this.getValue().item(0).getBlue().getCssText() + ") " + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string2 = this.getValue().item(0) + " rgb(" + string2 + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + this.getValue().item(1).getBlue().getCssText() + ')';
                    break;
                }
                case 106: {
                    string2 = this.getValue().item(0) + " rgb(" + string2 + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + this.getValue().item(1).getBlue().getCssText() + ") " + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string2);
        }

        @Override
        public void redFloatValueChanged(short s2, float f2) throws DOMException {
            String string2;
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    string2 = "rgb(" + FloatValue.getCssText(s2, f2) + ", " + this.getValue().getGreen().getCssText() + ", " + this.getValue().getBlue().getCssText() + ')';
                    break;
                }
                case 2: {
                    string2 = "rgb(" + FloatValue.getCssText(s2, f2) + ", " + this.getValue().item(0).getGreen().getCssText() + ", " + this.getValue().item(0).getBlue().getCssText() + ") " + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string2 = this.getValue().item(0) + " rgb(" + FloatValue.getCssText(s2, f2) + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + this.getValue().item(1).getBlue().getCssText() + ')';
                    break;
                }
                case 106: {
                    string2 = this.getValue().item(0) + " rgb(" + FloatValue.getCssText(s2, f2) + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + this.getValue().item(1).getBlue().getCssText() + ") " + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string2);
        }

        @Override
        public void greenTextChanged(String string2) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    string2 = "rgb(" + this.getValue().getRed().getCssText() + ", " + string2 + ", " + this.getValue().getBlue().getCssText() + ')';
                    break;
                }
                case 2: {
                    string2 = "rgb(" + this.getValue().item(0).getRed().getCssText() + ", " + string2 + ", " + this.getValue().item(0).getBlue().getCssText() + ") " + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string2 = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + string2 + ", " + this.getValue().item(1).getBlue().getCssText() + ')';
                    break;
                }
                case 106: {
                    string2 = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + string2 + ", " + this.getValue().item(1).getBlue().getCssText() + ") " + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string2);
        }

        @Override
        public void greenFloatValueChanged(short s2, float f2) throws DOMException {
            String string2;
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    string2 = "rgb(" + this.getValue().getRed().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ", " + this.getValue().getBlue().getCssText() + ')';
                    break;
                }
                case 2: {
                    string2 = "rgb(" + this.getValue().item(0).getRed().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ", " + this.getValue().item(0).getBlue().getCssText() + ") " + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string2 = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ", " + this.getValue().item(1).getBlue().getCssText() + ')';
                    break;
                }
                case 106: {
                    string2 = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ", " + this.getValue().item(1).getBlue().getCssText() + ") " + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string2);
        }

        @Override
        public void blueTextChanged(String string2) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    string2 = "rgb(" + this.getValue().getRed().getCssText() + ", " + this.getValue().getGreen().getCssText() + ", " + string2 + ')';
                    break;
                }
                case 2: {
                    string2 = "rgb(" + this.getValue().item(0).getRed().getCssText() + ", " + this.getValue().item(0).getGreen().getCssText() + ", " + string2 + ") " + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string2 = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + string2 + ")";
                    break;
                }
                case 106: {
                    string2 = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + string2 + ") " + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string2);
        }

        @Override
        public void blueFloatValueChanged(short s2, float f2) throws DOMException {
            String string2;
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    string2 = "rgb(" + this.getValue().getRed().getCssText() + ", " + this.getValue().getGreen().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ')';
                    break;
                }
                case 2: {
                    string2 = "rgb(" + this.getValue().item(0).getRed().getCssText() + ", " + this.getValue().item(0).getGreen().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ") " + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string2 = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ')';
                    break;
                }
                case 106: {
                    string2 = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ") " + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string2);
        }

        @Override
        public void rgbColorChanged(String string2) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    break;
                }
                case 2: {
                    string2 = string2 + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string2 = this.getValue().item(0).getCssText() + ' ' + string2;
                    break;
                }
                case 106: {
                    string2 = this.getValue().item(0).getCssText() + ' ' + string2 + ' ' + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string2);
        }

        @Override
        public void rgbColorICCColorChanged(String string2, String string3) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    this.textChanged(string2 + ' ' + string3);
                    break;
                }
                case 106: {
                    this.textChanged(this.getValue().item(0).getCssText() + ' ' + string2 + ' ' + string3);
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorChanged(short s2, String string2, String string3) throws DOMException {
            switch (s2) {
                case 102: {
                    this.textChanged("currentcolor");
                    break;
                }
                case 1: {
                    this.textChanged(string2);
                    break;
                }
                case 2: {
                    this.textChanged(string2 + ' ' + string3);
                    break;
                }
                default: {
                    throw new DOMException(9, "");
                }
            }
        }

        @Override
        public void colorProfileChanged(String string2) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    stringBuffer.append(string2);
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    for (int i2 = 0; i2 < iCCColor.getLength(); ++i2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(i2));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    stringBuffer.append(string2);
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    for (int i3 = 0; i3 < iCCColor.getLength(); ++i3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(i3));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorsCleared() throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorsInitialized(float f2) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    stringBuffer.append(',');
                    stringBuffer.append(f2);
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    stringBuffer.append(',');
                    stringBuffer.append(f2);
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorInsertedBefore(float f2, int n2) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    int n3;
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n3 = 0; n3 < n2; ++n3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n3));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f2);
                    for (n3 = n2; n3 < iCCColor.getLength(); ++n3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n3));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    int n4;
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n4 = 0; n4 < n2; ++n4) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n4));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f2);
                    for (n4 = n2; n4 < iCCColor.getLength(); ++n4) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n4));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorReplaced(float f2, int n2) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    int n3;
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n3 = 0; n3 < n2; ++n3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n3));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f2);
                    for (n3 = n2 + 1; n3 < iCCColor.getLength(); ++n3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n3));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    int n4;
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n4 = 0; n4 < n2; ++n4) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n4));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f2);
                    for (n4 = n2 + 1; n4 < iCCColor.getLength(); ++n4) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n4));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorRemoved(int n2) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    int n3;
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n3 = 0; n3 < n2; ++n3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n3));
                    }
                    for (n3 = n2 + 1; n3 < iCCColor.getLength(); ++n3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n3));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    int n4;
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n4 = 0; n4 < n2; ++n4) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n4));
                    }
                    for (n4 = n2 + 1; n4 < iCCColor.getLength(); ++n4) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n4));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorAppend(float f2) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (int i2 = 0; i2 < iCCColor.getLength(); ++i2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(i2));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f2);
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (int i3 = 0; i3 < iCCColor.getLength(); ++i3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(i3));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f2);
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void uriChanged(String string2) {
            this.textChanged("url(" + string2 + ") none");
        }

        @Override
        public void paintChanged(short s2, String string2, String string3, String string4) {
            switch (s2) {
                case 101: {
                    this.textChanged("none");
                    break;
                }
                case 102: {
                    this.textChanged("currentcolor");
                    break;
                }
                case 1: {
                    this.textChanged(string3);
                    break;
                }
                case 2: {
                    this.textChanged(string3 + ' ' + string4);
                    break;
                }
                case 107: {
                    this.textChanged("url(" + string2 + ')');
                    break;
                }
                case 103: {
                    this.textChanged("url(" + string2 + ") none");
                    break;
                }
                case 104: {
                    this.textChanged("url(" + string2 + ") currentcolor");
                    break;
                }
                case 105: {
                    this.textChanged("url(" + string2 + ") " + string3);
                    break;
                }
                case 106: {
                    this.textChanged("url(" + string2 + ") " + string3 + ' ' + string4);
                }
            }
        }
    }

    public static interface PaintModificationHandler
    extends CSSOMSVGColor.ModificationHandler {
        public void uriChanged(String var1);

        public void paintChanged(short var1, String var2, String var3, String var4);
    }
}

