/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.dom;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.css.dom.CSSOMValue;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.value.Value;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSOMComputedStyle
implements CSSStyleDeclaration {
    protected CSSEngine cssEngine;
    protected CSSStylableElement element;
    protected String pseudoElement;
    protected Map values = new HashMap();

    public CSSOMComputedStyle(CSSEngine cSSEngine, CSSStylableElement cSSStylableElement, String string2) {
        this.cssEngine = cSSEngine;
        this.element = cSSStylableElement;
        this.pseudoElement = string2;
    }

    @Override
    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.cssEngine.getNumberOfProperties(); ++i2) {
            stringBuffer.append(this.cssEngine.getPropertyName(i2));
            stringBuffer.append(": ");
            stringBuffer.append(this.cssEngine.getComputedStyle(this.element, this.pseudoElement, i2).getCssText());
            stringBuffer.append(";\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public void setCssText(String string2) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public String getPropertyValue(String string2) {
        int n2 = this.cssEngine.getPropertyIndex(string2);
        if (n2 == -1) {
            return "";
        }
        Value value = this.cssEngine.getComputedStyle(this.element, this.pseudoElement, n2);
        return value.getCssText();
    }

    @Override
    public CSSValue getPropertyCSSValue(String string2) {
        int n2;
        CSSValue cSSValue = (CSSValue)this.values.get(string2);
        if (cSSValue == null && (n2 = this.cssEngine.getPropertyIndex(string2)) != -1) {
            cSSValue = this.createCSSValue(n2);
            this.values.put(string2, cSSValue);
        }
        return cSSValue;
    }

    @Override
    public String removeProperty(String string2) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public String getPropertyPriority(String string2) {
        return "";
    }

    @Override
    public void setProperty(String string2, String string3, String string4) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public int getLength() {
        return this.cssEngine.getNumberOfProperties();
    }

    @Override
    public String item(int n2) {
        if (n2 < 0 || n2 >= this.cssEngine.getNumberOfProperties()) {
            return "";
        }
        return this.cssEngine.getPropertyName(n2);
    }

    @Override
    public CSSRule getParentRule() {
        return null;
    }

    protected CSSValue createCSSValue(int n2) {
        return new ComputedCSSValue(n2);
    }

    public class ComputedCSSValue
    extends CSSOMValue
    implements CSSOMValue.ValueProvider {
        protected int index;

        public ComputedCSSValue(int n2) {
            super(null);
            this.valueProvider = this;
            this.index = n2;
        }

        @Override
        public Value getValue() {
            return CSSOMComputedStyle.this.cssEngine.getComputedStyle(CSSOMComputedStyle.this.element, CSSOMComputedStyle.this.pseudoElement, this.index);
        }
    }
}

