/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedRangeException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

public abstract class Lexer
extends BaseRecognizer
implements TokenSource {
    protected CharStream input;

    public Lexer() {
    }

    public Lexer(CharStream input) {
        this.input = input;
    }

    public Lexer(CharStream input, RecognizerSharedState state) {
        super(state);
        this.input = input;
    }

    public void reset() {
        super.reset();
        if (this.input != null) {
            this.input.seek(0);
        }
        if (this.state == null) {
            return;
        }
        this.state.token = null;
        this.state.type = 0;
        this.state.channel = 0;
        this.state.tokenStartCharIndex = -1;
        this.state.tokenStartCharPositionInLine = -1;
        this.state.tokenStartLine = -1;
        this.state.text = null;
    }

    public Token nextToken() {
        while (true) {
            this.state.token = null;
            this.state.channel = 0;
            this.state.tokenStartCharIndex = this.input.index();
            this.state.tokenStartCharPositionInLine = this.input.getCharPositionInLine();
            this.state.tokenStartLine = this.input.getLine();
            this.state.text = null;
            if (this.input.LA(1) == -1) {
                return Token.EOF_TOKEN;
            }
            try {
                this.mTokens();
                if (this.state.token == null) {
                    this.emit();
                } else if (this.state.token == Token.SKIP_TOKEN) continue;
                return this.state.token;
            }
            catch (NoViableAltException nva) {
                this.reportError(nva);
                this.recover(nva);
                continue;
            }
            catch (RecognitionException re2) {
                this.reportError(re2);
                continue;
            }
            break;
        }
    }

    public void skip() {
        this.state.token = Token.SKIP_TOKEN;
    }

    public abstract void mTokens() throws RecognitionException;

    public void setCharStream(CharStream input) {
        this.input = null;
        this.reset();
        this.input = input;
    }

    public CharStream getCharStream() {
        return this.input;
    }

    public String getSourceName() {
        return this.input.getSourceName();
    }

    public void emit(Token token2) {
        this.state.token = token2;
    }

    public Token emit() {
        CommonToken t2 = new CommonToken(this.input, this.state.type, this.state.channel, this.state.tokenStartCharIndex, this.getCharIndex() - 1);
        t2.setLine(this.state.tokenStartLine);
        t2.setText(this.state.text);
        t2.setCharPositionInLine(this.state.tokenStartCharPositionInLine);
        this.emit(t2);
        return t2;
    }

    public void match(String s2) throws MismatchedTokenException {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (this.input.LA(1) != s2.charAt(i2)) {
                if (this.state.backtracking > 0) {
                    this.state.failed = true;
                    return;
                }
                MismatchedTokenException mte = new MismatchedTokenException(s2.charAt(i2), this.input);
                this.recover(mte);
                throw mte;
            }
            this.input.consume();
            this.state.failed = false;
        }
    }

    public void matchAny() {
        this.input.consume();
    }

    public void match(int c2) throws MismatchedTokenException {
        if (this.input.LA(1) != c2) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedTokenException mte = new MismatchedTokenException(c2, this.input);
            this.recover(mte);
            throw mte;
        }
        this.input.consume();
        this.state.failed = false;
    }

    public void matchRange(int a2, int b2) throws MismatchedRangeException {
        if (this.input.LA(1) < a2 || this.input.LA(1) > b2) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedRangeException mre = new MismatchedRangeException(a2, b2, this.input);
            this.recover(mre);
            throw mre;
        }
        this.input.consume();
        this.state.failed = false;
    }

    public int getLine() {
        return this.input.getLine();
    }

    public int getCharPositionInLine() {
        return this.input.getCharPositionInLine();
    }

    public int getCharIndex() {
        return this.input.index();
    }

    public String getText() {
        if (this.state.text != null) {
            return this.state.text;
        }
        return this.input.substring(this.state.tokenStartCharIndex, this.getCharIndex() - 1);
    }

    public void setText(String text2) {
        this.state.text = text2;
    }

    public void reportError(RecognitionException e2) {
        this.displayRecognitionError(this.getTokenNames(), e2);
    }

    public String getErrorMessage(RecognitionException e2, String[] tokenNames) {
        String msg = null;
        if (e2 instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)e2;
            msg = "mismatched character " + this.getCharErrorDisplay(e2.c) + " expecting " + this.getCharErrorDisplay(mte.expecting);
        } else if (e2 instanceof NoViableAltException) {
            NoViableAltException nvae = (NoViableAltException)e2;
            msg = "no viable alternative at character " + this.getCharErrorDisplay(e2.c);
        } else if (e2 instanceof EarlyExitException) {
            EarlyExitException eee = (EarlyExitException)e2;
            msg = "required (...)+ loop did not match anything at character " + this.getCharErrorDisplay(e2.c);
        } else if (e2 instanceof MismatchedNotSetException) {
            MismatchedNotSetException mse = (MismatchedNotSetException)e2;
            msg = "mismatched character " + this.getCharErrorDisplay(e2.c) + " expecting set " + mse.expecting;
        } else if (e2 instanceof MismatchedSetException) {
            MismatchedSetException mse = (MismatchedSetException)e2;
            msg = "mismatched character " + this.getCharErrorDisplay(e2.c) + " expecting set " + mse.expecting;
        } else if (e2 instanceof MismatchedRangeException) {
            MismatchedRangeException mre = (MismatchedRangeException)e2;
            msg = "mismatched character " + this.getCharErrorDisplay(e2.c) + " expecting set " + this.getCharErrorDisplay(mre.a) + ".." + this.getCharErrorDisplay(mre.b);
        } else {
            msg = super.getErrorMessage(e2, tokenNames);
        }
        return msg;
    }

    public String getCharErrorDisplay(int c2) {
        String s2 = String.valueOf((char)c2);
        switch (c2) {
            case -1: {
                s2 = "<EOF>";
                break;
            }
            case 10: {
                s2 = "\\n";
                break;
            }
            case 9: {
                s2 = "\\t";
                break;
            }
            case 13: {
                s2 = "\\r";
            }
        }
        return "'" + s2 + "'";
    }

    public void recover(RecognitionException re2) {
        this.input.consume();
    }

    public void traceIn(String ruleName, int ruleIndex) {
        String inputSymbol = (char)this.input.LT(1) + " line=" + this.getLine() + ":" + this.getCharPositionInLine();
        super.traceIn(ruleName, ruleIndex, inputSymbol);
    }

    public void traceOut(String ruleName, int ruleIndex) {
        String inputSymbol = (char)this.input.LT(1) + " line=" + this.getLine() + ":" + this.getCharPositionInLine();
        super.traceOut(ruleName, ruleIndex, inputSymbol);
    }
}

