/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.NativeMethod;
import com.kenai.jffi.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeMethods {
    private static final Map<Class, NativeMethods> registeredMethods = new WeakHashMap<Class, NativeMethods>();
    private final long memory;
    private final List<NativeMethod> methods;

    private NativeMethods(long memory, List<NativeMethod> methods) {
        this.memory = memory;
        this.methods = new ArrayList<NativeMethod>(methods);
    }

    public static final synchronized void register(Class clazz, List<NativeMethod> methods) {
        long ptrSize = Platform.getPlatform().addressSize() / 8;
        MemoryIO mm = MemoryIO.getInstance();
        long memory = mm.allocateMemory((long)(methods.size() * 3) * ptrSize, true);
        if (memory == 0L) {
            throw new OutOfMemoryError("could not allocate native memory");
        }
        NativeMethods nm = new NativeMethods(memory, methods);
        long off = 0L;
        for (NativeMethod m2 : methods) {
            mm.putAddress(memory + off, m2.name);
            mm.putAddress(memory + (off += ptrSize), m2.signature);
            mm.putAddress(memory + (off += ptrSize), m2.function);
            off += ptrSize;
        }
        if (Foreign.getInstance().registerNatives(clazz, memory, methods.size()) != 0) {
            throw new RuntimeException("failed to register native methods");
        }
        registeredMethods.put(clazz, nm);
    }

    public static final synchronized void unregister(Class clazz) {
        if (!registeredMethods.containsKey(clazz)) {
            throw new IllegalArgumentException("methods were not registered on class via NativeMethods.register");
        }
        if (Foreign.getInstance().unregisterNatives(clazz) != 0) {
            throw new RuntimeException("failed to unregister native methods");
        }
        registeredMethods.remove(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            MemoryIO.getInstance().freeMemory(this.memory);
        }
        finally {
            super.finalize();
        }
    }
}

