/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.util;

import com.kenai.jaffl.util.BufferPool;
import com.kenai.jaffl.util.SimpleBufferPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBufferPool
implements BufferPool {
    private final int maxBufferSize;
    private final int maxItemsPerSize;
    private final int maxPoolIndex;
    private SimpleBufferPool[] pools;

    public MultiBufferPool(int maxBufferSize, int maxItemsPerSize, boolean threadSafe) {
        this.maxBufferSize = maxBufferSize;
        this.maxItemsPerSize = maxItemsPerSize;
        this.maxPoolIndex = MultiBufferPool.getSizeIndex(maxBufferSize);
        this.pools = new SimpleBufferPool[this.maxPoolIndex + 1];
        for (int i2 = 0; i2 <= this.maxPoolIndex; ++i2) {
            this.pools[i2] = threadSafe ? new SynchronizedPool(1 << i2, maxItemsPerSize) : new SimpleBufferPool(1 << i2, maxItemsPerSize);
        }
    }

    public MultiBufferPool(int maxBufferSize, int maxItemsPerSize) {
        this(maxBufferSize, maxItemsPerSize, false);
    }

    private static final int getSizeIndex(int size) {
        int start = 0;
        int ssize = size;
        if (ssize > 65535) {
            start += 16;
            ssize >>= 16;
        }
        if (ssize > 255) {
            start += 8;
            ssize >>= 8;
        }
        if (ssize > 15) {
            start += 4;
        }
        for (int i2 = start; i2 < 32; ++i2) {
            if (1 << i2 < size) continue;
            return i2;
        }
        return 32;
    }

    @Override
    public ByteBuffer get(int size) {
        int index = MultiBufferPool.getSizeIndex(size);
        if (index <= this.maxPoolIndex) {
            return this.pools[index].get(size);
        }
        return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
    }

    @Override
    public void put(ByteBuffer buf) {
        int index = MultiBufferPool.getSizeIndex(buf.capacity());
        if (index <= this.maxPoolIndex) {
            this.pools[index].put(buf);
        }
    }

    @Override
    public void putAll(List<ByteBuffer> list) {
        for (ByteBuffer buf : list) {
            this.put(buf);
        }
    }

    static class SynchronizedPool
    extends SimpleBufferPool {
        public SynchronizedPool(int bufferSize, int poolSize) {
            super(bufferSize, poolSize);
        }

        public synchronized ByteBuffer get(int size) {
            return super.get(size);
        }

        public synchronized void put(ByteBuffer buf) {
            super.put(buf);
        }
    }
}

