/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.provider.jffi.AbstractX86StubCompiler;
import com.kenai.jaffl.provider.jffi.CodegenUtils;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jnr.x86asm.Asm;
import com.kenai.jnr.x86asm.Assembler;
import com.kenai.jnr.x86asm.Register;

final class X86_64StubCompiler
extends AbstractX86StubCompiler {
    X86_64StubCompiler() {
    }

    final boolean canCompile(Class returnType, Class[] parameterTypes, CallingConvention convention) {
        if (returnType != Byte.TYPE && returnType != Short.TYPE && returnType != Integer.TYPE && returnType != Long.TYPE && returnType != Float.TYPE && returnType != Double.TYPE && returnType != Void.TYPE) {
            return false;
        }
        if (convention != CallingConvention.DEFAULT) {
            return false;
        }
        int fCount = 0;
        int iCount = 0;
        for (Class t2 : parameterTypes) {
            if (t2 == Byte.TYPE || t2 == Short.TYPE || t2 == Integer.TYPE || t2 == Long.TYPE) {
                ++iCount;
                continue;
            }
            if (t2 == Float.TYPE || t2 == Double.TYPE) {
                ++fCount;
                continue;
            }
            return false;
        }
        return iCount <= 6 && fCount <= 8;
    }

    final void compile(Function function, String name, Class returnType, Class[] parameterTypes, CallingConvention convention, boolean saveErrno) {
        int fCount = 0;
        int iCount = 0;
        for (Class t2 : parameterTypes) {
            if (t2 == Byte.TYPE || t2 == Short.TYPE || t2 == Integer.TYPE || t2 == Long.TYPE) {
                ++iCount;
                continue;
            }
            if (t2 == Float.TYPE || t2 == Double.TYPE) {
                ++fCount;
                continue;
            }
            throw new IllegalArgumentException("invalid parameter type");
        }
        Assembler a2 = new Assembler(Asm.X86_64);
        if (iCount > 0) {
            a2.mov(Asm.rdi, Asm.rdx);
        }
        if (iCount > 1) {
            a2.mov(Asm.rsi, Asm.rcx);
        }
        if (iCount > 2) {
            a2.mov(Asm.rdx, Asm.r8);
        }
        if (iCount > 3) {
            a2.mov(Asm.rcx, Asm.r9);
        }
        if (iCount > 4) {
            a2.mov(Asm.r8, Asm.qword_ptr((Register)Asm.rsp, (long)8L));
        }
        if (iCount > 5) {
            a2.mov(Asm.r9, Asm.qword_ptr((Register)Asm.rsp, (long)16L));
        }
        if (iCount > 6) {
            throw new IllegalArgumentException("integer argument count > 6");
        }
        if (fCount > 8) {
            throw new IllegalArgumentException("float argument count > 8");
        }
        if (saveErrno) {
            int space = returnType == Float.TYPE || returnType == Double.TYPE ? 24 : 8;
            a2.sub(Asm.rsp, Asm.imm((long)space));
            a2.mov(Asm.rax, Asm.imm((long)function.getFunctionAddress()));
            a2.call(Asm.rax);
            if (returnType == Float.TYPE) {
                a2.movss(Asm.dword_ptr((Register)Asm.rsp, (long)0L), Asm.xmm0);
            } else if (returnType == Double.TYPE) {
                a2.movsd(Asm.qword_ptr((Register)Asm.rsp, (long)0L), Asm.xmm0);
            } else {
                a2.mov(Asm.qword_ptr((Register)Asm.rsp, (long)0L), Asm.rax);
            }
            a2.mov(Asm.rax, Asm.imm((long)errnoFunctionAddress));
            a2.call(Asm.rax);
            if (returnType == Float.TYPE) {
                a2.movss(Asm.xmm0, Asm.dword_ptr((Register)Asm.rsp, (long)0L));
            } else if (returnType == Double.TYPE) {
                a2.movsd(Asm.xmm0, Asm.qword_ptr((Register)Asm.rsp, (long)0L));
            } else {
                a2.mov(Asm.rax, Asm.dword_ptr((Register)Asm.rsp, (long)0L));
            }
            a2.add(Asm.rsp, Asm.imm((long)space));
            a2.ret();
        } else {
            a2.mov(Asm.rax, Asm.imm((long)function.getFunctionAddress()));
            a2.jmp(Asm.rax);
        }
        this.stubs.add(new AbstractX86StubCompiler.Stub(name, CodegenUtils.sig(returnType, parameterTypes), a2));
    }
}

