/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import java.util.Arrays;
import java.util.Map;
import org.python.objectweb.asm.AnnotationVisitor;
import org.python.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodegenUtils {
    public static String c(String p2) {
        return p2.replace('/', '.');
    }

    public static String p(Class n2) {
        return n2.getName().replace('.', '/');
    }

    public static String ci(Class n2) {
        if (n2.isArray()) {
            if ((n2 = n2.getComponentType()).isPrimitive()) {
                if (n2 == Byte.TYPE) {
                    return "[B";
                }
                if (n2 == Boolean.TYPE) {
                    return "[Z";
                }
                if (n2 == Short.TYPE) {
                    return "[S";
                }
                if (n2 == Character.TYPE) {
                    return "[C";
                }
                if (n2 == Integer.TYPE) {
                    return "[I";
                }
                if (n2 == Float.TYPE) {
                    return "[F";
                }
                if (n2 == Double.TYPE) {
                    return "[D";
                }
                if (n2 == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n2.getName());
            }
            return "[" + CodegenUtils.ci(n2);
        }
        if (n2.isPrimitive()) {
            if (n2 == Byte.TYPE) {
                return "B";
            }
            if (n2 == Boolean.TYPE) {
                return "Z";
            }
            if (n2 == Short.TYPE) {
                return "S";
            }
            if (n2 == Character.TYPE) {
                return "C";
            }
            if (n2 == Integer.TYPE) {
                return "I";
            }
            if (n2 == Float.TYPE) {
                return "F";
            }
            if (n2 == Double.TYPE) {
                return "D";
            }
            if (n2 == Long.TYPE) {
                return "J";
            }
            if (n2 == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n2.getName());
        }
        return "L" + CodegenUtils.p(n2) + ";";
    }

    public static String human(Class n2) {
        return n2.getCanonicalName();
    }

    public static String sig(Class retval, Class ... params) {
        return CodegenUtils.sigParams(params) + CodegenUtils.ci(retval);
    }

    public static String sig(Class retval, String descriptor, Class ... params) {
        return CodegenUtils.sigParams(descriptor, params) + CodegenUtils.ci(retval);
    }

    public static String sigParams(Class ... params) {
        StringBuilder signature = new StringBuilder("(");
        for (int i2 = 0; i2 < params.length; ++i2) {
            signature.append(CodegenUtils.ci(params[i2]));
        }
        signature.append(")");
        return signature.toString();
    }

    public static String sigParams(String descriptor, Class ... params) {
        StringBuilder signature = new StringBuilder("(");
        signature.append(descriptor);
        for (int i2 = 0; i2 < params.length; ++i2) {
            signature.append(CodegenUtils.ci(params[i2]));
        }
        signature.append(")");
        return signature.toString();
    }

    public static String pretty(Class retval, Class ... params) {
        return CodegenUtils.prettyParams(params) + CodegenUtils.human(retval);
    }

    public static String prettyParams(Class ... params) {
        StringBuilder signature = new StringBuilder("(");
        for (int i2 = 0; i2 < params.length; ++i2) {
            signature.append(CodegenUtils.human(params[i2]));
            if (i2 >= params.length - 1) continue;
            signature.append(',');
        }
        signature.append(")");
        return signature.toString();
    }

    public static Class[] params(Class ... classes) {
        return classes;
    }

    public static Class[] params(Class cls, int times) {
        Object[] classes = new Class[times];
        Arrays.fill(classes, cls);
        return classes;
    }

    public static Class[] params(Class cls1, Class clsFill, int times) {
        Object[] classes = new Class[times + 1];
        Arrays.fill(classes, clsFill);
        classes[0] = cls1;
        return classes;
    }

    /*
     * WARNING - void declaration
     */
    public static String getAnnotatedBindingClassName(String javaMethodName, String typeName, boolean isStatic, int required, int optional, boolean multi, boolean framed) {
        void commonClassSuffix;
        String string2;
        String string3 = string2 = framed ? "$RUBYFRAMEDINVOKER$" : "$RUBYINVOKER$";
        String marker = multi ? (isStatic ? "$s" : "$i") + "_method_multi" + string2 + javaMethodName : (isStatic ? "$s" : "$i") + "_method_" + required + "_" + optional + (String)commonClassSuffix + javaMethodName;
        return typeName + marker;
    }

    public static void visitAnnotationFields(AnnotationVisitor visitor2, Map<String, Object> fields) {
        for (Map.Entry<String, Object> fieldEntry : fields.entrySet()) {
            Object value = fieldEntry.getValue();
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                AnnotationVisitor arrayV = visitor2.visitArray(fieldEntry.getKey());
                for (int i2 = 0; i2 < values.length; ++i2) {
                    arrayV.visit(null, values[i2]);
                }
                arrayV.visitEnd();
                continue;
            }
            if (value.getClass().isEnum()) {
                visitor2.visitEnum(fieldEntry.getKey(), CodegenUtils.ci(value.getClass()), value.toString());
                continue;
            }
            if (value instanceof Class) {
                visitor2.visit(fieldEntry.getKey(), Type.getType((Class)value));
                continue;
            }
            visitor2.visit(fieldEntry.getKey(), value);
        }
    }
}

