/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.CallingConvention;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.annotations.StdCall;
import com.kenai.jaffl.annotations.Synchronized;
import com.kenai.jaffl.provider.Invoker;
import com.kenai.jaffl.provider.Library;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeInvocationHandler
implements InvocationHandler {
    private final InvokerMap invokers;
    private final Library library;
    private final Map<LibraryOption, Object> optionsMap;
    private final Class<?> interfaceClass;

    public NativeInvocationHandler(Library library, Class<?> interfaceClass, Map<LibraryOption, ?> optionsMap) {
        this.library = library;
        this.interfaceClass = interfaceClass;
        this.optionsMap = new HashMap(optionsMap);
        if (interfaceClass.getAnnotation(StdCall.class) != null) {
            this.optionsMap.put(LibraryOption.CallingConvention, (Object)CallingConvention.STDCALL);
        }
        this.invokers = new InvokerMap(interfaceClass.getDeclaredMethods().length);
    }

    public static <T> T wrapInterface(Library library, Class<T> interfaceClass, Map<LibraryOption, ?> optionsMap) {
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new NativeInvocationHandler(library, interfaceClass, optionsMap)));
    }

    private Invoker getInvoker(Method method) {
        Invoker invoker = this.invokers.get(method);
        if (invoker != null) {
            return invoker;
        }
        return this.createInvoker(method);
    }

    private synchronized Invoker createInvoker(Method method) {
        Invoker invoker = this.invokers.get(method);
        if (invoker != null) {
            return invoker;
        }
        invoker = this.library.getInvoker(method, this.optionsMap);
        if (method.getAnnotation(Synchronized.class) != null || this.interfaceClass.getAnnotation(Synchronized.class) != null) {
            invoker = new SynchronizedInvoker(invoker, this.library.libraryLock());
        }
        this.invokers.put(method, invoker);
        return invoker;
    }

    @Override
    public Object invoke(Object self, Method method, Object[] argArray) throws Throwable {
        return this.getInvoker(method).invoke(argArray);
    }

    private static final class InvokerMap {
        private volatile Object[] entries;
        private static final float loadFactor = 0.5f;
        private static final Hasher hasher = Platform.getPlatform().getJavaMajorVersion() >= 6 ? IdentityHasherSingleton.getInstance() : NameHasherSingleton.getInstance();

        public InvokerMap(int maxEntries) {
            int size;
            int capacity = (int)((float)maxEntries / 0.5f) + 1;
            for (size = 1; size < capacity; size <<= 1) {
            }
            this.entries = new Object[size * 2];
        }

        public final synchronized void put(Method method, Invoker invoker) {
            Object[] tmp = new Object[this.entries.length];
            System.arraycopy(this.entries, 0, tmp, 0, tmp.length);
            int start = InvokerMap.indexFor(method, tmp.length);
            block0: for (int loop = 0; loop < 2; ++loop) {
                for (int i2 = start; i2 < tmp.length - 1; i2 += 2) {
                    if (tmp[i2] != null) continue;
                    tmp[i2] = method;
                    tmp[i2 + 1] = invoker;
                    break block0;
                }
                start = 0;
            }
            this.entries = tmp;
        }

        public final Invoker get(Method method) {
            Object[] tmp = this.entries;
            int start = InvokerMap.indexFor(method, tmp.length);
            block0: for (int loop = 0; loop < 2; ++loop) {
                for (int i2 = start; i2 < tmp.length - 1; i2 += 2) {
                    if (tmp[i2] == method) {
                        return (Invoker)tmp[i2 + 1];
                    }
                    if (tmp[i2] == null) break block0;
                }
                start = 0;
            }
            return null;
        }

        private static final int indexFor(Method key, int length) {
            return hasher.hash(key) & length - 1;
        }

        private static final class NameHasherSingleton {
            private NameHasherSingleton() {
            }

            public static final Hasher getInstance() {
                return new NameHasher();
            }

            private static final class NameHasher
            implements Hasher {
                private NameHasher() {
                }

                public final int hash(Method key) {
                    int h2 = key.hashCode();
                    h2 += h2 << 15 ^ 0xFFFFCD7D;
                    h2 ^= h2 >>> 10;
                    h2 += h2 << 3;
                    h2 ^= h2 >>> 6;
                    h2 += (h2 << 2) + (h2 << 14);
                    return h2 ^ h2 >>> 16;
                }
            }
        }

        private static final class IdentityHasherSingleton {
            private IdentityHasherSingleton() {
            }

            public static final Hasher getInstance() {
                return new IdentityHasher();
            }

            private static final class IdentityHasher
            implements Hasher {
                private IdentityHasher() {
                }

                public final int hash(Method key) {
                    int h2 = System.identityHashCode(key);
                    return (h2 << 1) - (h2 << 8);
                }
            }
        }

        private static interface Hasher {
            public int hash(Method var1);
        }
    }

    private static final class SynchronizedInvoker
    implements Invoker {
        private final Object lock;
        private final Invoker invoker;

        public SynchronizedInvoker(Invoker invoker, Object lock) {
            this.invoker = invoker;
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object[] parameters) {
            Object object = this.lock;
            synchronized (object) {
                return this.invoker.invoke(parameters);
            }
        }
    }
}

