/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.TristateButtonModel;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import sun.swing.plaf.synth.SynthIcon;

public class TristateCheckBoxIcon
implements Icon,
SynthConstants {
    private UIDefaults.LazyValue _originalIcon;
    private static Map<String, Boolean> _synthIconMap;

    public TristateCheckBoxIcon(UIDefaults.LazyValue originalIcon) {
        this._originalIcon = originalIcon;
    }

    protected boolean isSynthIconClassName(String name) {
        return name != null && name.contains("sun.swing.plaf.synth.SynthIcon");
    }

    private boolean isSynthIcon(Icon icon) {
        if (_synthIconMap == null) {
            _synthIconMap = new HashMap<String, Boolean>();
        }
        ArrayList<String> classNamesToPut = new ArrayList<String>();
        boolean isSynthIcon = false;
        for (Class<?> aClass = icon.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            String name = aClass.getCanonicalName();
            if (name == null) continue;
            Boolean value = _synthIconMap.get(name);
            if (value != null) {
                return value;
            }
            classNamesToPut.add(name);
            if (!this.isSynthIconClassName(name)) continue;
            isSynthIcon = true;
            break;
        }
        for (String name : classNamesToPut) {
            _synthIconMap.put(name, isSynthIcon);
        }
        return isSynthIcon;
    }

    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        if (this.isSynthIcon(icon)) {
            int state = this.getComponentState((JComponent)c2);
            if (c2 instanceof TristateCheckBox && ((TristateCheckBox)c2).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c2).getModel()).isMixed()) {
                state &= 0xFFFFFDFF;
            }
            SynthContext context = new SynthContext((JComponent)c2, Region.CHECK_BOX, SynthLookAndFeel.getStyle((JComponent)c2, Region.CHECK_BOX), state);
            int w2 = ((SynthIcon)icon).getIconWidth(context);
            int h2 = ((SynthIcon)icon).getIconHeight(context);
            ((SynthIcon)icon).paintIcon(context, g2, x2, y2, w2, h2);
        } else {
            if (c2 instanceof TristateCheckBox && ((TristateCheckBox)c2).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c2).getModel()).isMixed()) {
                ((TristateButtonModel)((TristateCheckBox)c2).getModel()).internalSetSelected(false);
            }
            icon.paintIcon(c2, g2, x2, y2);
            if (c2 instanceof TristateCheckBox && ((TristateCheckBox)c2).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c2).getModel()).isMixed()) {
                ((TristateButtonModel)((TristateCheckBox)c2).getModel()).internalSetSelected(true);
            }
        }
        g2.setColor(UIManager.getColor("CheckBox.foreground"));
        if (c2 instanceof TristateCheckBox && ((TristateCheckBox)c2).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c2).getModel()).isMixed()) {
            this.drawSquare(c2, g2, x2, y2);
        }
    }

    private int getComponentState(JComponent c2) {
        AbstractButton button;
        ButtonModel model;
        int state = 1;
        if (!c2.isEnabled()) {
            state = 8;
        }
        if ((model = (button = (AbstractButton)c2).getModel()).isPressed()) {
            state = model.isArmed() ? 4 : 2;
        }
        if (model.isRollover()) {
            state |= 2;
        }
        if (model.isSelected()) {
            state |= 0x200;
        }
        if (c2.isFocusOwner() && button.isFocusPainted()) {
            state |= 0x100;
        }
        if (c2 instanceof JButton && ((JButton)c2).isDefaultButton()) {
            state |= 0x400;
        }
        return state;
    }

    public int getIconWidth() {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        return icon.getIconWidth();
    }

    public int getIconHeight() {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        return icon.getIconHeight();
    }

    protected void drawSquare(Component c2, Graphics g2, int x2, int y2) {
        int w2 = Math.min(this.getIconWidth(), this.getIconHeight());
        int h2 = Math.min(this.getIconWidth(), this.getIconHeight());
        int xMargin = w2 / 3;
        int yMargin = h2 / 3;
        g2.fillRect(x2 + xMargin, y2 + yMargin, w2 - xMargin * 2, h2 - yMargin * 2);
    }
}

