/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class TextComponentSearchable
extends Searchable
implements DocumentListener,
PropertyChangeListener {
    private Highlighter.HighlightPainter _highlightPainter;
    private static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(204, 204, 255);
    private Color _highlightColor = null;
    private int _selectedIndex = -1;
    private HighlighCache _highlighCache = new HighlighCache();
    private String _text = null;

    public TextComponentSearchable(JTextComponent textComponent) {
        super(textComponent);
        this.installHighlightsRemover();
        this.setHighlightColor(DEFAULT_HIGHLIGHT_COLOR);
    }

    public void uninstallHighlightsRemover() {
        DelegateAction.restoreAction(this._component, 0, KeyStroke.getKeyStroke(27, 0));
    }

    public void installHighlightsRemover() {
        DelegateAction.replaceAction(this._component, 0, KeyStroke.getKeyStroke(27, 0), new DelegateAction(){
            private static final long serialVersionUID = 8572103995404313032L;

            public boolean isDelegateEnabled() {
                Iterator highlights;
                if (TextComponentSearchable.this._component instanceof JTextComponent && !(highlights = TextComponentSearchable.this._highlighCache.getAllHighlights()).hasNext()) {
                    return false;
                }
                return super.isDelegateEnabled();
            }

            public boolean delegateActionPerformed(ActionEvent e2) {
                Iterator highlights;
                if (TextComponentSearchable.this._component instanceof JTextComponent && !(highlights = TextComponentSearchable.this._highlighCache.getAllHighlights()).hasNext()) {
                    return false;
                }
                TextComponentSearchable.this.removeAllHighlights();
                return true;
            }
        });
    }

    public void installListeners() {
        super.installListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().addDocumentListener(this);
            this._component.addPropertyChangeListener("document", this);
        }
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().removeDocumentListener(this);
            this._component.removePropertyChangeListener("document", this);
        }
    }

    protected void setSelectedIndex(int index, boolean incremental) {
        if (this._component instanceof JTextComponent) {
            if (index == -1) {
                this.removeAllHighlights();
                this._selectedIndex = -1;
                return;
            }
            if (!incremental) {
                this.removeAllHighlights();
            }
            String text2 = this.getSearchingText();
            try {
                this.addHighlight(index, text2, incremental);
            }
            catch (BadLocationException e2) {
                e2.printStackTrace();
            }
        }
    }

    protected void addHighlight(final int index, final String text2, boolean incremental) throws BadLocationException {
        if (this._component instanceof JTextComponent) {
            final JTextComponent textComponent = (JTextComponent)this._component;
            Object obj = textComponent.getHighlighter().addHighlight(index, index + text2.length(), this._highlightPainter);
            this._highlighCache.addHighlight(obj);
            this._selectedIndex = index;
            if (!incremental) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        TextComponentSearchable.this.scrollTextVisible(textComponent, index, text2.length());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private void scrollTextVisible(JTextComponent textComponent, int index, int length) {
        if (index != -1) {
            try {
                Rectangle begin = textComponent.modelToView(index);
                if (begin == null) {
                    return;
                }
                Rectangle end = textComponent.modelToView(index + length);
                if (end == null) {
                    return;
                }
                Rectangle bounds = this._component.getVisibleRect();
                if (begin.x <= bounds.width) {
                    begin.width = end.x;
                    begin.x = 0;
                } else {
                    begin.width = end.x - begin.x;
                }
                textComponent.scrollRectToVisible(begin);
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
    }

    protected void removeAllHighlights() {
        if (this._component instanceof JTextComponent) {
            Iterator itor = this._highlighCache.getAllHighlights();
            while (itor.hasNext()) {
                Object o2 = itor.next();
                ((JTextComponent)this._component).getHighlighter().removeHighlight(o2);
            }
            this._highlighCache.removeAllHighlights();
        }
    }

    protected int getSelectedIndex() {
        if (this._component instanceof JTextComponent) {
            return this._selectedIndex;
        }
        return 0;
    }

    protected Object getElementAt(int index) {
        String text2 = this.getSearchingText();
        if (text2 != null && this._component instanceof JTextComponent) {
            int elementCount;
            int endIndex = index + text2.length();
            if (endIndex > (elementCount = this.getElementCount())) {
                endIndex = this.getElementCount();
            }
            try {
                return ((JTextComponent)this._component).getDocument().getText(index, endIndex - index + 1);
            }
            catch (BadLocationException e2) {
                return null;
            }
        }
        return "";
    }

    protected int getElementCount() {
        if (this._component instanceof JTextComponent) {
            return ((JTextComponent)this._component).getDocument().getLength();
        }
        return 0;
    }

    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            if (evt.getOldValue() instanceof Document) {
                ((Document)evt.getNewValue()).removeDocumentListener(this);
            }
            if (evt.getNewValue() instanceof Document) {
                ((Document)evt.getNewValue()).addDocumentListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void insertUpdate(DocumentEvent e2) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void removeUpdate(DocumentEvent e2) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void changedUpdate(DocumentEvent e2) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    protected boolean isActivateKey(KeyEvent e2) {
        if (this._component instanceof JTextComponent && ((JTextComponent)this._component).isEditable()) {
            return e2.getID() == 401 && e2.getKeyCode() == 70 && JideSwingUtilities.isMenuShortcutKeyDown(e2);
        }
        return super.isActivateKey(e2);
    }

    public Color getHighlightColor() {
        if (this._highlightColor != null) {
            return this._highlightColor;
        }
        return DEFAULT_HIGHLIGHT_COLOR;
    }

    public void setHighlightColor(Color highlightColor) {
        this._highlightColor = highlightColor;
        this._highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(this._highlightColor);
    }

    public int findLast(String s2) {
        if (this._component instanceof JTextComponent) {
            String text2 = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return text2.lastIndexOf(s2);
            }
            return TextComponentSearchable.lastIndexOf(text2, s2, text2.length());
        }
        return super.findLast(s2);
    }

    private String getDocumentText() {
        if (this._text == null) {
            Document document = ((JTextComponent)this._component).getDocument();
            try {
                String text2;
                this._text = text2 = document.getText(0, document.getLength());
            }
            catch (BadLocationException e2) {
                return "";
            }
        }
        return this._text;
    }

    public int findFirst(String s2) {
        if (this._component instanceof JTextComponent) {
            String text2 = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return text2.indexOf(s2);
            }
            return TextComponentSearchable.indexOf(text2, s2, 0);
        }
        return super.findFirst(s2);
    }

    static int lastIndexOf(String source, String target, int fromIndex) {
        int sourceCount = source.length();
        int targetCount = target.length();
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char[] lowerTarget = target.toLowerCase().toCharArray();
        char[] upperTarget = target.toUpperCase().toCharArray();
        int strLastIndex = targetCount - 1;
        int min = targetCount - 1;
        int i2 = min + fromIndex;
        while (i2 >= min) {
            while (i2 >= min && source.charAt(i2) != lowerTarget[strLastIndex] && source.charAt(i2) != upperTarget[strLastIndex]) {
                --i2;
            }
            if (i2 < min) break;
            int j2 = i2 - 1;
            int start = j2 - (targetCount - 1);
            int k2 = strLastIndex - 1;
            while (j2 > start) {
                char ch2 = source.charAt(j2);
                if (ch2 != lowerTarget[k2] && ch2 != upperTarget[k2]) {
                    --i2;
                    break;
                }
                --j2;
                --k2;
            }
            if (j2 > start) continue;
            return start + 1;
        }
        return -1;
    }

    private static int indexOf(String source, String target, int fromIndex) {
        int sourceCount = source.length();
        int targetCount = target.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char[] lowerTarget = target.toLowerCase().toCharArray();
        char[] upperTarget = target.toUpperCase().toCharArray();
        int max = sourceCount - targetCount;
        for (int i2 = fromIndex; i2 <= max; ++i2) {
            char ch2;
            int j2;
            char c2 = source.charAt(i2);
            if (c2 != lowerTarget[0] && c2 != upperTarget[0]) {
                ++i2;
                while (i2 <= max && source.charAt(i2) != lowerTarget[0] && source.charAt(i2) != upperTarget[0]) {
                    ++i2;
                }
            }
            if (i2 > max) continue;
            int end = j2 + targetCount - 1;
            int k2 = 1;
            for (j2 = i2 + 1; j2 < end && ((ch2 = source.charAt(j2)) == lowerTarget[k2] || ch2 == upperTarget[k2]); ++j2) {
                ++k2;
            }
            if (j2 != end) continue;
            return i2;
        }
        return -1;
    }

    public int findFromCursor(String s2) {
        String text2;
        if (this.isCountMatch()) {
            int oldIndex;
            text2 = this.getDocumentText();
            int newIndex = 0;
            this._matchCount = -1;
            do {
                oldIndex = newIndex;
                newIndex = (this.isCaseSensitive() ? text2.indexOf(s2, oldIndex) : TextComponentSearchable.indexOf(text2, s2, oldIndex)) + 1;
                ++this._matchCount;
            } while (newIndex > oldIndex);
        }
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(s2);
        }
        if (this._component instanceof JTextComponent) {
            int found;
            int count;
            int selectedIndex;
            text2 = this.getDocumentText();
            int n2 = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s2.length() > 0 ? -1 : 0;
            }
            int n3 = found = this.isCaseSensitive() ? text2.indexOf(s2, selectedIndex) : TextComponentSearchable.indexOf(text2, s2, selectedIndex);
            if (found == -1) {
                int n4 = found = this.isCaseSensitive() ? text2.indexOf(s2, 0) : TextComponentSearchable.indexOf(text2, s2, 0);
                if (found >= selectedIndex) {
                    found = -1;
                }
            }
            return found;
        }
        return super.findFromCursor(s2);
    }

    public int reverseFindFromCursor(String s2) {
        if (!this.isReverseOrder()) {
            return this.findFromCursor(s2);
        }
        if (this._component instanceof JTextComponent) {
            int found;
            int count;
            int selectedIndex;
            String text2 = this.getDocumentText();
            int n2 = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s2.length() > 0 ? -1 : 0;
            }
            int n3 = found = this.isCaseSensitive() ? text2.lastIndexOf(s2, selectedIndex) : TextComponentSearchable.lastIndexOf(text2, s2, selectedIndex);
            if (found == -1) {
                int n4 = found = this.isCaseSensitive() ? text2.lastIndexOf(s2, text2.length() - 1) : TextComponentSearchable.lastIndexOf(text2, s2, text2.length() - 1);
                if (found <= selectedIndex) {
                    found = -1;
                }
            }
            return found;
        }
        return super.findFromCursor(s2);
    }

    public int findNext(String s2) {
        if (this._component instanceof JTextComponent) {
            int found;
            int count;
            int selectedIndex;
            String text2 = this.getDocumentText();
            int n2 = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s2.length() > 0 ? -1 : 0;
            }
            int n3 = found = this.isCaseSensitive() ? text2.indexOf(s2, selectedIndex + 1) : TextComponentSearchable.indexOf(text2, s2, selectedIndex + 1);
            if (found == -1 && this.isRepeats()) {
                int n4 = found = this.isCaseSensitive() ? text2.indexOf(s2, 0) : TextComponentSearchable.indexOf(text2, s2, 0);
                if (found > selectedIndex) {
                    found = -1;
                }
            }
            return found;
        }
        return super.findNext(s2);
    }

    public int findPrevious(String s2) {
        if (this._component instanceof JTextComponent) {
            int found;
            int count;
            int selectedIndex;
            String text2 = this.getDocumentText();
            int n2 = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s2.length() > 0 ? -1 : 0;
            }
            int n3 = found = this.isCaseSensitive() ? text2.lastIndexOf(s2, selectedIndex - 1) : TextComponentSearchable.lastIndexOf(text2, s2, selectedIndex - 1);
            if (found == -1 && this.isRepeats()) {
                int n4 = found = this.isCaseSensitive() ? text2.lastIndexOf(s2, count - 1) : TextComponentSearchable.lastIndexOf(text2, s2, count - 1);
                if (found < selectedIndex) {
                    found = -1;
                }
            }
            return found;
        }
        return super.findPrevious(s2);
    }

    public void hidePopup() {
        super.hidePopup();
        this._selectedIndex = -1;
    }

    protected void searchingTextEmpty() {
        this.setSelectedIndex(-1, false);
    }

    private class HighlighCache
    extends HashMap {
        private HighlighCache() {
        }

        public void addHighlight(Object obj) {
            this.put(obj, null);
        }

        public void removeHighlight(Object obj) {
            this.remove(obj);
        }

        public Iterator getAllHighlights() {
            return this.keySet().iterator();
        }

        public void removeAllHighlights() {
            this.clear();
        }
    }
}

