/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class StyledLabelBuilder {
    private StringBuffer buffer = new StringBuffer();
    private List ranges = new ArrayList();
    private int start = 0;
    private Map styles = new HashMap();
    private static int[] colorShorthandTable = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};
    private static Map colorNamesMap = new TreeMap();

    public void clear() {
        this.buffer.delete(0, this.buffer.length());
        this.ranges.clear();
        this.start = 0;
    }

    public StyledLabelBuilder register(String text2, Color fontColor) {
        this.styles.put(text2, new StyleRange(fontColor));
        return this;
    }

    public StyledLabelBuilder register(String text2, int fontStyle) {
        this.styles.put(text2, new StyleRange(fontStyle));
        return this;
    }

    public StyledLabelBuilder register(String text2, int fontStyle, Color fontColor) {
        this.styles.put(text2, new StyleRange(fontStyle, fontColor));
        return this;
    }

    public StyledLabelBuilder register(String text2, int fontStyle, Color fontColor, int additionalStyle) {
        this.styles.put(text2, new StyleRange(this.start, text2.length(), fontStyle, fontColor, additionalStyle));
        return this;
    }

    public StyledLabelBuilder register(String text2, int fontStyle, Color fontColor, int additionalStyle, Color lineColor) {
        this.styles.put(text2, new StyleRange(this.start, text2.length(), fontStyle, fontColor, additionalStyle, lineColor));
        return this;
    }

    public StyledLabelBuilder register(String text2, int fontStyle, Color fontColor, int additionalStyle, Color lineColor, Stroke lineStroke) {
        this.styles.put(text2, new StyleRange(this.start, text2.length(), fontStyle, fontColor, additionalStyle, lineColor, lineStroke));
        return this;
    }

    public StyledLabelBuilder register(String text2, int fontStyle, Color fontColor, int additionalStyle, Color lineColor, Stroke lineStroke, float fontShrinkRatio) {
        this.styles.put(text2, new StyleRange(this.start, text2.length(), fontStyle, fontColor, additionalStyle, lineColor, lineStroke, fontShrinkRatio));
        return this;
    }

    public StyledLabelBuilder register(String text2, int fontStyle, int additionalStyle) {
        this.styles.put(text2, new StyleRange(this.start, text2.length(), fontStyle, additionalStyle));
        return this;
    }

    public StyledLabelBuilder register(String text2, int fontStyle, int additionalStyle, float fontShrinkRatio) {
        this.styles.put(text2, new StyleRange(this.start, text2.length(), fontStyle, additionalStyle, fontShrinkRatio));
        return this;
    }

    public StyledLabelBuilder register(String text2, String format) {
        ParsedStyleResult result = StyledLabelBuilder.parseStyleAnnotation(format.toCharArray(), 0, this);
        this.styles.put(text2, new StyleRange(result.fontStyle, result.fontColor, result.backgroundColor, result.additionalStyle, result.lineColor));
        return this;
    }

    public StyledLabelBuilder add(String text2) {
        this.buffer.append(text2);
        this.start += text2.length();
        return this;
    }

    public StyledLabelBuilder add(String text2, Color fontColor) {
        this.ranges.add(new StyleRange(this.start, text2.length(), fontColor));
        return this.add(text2);
    }

    public StyledLabelBuilder add(String text2, int fontStyle) {
        this.ranges.add(new StyleRange(this.start, text2.length(), fontStyle));
        return this.add(text2);
    }

    public StyledLabelBuilder add(String text2, int fontStyle, Color fontColor) {
        this.ranges.add(new StyleRange(this.start, text2.length(), fontStyle, fontColor));
        return this.add(text2);
    }

    public StyledLabelBuilder add(String text2, int fontStyle, Color fontColor, int additionalStyle) {
        this.ranges.add(new StyleRange(this.start, text2.length(), fontStyle, fontColor, additionalStyle));
        return this.add(text2);
    }

    public StyledLabelBuilder add(String text2, int fontStyle, Color fontColor, int additionalStyle, Color lineColor) {
        this.ranges.add(new StyleRange(this.start, text2.length(), fontStyle, fontColor, additionalStyle, lineColor));
        return this.add(text2);
    }

    public StyledLabelBuilder add(String text2, int fontStyle, Color fontColor, Color backgroundColor, int additionalStyle, Color lineColor) {
        this.ranges.add(new StyleRange(this.start, text2.length(), fontStyle, fontColor, backgroundColor, additionalStyle, lineColor));
        return this.add(text2);
    }

    public StyledLabelBuilder add(String text2, int fontStyle, Color fontColor, Color backgroundColor, int additionalStyle, Color lineColor, Stroke lineStroke) {
        this.ranges.add(new StyleRange(this.start, text2.length(), fontStyle, fontColor, backgroundColor, additionalStyle, lineColor, lineStroke));
        return this.add(text2);
    }

    public StyledLabelBuilder add(String text2, int fontStyle, Color fontColor, int additionalStyle, Color lineColor, Stroke lineStroke, float fontShrinkRatio) {
        this.ranges.add(new StyleRange(this.start, text2.length(), fontStyle, fontColor, additionalStyle, lineColor, lineStroke, fontShrinkRatio));
        return this.add(text2);
    }

    public StyledLabelBuilder add(String text2, String style) {
        StyleRange range = (StyleRange)this.styles.get(style);
        if (range == null) {
            ParsedStyleResult result = StyledLabelBuilder.parseStyleAnnotation(style.toCharArray(), 0, this);
            return this.add(text2, result.fontStyle, result.fontColor, result.backgroundColor, result.additionalStyle, result.lineColor);
        }
        return this.add(text2, range.getFontStyle(), range.getFontColor(), range.getAdditionalStyle(), range.getLineColor(), range.getLineStroke(), range.getFontShrinkRatio());
    }

    public StyledLabelBuilder add(String text2, int fontStyle, int additionalStyle) {
        this.ranges.add(new StyleRange(this.start, text2.length(), fontStyle, additionalStyle));
        return this.add(text2);
    }

    public StyledLabelBuilder add(String text2, int fontStyle, int additionalStyle, float fontShrinkRatio) {
        this.ranges.add(new StyleRange(this.start, text2.length(), fontStyle, additionalStyle, fontShrinkRatio));
        return this.add(text2);
    }

    public StyledLabel configure(StyledLabel label, String style) {
        StyledLabelBuilder.setStyledText(label, style, this);
        return label;
    }

    public StyledLabel configure(StyledLabel label) {
        label.setText(this.buffer.toString());
        int size = this.ranges.size();
        for (int i2 = 0; i2 < size; ++i2) {
            label.addStyleRange((StyleRange)this.ranges.get(i2));
        }
        return label;
    }

    public StyledLabel createLabel() {
        return this.configure(new StyledLabel());
    }

    public static StyledLabel createStyledLabel(String text2) {
        StyledLabel label = new StyledLabel();
        StyledLabelBuilder.setStyledText(label, text2);
        return label;
    }

    public static void setStyledText(StyledLabel label, String text2) {
        StyledLabelBuilder.setStyledText(label, text2.toCharArray());
    }

    private static void setStyledText(StyledLabel label, String text2, StyledLabelBuilder builder) {
        StyledLabelBuilder.setStyledText(label, text2.toCharArray(), builder);
    }

    public static void setStyledText(StyledLabel label, char[] text2) {
        StyledLabelBuilder.setStyledText(label, text2, null);
    }

    private static void setStyledText(StyledLabel label, char[] text2, StyledLabelBuilder builder) {
        StringBuffer labelText = new StringBuffer(text2.length);
        boolean escaped = false;
        label.clearStyleRanges();
        label.setLineWrap(false);
        int endOfText = text2.length;
        for (int j2 = text2.length - 1; j2 >= 0; --j2) {
            if (text2[j2] != '@') continue;
            if (!StyledLabelBuilder.isGlobalConfiguration(label, text2, j2 + 1)) break;
            endOfText = j2;
            break;
        }
        block5: for (int i2 = 0; i2 < endOfText; ++i2) {
            if (escaped) {
                labelText.append(text2[i2]);
                escaped = false;
                continue;
            }
            switch (text2[i2]) {
                case '{': {
                    ParsedStyleResult result = StyledLabelBuilder.parseStylePart(text2, i2 + 1, builder);
                    if (result == null) {
                        labelText.append(text2[i2]);
                        continue block5;
                    }
                    int realIndex = labelText.length();
                    labelText.append(result.text);
                    if (result.text.length() > 0) {
                        label.addStyleRange(new StyleRange(realIndex, result.text.length(), result.fontStyle, result.fontColor, result.backgroundColor, result.additionalStyle, result.lineColor));
                    }
                    i2 = Math.max(i2, result.endOffset);
                    continue block5;
                }
                case '\\': {
                    escaped = true;
                    continue block5;
                }
                default: {
                    labelText.append(text2[i2]);
                }
            }
        }
        label.setText(labelText.toString());
    }

    private static boolean isGlobalConfiguration(StyledLabel label, char[] text2, int offset) {
        String globalString = new String(text2, offset, text2.length - offset);
        String[] subStringsLevel0 = globalString.split(",");
        if (subStringsLevel0.length <= 0 || subStringsLevel0[0] == null) {
            return false;
        }
        int defaultRows = 1;
        int maxRows = 0;
        int minRows = 0;
        int preferredWidth = 0;
        for (String subStringLevel0 : subStringsLevel0) {
            String[] subStrings = subStringLevel0.split(":");
            if (subStrings.length <= 0 || subStrings[0] == null) {
                return false;
            }
            String property = subStrings[0].trim().toLowerCase();
            if ("rows".equals(property) || "row".equals(property) || "r".equals(property)) {
                if (subStrings.length > 4 || subStrings.length < 1) {
                    return false;
                }
                if (subStrings.length >= 2 && subStrings[1].trim().length() > 0) {
                    try {
                        defaultRows = Integer.valueOf(subStrings[1]);
                    }
                    catch (NumberFormatException e2) {
                        return false;
                    }
                }
                if (subStrings.length >= 3 && subStrings[2].trim().length() > 0) {
                    try {
                        minRows = Integer.valueOf(subStrings[2]);
                    }
                    catch (NumberFormatException e3) {
                        return false;
                    }
                    if (minRows > defaultRows || minRows < 0) {
                        if (subStrings[1].trim().length() > 0) {
                            minRows = 0;
                        } else if (minRows > defaultRows) {
                            defaultRows = minRows;
                        } else {
                            minRows = 0;
                        }
                    }
                }
                if (subStrings.length < 4 || subStrings[3].trim().length() <= 0) continue;
                try {
                    maxRows = Integer.valueOf(subStrings[3]);
                }
                catch (NumberFormatException e4) {
                    return false;
                }
                if (maxRows >= defaultRows && maxRows >= 0) continue;
                maxRows = 0;
                continue;
            }
            if ("w".equals(property) || "width".equals(property) || "preferredwidth".equals(property)) {
                if (subStrings.length != 2) {
                    return false;
                }
                if (subStrings[1].trim().length() <= 0) continue;
                try {
                    preferredWidth = Integer.valueOf(subStrings[1]);
                    continue;
                }
                catch (NumberFormatException e5) {
                    return false;
                }
            }
            return false;
        }
        label.setLineWrap(true);
        label.setRows(defaultRows);
        label.setMaxRows(maxRows);
        label.setMinRows(minRows);
        label.setPreferredWidth(preferredWidth);
        if (defaultRows == 1 && maxRows == 1 && minRows == 1) {
            label.setLineWrap(false);
        }
        return true;
    }

    public static String parseToVoidStyledTextConfusion(String originalString) {
        String destString = originalString.replaceAll("\\\\", "\\\\\\\\");
        destString = destString.replaceAll("\\{", "\\\\{");
        return destString;
    }

    private static ParsedStyleResult parseStylePart(char[] text2, int start, StyledLabelBuilder builder) {
        ParsedStyleResult result = new ParsedStyleResult();
        int i2 = start;
        int findIndex = StyledLabelBuilder.findNext(text2, ':', i2);
        int indexMatchingBracket = StyledLabelBuilder.findMatchingBracket(text2, start);
        if (findIndex < 0 || findIndex > indexMatchingBracket) {
            return null;
        }
        result.text = StyledLabelBuilder.createTrimmedString(text2, i2, findIndex - 1);
        return StyledLabelBuilder.parseStyleAnnotation(text2, findIndex + 1, builder, result);
    }

    private static int findMatchingBracket(char[] text2, int offset) {
        if (text2.length == 0) {
            return -1;
        }
        if (offset >= text2.length) {
            return -1;
        }
        int count = 1;
        int len = text2.length - offset;
        int i2 = 0;
        while (i2 < len) {
            char x2 = text2[offset];
            if (x2 == '{') {
                ++count;
            } else if (x2 == '}' && --count == 0) {
                return offset;
            }
            ++i2;
            ++offset;
        }
        return -1;
    }

    private static ParsedStyleResult parseStyleAnnotation(char[] text2, int start, StyledLabelBuilder builder) {
        ParsedStyleResult result = new ParsedStyleResult();
        return StyledLabelBuilder.parseStyleAnnotation(text2, start, builder, result);
    }

    private static ParsedStyleResult parseStyleAnnotation(char[] text2, int findIndex, StyledLabelBuilder builder, ParsedStyleResult result) {
        int i2 = findIndex;
        char[] importantChars = new char[]{',', '}'};
        boolean endOfTag = false;
        while (i2 < text2.length && !endOfTag) {
            String style;
            int colonIndex;
            findIndex = StyledLabelBuilder.findNextOf(text2, importantChars, i2);
            if (findIndex == -1 || text2[findIndex] == '}') {
                endOfTag = true;
            }
            if ((colonIndex = (style = StyledLabelBuilder.createTrimmedString(text2, i2, findIndex == -1 ? text2.length - 1 : findIndex - 1)).indexOf(58)) != -1) {
                String color = style.substring(colonIndex + 1);
                if (color.length() > 1) {
                    if (color.charAt(0) == '(') {
                        findIndex = StyledLabelBuilder.findNext(text2, ')', i2 + colonIndex + 1);
                        style = StyledLabelBuilder.createTrimmedString(text2, i2, findIndex + 1);
                        color = style.substring(colonIndex + 1);
                        if (text2[findIndex + 1] == '}') {
                            endOfTag = true;
                        }
                        ++findIndex;
                    }
                    if (style.charAt(0) == 'f') {
                        result.fontColor = StyledLabelBuilder.toColor(color);
                    } else if (style.charAt(0) == 'b') {
                        result.backgroundColor = StyledLabelBuilder.toColor(color);
                    } else {
                        result.lineColor = StyledLabelBuilder.toColor(color);
                    }
                }
            } else if (style.equals("plain") || style.equals("p")) {
                result.fontStyle = 0;
            } else if (style.equals("bold") || style.equals("b")) {
                result.fontStyle = 1;
            } else if (style.equals("italic") || style.equals("i")) {
                result.fontStyle = 2;
            } else if (style.equals("bolditalic") || style.equals("bi")) {
                result.fontStyle = 3;
            } else if (style.equals("strike") || style.equals("s")) {
                result.additionalStyle |= 1;
            } else if (style.equals("doublestrike") || style.equals("ds")) {
                result.additionalStyle |= 2;
            } else if (style.equals("waved") || style.equals("w")) {
                result.additionalStyle |= 4;
            } else if (style.equals("underlined") || style.equals("u")) {
                result.additionalStyle |= 8;
            } else if (style.equals("dotted") || style.equals("d")) {
                result.additionalStyle |= 0x10;
            } else if (style.equals("superscript") || style.equals("sp")) {
                result.additionalStyle |= 0x20;
            } else if (style.equals("subscript") || style.equals("sb")) {
                result.additionalStyle |= 0x40;
            } else if (builder != null && builder.styles.containsKey(style)) {
                StyleRange range = (StyleRange)builder.styles.get(style);
                result.fontStyle = range.getFontStyle();
                result.fontColor = range.getFontColor();
                result.backgroundColor = range.getBackgroundColor();
                result.additionalStyle = range.getAdditionalStyle();
                result.lineColor = range.getLineColor();
            } else if (style.length() > 0) {
                // empty if block
            }
            i2 = findIndex + 1;
        }
        result.endOffset = i2 - 1;
        return result;
    }

    private static Color toColor(String str) {
        switch (str.charAt(0)) {
            case '(': {
                int red = StyledLabelBuilder.nextColorInt(str, 1);
                int index = str.indexOf(44);
                int green = StyledLabelBuilder.nextColorInt(str, index + 1);
                index = str.indexOf(44, index + 1);
                int blue = StyledLabelBuilder.nextColorInt(str, index + 1);
                return new Color(red, green, blue);
            }
            case '#': {
                if (str.length() == 4) {
                    return new Color(StyledLabelBuilder.getShorthandValue(str.charAt(1)), StyledLabelBuilder.getShorthandValue(str.charAt(2)), StyledLabelBuilder.getShorthandValue(str.charAt(3)));
                }
                return new Color(Integer.parseInt(str.substring(1), 16));
            }
            case '0': {
                return new Color(Integer.parseInt(str.substring(2), 16));
            }
        }
        return (Color)colorNamesMap.get(str);
    }

    private static int nextColorInt(String str, int index) {
        char c2;
        int colorLength;
        char c3;
        while (index < str.length() && ('0' > (c3 = str.charAt(index)) || c3 > '9')) {
            ++index;
        }
        for (colorLength = index; colorLength < index + 3 && (c2 = str.charAt(colorLength)) >= '0' && '9' >= c2; ++colorLength) {
        }
        return Integer.parseInt(str.substring(index, colorLength));
    }

    private static int getShorthandValue(char c2) {
        if ('A' <= (c2 = Character.toUpperCase(c2)) && c2 <= 'F') {
            return colorShorthandTable[c2 - 65 + 10];
        }
        return colorShorthandTable[c2 - 48];
    }

    public static Map getColorNamesMap() {
        return colorNamesMap;
    }

    private static String createTrimmedString(char[] text2, int start, int end) {
        while ((text2[start] == ' ' || text2[start] == '\t') && start < text2.length) {
            ++start;
        }
        while ((text2[end] == ' ' || text2[end] == '\t') && start < end) {
            --end;
        }
        if (end >= start) {
            StringBuffer buffer = new StringBuffer(end - start);
            boolean escaped = false;
            for (int i2 = start; i2 <= end; ++i2) {
                if (text2[i2] == '\\' && !escaped) {
                    escaped = true;
                    continue;
                }
                buffer.append(text2[i2]);
                if (!escaped) continue;
                escaped = false;
            }
            return buffer.toString();
        }
        return "";
    }

    private static int findNextOf(char[] text2, char[] chars, int start) {
        boolean escaped = false;
        for (int i2 = start; i2 < text2.length; ++i2) {
            if (escaped) {
                escaped = false;
                continue;
            }
            if (text2[i2] == '\\') {
                escaped = true;
                continue;
            }
            for (char c2 : chars) {
                if (text2[i2] != c2) continue;
                return i2;
            }
        }
        return -1;
    }

    private static int findNext(char[] text2, char c2, int start) {
        boolean escaped = false;
        for (int i2 = start; i2 < text2.length; ++i2) {
            if (escaped) {
                escaped = false;
                continue;
            }
            if (text2[i2] == '\\') {
                escaped = true;
                continue;
            }
            if (text2[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    static {
        colorNamesMap.put("white", new Color(0xFFFFFF));
        colorNamesMap.put("lightGray", new Color(0xC0C0C0));
        colorNamesMap.put("gray", new Color(0x808080));
        colorNamesMap.put("darkGray", new Color(0x404040));
        colorNamesMap.put("black", new Color(0));
        colorNamesMap.put("red", new Color(0xFF0000));
        colorNamesMap.put("pink", new Color(0xFFAFAF));
        colorNamesMap.put("orange", new Color(16762880));
        colorNamesMap.put("yellow", new Color(0xFFFF00));
        colorNamesMap.put("green", new Color(65280));
        colorNamesMap.put("magenta", new Color(0xFF00FF));
        colorNamesMap.put("cyan", new Color(65535));
        colorNamesMap.put("blue", new Color(255));
    }

    private static class ParsedStyleResult {
        String text;
        int endOffset;
        int fontStyle = 0;
        Color fontColor = null;
        Color lineColor = null;
        Color backgroundColor = null;
        int additionalStyle = 0;

        private ParsedStyleResult() {
        }
    }
}

