/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.PartialSide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.EtchedBorder;

public class PartialEtchedBorder
extends EtchedBorder
implements PartialSide {
    private static final long serialVersionUID = 2711317518164196639L;
    private int _sides;
    private boolean _roundedCorners = false;

    public PartialEtchedBorder() {
        this(15);
    }

    public PartialEtchedBorder(int sides) {
        this._sides = sides;
    }

    public PartialEtchedBorder(int etchType, int sides) {
        super(etchType);
        this._sides = sides;
    }

    public PartialEtchedBorder(Color highlight, Color shadow, int sides) {
        super(highlight, shadow);
        this._sides = sides;
    }

    public PartialEtchedBorder(int etchType, Color highlight, Color shadow, int sides) {
        super(etchType, highlight, shadow);
        this._sides = sides;
    }

    public int getSides() {
        return this._sides;
    }

    public void setSides(int sides) {
        this._sides = sides;
    }

    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        int w2 = width;
        int h2 = height;
        g2.translate(x2, y2);
        if (c2.getBackground() == null) {
            c2.setBackground(Color.GRAY);
        }
        Color shadowColor = this.getShadowColor(c2);
        Color highlightColor = this.getHighlightColor(c2);
        if (this._sides == 15) {
            g2.setColor(this.etchType == 1 ? shadowColor : highlightColor);
            if (this.isRoundedCorners()) {
                g2.drawRoundRect(0, 0, w2 - 2, h2 - 2, 2, 2);
            } else {
                g2.drawRect(0, 0, w2 - 2, h2 - 2);
            }
            g2.setColor(this.etchType == 1 ? highlightColor : shadowColor);
            g2.drawLine(1, h2 - 3, 1, 1);
            g2.drawLine(1, 1, w2 - 3, 1);
            g2.drawLine(0, h2 - 1, w2 - 1, h2 - 1);
            g2.drawLine(w2 - 1, h2 - 1, w2 - 1, 0);
        } else {
            if ((this._sides & 1) != 0) {
                g2.setColor(this.etchType == 1 ? shadowColor : highlightColor);
                g2.drawLine(0, 0, w2 - 2, 0);
                g2.setColor(this.etchType == 1 ? highlightColor : shadowColor);
                g2.drawLine(1, 1, w2 - 2, 1);
            }
            if ((this._sides & 2) != 0) {
                g2.setColor(this.etchType == 1 ? shadowColor : highlightColor);
                g2.drawLine(0, h2 - 2, w2 - 1, h2 - 2);
                g2.setColor(this.etchType == 1 ? highlightColor : shadowColor);
                g2.drawLine(0, h2 - 1, w2 - 1, h2 - 1);
            }
            if ((this._sides & 8) != 0) {
                g2.setColor(this.etchType == 1 ? shadowColor : highlightColor);
                g2.drawLine(0, h2 - 2, 0, 0);
                g2.setColor(this.etchType == 1 ? highlightColor : shadowColor);
                g2.drawLine(1, h2 - 3, 1, 1);
            }
            if ((this._sides & 4) != 0) {
                g2.setColor(this.etchType == 1 ? shadowColor : highlightColor);
                g2.drawLine(w2 - 2, h2 - 2, w2 - 2, 0);
                g2.setColor(this.etchType == 1 ? highlightColor : shadowColor);
                g2.drawLine(w2 - 1, h2 - 1, w2 - 1, 0);
            }
        }
        g2.translate(-x2, -y2);
    }

    public Insets getBorderInsets(Component c2) {
        Insets borderInsets = super.getBorderInsets(c2);
        if ((this._sides & 1) == 0) {
            borderInsets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            borderInsets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            borderInsets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            borderInsets.right = 0;
        }
        return borderInsets;
    }

    public Insets getBorderInsets(Component c2, Insets insets) {
        Insets borderInsets = super.getBorderInsets(c2, insets);
        if ((this._sides & 1) == 0) {
            borderInsets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            borderInsets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            borderInsets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            borderInsets.right = 0;
        }
        return borderInsets;
    }

    public boolean isRoundedCorners() {
        return this._roundedCorners;
    }

    public void setRoundedCorners(boolean roundedCorners) {
        this._roundedCorners = roundedCorners;
    }
}

