/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public class LegacyTristateCheckBox
extends JCheckBox {
    public static final String PROPERTY_STATE = "state";
    public static final State NOT_SELECTED = new State();
    public static final State SELECTED = new State();
    public static final State DONT_CARE = new State();
    private final TristateDecorator model;

    public LegacyTristateCheckBox(String text2, Icon icon, State initial) {
        super(text2, icon);
        super.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                LegacyTristateCheckBox.this.grabFocus();
                LegacyTristateCheckBox.this.setState(LegacyTristateCheckBox.this.getNextState(LegacyTristateCheckBox.this.getState()));
            }
        });
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){
            private static final long serialVersionUID = 7121802319351334948L;

            public void actionPerformed(ActionEvent e2) {
                LegacyTristateCheckBox.this.grabFocus();
                LegacyTristateCheckBox.this.setState(LegacyTristateCheckBox.this.getNextState(LegacyTristateCheckBox.this.getState()));
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(initial);
    }

    public LegacyTristateCheckBox(String text2, State initial) {
        this(text2, null, initial);
    }

    public LegacyTristateCheckBox(String text2) {
        this(text2, DONT_CARE);
    }

    public LegacyTristateCheckBox() {
        this((String)null);
    }

    public void addMouseListener(MouseListener l2) {
    }

    public void setState(State state) {
        State old = this.model.getState();
        this.model.setState(state);
        if (old != state) {
            this.firePropertyChange(PROPERTY_STATE, old, state);
        }
        if (LookAndFeelFactory.isSyntheticaLnfInstalled() && (UIManager.getLookAndFeel().getClass().getName().startsWith("de.javasoft.plaf.synthetica.Synthetica") || LookAndFeelFactory.isLnfInUse("de.javasoft.plaf.synthetica.SyntheticaLookAndFeel"))) {
            if (state == DONT_CARE) {
                this.setName("HalfSelected");
            } else {
                this.setName("");
            }
        }
    }

    public State getState() {
        return this.model.getState();
    }

    public void setSelected(boolean b2) {
        if (b2) {
            this.setState(SELECTED);
        } else {
            this.setState(NOT_SELECTED);
        }
    }

    protected State getNextState(State current) {
        if (current == NOT_SELECTED) {
            return SELECTED;
        }
        if (current == SELECTED) {
            return DONT_CARE;
        }
        return NOT_SELECTED;
    }

    private class TristateDecorator
    implements ButtonModel {
        private final ButtonModel other;
        private State _state;

        private TristateDecorator(ButtonModel other) {
            this.other = other;
        }

        private void setState(State state) {
            if (state == NOT_SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (state == SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            }
            this._state = state;
        }

        private State getState() {
            return this._state == null ? DONT_CARE : this._state;
        }

        public void setArmed(boolean b2) {
        }

        public void setEnabled(boolean b2) {
            LegacyTristateCheckBox.this.setFocusable(b2);
            this.other.setEnabled(b2);
        }

        public boolean isArmed() {
            return this.other.isArmed();
        }

        public boolean isSelected() {
            return this.other.isSelected();
        }

        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        public boolean isPressed() {
            return this.other.isPressed();
        }

        public boolean isRollover() {
            return this.other.isRollover();
        }

        public void setSelected(boolean b2) {
            this.other.setSelected(b2);
        }

        public void setPressed(boolean b2) {
            this.other.setPressed(b2);
        }

        public void setRollover(boolean b2) {
            this.other.setRollover(b2);
        }

        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        public void setActionCommand(String s2) {
            this.other.setActionCommand(s2);
        }

        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        public void addActionListener(ActionListener l2) {
            this.other.addActionListener(l2);
        }

        public void removeActionListener(ActionListener l2) {
            this.other.removeActionListener(l2);
        }

        public void addItemListener(ItemListener l2) {
            this.other.addItemListener(l2);
        }

        public void removeItemListener(ItemListener l2) {
            this.other.removeItemListener(l2);
        }

        public void addChangeListener(ChangeListener l2) {
            this.other.addChangeListener(l2);
        }

        public void removeChangeListener(ChangeListener l2) {
            this.other.removeChangeListener(l2);
        }

        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }

    public static class State {
        private State() {
        }
    }
}

