/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.WindowsDesktopProperty;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.FastGradientPainter;
import com.jidesoft.swing.JideBorderLayout;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.CellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.tree.TreeCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JideSwingUtilities
implements SwingConstants {
    private static final Logger LOGGER_FOCUS = Logger.getLogger(JideSwingUtilities.class.getName() + ".focus");
    private static final boolean AA_TEXT;
    private static final boolean AA_TEXT_DEFINED;
    public static final Object AA_TEXT_PROPERTY_KEY;
    private static PropertyChangeListener _setOpaqueTrueListener;
    private static PropertyChangeListener _setOpaqueFalseListener;
    private static final String OPAQUE_LISTENER = "setOpaqueRecursively.opaqueListener";
    public static final String SET_OPAQUE_RECURSIVELY_EXCLUDED = "setOpaqueRecursively.excluded";
    static Map renderingHints;
    private static Class<?> _radialGradientPaintClass;
    private static Constructor<?> _radialGradientPaintConstructor1;
    private static Constructor<?> _radialGradientPaintConstructor2;
    private static Class<?> _linearGradientPaintClass;
    private static Constructor<?> _linearGradientPaintConstructor1;
    private static Constructor<?> _linearGradientPaintConstructor2;
    protected static boolean tracingFocus;
    private static ChangeListener _viewportSyncListener;

    public static JPanel createLeftPanel(Component object) {
        NullPanel ret = new NullPanel(new BorderLayout());
        ret.setOpaque(false);
        ret.add(object, "Before");
        return ret;
    }

    public static JPanel createRightPanel(Component object) {
        NullPanel ret = new NullPanel(new BorderLayout());
        ret.setOpaque(false);
        ret.add(object, "After");
        return ret;
    }

    public static JPanel createTopPanel(Component object) {
        NullPanel ret = new NullPanel(new BorderLayout());
        ret.setOpaque(false);
        ret.add(object, "First");
        return ret;
    }

    public static JPanel createBottomPanel(Component object) {
        NullPanel ret = new NullPanel(new BorderLayout());
        ret.setOpaque(false);
        ret.add(object, "Last");
        return ret;
    }

    public static JPanel createCenterPanel(Component object) {
        NullPanel ret = new NullPanel(new GridBagLayout());
        ret.setOpaque(false);
        ret.add(object, new GridBagConstraints());
        return ret;
    }

    public static JPanel createLabeledComponent(JLabel title, Component component, Object constraint) {
        NullPanel ret = new NullPanel(new JideBorderLayout(3, 3));
        ret.setOpaque(false);
        ret.add((Component)title, constraint);
        title.setLabelFor(component);
        ret.add(component);
        return ret;
    }

    public static void centerWindow(Window childToCenter) {
        childToCenter.setLocationRelativeTo(childToCenter.getParent());
    }

    public static void globalCenterWindow(Window childToCenter) {
        childToCenter.setLocationRelativeTo(null);
    }

    public static void paintArrow(Graphics g2, Color color, int startX, int startY, int width, int orientation) {
        Color oldColor = g2.getColor();
        g2.setColor(color);
        width = width / 2 * 2 + 1;
        if (orientation == 0) {
            for (int i2 = 0; i2 < (width + 1) / 2; ++i2) {
                g2.drawLine(startX + i2, startY + i2, startX + width - i2 - 1, startY + i2);
            }
        } else if (orientation == 1) {
            for (int i3 = 0; i3 < (width + 1) / 2; ++i3) {
                g2.drawLine(startX + i3, startY + i3, startX + i3, startY + width - i3 - 1);
            }
        }
        g2.setColor(oldColor);
    }

    public static void paintArrow(JComponent c2, Graphics g2, Color color, int startX, int startY, int width, int orientation) {
        if (!c2.getComponentOrientation().isLeftToRight()) {
            Color oldColor = g2.getColor();
            g2.setColor(color);
            width = width / 2 * 2 + 1;
            for (int i2 = 0; i2 < (width + 1) / 2; ++i2) {
                g2.drawLine(startX + width - i2, startY + i2, startX + width - i2, startY + width - i2 - 1);
            }
            g2.setColor(oldColor);
            return;
        }
        JideSwingUtilities.paintArrow(g2, color, startX, startY, width, orientation);
    }

    public static void paintCross(Graphics g2, Color color, int centerX, int centerY, int size, int width) {
        g2.setColor(color);
        size /= 2;
        for (int i2 = 0; i2 < width; ++i2) {
            g2.drawLine(centerX - size, centerY - size, centerX + size, centerY + size);
            g2.drawLine(centerX + size, centerY - size, centerX - size, centerY + size);
            ++centerX;
        }
    }

    public static Frame getFrame(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        for (Container p2 = component.getParent(); p2 != null; p2 = p2.getParent()) {
            if (!(p2 instanceof Frame)) continue;
            return (Frame)p2;
        }
        return null;
    }

    public static void toggleRTLnLTR(Component topContainer) {
        ComponentOrientation co2 = topContainer.getComponentOrientation();
        co2 = co2 == ComponentOrientation.RIGHT_TO_LEFT ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT;
        topContainer.applyComponentOrientation(co2);
    }

    public static void synchronizeView(JViewport masterViewport, JViewport slaveViewport, int orientation) {
        HashMap property;
        int i2;
        if (masterViewport == null || slaveViewport == null) {
            return;
        }
        ChangeListener[] changeListeners = masterViewport.getChangeListeners();
        for (i2 = 0; i2 < changeListeners.length && changeListeners[i2] != JideSwingUtilities.getViewportSynchronizationChangeListener(); ++i2) {
        }
        if (i2 >= changeListeners.length) {
            masterViewport.addChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
        }
        if (!((property = masterViewport.getClientProperty("synchronizeViewSlaveViewport")) instanceof Map)) {
            property = new HashMap();
        }
        Map slaveViewportMap = property;
        slaveViewportMap.put(slaveViewport, orientation);
        masterViewport.putClientProperty("synchronizeViewSlaveViewport", slaveViewportMap);
        property = slaveViewport.getClientProperty("synchronizeViewMasterViewport");
        if (!(property instanceof Map)) {
            property = new HashMap();
        }
        Map masterViewportMap = property;
        masterViewportMap.put(masterViewport, orientation);
        slaveViewport.putClientProperty("synchronizeViewMasterViewport", masterViewportMap);
    }

    public static void unsynchronizeView(JViewport masterViewport, JViewport slaveViewport) {
        if (masterViewport == null || slaveViewport == null) {
            return;
        }
        Object property = masterViewport.getClientProperty("synchronizeViewSlaveViewport");
        if (property instanceof Map) {
            Map slaveViewportMap = (Map)property;
            slaveViewportMap.remove(slaveViewport);
            if (slaveViewportMap.isEmpty()) {
                slaveViewportMap = null;
                masterViewport.removeChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
            }
            masterViewport.putClientProperty("synchronizeViewSlaveViewport", slaveViewportMap);
        }
        if ((property = slaveViewport.getClientProperty("synchronizeViewMasterViewport")) instanceof Map) {
            Map masterViewportMap = (Map)property;
            masterViewportMap.remove(masterViewport);
            if (masterViewportMap.isEmpty()) {
                masterViewportMap = null;
            }
            slaveViewport.putClientProperty("synchronizeViewMasterViewport", masterViewportMap);
        }
    }

    public static int getButtonState(AbstractButton b2) {
        ButtonModel model = b2.getModel();
        if (!model.isEnabled()) {
            if (model.isSelected()) {
                return 5;
            }
            return 4;
        }
        if (model.isPressed() && model.isArmed()) {
            if (model.isRollover()) {
                return 1;
            }
            if (model.isSelected()) {
                return 3;
            }
        } else {
            if (b2.isRolloverEnabled() && model.isRollover()) {
                if (model.isSelected()) {
                    return 1;
                }
                return 2;
            }
            if (model.isSelected()) {
                return 3;
            }
            if (b2.hasFocus() && b2.isFocusPainted()) {
                if (model.isSelected()) {
                    return 1;
                }
                return 2;
            }
        }
        return 0;
    }

    public static int[] getButtonState(JideSplitButton b2) {
        int[] states = new int[2];
        SplitButtonModel model = (SplitButtonModel)b2.getModel();
        if (!model.isEnabled()) {
            states[0] = model.isButtonSelected() ? 5 : 4;
        } else if (b2.hasFocus() && b2.isFocusPainted()) {
            if (model.isButtonSelected()) {
                states[0] = 3;
                states[1] = 7;
            } else if (model.isSelected()) {
                states[0] = 7;
                states[1] = 3;
            } else {
                states[0] = 2;
                states[1] = 7;
            }
        } else if (model.isPressed() && model.isArmed()) {
            if (model.isButtonRollover()) {
                states[0] = 1;
                states[1] = 7;
            } else if (model.isRollover()) {
                states[0] = 7;
                states[1] = 2;
            }
        } else if (b2.isRolloverEnabled() && model.isButtonRollover()) {
            if (model.isButtonSelected()) {
                states[0] = 1;
                states[1] = 7;
            } else if (model.isSelected()) {
                states[0] = 2;
                states[1] = 1;
            } else {
                states[0] = 2;
                states[1] = 7;
            }
        } else if (b2.isRolloverEnabled() && model.isRollover()) {
            if (model.isButtonSelected()) {
                states[0] = 1;
                states[1] = 2;
            } else if (model.isSelected()) {
                states[0] = 7;
                states[1] = 1;
            } else {
                states[0] = 7;
                states[1] = 2;
            }
        } else if (model.isButtonSelected()) {
            states[0] = 3;
            states[1] = 7;
        } else if (model.isSelected()) {
            states[0] = 7;
            states[1] = 3;
        } else {
            states[0] = 0;
            states[1] = 0;
        }
        return states;
    }

    public static boolean equals(Object o1, Object o2) {
        return JideSwingUtilities.equals(o1, o2, false);
    }

    public static boolean equals(Object o1, Object o2, boolean considerArrayOrList) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null) {
            return false;
        }
        if (o1 instanceof CharSequence && o2 instanceof CharSequence) {
            return JideSwingUtilities.equals((CharSequence)o1, (CharSequence)o2, true);
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable && o1.getClass().isAssignableFrom(o2.getClass())) {
            return ((Comparable)o1).compareTo(o2) == 0;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable && o2.getClass().isAssignableFrom(o1.getClass())) {
            return ((Comparable)o2).compareTo(o1) == 0;
        }
        if (considerArrayOrList && o1 instanceof List && o2 instanceof List) {
            int length2;
            int length1 = ((List)o1).size();
            if (length1 != (length2 = ((List)o2).size())) {
                return false;
            }
            for (int i2 = 0; i2 < length1; ++i2) {
                if (JideSwingUtilities.equals(((List)o1).get(i2), ((List)o2).get(i2), true)) continue;
                return false;
            }
            return true;
        }
        if (considerArrayOrList && o1.getClass().isArray() && o2.getClass().isArray()) {
            int length2;
            int length1 = Array.getLength(o1);
            if (length1 != (length2 = Array.getLength(o2))) {
                return false;
            }
            for (int i3 = 0; i3 < length1; ++i3) {
                if (JideSwingUtilities.equals(Array.get(o1, i3), Array.get(o2, i3), true)) continue;
                return false;
            }
            return true;
        }
        return o1.equals(o2);
    }

    public static boolean equals(CharSequence s1, CharSequence s2, boolean caseSensitive) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        int to = 0;
        int po = 0;
        int len = s1.length();
        while (len-- > 0) {
            char c2;
            char c1;
            if ((c1 = s1.charAt(to++)) == (c2 = s2.charAt(po++)) || !caseSensitive && JideSwingUtilities.charsEqualIgnoreCase(c1, c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean charsEqualIgnoreCase(char a2, char b2) {
        return a2 == b2 || JideSwingUtilities.toUpperCase(a2) == JideSwingUtilities.toUpperCase(b2) || JideSwingUtilities.toLowerCase(a2) == JideSwingUtilities.toLowerCase(b2);
    }

    public static char toUpperCase(char a2) {
        if (a2 < 'a') {
            return a2;
        }
        if (a2 >= 'a' && a2 <= 'z') {
            return (char)(a2 + -32);
        }
        return Character.toUpperCase(a2);
    }

    public static char toLowerCase(char a2) {
        if (a2 < 'A' || a2 >= 'a' && a2 <= 'z') {
            return a2;
        }
        if (a2 >= 'A' && a2 <= 'Z') {
            return (char)(a2 + 32);
        }
        return Character.toLowerCase(a2);
    }

    public static BufferedImage getFasterScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean progressiveBilinear) {
        int h2;
        int w2;
        boolean isTranslucent;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = ret.getWidth();
        int prevH = ret.getHeight();
        boolean bl2 = isTranslucent = img.getTransparency() != 1;
        if (progressiveBilinear) {
            w2 = img.getWidth();
            h2 = img.getHeight();
        } else {
            w2 = targetWidth;
            h2 = targetHeight;
        }
        do {
            if (progressiveBilinear && w2 > targetWidth && (w2 /= 2) < targetWidth) {
                w2 = targetWidth;
            }
            if (progressiveBilinear && h2 > targetHeight && (h2 /= 2) < targetHeight) {
                h2 = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w2, h2, type);
                g2 = scratchImage.createGraphics();
            }
            if (g2 != null) {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
                g2.drawImage(ret, 0, 0, w2, h2, 0, 0, prevW, prevH, null);
            }
            prevW = w2;
            prevH = h2;
            ret = scratchImage;
        } while (w2 != targetWidth || h2 != targetHeight);
        if (g2 != null) {
            g2.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)ret, 0, 0, null);
            g2.dispose();
            ret = scratchImage;
        }
        return ret;
    }

    public static int getFocusAcceleratorKeyMask() {
        return 8;
    }

    public static boolean shouldUseSystemFont() {
        boolean useSystemFontSettings;
        String property = SecurityUtils.getProperty("jide.useSystemfont", "");
        if ("false".equals(property)) {
            return false;
        }
        if ("true".equals(property)) {
            return true;
        }
        if (SystemInfo.isJdk15Above() || SystemInfo.isCJKLocale()) {
            return true;
        }
        String systemFonts = null;
        try {
            systemFonts = (String)AccessController.doPrivileged(new GetPropertyAction("swing.useSystemFontSettings"));
        }
        catch (AccessControlException e2) {
            // empty catch block
        }
        boolean bl2 = useSystemFontSettings = systemFonts != null && Boolean.valueOf(systemFonts) != false;
        if (useSystemFontSettings) {
            Object value = UIDefaultsLookup.get("Application.useSystemFontSettings");
            useSystemFontSettings = value != null || Boolean.TRUE.equals(value);
        }
        return "true".equals(SecurityUtils.getProperty("defaultFont", "false")) || useSystemFontSettings;
    }

    public static void printUIDefaults() {
        Enumeration e2 = UIManager.getDefaults().keys();
        ArrayList<String> list = new ArrayList<String>();
        System.out.println("Non-string keys ---");
        while (e2.hasMoreElements()) {
            Object key = e2.nextElement();
            if (key instanceof String) {
                list.add((String)key);
                continue;
            }
            System.out.println(key + " => " + UIDefaultsLookup.get(key));
        }
        System.out.println();
        Collections.sort(list);
        System.out.println("String keys ---");
        for (String key : list) {
            System.out.println(key + " => " + UIDefaultsLookup.get(key));
        }
    }

    public static void setRecursively(Component c2, Handler handler2) {
        JideSwingUtilities.setRecursively0(c2, handler2);
        handler2.postAction(c2);
    }

    private static void setRecursively0(Component c2, Handler handler2) {
        if (handler2.condition(c2)) {
            handler2.action(c2);
        }
        if (handler2 instanceof ConditionHandler && ((ConditionHandler)handler2).stopCondition(c2)) {
            return;
        }
        Component[] children = null;
        if (c2 instanceof JMenu) {
            children = ((JMenu)c2).getMenuComponents();
        } else if (c2 instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)c2;
            children = new Component[tabbedPane.getTabCount()];
            for (int i2 = 0; i2 < children.length; ++i2) {
                children[i2] = tabbedPane.getComponentAt(i2);
            }
        } else if (c2 instanceof Container) {
            children = ((Container)c2).getComponents();
        }
        if (children != null) {
            for (Component child : children) {
                JideSwingUtilities.setRecursively0(child, handler2);
            }
        }
    }

    public static Component findFirstComponentByName(Container c2, final String name) {
        if (name != null && name.trim().length() != 0) {
            return JideSwingUtilities.getRecursively(c2, new GetHandler(){

                public boolean condition(Component c2) {
                    return name.equals(c2.getName());
                }

                public Component action(Component c2) {
                    return c2;
                }
            });
        }
        return null;
    }

    public static Component findFirstComponentByClass(Container c2, final Class<?> clazz) {
        if (clazz != null) {
            return JideSwingUtilities.getRecursively(c2, new GetHandler(){

                public boolean condition(Component c2) {
                    return c2.getClass().isAssignableFrom(clazz);
                }

                public Component action(Component c2) {
                    return c2;
                }
            });
        }
        return null;
    }

    public static Component getRecursively(Component c2, GetHandler handler2) {
        return JideSwingUtilities.getRecursively0(c2, handler2);
    }

    private static Component getRecursively0(Component c2, GetHandler handler2) {
        if (handler2.condition(c2)) {
            return handler2.action(c2);
        }
        Component[] children = null;
        if (c2 instanceof JMenu) {
            children = ((JMenu)c2).getMenuComponents();
        } else if (c2 instanceof Container) {
            children = ((Container)c2).getComponents();
        }
        if (children != null) {
            for (Component child : children) {
                Component result = JideSwingUtilities.getRecursively0(child, handler2);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static void setEnabledRecursively(Component c2, final boolean enabled) {
        JideSwingUtilities.setRecursively(c2, new Handler(){

            public boolean condition(Component c2) {
                return true;
            }

            public void action(Component c2) {
                c2.setEnabled(enabled);
            }

            public void postAction(Component c2) {
            }
        });
    }

    public static void putClientPropertyRecursively(Component c2, final String clientProperty, final Object value) {
        JideSwingUtilities.setRecursively(c2, new Handler(){

            public boolean condition(Component c2) {
                return c2 instanceof JComponent;
            }

            public void action(Component c2) {
                ((JComponent)c2).putClientProperty(clientProperty, value);
            }

            public void postAction(Component c2) {
            }
        });
    }

    public static void setRequestFocusEnabledRecursively(Component c2, final boolean enabled) {
        JideSwingUtilities.setRecursively(c2, new Handler(){

            public boolean condition(Component c2) {
                return true;
            }

            public void action(Component c2) {
                if (c2 instanceof JComponent) {
                    ((JComponent)c2).setRequestFocusEnabled(enabled);
                }
            }

            public void postAction(Component c2) {
            }
        });
    }

    public static void setOpaqueRecursively(Component c2, final boolean opaque) {
        JideSwingUtilities.setRecursively(c2, new Handler(){

            public boolean condition(Component c2) {
                return !(c2 instanceof JComboBox) && !(c2 instanceof JButton) && !(c2 instanceof JTextComponent) && !(c2 instanceof ListCellRenderer) && !(c2 instanceof TreeCellRenderer) && !(c2 instanceof TableCellRenderer) && !(c2 instanceof CellEditor);
            }

            public void action(Component c2) {
                if (c2 instanceof JComponent) {
                    JComponent jc = (JComponent)c2;
                    if (Boolean.TRUE.equals(jc.getClientProperty(JideSwingUtilities.SET_OPAQUE_RECURSIVELY_EXCLUDED))) {
                        return;
                    }
                    Object clientProperty = jc.getClientProperty(JideSwingUtilities.OPAQUE_LISTENER);
                    if (clientProperty != null) {
                        jc.removePropertyChangeListener("opaque", (PropertyChangeListener)clientProperty);
                        jc.putClientProperty(JideSwingUtilities.OPAQUE_LISTENER, null);
                    }
                    jc.setOpaque(opaque);
                    if (jc.getClientProperty(JideSwingUtilities.OPAQUE_LISTENER) == null) {
                        if (opaque) {
                            if (_setOpaqueTrueListener == null) {
                                _setOpaqueTrueListener = new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent evt) {
                                        if (evt.getSource() instanceof JComponent) {
                                            Component component = (Component)evt.getSource();
                                            component.removePropertyChangeListener("opaque", this);
                                            if (component instanceof JComponent) {
                                                ((JComponent)component).setOpaque(true);
                                            }
                                            component.addPropertyChangeListener("opaque", this);
                                        }
                                    }
                                };
                            }
                            jc.addPropertyChangeListener("opaque", _setOpaqueTrueListener);
                            jc.putClientProperty(JideSwingUtilities.OPAQUE_LISTENER, _setOpaqueTrueListener);
                        } else {
                            if (_setOpaqueFalseListener == null) {
                                _setOpaqueFalseListener = new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent evt) {
                                        if (evt.getSource() instanceof JComponent && evt.getSource() instanceof JComponent) {
                                            Component component = (Component)evt.getSource();
                                            component.removePropertyChangeListener("opaque", this);
                                            if (component instanceof JComponent) {
                                                ((JComponent)component).setOpaque(false);
                                            }
                                            component.addPropertyChangeListener("opaque", this);
                                        }
                                    }
                                };
                            }
                            jc.addPropertyChangeListener("opaque", _setOpaqueFalseListener);
                            jc.putClientProperty(JideSwingUtilities.OPAQUE_LISTENER, _setOpaqueFalseListener);
                        }
                    }
                }
            }

            public void postAction(Component c2) {
            }
        });
    }

    public static Dimension getPreferredButtonSize(AbstractButton b2, int textIconGap, boolean isHorizontal) {
        if (b2.getComponentCount() > 0) {
            return null;
        }
        Icon icon = b2.getIcon();
        String text2 = b2.getText();
        Font font = b2.getFont();
        FontMetrics fm = b2.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        JideSwingUtilities.layoutCompoundLabel(b2, fm, text2, icon, isHorizontal, b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewR, iconR, textR, text2 == null ? 0 : textIconGap);
        Rectangle r2 = iconR.union(textR);
        Insets insets = b2.getInsets();
        r2.width += insets.left + insets.right;
        r2.height += insets.top + insets.bottom;
        return r2.getSize();
    }

    public static String layoutCompoundLabel(JComponent c2, FontMetrics fm, String text2, Icon icon, boolean isHorizontal, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c2 != null && !c2.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return JideSwingUtilities.layoutCompoundLabelImpl(c2, fm, text2, icon, isHorizontal, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String text2, Icon icon, boolean isHorizontal, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        return JideSwingUtilities.layoutCompoundLabelImpl(null, fm, text2, icon, isHorizontal, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    private static String layoutCompoundLabelImpl(JComponent c2, FontMetrics fm, String text2, Icon icon, boolean isHorizontal, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        if (isHorizontal) {
            return JideSwingUtilities.layoutCompoundLabelImplHorizontal(c2, fm, text2, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
        }
        return JideSwingUtilities.layoutCompoundLabelImplVertical(c2, fm, text2, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    private static String getMaxLengthWord(String text2) {
        if (text2.indexOf(32) == -1) {
            return text2;
        }
        int minDiff = text2.length();
        int minPos = -1;
        int mid = text2.length() / 2;
        int pos = -1;
        while ((pos = text2.indexOf(32, pos + 1)) != -1) {
            int diff = Math.abs(pos - mid);
            if (diff >= minDiff) continue;
            minDiff = diff;
            minPos = pos;
        }
        return minPos >= mid ? text2.substring(0, minPos) : text2.substring(minPos + 1);
    }

    private static String layoutCompoundLabelImplHorizontal(JComponent c2, FontMetrics fm, String text2, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int availTextWidth;
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text2 == null || text2.equals("");
        View v2 = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text2 = "";
        } else {
            View view = v2 = c2 != null ? (View)c2.getClientProperty("html") : null;
            if (v2 != null) {
                textR.width = (int)v2.getPreferredSpan(0);
                textR.height = (int)v2.getPreferredSpan(1);
            } else {
                textR.width = SwingUtilities.computeStringWidth(fm, text2);
                textR.height = fm.getHeight();
            }
        }
        int n2 = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        if (!textIsEmpty && textR.width > (availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap))) {
            if (v2 != null) {
                textR.width = availTextWidth;
            } else {
                int nChars;
                String clipString = "...";
                int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
                for (nChars = 0; nChars < text2.length() && (totalWidth += fm.charWidth(text2.charAt(nChars))) <= availTextWidth; ++nChars) {
                }
                text2 = text2.substring(0, nChars) + clipString;
                textR.width = SwingUtilities.computeStringWidth(fm, text2);
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? (iconR.height >> 1) - (textR.height >> 1) : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? (iconR.width >> 1) - (textR.width >> 1) : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + (viewR.height >> 1) - (labelR_y + (labelR_height >> 1)) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + (viewR.width >> 1) - (labelR_x + (labelR_width >> 1)));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        return text2;
    }

    private static String layoutCompoundLabelImplVertical(JComponent c2, FontMetrics fm, String text2, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int dIcony;
        int dy;
        int availTextHeight;
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text2 == null || text2.equals("");
        View v2 = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text2 = "";
        } else {
            View view = v2 = c2 != null ? (View)c2.getClientProperty("html") : null;
            if (v2 != null) {
                textR.height = (int)v2.getPreferredSpan(0);
                textR.width = (int)v2.getPreferredSpan(1);
            } else {
                textR.height = SwingUtilities.computeStringWidth(fm, text2);
                textR.width = fm.getHeight();
            }
        }
        int n2 = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        if (!textIsEmpty && textR.height > (availTextHeight = horizontalTextPosition == 0 ? viewR.height : viewR.height - (iconR.height + gap))) {
            if (v2 != null) {
                textR.height = availTextHeight;
            } else {
                int nChars;
                String clipString = "...";
                int totalHeight = SwingUtilities.computeStringWidth(fm, clipString);
                for (nChars = 0; nChars < text2.length() && (totalHeight += fm.charWidth(text2.charAt(nChars))) <= availTextHeight; ++nChars) {
                }
                text2 = text2.substring(0, nChars) + clipString;
                textR.height = SwingUtilities.computeStringWidth(fm, text2);
            }
        }
        if (verticalTextPosition == 1) {
            textR.x = horizontalTextPosition != 0 ? 0 : -(textR.width + gap);
        } else if (verticalTextPosition == 0) {
            textR.y = (iconR.width >> 1) - (textR.width >> 1);
        } else {
            textR.x = horizontalTextPosition != 0 ? iconR.width - textR.width : iconR.width + gap;
        }
        textR.y = horizontalTextPosition == 2 ? -(textR.height + gap) : (horizontalTextPosition == 0 ? (iconR.height >> 1) - (textR.height >> 1) : iconR.height + gap);
        int labelR_x = Math.min(iconR.y, textR.y);
        int labelR_width = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_x;
        int labelR_y = Math.min(iconR.x, textR.x);
        int labelR_height = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_y;
        if (verticalAlignment == 1) {
            dy = viewR.x - labelR_y;
            dIcony = viewR.x + viewR.width - (labelR_y + labelR_height);
        } else if (verticalAlignment == 0) {
            dIcony = dy = viewR.x + (viewR.width >> 1) - (labelR_y + (labelR_height >> 1));
        } else {
            dy = viewR.x + viewR.width - (labelR_y + labelR_height);
            dIcony = viewR.x - labelR_y;
        }
        int dx = horizontalAlignment == 2 ? viewR.y - labelR_x : (horizontalAlignment == 4 ? viewR.y + viewR.height - (labelR_x + labelR_width) : viewR.y + (viewR.height >> 1) - (labelR_x + (labelR_width >> 1)));
        textR.y += dx;
        textR.x += dy;
        iconR.y += dx;
        iconR.x += dIcony;
        return text2;
    }

    public static int getOrientationOf(Component component) {
        Integer value;
        if (component instanceof Alignable) {
            return ((Alignable)((Object)component)).getOrientation();
        }
        if (component instanceof JComponent && (value = (Integer)((JComponent)component).getClientProperty("orientation")) != null) {
            return value;
        }
        return 0;
    }

    public static void setOrientationOf(Component component, int orientation) {
        int old = JideSwingUtilities.getOrientationOf(component);
        if (orientation != old) {
            if (component instanceof Alignable) {
                ((Alignable)((Object)component)).setOrientation(orientation);
            } else if (component instanceof JComponent) {
                ((JComponent)component).putClientProperty("orientation", orientation);
            }
        }
    }

    public static void setChildrenOrientationOf(Container c2, int orientation) {
        Component[] components;
        for (Component component : components = c2.getComponents()) {
            JideSwingUtilities.setOrientationOf(component, orientation);
        }
    }

    public static Map<Component, Boolean> disableDoubleBuffered(Component c2) {
        final HashMap<Component, Boolean> map = new HashMap<Component, Boolean>();
        if (c2 instanceof JComponent) {
            JideSwingUtilities.setRecursively(c2, new Handler(){

                public boolean condition(Component c2) {
                    return c2 instanceof JComponent && c2.isDoubleBuffered();
                }

                public void action(Component c2) {
                    map.put(c2, Boolean.TRUE);
                    ((JComponent)c2).setDoubleBuffered(false);
                }

                public void postAction(Component c2) {
                }
            });
        }
        return map;
    }

    public static Map<Component, Boolean> enableDoubleBuffered(Component c2) {
        final HashMap<Component, Boolean> map = new HashMap<Component, Boolean>();
        if (c2 instanceof JComponent) {
            JideSwingUtilities.setRecursively(c2, new Handler(){

                public boolean condition(Component c2) {
                    return c2 instanceof JComponent && !c2.isDoubleBuffered();
                }

                public void action(Component c2) {
                    map.put(c2, Boolean.FALSE);
                    ((JComponent)c2).setDoubleBuffered(true);
                }

                public void postAction(Component c2) {
                }
            });
        }
        return map;
    }

    public static void restoreDoubleBuffered(Component c2, final Map<Component, Boolean> map) {
        JideSwingUtilities.setRecursively(c2, new Handler(){

            public boolean condition(Component c2) {
                return c2 instanceof JComponent;
            }

            public void action(Component c2) {
                Boolean value = (Boolean)map.get(c2);
                if (value != null) {
                    ((JComponent)c2).setDoubleBuffered(Boolean.TRUE.equals(value));
                }
            }

            public void postAction(Component c2) {
            }
        });
    }

    public static void paintBackground(Graphics g2, Rectangle rect, Color border, Color bk2) {
        Color old = g2.getColor();
        g2.setColor(bk2);
        g2.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        g2.setColor(border);
        g2.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
        g2.setColor(old);
    }

    public static void paintBackground(Graphics2D g2d, Rectangle rect, Color border, Paint paint) {
        Color old = g2d.getColor();
        g2d.setPaint(paint);
        g2d.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        g2d.setColor(border);
        g2d.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
        g2d.setColor(old);
    }

    private static boolean drawTextAntialiased(Component c2) {
        if (!AA_TEXT_DEFINED) {
            if (c2 != null) {
                if (c2 instanceof JComponent) {
                    Boolean aaProperty = (Boolean)((JComponent)c2).getClientProperty(AA_TEXT_PROPERTY_KEY);
                    return aaProperty != null ? aaProperty : false;
                }
                return false;
            }
            return false;
        }
        return AA_TEXT;
    }

    public static boolean drawTextAntialiased(boolean aaText) {
        if (!AA_TEXT_DEFINED) {
            return aaText;
        }
        return AA_TEXT;
    }

    public static void drawStringUnderlineCharAt(JComponent c2, Graphics g2, String text2, int underlinedIndex, int x2, int y2) {
        JideSwingUtilities.drawString(c2, g2, text2, x2, y2);
        if (underlinedIndex >= 0 && underlinedIndex < text2.length()) {
            FontMetrics fm = g2.getFontMetrics();
            int underlineRectX = x2 + fm.stringWidth(text2.substring(0, underlinedIndex));
            int underlineRectY = y2;
            int underlineRectWidth = fm.charWidth(text2.charAt(underlinedIndex));
            int underlineRectHeight = 1;
            g2.fillRect(underlineRectX, underlineRectY + fm.getDescent() - 1, underlineRectWidth, underlineRectHeight);
        }
    }

    private static Map getRenderingHints(Graphics2D g2d, Map hintsToSave, Map savedHints) {
        if (savedHints == null) {
            savedHints = new RenderingHints(null);
        } else {
            savedHints.clear();
        }
        if (hintsToSave == null || hintsToSave.size() == 0) {
            return savedHints;
        }
        Set objects = hintsToSave.keySet();
        for (Object o2 : objects) {
            RenderingHints.Key key = (RenderingHints.Key)o2;
            Object value = g2d.getRenderingHint(key);
            if (value == null) continue;
            savedHints.put(key, value);
        }
        return savedHints;
    }

    public static void drawString(JComponent c2, Graphics g2, String text2, int x2, int y2) {
        if (SystemInfo.isJdk6Above()) {
            Graphics2D g2d = (Graphics2D)g2;
            Map oldHints = null;
            if (renderingHints != null) {
                oldHints = JideSwingUtilities.getRenderingHints(g2d, renderingHints, null);
                g2d.addRenderingHints(renderingHints);
            }
            g2d.drawString(text2, x2, y2);
            if (oldHints != null) {
                g2d.addRenderingHints(oldHints);
            }
        } else if (JideSwingUtilities.drawTextAntialiased(c2) && g2 instanceof Graphics2D) {
            Graphics2D g22 = (Graphics2D)g2;
            Object oldAAValue = g22.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g22.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g22.drawString(text2, x2, y2);
            g22.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        } else {
            g2.drawString(text2, x2, y2);
        }
    }

    public static Object setupAntialiasing(Component c2, Graphics g2) {
        Object oldHints;
        Graphics2D g2d = (Graphics2D)g2;
        if (SystemInfo.isJdk6Above()) {
            oldHints = JideSwingUtilities.getRenderingHints(g2d, renderingHints, null);
            if (renderingHints != null) {
                g2d.addRenderingHints(renderingHints);
            }
        } else {
            oldHints = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (JideSwingUtilities.drawTextAntialiased(c2)) {
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        return oldHints;
    }

    public static void restoreAntialiasing(Component c2, Graphics g2, Object oldHints) {
        Graphics2D g2d = (Graphics2D)g2;
        if (SystemInfo.isJdk6Above()) {
            if (oldHints instanceof RenderingHints) {
                g2d.addRenderingHints((RenderingHints)oldHints);
            }
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldHints);
        }
    }

    public static Object setupShapeAntialiasing(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2;
        Object oldHints = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return oldHints;
    }

    public static void restoreShapeAntialiasing(Graphics g2, Object oldHints) {
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHints);
    }

    public static void drawGrip(Graphics g2, Rectangle rectangle, int maxLength, int maxThickness) {
        JideSwingUtilities.drawGrip(g2, rectangle, maxLength, maxThickness, true);
    }

    public static void drawGrip(Graphics g2, Rectangle rectangle, int maxLength, int maxThickness, boolean isSelected) {
        if (rectangle.width > rectangle.height) {
            int count = maxLength;
            if (maxLength * 3 > rectangle.width) {
                count = rectangle.width / 3;
            }
            int startX = rectangle.x + (rectangle.width - count * 3 >> 1);
            int startY = rectangle.y + (rectangle.height - maxThickness * 3 >> 1);
            for (int i2 = 0; i2 < maxThickness; ++i2) {
                for (int j2 = 0; j2 < count; ++j2) {
                    if (isSelected) {
                        g2.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                        g2.drawLine(startX + j2 * 3, startY + i2 * 3, startX + j2 * 3, startY + i2 * 3);
                    }
                    g2.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    g2.drawLine(startX + j2 * 3 + 1, startY + i2 * 3 + 1, startX + j2 * 3 + 1, startY + i2 * 3 + 1);
                }
            }
        } else {
            int count = maxLength;
            if (maxLength * 3 > rectangle.height) {
                count = rectangle.height / 3;
            }
            int startX = rectangle.x + (rectangle.width - maxThickness * 3 >> 1);
            int startY = rectangle.y + (rectangle.height - count * 3 >> 1);
            for (int i3 = 0; i3 < maxThickness; ++i3) {
                for (int j3 = 0; j3 < count; ++j3) {
                    if (isSelected) {
                        g2.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                        g2.drawLine(startX + i3 * 3, startY + j3 * 3, startX + i3 * 3, startY + j3 * 3);
                    }
                    g2.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    g2.drawLine(startX + i3 * 3 + 1, startY + j3 * 3 + 1, startX + i3 * 3 + 1, startY + j3 * 3 + 1);
                }
            }
        }
    }

    public static void registerTabKey(Container container) {
        if (container instanceof JComponent) {
            ((JComponent)container).registerKeyboardAction(new AbstractAction(){

                public void actionPerformed(ActionEvent e2) {
                    DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }, KeyStroke.getKeyStroke(9, 0), 0);
        } else {
            for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
                Component c2 = container.getComponent(i2);
                if (!(c2 instanceof JComponent) || !c2.isFocusable()) continue;
                ((JComponent)container).registerKeyboardAction(new AbstractAction(){

                    public void actionPerformed(ActionEvent e2) {
                        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }, KeyStroke.getKeyStroke(9, 0), 0);
            }
        }
    }

    public static void fillGradient(Graphics g2, Rectangle rect, int orientation) {
        Graphics2D g2d = (Graphics2D)g2;
        Color col1 = new Color(255, 255, 255, 0);
        Color col2 = new Color(255, 255, 255, 48);
        Color col3 = new Color(0, 0, 0, 0);
        Color col4 = new Color(0, 0, 0, 32);
        if (orientation == 0) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height >> 1), col2, col1, true);
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y + (rect.height >> 1), rect.width, rect.height >> 1), col3, col4, true);
        } else {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width >> 1, rect.height), col2, col1, false);
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x + (rect.width >> 1), rect.y, rect.width >> 1, rect.height), col3, col4, false);
        }
    }

    public static void fillSingleGradient(Graphics g2, Rectangle rect, int orientation) {
        JideSwingUtilities.fillSingleGradient(g2, rect, orientation, 127);
    }

    public static void fillSingleGradient(Graphics g2, Rectangle rect, int orientation, int level) {
        Graphics2D g2d = (Graphics2D)g2;
        Color col1 = new Color(255, 255, 255, 0);
        Color col2 = new Color(255, 255, 255, level);
        if (orientation == 5) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), col2, col1, true);
        } else if (orientation == 1) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), col1, col2, true);
        } else if (orientation == 3) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), col2, col1, false);
        } else if (orientation == 7) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), col1, col2, false);
        }
    }

    public static Paint getRadialGradientPaint(Point2D point, float radius, float[] fractions, Color[] colors2) {
        Class<?> radialGradientPaintClass = null;
        try {
            radialGradientPaintClass = SystemInfo.isJdk6Above() ? Class.forName("java.awt.RadialGradientPaint") : Class.forName("org.apache.batik.ext.awt.RadialGradientPaint");
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        if (radialGradientPaintClass != null) {
            try {
                if (_radialGradientPaintConstructor2 == null) {
                    _radialGradientPaintConstructor2 = radialGradientPaintClass.getConstructor(Point2D.class, Float.TYPE, float[].class, Color[].class);
                }
                Object radialGradientPaint = _radialGradientPaintConstructor2.newInstance(point, Float.valueOf(radius), fractions, colors2);
                return (Paint)radialGradientPaint;
            }
            catch (NoSuchMethodException e2) {
            }
            catch (InstantiationException e3) {
            }
            catch (IllegalAccessException e4) {
            }
            catch (InvocationTargetException e5) {
                // empty catch block
            }
        }
        System.err.println("Warning - radial gradients are only supported in Java 6 and higher or use batik-aw-util.jar, using a plain color instead");
        return colors2[0];
    }

    public static Paint getRadialGradientPaint(float cx2, float cy2, float radius, float[] fractions, Color[] colors2) {
        if (_radialGradientPaintClass == null) {
            try {
                _radialGradientPaintClass = SystemInfo.isJdk6Above() ? Class.forName("java.awt.RadialGradientPaint") : Class.forName("org.apache.batik.ext.awt.RadialGradientPaint");
            }
            catch (ClassNotFoundException e1) {
                // empty catch block
            }
        }
        if (_radialGradientPaintClass != null) {
            try {
                if (_radialGradientPaintConstructor1 == null) {
                    _radialGradientPaintConstructor1 = _radialGradientPaintClass.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, float[].class, Color[].class);
                }
                Object radialGradientPaint = _radialGradientPaintConstructor1.newInstance(Float.valueOf(cx2), Float.valueOf(cy2), Float.valueOf(radius), fractions, colors2);
                return (Paint)radialGradientPaint;
            }
            catch (NoSuchMethodException e2) {
            }
            catch (InstantiationException e3) {
            }
            catch (IllegalAccessException e4) {
            }
            catch (InvocationTargetException e5) {
                // empty catch block
            }
        }
        System.err.println("Warning - radial gradients are only supported in Java 6 and higher or use batik-aw-util.jar, using a plain color instead");
        return colors2[0];
    }

    public static Paint getLinearGradientPaint(float startX, float startY, float endX, float endY, float[] fractions, Color[] colors2) {
        if (_linearGradientPaintClass == null) {
            try {
                _linearGradientPaintClass = SystemInfo.isJdk6Above() ? Class.forName("java.awt.LinearGradientPaint") : Class.forName("org.apache.batik.ext.awt.LinearGradientPaint");
            }
            catch (ClassNotFoundException e1) {
                // empty catch block
            }
        }
        if (_linearGradientPaintClass != null) {
            try {
                if (_linearGradientPaintConstructor1 == null) {
                    _linearGradientPaintConstructor1 = _linearGradientPaintClass.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, float[].class, Color[].class);
                }
                Object linearGradientPaint = _linearGradientPaintConstructor1.newInstance(Float.valueOf(startX), Float.valueOf(startY), Float.valueOf(endX), Float.valueOf(endY), fractions, colors2);
                return (Paint)linearGradientPaint;
            }
            catch (NoSuchMethodException e2) {
            }
            catch (InstantiationException e3) {
            }
            catch (IllegalAccessException e4) {
            }
            catch (InvocationTargetException e5) {
                // empty catch block
            }
        }
        System.err.println("Warning - linear gradients are only supported in Java 6 and higher or use batik-aw-util.jar, using a plain color instead");
        return colors2[0];
    }

    public static boolean containerContainsFocus(Container cont) {
        boolean focusOwned;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Component permFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean bl2 = focusOwned = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, cont);
        if (!focusOwned) {
            focusOwned = permFocusOwner != null && SwingUtilities.isDescendingFrom(permFocusOwner, cont);
        }
        return focusOwned;
    }

    public static boolean componentIsPermanentFocusOwner(Component comp) {
        return comp != null && KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == comp;
    }

    public static void installColorsAndFont(Component c2, Color background, Color foreground, Font font) {
        JideSwingUtilities.installFont(c2, font);
        JideSwingUtilities.installColors(c2, background, foreground);
    }

    public static void installFont(Component c2, Font font) {
        Font f2 = c2.getFont();
        if (f2 == null || f2 instanceof UIResource) {
            c2.setFont(font);
        }
    }

    public static void installColors(Component c2, Color background, Color foreground) {
        Color bg2 = c2.getBackground();
        if (background != null && (bg2 == null || bg2 instanceof UIResource)) {
            c2.setBackground(background);
        }
        Color fg = c2.getForeground();
        if (foreground != null && (fg == null || fg instanceof UIResource)) {
            c2.setForeground(foreground);
        }
    }

    public static void installBorder(JComponent c2, Border defaultBorder) {
        Border border = c2.getBorder();
        if (border == null || border instanceof UIResource) {
            c2.setBorder(defaultBorder);
        }
    }

    public static void fillNormalGradient(Graphics2D g2d, Shape s2, Color startColor, Color endColor, boolean isVertical) {
        Rectangle rect = s2.getBounds();
        GradientPaint paint = isVertical ? new GradientPaint(rect.x, rect.y, startColor, rect.x, rect.height + rect.y, endColor, true) : new GradientPaint(rect.x, rect.y, startColor, rect.width + rect.x, rect.y, endColor, true);
        Paint old = g2d.getPaint();
        g2d.setPaint(paint);
        g2d.fill(s2);
        g2d.setPaint(old);
    }

    public static void fillGradient(Graphics2D g2d, Shape s2, Color startColor, Color endColor, boolean isVertical) {
        if ("true".equals(SecurityUtils.getProperty("normalGradientPaint", "false"))) {
            JideSwingUtilities.fillNormalGradient(g2d, s2, startColor, endColor, isVertical);
        } else {
            FastGradientPainter.drawGradient(g2d, s2, startColor, endColor, isVertical);
        }
    }

    public static void clearGradientCache() {
        FastGradientPainter.clearGradientCache();
    }

    public static Window getTopModalDialog(Window w2) {
        Window[] ws;
        for (Window w1 : ws = w2.getOwnedWindows()) {
            if (!w1.isVisible() || !(w1 instanceof Dialog) || !((Dialog)w1).isModal()) continue;
            return JideSwingUtilities.getTopModalDialog(w1);
        }
        return w2;
    }

    public static void traceFocus() {
        JideSwingUtilities.traceFocus(false);
    }

    public static void traceFocus(final boolean useBorders) {
        if (tracingFocus) {
            return;
        }
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String newName;
                String oldName;
                if (useBorders) {
                    Component newValue;
                    Border oldBorder;
                    Component oldValue = (Component)evt.getOldValue();
                    if (oldValue instanceof JComponent && (oldBorder = ((JComponent)oldValue).getBorder()) instanceof TraceDebugBorder) {
                        ((JComponent)oldValue).setBorder(((TraceDebugBorder)oldBorder).getInsideBorder());
                    }
                    if ((newValue = (Component)evt.getNewValue()) instanceof JComponent) {
                        Border oldBorder2 = ((JComponent)newValue).getBorder();
                        if (oldBorder2 == null) {
                            oldBorder2 = new EmptyBorder(0, 0, 0, 0);
                        }
                        if (!(oldBorder2 instanceof TraceDebugBorder)) {
                            ((JComponent)newValue).setBorder(new TraceDebugBorder(oldBorder2));
                        }
                    }
                }
                String string2 = oldName = evt.getOldValue() == null ? "null" : evt.getOldValue().getClass().getName();
                if (evt.getOldValue() instanceof Component && ((Component)evt.getOldValue()).getName() != null) {
                    oldName = oldName + "'" + ((Component)evt.getOldValue()).getName() + "'";
                }
                String string3 = newName = evt.getNewValue() == null ? "null" : evt.getNewValue().getClass().getName();
                if (evt.getNewValue() instanceof Component && ((Component)evt.getNewValue()).getName() != null) {
                    newName = newName + "'" + ((Component)evt.getNewValue()).getName() + "'";
                }
                System.out.println(evt.getPropertyName() + ": " + oldName + " ==> " + newName);
            }
        };
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", listener);
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", listener);
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", listener);
        tracingFocus = true;
    }

    public static void runGCAndPrintFreeMemory() {
        DecimalFormat memFormatter = new DecimalFormat("###,###,##0.####");
        String memFree = memFormatter.format(Runtime.getRuntime().freeMemory() / 1024L);
        String memTotal = memFormatter.format(Runtime.getRuntime().totalMemory() / 1024L);
        String memUsed = memFormatter.format((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
        System.out.println("before gc: (Total [" + memTotal + "k] - Free [" + memFree + "k]) = Used [" + memUsed + "k]");
        System.runFinalization();
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        memFree = memFormatter.format(Runtime.getRuntime().freeMemory() / 1024L);
        memTotal = memFormatter.format(Runtime.getRuntime().totalMemory() / 1024L);
        memUsed = memFormatter.format((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
        System.out.println("after gc: (Total [" + memTotal + "k] - Free [" + memFree + "k]) = Used [" + memUsed + "k]");
    }

    public static JPanel createTableModelModifier(final DefaultTableModel tableModel) {
        JPanel tableModelPanel = new JPanel(new BorderLayout(6, 6));
        final JTable table = new JTable(tableModel);
        tableModelPanel.add(new JScrollPane(table));
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton insert = new JButton("Insert");
        insert.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                Vector<Vector> rowData = tableModel.getDataVector();
                int index = table.getSelectedRow();
                if (index != -1) {
                    Vector v2 = rowData.get(index);
                    Vector<Object> clone = new Vector<Object>();
                    for (int i2 = 0; i2 < v2.size(); ++i2) {
                        if (i2 == 0) {
                            clone.add((int)(Math.random() * 10.0));
                            continue;
                        }
                        clone.add("" + v2.get(i2));
                    }
                    tableModel.insertRow(index, clone);
                }
            }
        });
        JButton delete = new JButton("Delete");
        delete.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                int[] rows = table.getSelectedRows();
                for (int i2 = rows.length - 1; i2 >= 0; --i2) {
                    int row = rows[i2];
                    tableModel.removeRow(row);
                }
            }
        });
        JButton clear = new JButton("Clear");
        clear.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                for (int i2 = 0; i2 < tableModel.getRowCount(); ++i2) {
                    tableModel.removeRow(0);
                }
            }
        });
        buttonPanel.add(insert);
        buttonPanel.add(delete);
        buttonPanel.add(clear);
        tableModelPanel.add((Component)buttonPanel, "Last");
        return tableModelPanel;
    }

    public static Component findSomethingFocusable(Container container) {
        Component[] comps;
        if (JideSwingUtilities.passesFocusabilityTest(container)) {
            container.requestFocusInWindow();
            return container;
        }
        for (Component comp1 : comps = container.getComponents()) {
            Component comp;
            if (JideSwingUtilities.passesFocusabilityTest(comp1)) {
                container.requestFocusInWindow();
                return container;
            }
            if (!(comp1 instanceof Container) || (comp = JideSwingUtilities.findSomethingFocusable((Container)comp1)) == null) continue;
            return comp;
        }
        return null;
    }

    public static boolean passesFocusabilityTest(Component comp) {
        return comp != null && comp.isEnabled() && comp.isDisplayable() && comp.isVisible() && comp.isFocusable() && comp.isShowing();
    }

    public static void ignoreException(Exception e2) {
    }

    public static void printException(Exception e2) {
        System.err.println(e2.getLocalizedMessage());
    }

    public static void throwException(Exception e2) {
        if (e2 instanceof RuntimeException) {
            throw (RuntimeException)e2;
        }
        throw new RuntimeException(e2);
    }

    public static void throwInvocationTargetException(InvocationTargetException e2) {
        if (e2.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)e2.getTargetException();
        }
        if (e2.getTargetException() instanceof Error) {
            throw (Error)e2.getTargetException();
        }
        throw new RuntimeException(e2.getTargetException());
    }

    public static int findDisplayedMnemonicIndex(String text2, int mnemonic) {
        if (text2 == null || mnemonic == 0) {
            return -1;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = text2.indexOf(uc);
        int lci = text2.indexOf(lc);
        if (uci == -1) {
            return lci;
        }
        if (lci == -1) {
            return uci;
        }
        return lci < uci ? lci : uci;
    }

    public static Component getDescendantOfClass(Class c2, Container container) {
        Component[] components;
        if (container == null || c2 == null) {
            return null;
        }
        for (Component component : components = container.getComponents()) {
            Component found;
            if (c2.isInstance(component)) {
                return component;
            }
            if (!(component instanceof Container) || (found = JideSwingUtilities.getDescendantOfClass(c2, (Container)component)) == null) continue;
            return found;
        }
        return null;
    }

    public static float getDefaultFontSize() {
        String fontSize = SecurityUtils.getProperty("jide.fontSize", null);
        float defaultFontSize = -1.0f;
        try {
            if (fontSize != null) {
                defaultFontSize = Float.parseFloat(fontSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultFontSize;
    }

    public static Object getMenuFont(Toolkit toolkit, UIDefaults table) {
        Font font;
        Object menuFont = null;
        float defaultFontSize = JideSwingUtilities.getDefaultFontSize();
        menuFont = JideSwingUtilities.shouldUseSystemFont() ? (defaultFontSize == -1.0f ? table.getFont("ToolBar.font") : new WindowsDesktopProperty("win.menu.font", table.getFont("ToolBar.font"), toolkit, defaultFontSize)) : ((font = table.getFont("ToolBar.font")) == null ? SecurityUtils.createFontUIResource("Tahoma", 0, defaultFontSize != -1.0f ? (int)defaultFontSize : 11) : SecurityUtils.createFontUIResource(font.getFontName(), 0, defaultFontSize != -1.0f ? (int)defaultFontSize : font.getSize()));
        if (menuFont == null) {
            return JideSwingUtilities.getControlFont(toolkit, table);
        }
        return menuFont;
    }

    public static Object getControlFont(Toolkit toolkit, UIDefaults table, String defaultUIDefault) {
        Object controlFont;
        float defaultFontSize = JideSwingUtilities.getDefaultFontSize();
        if (JideSwingUtilities.shouldUseSystemFont()) {
            Font font = table.getFont(defaultUIDefault);
            if (font == null) {
                font = new Font("Tahoma", 0, 12);
            }
            controlFont = defaultFontSize == -1.0f ? font : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, defaultFontSize);
        } else {
            Font font = table.getFont(defaultUIDefault);
            controlFont = font == null ? SecurityUtils.createFontUIResource("Tahoma", 0, defaultFontSize != -1.0f ? (int)defaultFontSize : 11) : (defaultFontSize == -1.0f ? font : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, defaultFontSize));
        }
        return controlFont;
    }

    public static Object getControlFont(Toolkit toolkit, UIDefaults table) {
        return JideSwingUtilities.getControlFont(toolkit, table, "Label.font");
    }

    public static Object getBoldFont(Toolkit toolkit, UIDefaults table) {
        Object boldFont;
        if (SystemInfo.isCJKLocale()) {
            return JideSwingUtilities.getControlFont(toolkit, table);
        }
        float defaultFontSize = JideSwingUtilities.getDefaultFontSize();
        if (JideSwingUtilities.shouldUseSystemFont()) {
            Font font = table.getFont("Label.font");
            if (font == null) {
                font = new Font("Tahoma", 0, 12);
            }
            boldFont = defaultFontSize == -1.0f ? new FontUIResource(font.deriveFont(1)) : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, defaultFontSize, 1);
        } else {
            Font font = table.getFont("Label.font");
            boldFont = font == null ? SecurityUtils.createFontUIResource("Tahoma", 1, defaultFontSize != -1.0f ? (int)defaultFontSize : 11) : SecurityUtils.createFontUIResource(font.getFontName(), 1, defaultFontSize != -1.0f ? (int)defaultFontSize : font.getSize());
        }
        return boldFont;
    }

    public static void drawShadow(Graphics g2, Component c2, int x2, int y2, int w2, int h2) {
        if (w2 <= 0 || h2 <= 0) {
            return;
        }
        ShadowFactory factory = new ShadowFactory(6, 0.7f, Color.GRAY);
        BufferedImage temp = new BufferedImage(w2, h2, 2);
        Graphics2D g22 = temp.createGraphics();
        g22.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g22.setColor(Color.BLACK);
        g22.fillRect(0, 0, temp.getWidth(), temp.getHeight());
        g22.dispose();
        BufferedImage shadow = factory.createShadow(temp);
        g2.drawImage(shadow, x2, y2, c2);
    }

    public static void drawImageBorder(Graphics g2, ImageIcon img, Rectangle rect, Insets ins, boolean drawCenter) {
        int left = ins.left;
        int right = ins.right;
        int top = ins.top;
        int bottom = ins.bottom;
        int x2 = rect.x;
        int y2 = rect.y;
        int w2 = rect.width;
        int h2 = rect.height;
        g2.drawImage(img.getImage(), x2, y2, x2 + left, y2 + top, 0, 0, left, top, null);
        g2.drawImage(img.getImage(), x2 + left, y2, x2 + w2 - right, y2 + top, left, 0, img.getIconWidth() - right, top, null);
        g2.drawImage(img.getImage(), x2 + w2 - right, y2, x2 + w2, y2 + top, img.getIconWidth() - right, 0, img.getIconWidth(), top, null);
        g2.drawImage(img.getImage(), x2, y2 + top, x2 + left, y2 + h2 - bottom, 0, top, left, img.getIconHeight() - bottom, null);
        g2.drawImage(img.getImage(), x2 + left, y2 + top, x2 + w2 - right, y2 + h2 - bottom, left, top, img.getIconWidth() - right, img.getIconHeight() - bottom, null);
        g2.drawImage(img.getImage(), x2 + w2 - right, y2 + top, x2 + w2, y2 + h2 - bottom, img.getIconWidth() - right, top, img.getIconWidth(), img.getIconHeight() - bottom, null);
        g2.drawImage(img.getImage(), x2, y2 + h2 - bottom, x2 + left, y2 + h2, 0, img.getIconHeight() - bottom, left, img.getIconHeight(), null);
        g2.drawImage(img.getImage(), x2 + left, y2 + h2 - bottom, x2 + w2 - right, y2 + h2, left, img.getIconHeight() - bottom, img.getIconWidth() - right, img.getIconHeight(), null);
        g2.drawImage(img.getImage(), x2 + w2 - right, y2 + h2 - bottom, x2 + w2, y2 + h2, img.getIconWidth() - right, img.getIconHeight() - bottom, img.getIconWidth(), img.getIconHeight(), null);
        if (drawCenter) {
            g2.drawImage(img.getImage(), x2 + left, y2 + top, x2 + w2 - right, y2 + h2 - bottom, left, top, img.getIconWidth() - right, img.getIconHeight() - bottom, null);
        }
    }

    public static boolean compositeRequestFocus(Component component) {
        LOGGER_FOCUS.fine("compositeRequestFocus " + component);
        if (component instanceof Container) {
            Container rootAncestor;
            LOGGER_FOCUS.fine("compositeRequestFocus is container.");
            Container container = (Container)component;
            if (container.isFocusCycleRoot()) {
                LOGGER_FOCUS.fine("compositeRequestFocus is focuscycleroot.");
                FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
                Component comp = policy.getDefaultComponent(container);
                LOGGER_FOCUS.fine("compositeRequestFocus default component = " + comp);
                if (comp != null && comp.isShowing() && container.getComponentCount() > 0) {
                    LOGGER_FOCUS.fine("compositeRequestFocus default component passesFocusabilityTest =" + JideSwingUtilities.passesFocusabilityTest(comp));
                    LOGGER_FOCUS.fine("compositeRequestFocus requestFocus for " + comp);
                    return comp.requestFocusInWindow();
                }
            }
            if ((rootAncestor = container.getFocusCycleRootAncestor()) != null) {
                LOGGER_FOCUS.fine("compositeRequestFocus using rootAncestor =" + rootAncestor);
                FocusTraversalPolicy policy = rootAncestor.getFocusTraversalPolicy();
                Component comp = null;
                try {
                    comp = policy.getComponentAfter(rootAncestor, container);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                LOGGER_FOCUS.fine("compositeRequestFocus getComponentAfter =" + comp);
                if (comp != null && SwingUtilities.isDescendingFrom(comp, container)) {
                    LOGGER_FOCUS.fine("compositeRequestFocus getComponentAfter passesFocusabilityTest =" + JideSwingUtilities.passesFocusabilityTest(comp));
                    LOGGER_FOCUS.fine("compositeRequestFocus requestFocus for " + comp);
                    return comp.requestFocusInWindow();
                }
            }
        }
        if (!JideSwingUtilities.passesFocusabilityTest(component)) {
            LOGGER_FOCUS.fine("compositeRequestFocus returingfalse because !passesFocusabilityTest" + component);
            return false;
        }
        LOGGER_FOCUS.fine("compositeRequestFocus component=" + component);
        return component.requestFocusInWindow();
    }

    public static boolean isAncestorOfFocusOwner(Component component) {
        boolean hasFocus = false;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == focusOwner || component instanceof Container && ((Container)component).isAncestorOf(focusOwner)) {
            hasFocus = true;
        }
        return hasFocus;
    }

    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return JideSwingUtilities.getWindowForComponent(parentComponent.getParent());
    }

    public static boolean isKeyListenerRegistered(Component component, KeyListener l2) {
        KeyListener[] listeners;
        for (KeyListener listener : listeners = component.getKeyListeners()) {
            if (listener != l2) continue;
            return true;
        }
        return false;
    }

    public static void insertKeyListener(Component component, KeyListener l2, int index) {
        KeyListener[] listeners;
        for (KeyListener listener : listeners = component.getKeyListeners()) {
            component.removeKeyListener(listener);
        }
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            KeyListener listener = listeners[i2];
            if (index == i2) {
                component.addKeyListener(l2);
            }
            component.addKeyListener(listener);
        }
        if (index > listeners.length - 1) {
            component.addKeyListener(l2);
        }
    }

    public static void insertTableModelListener(TableModel model, TableModelListener l2, int index) {
        TableModelListener[] listeners;
        if (!(model instanceof AbstractTableModel)) {
            model.addTableModelListener(l2);
            return;
        }
        for (TableModelListener listener : listeners = ((AbstractTableModel)model).getTableModelListeners()) {
            model.removeTableModelListener(listener);
        }
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            TableModelListener listener = listeners[i2];
            if (index == i2) {
                model.addTableModelListener(l2);
            }
            model.addTableModelListener(listener);
        }
        if (index < 0 || index > listeners.length - 1) {
            model.addTableModelListener(l2);
        }
    }

    public static void insertPropertyChangeListener(Component component, PropertyChangeListener l2, String propertyName, int index) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener listener : listeners = propertyName == null ? component.getPropertyChangeListeners() : component.getPropertyChangeListeners(propertyName)) {
            if (propertyName == null) {
                component.removePropertyChangeListener(listener);
                continue;
            }
            component.removePropertyChangeListener(propertyName, listener);
        }
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            PropertyChangeListener listener = listeners[i2];
            if (index == i2) {
                if (propertyName == null) {
                    component.addPropertyChangeListener(l2);
                } else {
                    component.addPropertyChangeListener(propertyName, l2);
                }
            }
            if (propertyName == null) {
                component.addPropertyChangeListener(listener);
                continue;
            }
            component.addPropertyChangeListener(propertyName, listener);
        }
        if (index > listeners.length - 1) {
            if (propertyName == null) {
                component.addPropertyChangeListener(l2);
            } else {
                component.addPropertyChangeListener(propertyName, l2);
            }
        }
    }

    public static void insertPropertyChangeListener(KeyboardFocusManager manager, PropertyChangeListener l2, String propertyName, int index) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener listener : listeners = propertyName == null ? manager.getPropertyChangeListeners() : manager.getPropertyChangeListeners(propertyName)) {
            if (propertyName == null) {
                manager.removePropertyChangeListener(listener);
                continue;
            }
            manager.removePropertyChangeListener(propertyName, listener);
        }
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            PropertyChangeListener listener = listeners[i2];
            if (index == i2) {
                if (propertyName == null) {
                    manager.addPropertyChangeListener(l2);
                } else {
                    manager.addPropertyChangeListener(propertyName, l2);
                }
            }
            if (propertyName == null) {
                manager.addPropertyChangeListener(listener);
                continue;
            }
            manager.addPropertyChangeListener(propertyName, listener);
        }
        if (index > listeners.length - 1) {
            if (propertyName == null) {
                manager.addPropertyChangeListener(l2);
            } else {
                manager.addPropertyChangeListener(propertyName, l2);
            }
        }
    }

    public static boolean isPropertyChangeListenerRegistered(Component component, PropertyChangeListener l2) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener listener : listeners = component.getPropertyChangeListeners()) {
            if (listener != l2) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyChangeListenerRegistered(Component component, String propertyName, PropertyChangeListener l2) {
        PropertyChangeListener[] listeners;
        if (propertyName == null) {
            return JideSwingUtilities.isPropertyChangeListenerRegistered(component, l2);
        }
        for (PropertyChangeListener listener : listeners = component.getPropertyChangeListeners(propertyName)) {
            if (listener != l2) continue;
            return true;
        }
        return false;
    }

    public static boolean isMouseListenerRegistered(Component component, MouseListener l2) {
        MouseListener[] listeners;
        for (MouseListener listener : listeners = component.getMouseListeners()) {
            if (listener != l2) continue;
            return true;
        }
        return false;
    }

    public static void insertMouseListener(Component component, MouseListener l2, int index) {
        MouseListener[] listeners;
        for (MouseListener listener : listeners = component.getMouseListeners()) {
            component.removeMouseListener(listener);
        }
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            MouseListener listener = listeners[i2];
            if (index == i2) {
                component.addMouseListener(l2);
            }
            component.addMouseListener(listener);
        }
        if (index < 0 || index > listeners.length - 1) {
            component.addMouseListener(l2);
        }
    }

    public static boolean isMouseMotionListenerRegistered(Component component, MouseMotionListener l2) {
        MouseMotionListener[] listeners;
        for (MouseMotionListener listener : listeners = component.getMouseMotionListeners()) {
            if (listener != l2) continue;
            return true;
        }
        return false;
    }

    public static void insertMouseMotionListener(Component component, MouseMotionListener l2, int index) {
        MouseMotionListener[] listeners;
        for (MouseMotionListener listener : listeners = component.getMouseMotionListeners()) {
            component.removeMouseMotionListener(listener);
        }
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            MouseMotionListener listener = listeners[i2];
            if (index == i2) {
                component.addMouseMotionListener(l2);
            }
            component.addMouseMotionListener(listener);
        }
        if (index < 0 || index > listeners.length - 1) {
            component.addMouseMotionListener(l2);
        }
    }

    public static Component getScrollPane(Component innerComponent) {
        Component component = innerComponent;
        if (innerComponent instanceof JScrollPane) {
            return innerComponent;
        }
        if (component.getParent() != null && component.getParent().getParent() != null && component.getParent().getParent() instanceof JScrollPane) {
            component = component.getParent().getParent();
            return component;
        }
        return null;
    }

    public static boolean isListenerRegistered(EventListenerList list, Class t2, EventListener l2) {
        Object[] objects = list.getListenerList();
        return JideSwingUtilities.isListenerRegistered(objects, t2, l2);
    }

    public static boolean isListenerRegistered(Component component, Class t2, EventListener l2) {
        Object[] objects = component.getListeners(t2);
        return JideSwingUtilities.isListenerRegistered(objects, t2, l2);
    }

    private static boolean isListenerRegistered(Object[] objects, Class t2, EventListener l2) {
        for (int i2 = objects.length - 2; i2 >= 0; i2 -= 2) {
            if (objects[i2] != t2 || !objects[i2 + 1].equals(l2)) continue;
            return true;
        }
        return false;
    }

    public static Component getFirstChildOf(final Class<?> clazz, Component c2) {
        return JideSwingUtilities.getRecursively(c2, new GetHandler(){

            public boolean condition(Component c2) {
                return clazz.isAssignableFrom(c2.getClass());
            }

            public Component action(Component c2) {
                return c2;
            }
        });
    }

    public static int getComponentIndex(Container container, Component c2) {
        if (c2.getParent() != container) {
            return -1;
        }
        Component[] children = container.getComponents();
        for (int i2 = 0; i2 < children.length; ++i2) {
            if (children[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    public static Vector convertDefaultComboBoxModelToVector(DefaultComboBoxModel model) {
        Vector v2 = new Vector();
        for (int i2 = 0; i2 < model.getSize(); ++i2) {
            v2.add(model.getElementAt(i2));
        }
        return v2;
    }

    public static void ensureRowVisible(JTable table, int row) {
        Rectangle rScrollTo;
        Rectangle r2 = table.getVisibleRect();
        Rectangle rMid = table.getCellRect(row, 0, true);
        Rectangle rBefore = null;
        Rectangle rAfter = null;
        if (row < table.getModel().getRowCount() - 1) {
            rAfter = table.getCellRect(row + 1, 0, true);
        }
        if (row > 0) {
            rBefore = table.getCellRect(row - 1, 0, true);
        }
        int yLow = (int)rMid.getMinY();
        int yHi = (int)rMid.getMaxY();
        int xLow = r2.x;
        int xHi = r2.x + r2.width;
        if (rBefore != null) {
            yLow = (int)rBefore.getMinY();
        }
        if (rAfter != null) {
            yHi = (int)rAfter.getMaxY();
        }
        if (!r2.contains(rScrollTo = new Rectangle(xLow, yLow, xHi - xLow, yHi - yLow)) && rScrollTo.height != 0) {
            table.scrollRectToVisible(rScrollTo);
        }
    }

    public static void retargetMouseEvent(int id, MouseEvent e2, Component target) {
        if (target == null || target == e2.getSource() && id == e2.getID()) {
            return;
        }
        if (e2.isConsumed()) {
            return;
        }
        Point p2 = SwingUtilities.convertPoint((Component)e2.getSource(), e2.getX(), e2.getY(), target);
        MouseEvent retargeted = new MouseEvent(target, id, e2.getWhen(), e2.getModifiersEx() | e2.getModifiers(), p2.x, p2.y, e2.getClickCount(), e2.isPopupTrigger(), e2.getButton());
        target.dispatchEvent(retargeted);
    }

    public static JRootPane getOutermostRootPane(Component c2) {
        if (c2 instanceof RootPaneContainer && c2.getParent() == null) {
            return ((RootPaneContainer)((Object)c2)).getRootPane();
        }
        while (c2 != null) {
            if (c2 instanceof JRootPane) {
                JRootPane lastRootPane = (JRootPane)c2;
                if (c2.getParent().getParent() == null) {
                    return lastRootPane;
                }
                if (c2.getParent() instanceof JDialog || c2.getParent() instanceof JWindow || c2.getParent() instanceof JFrame || c2.getParent() instanceof JApplet) {
                    return lastRootPane;
                }
                c2 = c2.getParent().getParent();
            }
            c2 = SwingUtilities.getRootPane(c2);
        }
        return null;
    }

    public static boolean isFixedWidthFont(String fontName, Component component) {
        if (fontName.endsWith(" Bold") || fontName.endsWith(" ITC") || fontName.endsWith(" MT") || fontName.endsWith(" LET") || fontName.endsWith(".bold") || fontName.endsWith(".italic")) {
            return false;
        }
        try {
            int s2;
            int s1;
            int w2;
            int w1;
            int l2;
            Font font = new Font(fontName, 0, 12);
            if (!font.canDisplay('W')) {
                return false;
            }
            Font boldFont = font.deriveFont(1);
            FontMetrics fm = component.getFontMetrics(font);
            FontMetrics fmBold = component.getFontMetrics(boldFont);
            int l1 = fm.charWidth('l');
            if (l1 == (l2 = fmBold.charWidth('l')) && (w1 = fm.charWidth('W')) == (w2 = fmBold.charWidth('W')) && l1 == w1 && (s1 = fm.charWidth(' ')) == (s2 = fmBold.charWidth(' '))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void setLocaleRecursively(Component c2, final Locale locale2) {
        JideSwingUtilities.setRecursively(c2, new Handler(){

            public boolean condition(Component c2) {
                return true;
            }

            public void action(Component c2) {
                c2.setLocale(locale2);
            }

            public void postAction(Component c2) {
            }
        });
    }

    public static void setBounds(Container container, Component component, Rectangle bounds) {
        if (container.getComponentOrientation().isLeftToRight()) {
            component.setBounds(bounds);
        } else {
            Rectangle r2 = new Rectangle(bounds);
            int w2 = container.getWidth();
            r2.x = w2 - (bounds.x + bounds.width);
            component.setBounds(r2);
        }
    }

    public static void setBounds(Container container, Component component, int x2, int y2, int width, int height) {
        if (container.getComponentOrientation().isLeftToRight()) {
            component.setBounds(x2, y2, width, height);
        } else {
            int w2 = container.getWidth();
            component.setBounds(w2 - x2 - width, y2, width, height);
        }
    }

    public static void invalidateRecursively(Component c2) {
        if (c2 instanceof JComponent) {
            JideSwingUtilities.setRecursively(c2, new Handler(){

                public boolean condition(Component c2) {
                    return true;
                }

                public void action(Component c2) {
                    if (c2 instanceof JComponent) {
                        ((JComponent)c2).revalidate();
                    }
                    c2.invalidate();
                }

                public void postAction(Component c2) {
                }
            });
        }
        c2.doLayout();
        c2.repaint();
    }

    public static void synchronizeKeyboardActions(JComponent sourceComponent, JComponent targetComponent, KeyStroke[] keyStrokes, int condition) {
        for (KeyStroke keyStroke : keyStrokes) {
            ActionListener actionListener = sourceComponent.getActionForKeyStroke(keyStroke);
            if (actionListener == null) continue;
            targetComponent.registerKeyboardAction(actionListener, keyStroke, condition);
        }
    }

    public static JComponent getFirstJComponent(RootPaneContainer rootPaneContainer) {
        return (JComponent)JideSwingUtilities.getRecursively(rootPaneContainer.getContentPane(), new GetHandler(){

            public boolean condition(Component c2) {
                return c2 instanceof JComponent;
            }

            public Component action(Component c2) {
                return c2;
            }
        });
    }

    public static Dimension adjustPreferredScrollableViewportSize(JList list, Dimension defaultViewportSize) {
        Dimension preferredSize;
        Component c2;
        ListCellRenderer<String> renderer;
        Rectangle cellBonds = list.getCellBounds(0, 0);
        if (cellBonds != null && cellBonds.height < 3 && (renderer = list.getCellRenderer()) != null && (c2 = renderer.getListCellRendererComponent(list, "DUMMY STRING", 0, false, false)) != null && (preferredSize = c2.getPreferredSize()) != null) {
            int height = preferredSize.height;
            if (height < 3) {
                try {
                    height = list.getCellBounds((int)1, (int)1).height;
                }
                catch (Exception e2) {
                    height = 16;
                }
            }
            list.setFixedCellHeight(height);
        }
        if (SystemInfo.isJdk15Above()) {
            return defaultViewportSize;
        }
        ++defaultViewportSize.height;
        return defaultViewportSize;
    }

    public static void removeFromParentWithFocusTransfer(Component component) {
        boolean wasVisible = component.isVisible();
        component.setVisible(false);
        if (component.getParent() != null) {
            component.getParent().remove(component);
        }
        component.setVisible(wasVisible);
    }

    public static int getLineHeight(Component c2, int defaultHeight) {
        Font f2;
        Font font = f2 = c2 == null ? null : c2.getFont();
        if (f2 == null) {
            return defaultHeight;
        }
        FontMetrics fm = c2.getFontMetrics(f2);
        float h2 = fm.getHeight();
        return (int)(h2 += (float)fm.getDescent());
    }

    public static void addSeparatorIfNecessary(JPopupMenu popup) {
        int count = popup.getComponentCount();
        if (count > 0 && !(popup.getComponent(count - 1) instanceof JSeparator)) {
            popup.addSeparator();
        }
    }

    public static void removeExtraSeparators(JPopupMenu popup) {
        Component[] components = popup.getComponents();
        if (components.length <= 1) {
            return;
        }
        for (int i2 = 0; i2 < components.length; ++i2) {
            Component component = components[i2];
            if (!(component instanceof JSeparator)) continue;
            if (i2 == 0 || i2 == components.length - 1) {
                popup.remove(component);
                continue;
            }
            if (!(components[i2 - 1] instanceof JSeparator)) continue;
            popup.remove(component);
        }
    }

    @Deprecated
    public static void setTextComponentTransparent(JComponent component) {
        JideSwingUtilities.setComponentTransparent(component);
    }

    public static void setComponentTransparent(JComponent component) {
        component.setOpaque(false);
        component.putClientProperty("Synthetica.opaque", false);
        component.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
        component.putClientProperty("Nimbus.Overrides", new UIDefaults());
    }

    public static <T> int binarySearch(List<T> a2, T key) {
        int x1 = 0;
        int x2 = a2.size();
        int i2 = x2 / 2;
        while (x1 < x2) {
            if (!(a2.get(i2) instanceof Comparable)) {
                return i2;
            }
            int c2 = ((Comparable)a2.get(i2)).compareTo(key);
            if (c2 == 0) {
                return i2;
            }
            if (c2 < 0) {
                x1 = i2 + 1;
            } else {
                x2 = i2;
            }
            i2 = x1 + (x2 - x1) / 2;
        }
        return -1 * i2;
    }

    public static <T> int binarySearch(T[] a2, T key) {
        int x1 = 0;
        int x2 = a2.length;
        int i2 = x2 / 2;
        while (x1 < x2) {
            if (!(a2[i2] instanceof Comparable)) {
                return i2;
            }
            int c2 = ((Comparable)a2[i2]).compareTo(key);
            if (c2 == 0) {
                return i2;
            }
            if (c2 < 0) {
                x1 = i2 + 1;
            } else {
                x2 = i2;
            }
            i2 = x1 + (x2 - x1) / 2;
        }
        return -1 * i2;
    }

    public static int binarySearch(int[] a2, int key) {
        return JideSwingUtilities.binarySearch(a2, key, 0, a2.length);
    }

    public static int binarySearch(int[] a2, int key, int start, int end) {
        int x1 = start;
        int x2 = end;
        int i2 = x2 / 2;
        while (x1 < x2) {
            if (a2[i2] == key) {
                return i2;
            }
            if (a2[i2] < key) {
                x1 = i2 + 1;
            } else {
                x2 = i2;
            }
            i2 = x1 + (x2 - x1) / 2;
        }
        return -1 * i2;
    }

    public static boolean isMenuShortcutKeyDown(InputEvent event) {
        return (event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    public static boolean isMenuShortcutKeyDown(ActionEvent event) {
        return (event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    public static ChangeListener getViewportSynchronizationChangeListener() {
        if (_viewportSyncListener == null) {
            _viewportSyncListener = new viewportSynchronizationChangeListener();
        }
        return _viewportSyncListener;
    }

    public static void setWindowOpaque(Window window, boolean opaque) {
        try {
            Class<?> c2 = Class.forName("com.sun.awt.AWTUtilities");
            Method m2 = c2.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            m2.invoke(null, window, opaque);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setWindowOpacity(Window window, float opacity) {
        try {
            Class<?> awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
            Method mSetWindowOpacity = awtUtilitiesClass.getMethod("setWindowOpacity", Window.class, Float.TYPE);
            mSetWindowOpacity.invoke(null, window, Float.valueOf(opacity));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setWindowShape(Window window, Shape shape) {
        try {
            Class<?> c2 = Class.forName("com.sun.awt.AWTUtilities");
            Method m2 = c2.getMethod("setWindowShape", Window.class, Shape.class);
            m2.invoke(null, window, shape);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getOKString(Locale locale2) {
        String text2 = UIDefaultsLookup.getString("OptionPane.okButtonText", locale2);
        if (!(text2 != null && text2.length() > 0 || (text2 = UIDefaultsLookup.getString("ColorChooser.okText")) != null && text2.length() > 0)) {
            text2 = ButtonResources.getResourceBundle(locale2).getString("Button.ok");
        }
        return text2;
    }

    public static String getCancelString(Locale locale2) {
        String text2 = UIDefaultsLookup.getString("OptionPane.cancelButtonText", locale2);
        if (!(text2 != null && text2.length() > 0 || (text2 = UIDefaultsLookup.getString("ColorChooser.cancelText")) != null && text2.length() > 0)) {
            text2 = ButtonResources.getResourceBundle(locale2).getString("Button.cancel");
        }
        return text2;
    }

    public static String getYesString(Locale locale2) {
        String text2 = UIDefaultsLookup.getString("OptionPane.yesButtonText", locale2);
        if (text2 == null || text2.length() <= 0) {
            text2 = ButtonResources.getResourceBundle(locale2).getString("Button.yes");
        }
        return text2;
    }

    public static String getNoString(Locale locale2) {
        String text2 = UIDefaultsLookup.getString("OptionPane.noButtonText", locale2);
        if (text2 == null || text2.length() <= 0) {
            text2 = ButtonResources.getResourceBundle(locale2).getString("Button.no");
        }
        return text2;
    }

    public static FontMetrics getFontMetrics(JComponent c2, Graphics g2) {
        return JideSwingUtilities.getFontMetrics(c2, g2, g2.getFont());
    }

    public static FontMetrics getFontMetrics(JComponent c2, Graphics g2, Font font) {
        if (c2 != null) {
            return c2.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static void showPopupMenu(JPopupMenu popup, Component invoker, int x2, int y2) {
        popup.applyComponentOrientation(invoker.getComponentOrientation());
        if (popup.getComponentOrientation().isLeftToRight()) {
            popup.show(invoker, x2, y2);
        } else {
            popup.show(invoker, x2 - popup.getPreferredSize().width, y2);
        }
    }

    static {
        AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextPropertyKey");
        String aa2 = SecurityUtils.getProperty("swing.aatext", "false");
        AA_TEXT_DEFINED = aa2 != null;
        AA_TEXT = "true".equals(aa2);
        renderingHints = null;
        if (SystemInfo.isJdk6Above()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            renderingHints = (Map)tk.getDesktopProperty("awt.font.desktophints");
            tk.addPropertyChangeListener("awt.font.desktophints", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() instanceof RenderingHints) {
                        renderingHints = (RenderingHints)evt.getNewValue();
                    }
                }
            });
        }
        tracingFocus = false;
        Font.getFont("defaultFont");
        Font.getFont("emphasizedFont");
    }

    private static class viewportSynchronizationChangeListener
    implements ChangeListener {
        private viewportSynchronizationChangeListener() {
        }

        public void stateChanged(ChangeEvent e2) {
            if (!(e2.getSource() instanceof JViewport)) {
                return;
            }
            JViewport masterViewport = (JViewport)e2.getSource();
            Object property = masterViewport.getClientProperty("synchronizeViewSlaveViewport");
            if (!(property instanceof Map)) {
                return;
            }
            Dimension size = masterViewport.getSize();
            if (size.width == 0 || size.height == 0) {
                return;
            }
            Map slaveViewportMap = (Map)property;
            HashMap allViewportToSync = new HashMap();
            allViewportToSync.putAll(slaveViewportMap);
            while (true) {
                HashMap viewportToAdd = new HashMap();
                for (JViewport slaveViewport : allViewportToSync.keySet()) {
                    Object slaveProperty = slaveViewport.getClientProperty("synchronizeViewSlaveViewport");
                    if (!(slaveProperty instanceof Map)) continue;
                    int orientation = (Integer)allViewportToSync.get(slaveViewport);
                    Map viewportMap = (Map)slaveProperty;
                    for (JViewport viewport : viewportMap.keySet()) {
                        if (viewport == masterViewport || allViewportToSync.containsKey(viewport) || (Integer)viewportMap.get(viewport) != orientation) continue;
                        viewportToAdd.put(viewport, viewportMap.get(viewport));
                    }
                }
                if (viewportToAdd.isEmpty()) break;
                allViewportToSync.putAll(viewportToAdd);
            }
            for (JViewport slaveViewport : allViewportToSync.keySet()) {
                Point v2;
                Point v1;
                slaveViewport.removeChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
                int orientation = (Integer)allViewportToSync.get(slaveViewport);
                if (orientation == 0) {
                    v1 = masterViewport.getViewPosition();
                    v2 = slaveViewport.getViewPosition();
                    if (v1.x != v2.x) {
                        slaveViewport.setViewPosition(new Point(v1.x, v2.y));
                    }
                } else if (orientation == 1) {
                    v1 = masterViewport.getViewPosition();
                    v2 = slaveViewport.getViewPosition();
                    if (v1.y != v2.y) {
                        slaveViewport.setViewPosition(new Point(v2.x, v1.y));
                    }
                }
                slaveViewport.addChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
            }
        }
    }

    public static class TraceDebugBorder
    extends CompoundBorder {
        private static final long serialVersionUID = -1396250213346461982L;

        public TraceDebugBorder(Border insideBorder) {
            super(BorderFactory.createLineBorder(Color.RED, 1), insideBorder);
        }

        public Insets getBorderInsets(Component c2) {
            return this.getInsideBorder().getBorderInsets(c2);
        }

        public Insets getBorderInsets(Component c2, Insets insets) {
            return this.getInsideBorder().getBorderInsets(c2);
        }
    }

    public static interface GetHandler {
        public boolean condition(Component var1);

        public Component action(Component var1);
    }

    public static interface ConditionHandler
    extends Handler {
        public boolean stopCondition(Component var1);
    }

    public static interface Handler {
        public boolean condition(Component var1);

        public void action(Component var1);

        public void postAction(Component var1);
    }

    private static class GetPropertyAction
    implements PrivilegedAction {
        private String theProp;
        private String defaultVal;

        public GetPropertyAction(String theProp) {
            this.theProp = theProp;
        }

        public GetPropertyAction(String theProp, String defaultVal) {
            this.theProp = theProp;
            this.defaultVal = defaultVal;
        }

        public Object run() {
            String value = System.getProperty(this.theProp);
            return value == null ? this.defaultVal : value;
        }
    }
}

