/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class JideSplitPaneDivider
extends JPanel
implements PropertyChangeListener {
    protected DragController _dragger;
    protected int _dividerSize = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    protected JideSplitPane _jideSplitPane;
    protected MouseHandler _mouseHandler;
    protected int _orientation;
    static final Cursor HORIZONTAL_CURSOR = JideCursors.getPredefinedCursor(20);
    static final Cursor VERTICAL_CURSOR = JideCursors.getPredefinedCursor(21);
    static final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    private Painter _gripperPainter;
    public static final int COLLAPSED_STATE = 0;
    public static final int DEFAULT_STATE = 1;
    public static final int EXPANDED_STATE = 2;
    private int _currentState = 1;
    protected JButton _leftButton = null;
    protected JButton _rightButton = null;
    private int _triangleSize = 5;
    private int _buttonWidth = 5;
    private int _buttonHeight = 10;
    private int _lastPosition;

    public JideSplitPaneDivider(JideSplitPane splitPane) {
        this.setJideSplitPane(splitPane);
        this._orientation = this._jideSplitPane.getOrientation();
        this.setDividerSize(splitPane.getDividerSize());
        this.setDefaultResizeCursor();
        this.setBackground(UIDefaultsLookup.getColor("JideSplitPaneDivider.background"));
        this.setBorder(UIDefaultsLookup.getBorder("JideSplitPaneDivider.border"));
        if (this._jideSplitPane.isOneTouchExpandable()) {
            this.oneTouchExpandableChanged();
        }
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideSplitPaneDivider.gripperPainter");
        this.setOpaque(false);
        this.setLayout(null);
    }

    public void setDefaultResizeCursor() {
        this.setCursor(this._orientation == 1 ? HORIZONTAL_CURSOR : VERTICAL_CURSOR);
    }

    public JideSplitPane getJideSplitPane() {
        return this._jideSplitPane;
    }

    public void setJideSplitPane(JideSplitPane splitPane) {
        this.uninstallListeners();
        this._jideSplitPane = splitPane;
        this.installListeners();
    }

    private void installListeners() {
        if (this._jideSplitPane != null) {
            if (this._mouseHandler == null) {
                this._mouseHandler = this.createMouseHandler();
            }
            this._jideSplitPane.addMouseListener(this._mouseHandler);
            this._jideSplitPane.addMouseMotionListener(this._mouseHandler);
            this.addMouseListener(this._mouseHandler);
            this.addMouseMotionListener(this._mouseHandler);
            this._jideSplitPane.addPropertyChangeListener(this);
        }
    }

    private void uninstallListeners() {
        if (this._jideSplitPane != null) {
            this._jideSplitPane.removePropertyChangeListener(this);
            if (this._mouseHandler != null) {
                this._jideSplitPane.removeMouseListener(this._mouseHandler);
                this._jideSplitPane.removeMouseMotionListener(this._mouseHandler);
                this.removeMouseListener(this._mouseHandler);
                this.removeMouseMotionListener(this._mouseHandler);
                this._mouseHandler = null;
            }
        }
    }

    protected MouseHandler createMouseHandler() {
        return new MouseHandler();
    }

    public void setDividerSize(int newSize) {
        this._dividerSize = newSize;
    }

    public int getDividerSize() {
        return this._dividerSize;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getDividerSize(), this.getDividerSize());
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void propertyChange(PropertyChangeEvent e2) {
        if (e2.getSource() == this._jideSplitPane) {
            if ("orientation".equals(e2.getPropertyName())) {
                this._orientation = this._jideSplitPane.getOrientation();
                this.setCursor(this._orientation == 1 ? HORIZONTAL_CURSOR : VERTICAL_CURSOR);
                this.invalidate();
                this.validate();
            } else if ("oneTouchExpandable".equals(e2.getPropertyName())) {
                this.setDividerSize(this._jideSplitPane.getDividerSize());
                this.oneTouchExpandableChanged();
            } else if ("dividerSize".equals(e2.getPropertyName())) {
                this.setDividerSize(this._jideSplitPane.getDividerSize());
            } else if ("gripper".equals(e2.getPropertyName())) {
                this.repaint();
            }
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIDefaultsLookup.getColor("JideSplitPaneDivider.background"));
        this.setBorder(UIDefaultsLookup.getBorder("JideSplitPaneDivider.border"));
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideSplitPaneDivider.gripperPainter");
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Border border = this.getBorder();
        Dimension size = this.getSize();
        if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, size.width, size.height);
        }
        if (border != null) {
            border.paintBorder(this, g2, 0, 0, size.width, size.height);
        }
        if (this._jideSplitPane.isShowGripper()) {
            Rectangle rect = new Rectangle(size);
            if (this._gripperPainter != null) {
                if (rect.width > rect.height) {
                    this._gripperPainter.paint(this, g2, rect, 1, 0);
                } else {
                    this._gripperPainter.paint(this, g2, rect, 0, 0);
                }
            } else {
                ++rect.x;
                ++rect.y;
                JideSwingUtilities.drawGrip(g2, rect, 9, UIDefaultsLookup.getInt("JideSplitPane.dividerSize") / 3);
            }
        }
    }

    protected void prepareForDragging() {
        this._jideSplitPane.startDragging(this);
    }

    protected void dragDividerTo(int location) {
        this._jideSplitPane.dragDividerTo(this, location);
        this._currentState = 1;
        int indexOfDivider = this._jideSplitPane.indexOfDivider(this);
        this._lastPosition = this._jideSplitPane.getDividerLocation(indexOfDivider);
    }

    protected void finishDraggingTo(int location) {
        this._jideSplitPane.finishDraggingTo(this, location);
    }

    protected int getPreviousDividerLocation(boolean ignoreVisibility, boolean reversed) {
        return this._jideSplitPane.getPreviousDividerLocation(this, ignoreVisibility, reversed);
    }

    protected int getNextDividerLocation(boolean ignoreVisibility, boolean reversed) {
        return this._jideSplitPane.getNextDividerLocation(this, ignoreVisibility, reversed);
    }

    public Component getFirstComponent(boolean ignoreVisibility) {
        int index = this._jideSplitPane.indexOf(this);
        if (index - 1 >= 0) {
            for (int i2 = index - 1; i2 >= 0; --i2) {
                if (!ignoreVisibility && !this._jideSplitPane.getComponent(i2).isVisible()) continue;
                return this._jideSplitPane.getComponent(i2);
            }
            return this._jideSplitPane.getComponent(index - 1);
        }
        throw new IndexOutOfBoundsException("There is no component before divider " + index);
    }

    public Component getSecondComponent(boolean ignoreVisibility) {
        int index = this._jideSplitPane.indexOf(this);
        if (index + 1 < this._jideSplitPane.getComponentCount()) {
            for (int i2 = index + 1; i2 >= 0; ++i2) {
                if (!ignoreVisibility && !this._jideSplitPane.getComponent(i2).isVisible()) continue;
                return this._jideSplitPane.getComponent(i2);
            }
            return this._jideSplitPane.getComponent(index + 1);
        }
        throw new IndexOutOfBoundsException("There is no component before divider " + index);
    }

    protected void oneTouchExpandableChanged() {
        if (this._jideSplitPane.isOneTouchExpandable() && this._leftButton == null) {
            this._leftButton = this.createLeftOneTouchButton();
            if (this._leftButton != null) {
                this._leftButton.addActionListener(new OneTouchActionHandler(true));
                if (this._orientation == 1) {
                    this._leftButton.setBounds(1, 10, this._buttonWidth, this._buttonHeight);
                } else if (this._orientation == 0) {
                    this._leftButton.setBounds(10, 1, this._buttonHeight, this._buttonWidth);
                }
                this.add(this._leftButton);
            }
        }
        if (this._jideSplitPane.isOneTouchExpandable() && this._rightButton == null) {
            this._rightButton = this.createRightOneTouchButton();
            if (this._rightButton != null) {
                this._rightButton.addActionListener(new OneTouchActionHandler(false));
                if (this._orientation == 1) {
                    this._rightButton.setBounds(1, 25, this._buttonWidth, this._buttonHeight);
                } else if (this._orientation == 0) {
                    this._rightButton.setBounds(25, 1, this._buttonHeight, this._buttonWidth);
                }
                this.add(this._rightButton);
            }
        }
        if (!this._jideSplitPane.isOneTouchExpandable() && this._leftButton != null) {
            this.remove(this._leftButton);
            this._leftButton = null;
        }
        if (!this._jideSplitPane.isOneTouchExpandable() && this._rightButton != null) {
            this.remove(this._rightButton);
            this._rightButton = null;
        }
        int paneCount = this._jideSplitPane.getPaneCount();
        if (this._jideSplitPane.isOneTouchExpandable()) {
            for (int i2 = 0; i2 < paneCount; ++i2) {
                Component component = this._jideSplitPane.getPaneAt(i2);
                PortingUtils.setMinimumSize(component, new Dimension(0, 0));
            }
        } else {
            for (int i3 = 0; i3 < paneCount; ++i3) {
                Component component = this._jideSplitPane.getPaneAt(i3);
                PortingUtils.setMinimumSize(component, null);
            }
        }
    }

    protected JButton createLeftOneTouchButton() {
        JButton b2 = new JButton(){

            public void setBorder(Border b2) {
            }

            public void paint(Graphics g2) {
                block3: {
                    block5: {
                        block4: {
                            if (JideSplitPaneDivider.this._jideSplitPane == null) break block3;
                            g2.setColor(JideSplitPaneDivider.this.getBackground());
                            if (this.isOpaque()) {
                                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                            }
                            if (JideSplitPaneDivider.this._jideSplitPane.getLeftOneTouchButtonImageIcon() == null) break block4;
                            JideSplitPaneDivider.this._jideSplitPane.getLeftOneTouchButtonImageIcon().paintIcon(this, g2, 0, 0);
                            break block3;
                        }
                        if (JideSplitPaneDivider.this._orientation != 1) break block5;
                        g2.setColor(JideSplitPaneDivider.this.getDarkShadowColor());
                        int size = JideSplitPaneDivider.this._triangleSize;
                        for (int i2 = 0; i2 < size; ++i2) {
                            g2.drawLine(i2, size - i2, i2, size + i2);
                        }
                        break block3;
                    }
                    if (JideSplitPaneDivider.this._orientation != 0) break block3;
                    g2.setColor(JideSplitPaneDivider.this.getDarkShadowColor());
                    int size = JideSplitPaneDivider.this._triangleSize;
                    for (int i3 = 0; i3 < size; ++i3) {
                        g2.drawLine(size - i3, i3, size + i3, i3);
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        b2.setMinimumSize(new Dimension(this._buttonWidth, this._buttonHeight));
        b2.setCursor(Cursor.getPredefinedCursor(0));
        b2.setFocusPainted(false);
        b2.setBorderPainted(false);
        b2.setRequestFocusEnabled(false);
        return b2;
    }

    public int getCurrentState() {
        return this._currentState;
    }

    protected JButton createRightOneTouchButton() {
        JButton b2 = new JButton(){

            public void setBorder(Border b2) {
            }

            public void paint(Graphics g2) {
                block3: {
                    block5: {
                        block4: {
                            if (JideSplitPaneDivider.this._jideSplitPane == null) break block3;
                            g2.setColor(JideSplitPaneDivider.this.getBackground());
                            if (this.isOpaque()) {
                                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                            }
                            if (JideSplitPaneDivider.this._jideSplitPane.getRightOneTouchButtonImageIcon() == null) break block4;
                            JideSplitPaneDivider.this._jideSplitPane.getRightOneTouchButtonImageIcon().paintIcon(this, g2, 0, 0);
                            break block3;
                        }
                        if (JideSplitPaneDivider.this._orientation != 1) break block5;
                        g2.setColor(JideSplitPaneDivider.this.getDarkShadowColor());
                        int size = JideSplitPaneDivider.this._triangleSize;
                        int j2 = 0;
                        for (int i2 = size - 1; i2 >= 0; --i2) {
                            g2.drawLine(j2, size - i2, j2, size + i2);
                            ++j2;
                        }
                        break block3;
                    }
                    if (JideSplitPaneDivider.this._orientation != 0) break block3;
                    g2.setColor(JideSplitPaneDivider.this.getDarkShadowColor());
                    int size = JideSplitPaneDivider.this._triangleSize;
                    int j3 = 0;
                    for (int i3 = size - 1; i3 >= 0; --i3) {
                        g2.drawLine(size - i3, j3, size + i3, j3);
                        ++j3;
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        b2.setMinimumSize(new Dimension(this._buttonWidth, this._buttonHeight));
        b2.setCursor(Cursor.getPredefinedCursor(0));
        b2.setFocusPainted(false);
        b2.setBorderPainted(false);
        b2.setRequestFocusEnabled(false);
        return b2;
    }

    protected Color getDarkShadowColor() {
        return UIManager.getColor("controlDkShadow");
    }

    public void collapse() {
        if (this._leftButton != null) {
            this._leftButton.doClick();
        } else {
            new OneTouchActionHandler(true).actionPerformed(null);
        }
    }

    public void expand() {
        if (this._rightButton != null) {
            this._rightButton.doClick();
        } else {
            new OneTouchActionHandler(false).actionPerformed(null);
        }
    }

    protected class OneTouchActionHandler
    implements ActionListener {
        private boolean _collapse;

        public OneTouchActionHandler(boolean collapse) {
            this._collapse = collapse;
        }

        public void actionPerformed(ActionEvent e2) {
            if (this._collapse) {
                int previousDividerPosition;
                int indexOfDivider;
                int dividerPosition;
                if (JideSplitPaneDivider.this._currentState == 0 && (dividerPosition = JideSplitPaneDivider.this._jideSplitPane.getDividerLocation(indexOfDivider = JideSplitPaneDivider.this._jideSplitPane.indexOfDivider(JideSplitPaneDivider.this))) != (previousDividerPosition = JideSplitPaneDivider.this.getPreviousDividerLocation(true, false))) {
                    JideSplitPaneDivider.this._currentState = 1;
                }
                if (JideSplitPaneDivider.this._currentState == 2) {
                    JideSplitPaneDivider.this._jideSplitPane.setDividerLocation(JideSplitPaneDivider.this, JideSplitPaneDivider.this._lastPosition);
                    JideSplitPaneDivider.this._currentState = 1;
                } else if (JideSplitPaneDivider.this._currentState == 1) {
                    indexOfDivider = JideSplitPaneDivider.this._jideSplitPane.indexOfDivider(JideSplitPaneDivider.this);
                    JideSplitPaneDivider.this._lastPosition = JideSplitPaneDivider.this._jideSplitPane.getDividerLocation(indexOfDivider);
                    int loc = JideSplitPaneDivider.this.getPreviousDividerLocation(true, false);
                    JideSplitPaneDivider.this._jideSplitPane.setDividerLocation(JideSplitPaneDivider.this, loc);
                    JideSplitPaneDivider.this._currentState = 0;
                }
            } else {
                int nextDividerPosition;
                int indexOfDivider;
                int dividerPosition;
                if (JideSplitPaneDivider.this._currentState == 2 && (dividerPosition = JideSplitPaneDivider.this._jideSplitPane.getDividerLocation(indexOfDivider = JideSplitPaneDivider.this._jideSplitPane.indexOfDivider(JideSplitPaneDivider.this))) != (nextDividerPosition = JideSplitPaneDivider.this.getNextDividerLocation(true, false))) {
                    JideSplitPaneDivider.this._currentState = 1;
                }
                if (JideSplitPaneDivider.this._currentState == 0) {
                    JideSplitPaneDivider.this._jideSplitPane.setDividerLocation(JideSplitPaneDivider.this, JideSplitPaneDivider.this._lastPosition);
                    JideSplitPaneDivider.this._currentState = 1;
                } else if (JideSplitPaneDivider.this._currentState == 1) {
                    indexOfDivider = JideSplitPaneDivider.this._jideSplitPane.indexOfDivider(JideSplitPaneDivider.this);
                    JideSplitPaneDivider.this._lastPosition = JideSplitPaneDivider.this._jideSplitPane.getDividerLocation(indexOfDivider);
                    int loc = JideSplitPaneDivider.this.getNextDividerLocation(true, false);
                    JideSplitPaneDivider.this._jideSplitPane.setDividerLocation(JideSplitPaneDivider.this, loc);
                    JideSplitPaneDivider.this._currentState = 2;
                }
            }
        }
    }

    protected class VerticalDragController
    extends DragController {
        protected VerticalDragController(MouseEvent e2) {
            super(e2);
            Component leftC = JideSplitPaneDivider.this.getFirstComponent(false);
            Component rightC = JideSplitPaneDivider.this.getSecondComponent(false);
            this.initialLocation = JideSplitPaneDivider.this.getLocation().y;
            this.offset = e2.getSource() == JideSplitPaneDivider.this ? e2.getY() : e2.getY() - this.initialLocation;
            if (leftC == null || rightC == null || this.offset < -1 || this.offset >= JideSplitPaneDivider.this._jideSplitPane.getSize().height) {
                this.maxLocation = -1;
            } else {
                Component component;
                int i2;
                int index = JideSplitPaneDivider.this._jideSplitPane.indexOf(JideSplitPaneDivider.this);
                int modelUpHeight = 0;
                int modelDownHeight = 0;
                for (i2 = 0; i2 < index; ++i2) {
                    component = JideSplitPaneDivider.this._jideSplitPane.getComponent(i2);
                    if (component instanceof JideSplitPaneDivider) {
                        modelUpHeight = (int)((double)modelUpHeight + component.getSize().getHeight());
                        continue;
                    }
                    if (!component.isVisible()) continue;
                    if (((JideBoxLayout)JideSplitPaneDivider.this._jideSplitPane.getLayout()).getConstraintMap().get(component) == "fix") {
                        modelUpHeight += component.getHeight();
                        continue;
                    }
                    modelUpHeight = (int)((double)modelUpHeight + component.getMinimumSize().getHeight());
                }
                for (i2 = index + 1; i2 < JideSplitPaneDivider.this._jideSplitPane.getComponentCount(); ++i2) {
                    component = JideSplitPaneDivider.this._jideSplitPane.getComponent(i2);
                    if (component instanceof JideSplitPaneDivider) {
                        modelDownHeight = (int)((double)modelDownHeight + component.getSize().getHeight());
                        continue;
                    }
                    if (!component.isVisible()) continue;
                    if (((JideBoxLayout)JideSplitPaneDivider.this._jideSplitPane.getLayout()).getConstraintMap().get(component) == "fix") {
                        modelDownHeight += component.getHeight();
                        continue;
                    }
                    modelDownHeight = (int)((double)modelDownHeight + component.getMinimumSize().getHeight());
                }
                this.minLocation = modelUpHeight;
                this.maxLocation = JideSplitPaneDivider.this._jideSplitPane.getHeight() - modelDownHeight - (int)JideSplitPaneDivider.this.getSize().getHeight();
                if (this.maxLocation < this.minLocation) {
                    this.maxLocation = 0;
                    this.minLocation = 0;
                }
            }
        }

        protected int getNeededLocation(int x2, int y2) {
            int newY = Math.min(this.maxLocation, Math.max(this.minLocation, y2 - this.offset));
            if (JideSplitPaneDivider.this._jideSplitPane.getDividerStepSize() != 0) {
                int distanceFromCurrent = newY - JideSplitPaneDivider.this.getY();
                newY -= distanceFromCurrent % JideSplitPaneDivider.this._jideSplitPane.getDividerStepSize();
            }
            return newY;
        }

        protected int positionForMouseEvent(MouseEvent e2) {
            int newY = e2.getSource() == JideSplitPaneDivider.this ? e2.getY() + JideSplitPaneDivider.this.getLocation().y : e2.getY();
            newY = Math.min(this.maxLocation, Math.max(this.minLocation, newY - this.offset));
            if (JideSplitPaneDivider.this._jideSplitPane.getDividerStepSize() != 0) {
                int distanceFromCurrent = newY - JideSplitPaneDivider.this.getY();
                newY -= distanceFromCurrent % JideSplitPaneDivider.this._jideSplitPane.getDividerStepSize();
            }
            return newY;
        }
    }

    protected class DragController {
        int initialLocation;
        int maxLocation;
        int minLocation;
        int offset;

        protected DragController(MouseEvent e2) {
            ComponentOrientation o2 = JideSplitPaneDivider.this.getComponentOrientation();
            boolean ltr = o2.isLeftToRight();
            boolean reversed = !ltr && JideSplitPaneDivider.this._jideSplitPane.getOrientation() == 1;
            Component leftC = reversed ? JideSplitPaneDivider.this.getSecondComponent(false) : JideSplitPaneDivider.this.getFirstComponent(false);
            Component rightC = reversed ? JideSplitPaneDivider.this.getFirstComponent(false) : JideSplitPaneDivider.this.getSecondComponent(false);
            this.initialLocation = JideSplitPaneDivider.this.getLocation().x;
            this.offset = e2.getSource() == JideSplitPaneDivider.this ? e2.getX() : e2.getX() - this.initialLocation;
            if (leftC == null || rightC == null || this.offset < -1 || this.offset >= JideSplitPaneDivider.this._jideSplitPane.getSize().width) {
                this.maxLocation = -1;
            } else {
                Component component;
                int i2;
                int index = JideSplitPaneDivider.this._jideSplitPane.indexOf(JideSplitPaneDivider.this);
                int modelLeftWidth = 0;
                int modelRightWidth = 0;
                for (i2 = 0; i2 < index; ++i2) {
                    component = JideSplitPaneDivider.this._jideSplitPane.getComponent(i2);
                    if (component instanceof JideSplitPaneDivider) {
                        modelLeftWidth = (int)((double)modelLeftWidth + component.getSize().getWidth());
                        continue;
                    }
                    if (!component.isVisible()) continue;
                    if (((JideBoxLayout)JideSplitPaneDivider.this._jideSplitPane.getLayout()).getConstraintMap().get(component) == "fix") {
                        modelLeftWidth += component.getWidth();
                        continue;
                    }
                    modelLeftWidth = (int)((double)modelLeftWidth + component.getMinimumSize().getWidth());
                }
                for (i2 = index + 1; i2 < JideSplitPaneDivider.this._jideSplitPane.getComponentCount(); ++i2) {
                    component = JideSplitPaneDivider.this._jideSplitPane.getComponent(i2);
                    if (component instanceof JideSplitPaneDivider) {
                        modelRightWidth = (int)((double)modelRightWidth + component.getSize().getWidth());
                        continue;
                    }
                    if (!component.isVisible()) continue;
                    if (((JideBoxLayout)JideSplitPaneDivider.this._jideSplitPane.getLayout()).getConstraintMap().get(component) == "fix") {
                        modelRightWidth += component.getWidth();
                        continue;
                    }
                    modelRightWidth = (int)((double)modelRightWidth + component.getMinimumSize().getWidth());
                }
                this.minLocation = reversed ? modelRightWidth : modelLeftWidth;
                this.maxLocation = JideSplitPaneDivider.this._jideSplitPane.getWidth() - ((reversed ? modelLeftWidth : modelRightWidth) + (int)JideSplitPaneDivider.this.getSize().getWidth());
                if (this.maxLocation < this.minLocation) {
                    this.maxLocation = 0;
                    this.minLocation = 0;
                }
            }
        }

        protected boolean isValid() {
            return this.maxLocation > 0;
        }

        protected int positionForMouseEvent(MouseEvent e2) {
            int newX = e2.getSource() == JideSplitPaneDivider.this ? e2.getX() + JideSplitPaneDivider.this.getLocation().x : e2.getX();
            newX = Math.min(this.maxLocation, Math.max(this.minLocation, newX - this.offset));
            if (JideSplitPaneDivider.this._jideSplitPane.getDividerStepSize() != 0) {
                int distanceFromCurrent = newX - JideSplitPaneDivider.this.getX();
                newX -= distanceFromCurrent % JideSplitPaneDivider.this._jideSplitPane.getDividerStepSize();
            }
            return newX;
        }

        protected int getNeededLocation(int x2, int y2) {
            int newX = Math.min(this.maxLocation, Math.max(this.minLocation, x2 - this.offset));
            if (JideSplitPaneDivider.this._jideSplitPane.getDividerStepSize() != 0) {
                int distanceFromCurrent = newX - JideSplitPaneDivider.this.getX();
                newX -= distanceFromCurrent % JideSplitPaneDivider.this._jideSplitPane.getDividerStepSize();
            }
            return newX;
        }

        protected void continueDrag(int newX, int newY) {
            JideSplitPaneDivider.this.dragDividerTo(this.getNeededLocation(newX, newY));
        }

        protected void continueDrag(MouseEvent e2) {
            JideSplitPaneDivider.this.dragDividerTo(this.positionForMouseEvent(e2));
        }

        protected void completeDrag(int x2, int y2) {
            JideSplitPaneDivider.this.finishDraggingTo(this.getNeededLocation(x2, y2));
        }

        protected void completeDrag(MouseEvent e2) {
            JideSplitPaneDivider.this.finishDraggingTo(this.positionForMouseEvent(e2));
        }
    }

    protected class MouseHandler
    extends MouseInputAdapter {
        protected MouseHandler() {
        }

        public void mousePressed(MouseEvent e2) {
            if (e2.getSource() == JideSplitPaneDivider.this && JideSplitPaneDivider.this._dragger == null && JideSplitPaneDivider.this._jideSplitPane.isEnabled() && JideSplitPaneDivider.this._jideSplitPane.isDragResizable()) {
                if (JideSplitPaneDivider.this.getFirstComponent(true) != null && JideSplitPaneDivider.this.getSecondComponent(true) != null) {
                    JideSplitPaneDivider.this._dragger = JideSplitPaneDivider.this._orientation == 1 ? new DragController(e2) : new VerticalDragController(e2);
                    if (!JideSplitPaneDivider.this._dragger.isValid()) {
                        JideSplitPaneDivider.this._dragger = null;
                    } else {
                        JideSplitPaneDivider.this.prepareForDragging();
                        JideSplitPaneDivider.this._dragger.continueDrag(e2);
                    }
                }
                e2.consume();
            }
        }

        public void mouseReleased(MouseEvent e2) {
            if (JideSplitPaneDivider.this._dragger != null) {
                if (e2.getSource() == JideSplitPaneDivider.this._jideSplitPane) {
                    JideSplitPaneDivider.this._dragger.completeDrag(e2.getX(), e2.getY());
                } else if (e2.getSource() == JideSplitPaneDivider.this) {
                    Point ourLoc = JideSplitPaneDivider.this.getLocation();
                    JideSplitPaneDivider.this._dragger.completeDrag(e2.getX() + ourLoc.x, e2.getY() + ourLoc.y);
                }
                JideSplitPaneDivider.this._dragger = null;
                e2.consume();
            }
        }

        public void mouseDragged(MouseEvent e2) {
            if (JideSplitPaneDivider.this._dragger != null) {
                if (e2.getSource() == JideSplitPaneDivider.this._jideSplitPane) {
                    JideSplitPaneDivider.this._dragger.continueDrag(e2.getX(), e2.getY());
                } else if (e2.getSource() == JideSplitPaneDivider.this) {
                    Point ourLoc = JideSplitPaneDivider.this.getLocation();
                    JideSplitPaneDivider.this._dragger.continueDrag(e2.getX() + ourLoc.x, e2.getY() + ourLoc.y);
                }
                e2.consume();
            }
        }
    }
}

