/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideScrollPaneConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.border.Border;

public class JideScrollPaneLayout
extends ScrollPaneLayout
implements JideScrollPaneConstants {
    protected JViewport _rowFoot;
    protected JViewport _subColHead;
    protected JViewport _colFoot;
    protected Component _hLeft;
    protected Component _hRight;
    protected Component _vTop;
    protected Component _vBottom;
    protected Component _subUpperLeft;
    protected Component _subUpperRight;
    private static final long serialVersionUID = 7897026041296359186L;

    public void syncWithScrollPane(JScrollPane sp) {
        super.syncWithScrollPane(sp);
        if (sp instanceof JideScrollPane) {
            this._rowFoot = ((JideScrollPane)sp).getRowFooter();
            this._colFoot = ((JideScrollPane)sp).getColumnFooter();
            this._subColHead = ((JideScrollPane)sp).getSubColumnHeader();
            this._hLeft = ((JideScrollPane)sp).getScrollBarCorner("HORIZONTAL_LEFT");
            this._hRight = ((JideScrollPane)sp).getScrollBarCorner("HORIZONTAL_RIGHT");
            this._vTop = ((JideScrollPane)sp).getScrollBarCorner("VERTICAL_TOP");
            this._vBottom = ((JideScrollPane)sp).getScrollBarCorner("VERTICAL_BOTTOM");
            this._subUpperLeft = sp.getCorner("SUB_UPPER_LEFT");
            this._subUpperRight = sp.getCorner("SUB_UPPER_RIGHT");
        }
    }

    protected boolean isHsbCoversWholeWidth(JScrollPane sp) {
        return sp instanceof JideScrollPane && ((JideScrollPane)sp).isHorizontalScrollBarCoversWholeWidth();
    }

    protected boolean isVsbCoversWholeHeight(JScrollPane sp) {
        return sp instanceof JideScrollPane && ((JideScrollPane)sp).isVerticalScrollBarCoversWholeHeight();
    }

    protected boolean isColumnHeadersHeightUnified(JScrollPane sp) {
        return sp instanceof JideScrollPane && ((JideScrollPane)sp).isColumnHeadersHeightUnified();
    }

    protected boolean isColumnFootersHeightUnified(JScrollPane sp) {
        return sp instanceof JideScrollPane && ((JideScrollPane)sp).isColumnFootersHeightUnified();
    }

    public void addLayoutComponent(String s2, Component c2) {
        if (s2.equals("ROW_FOOTER")) {
            this._rowFoot = (JViewport)this.addSingletonComponent(this._rowFoot, c2);
        } else if (s2.equals("SUB_COLUMN_HEADER")) {
            this._subColHead = (JViewport)this.addSingletonComponent(this._subColHead, c2);
        } else if (s2.equals("COLUMN_FOOTER")) {
            this._colFoot = (JViewport)this.addSingletonComponent(this._colFoot, c2);
        } else if (s2.equals("HORIZONTAL_LEFT")) {
            this._hLeft = this.addSingletonComponent(this._hLeft, c2);
        } else if (s2.equals("HORIZONTAL_RIGHT")) {
            this._hRight = this.addSingletonComponent(this._hRight, c2);
        } else if (s2.equals("VERTICAL_TOP")) {
            this._vTop = this.addSingletonComponent(this._vTop, c2);
        } else if (s2.equals("VERTICAL_BOTTOM")) {
            this._vBottom = this.addSingletonComponent(this._vBottom, c2);
        } else if (s2.equals("SUB_UPPER_LEFT")) {
            this._subUpperLeft = this.addSingletonComponent(this._subUpperLeft, c2);
        } else if (s2.equals("SUB_UPPER_RIGHT")) {
            this._subUpperRight = this.addSingletonComponent(this._subUpperRight, c2);
        } else {
            super.addLayoutComponent(s2, c2);
        }
    }

    public void removeLayoutComponent(Component c2) {
        if (c2 == this._rowFoot) {
            this._rowFoot = null;
        } else if (c2 == this._subColHead) {
            this._subColHead = null;
        } else if (c2 == this._colFoot) {
            this._colFoot = null;
        } else if (c2 == this._hLeft) {
            this._hLeft = null;
        } else if (c2 == this._hRight) {
            this._hRight = null;
        } else if (c2 == this._vTop) {
            this._vTop = null;
        } else if (c2 == this._vBottom) {
            this._vBottom = null;
        } else if (c2 == this._subUpperLeft) {
            this._subUpperLeft = null;
        } else if (c2 == this._subUpperRight) {
            this._subUpperRight = null;
        } else {
            super.removeLayoutComponent(c2);
        }
    }

    public JViewport getRowFooter() {
        return this._rowFoot;
    }

    public JViewport getRowSubColumnHeader() {
        return this._subColHead;
    }

    public JViewport getColumnFooter() {
        return this._colFoot;
    }

    public Component getScrollBarCorner(String key) {
        if (key.equals("HORIZONTAL_LEFT")) {
            return this._hLeft;
        }
        if (key.equals("HORIZONTAL_RIGHT")) {
            return this._hRight;
        }
        if (key.equals("VERTICAL_BOTTOM")) {
            return this._vBottom;
        }
        if (key.equals("VERTICAL_TOP")) {
            return this._vTop;
        }
        if (key.equals("SUB_UPPER_LEFT")) {
            return this._subUpperLeft;
        }
        if (key.equals("SUB_UPPER_RIGHT")) {
            return this._subUpperRight;
        }
        return super.getCorner(key);
    }

    public Dimension preferredLayoutSize(Container parent) {
        boolean canScroll;
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)parent;
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        boolean flatLayout = scrollPane instanceof JideScrollPane && ((JideScrollPane)scrollPane).isFlatLayout();
        Insets insets = parent.getInsets();
        int prefWidth = insets.left + insets.right;
        int prefHeight = insets.top + insets.bottom;
        Dimension extentSize = null;
        Dimension viewSize = null;
        Component view = null;
        if (this.viewport != null) {
            extentSize = this.viewport.getPreferredSize();
            viewSize = this.viewport.getViewSize();
            view = this.viewport.getView();
            if (flatLayout && this.viewport.getView() != null) {
                extentSize = this.viewport.getView().getPreferredSize();
            }
        }
        if (extentSize != null) {
            prefWidth += extentSize.width;
            prefHeight += extentSize.height;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            Insets vpbInsets = viewportBorder.getBorderInsets(parent);
            prefWidth += vpbInsets.left + vpbInsets.right;
            prefHeight += vpbInsets.top + vpbInsets.bottom;
        }
        int rowHeaderWidth = 0;
        if (this.rowHead != null && this.rowHead.isVisible()) {
            rowHeaderWidth = this.rowHead.getPreferredSize().width;
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            rowHeaderWidth = Math.max(rowHeaderWidth, this.upperLeft.getPreferredSize().width);
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            rowHeaderWidth = Math.max(rowHeaderWidth, this.lowerLeft.getPreferredSize().width);
        }
        if (this._subUpperLeft != null && this._subUpperLeft.isVisible()) {
            rowHeaderWidth = Math.max(rowHeaderWidth, this._subUpperLeft.getPreferredSize().width);
        }
        prefWidth += rowHeaderWidth;
        int upperHeight = this.getUpperHeight();
        prefHeight += upperHeight + this.getSubUpperHeight();
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            prefWidth += this._rowFoot.getPreferredSize().width;
        }
        int lowerHeight = this.getLowerHeight();
        prefHeight += lowerHeight;
        if (this.vsb != null && this.vsbPolicy != 21 && !flatLayout) {
            if (this.vsbPolicy == 22) {
                prefWidth += this.vsb.getPreferredSize().width;
            } else if (viewSize != null && extentSize != null) {
                canScroll = true;
                if (view instanceof Scrollable) {
                    boolean bl2 = canScroll = !((Scrollable)((Object)view)).getScrollableTracksViewportHeight();
                }
                if (canScroll && viewSize.height > extentSize.height) {
                    prefWidth += this.vsb.getPreferredSize().width;
                }
            }
        }
        if (this.hsb != null && this.hsbPolicy != 31 && !flatLayout) {
            if (this.hsbPolicy == 32) {
                prefHeight += this.hsb.getPreferredSize().height;
            } else if (viewSize != null && extentSize != null) {
                canScroll = true;
                if (view instanceof Scrollable) {
                    boolean bl3 = canScroll = !((Scrollable)((Object)view)).getScrollableTracksViewportWidth();
                }
                if (canScroll && viewSize.width > extentSize.width) {
                    prefHeight += this.hsb.getPreferredSize().height;
                }
            }
        }
        return new Dimension(prefWidth, prefHeight);
    }

    private int getSubUpperHeight() {
        int subUpperHeight = 0;
        if (this._subUpperLeft != null && this._subUpperLeft.isVisible()) {
            subUpperHeight = this._subUpperLeft.getPreferredSize().height;
        }
        if (this._subUpperRight != null && this._subUpperRight.isVisible()) {
            subUpperHeight = Math.max(this._subUpperRight.getPreferredSize().height, subUpperHeight);
        }
        if (this._subColHead != null && this._subColHead.isVisible()) {
            subUpperHeight = Math.max(this._subColHead.getPreferredSize().height, subUpperHeight);
        }
        return subUpperHeight;
    }

    private int getUpperHeight() {
        int upperHeight = 0;
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            upperHeight = this.upperLeft.getPreferredSize().height;
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            upperHeight = Math.max(this.upperRight.getPreferredSize().height, upperHeight);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            upperHeight = Math.max(this.colHead.getPreferredSize().height, upperHeight);
        }
        return upperHeight;
    }

    private int getLowerHeight() {
        int lowerHeight = 0;
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            lowerHeight = this.lowerLeft.getPreferredSize().height;
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            lowerHeight = Math.max(this.lowerRight.getPreferredSize().height, lowerHeight);
        }
        if (this._colFoot != null && this._colFoot.isVisible()) {
            lowerHeight = Math.max(this._colFoot.getPreferredSize().height, lowerHeight);
        }
        return lowerHeight;
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension size;
        Border viewportBorder;
        boolean flatLayout;
        JScrollPane scrollPane = (JScrollPane)parent;
        boolean bl2 = flatLayout = scrollPane instanceof JideScrollPane && ((JideScrollPane)scrollPane).isFlatLayout();
        if (flatLayout) {
            return this.preferredLayoutSize(parent);
        }
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        Insets insets = parent.getInsets();
        int minWidth = insets.left + insets.right;
        int minHeight = insets.top + insets.bottom;
        if (this.viewport != null) {
            Dimension size2 = this.viewport.getMinimumSize();
            if (flatLayout && this.viewport.getView() != null) {
                size2 = this.viewport.getView().getMinimumSize();
            }
            minWidth += size2.width;
            minHeight += size2.height;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            Insets vpbInsets = viewportBorder.getBorderInsets(parent);
            minWidth += vpbInsets.left + vpbInsets.right;
            minHeight += vpbInsets.top + vpbInsets.bottom;
        }
        int rowHeaderWidth = 0;
        if (this.rowHead != null && this.rowHead.isVisible()) {
            Dimension size3 = this.rowHead.getMinimumSize();
            rowHeaderWidth = size3.width;
            minHeight = Math.max(minHeight, size3.height);
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            rowHeaderWidth = Math.max(rowHeaderWidth, this.upperLeft.getMinimumSize().width);
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            rowHeaderWidth = Math.max(rowHeaderWidth, this.lowerLeft.getMinimumSize().width);
        }
        if (this._subUpperLeft != null && this._subUpperLeft.isVisible()) {
            rowHeaderWidth = Math.max(rowHeaderWidth, this._subUpperLeft.getMinimumSize().width);
        }
        minWidth += rowHeaderWidth;
        int upperHeight = 0;
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            upperHeight = this.upperLeft.getMinimumSize().height;
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            upperHeight = Math.max(this.upperRight.getMinimumSize().height, upperHeight);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            Dimension size4 = this.colHead.getMinimumSize();
            minWidth = Math.max(minWidth, size4.width);
            upperHeight = Math.max(size4.height, upperHeight);
        }
        minHeight += upperHeight;
        int subUpperHeight = 0;
        if (this._subUpperLeft != null && this._subUpperLeft.isVisible()) {
            subUpperHeight = this._subUpperLeft.getMinimumSize().height;
        }
        if (this._subUpperRight != null && this._subUpperRight.isVisible()) {
            subUpperHeight = Math.max(this._subUpperRight.getMinimumSize().height, subUpperHeight);
        }
        if (this._subColHead != null && this._subColHead.isVisible()) {
            Dimension size5 = this._subColHead.getMinimumSize();
            minWidth = Math.max(minWidth, size5.width);
            subUpperHeight = Math.max(size5.height, subUpperHeight);
        }
        minHeight += subUpperHeight;
        int lowerHeight = 0;
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            lowerHeight = this.lowerLeft.getMinimumSize().height;
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            lowerHeight = Math.max(this.lowerRight.getMinimumSize().height, lowerHeight);
        }
        if (this._colFoot != null && this._colFoot.isVisible()) {
            size = this._colFoot.getMinimumSize();
            minWidth = Math.max(minWidth, size.width);
            lowerHeight = Math.max(size.height, lowerHeight);
        }
        minHeight += lowerHeight;
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            size = this._rowFoot.getMinimumSize();
            minWidth = Math.max(minWidth, size.width);
            minHeight += size.height;
        }
        if (this.vsb != null && this.vsbPolicy != 21 && !flatLayout) {
            size = this.vsb.getMinimumSize();
            minWidth += size.width;
            minHeight = Math.max(minHeight, size.height);
        }
        if (this.hsb != null && this.hsbPolicy != 31 && !flatLayout) {
            size = this.hsb.getMinimumSize();
            minWidth = Math.max(minWidth, size.width);
            minHeight += size.height;
        }
        return new Dimension(minWidth, minHeight);
    }

    public void layoutContainer(Container parent) {
        Dimension dim;
        int height;
        int columnFooterHeight;
        int columnHeaderHeight;
        boolean hsbNeeded;
        boolean vsbNeeded;
        Scrollable sv;
        boolean isEmpty;
        Insets vpbInsets;
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)parent;
        boolean flatLayout = scrollPane instanceof JideScrollPane && ((JideScrollPane)scrollPane).isFlatLayout();
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        Rectangle availR = scrollPane.getBounds();
        availR.y = 0;
        availR.x = 0;
        Insets insets = parent.getInsets();
        availR.x = insets.left;
        availR.y = insets.top;
        availR.width -= insets.left + insets.right;
        availR.height -= insets.top + insets.bottom;
        Rectangle colHeadR = new Rectangle(0, availR.y, 0, 0);
        int upperHeight = this.getUpperHeight();
        if (this.colHead != null && this.colHead.isVisible()) {
            int colHeadHeight;
            colHeadR.height = colHeadHeight = Math.min(availR.height, upperHeight);
            availR.y += colHeadHeight;
            availR.height -= colHeadHeight;
        }
        int subUpperHeight = this.getSubUpperHeight();
        Rectangle subColHeadR = new Rectangle(0, availR.y, 0, 0);
        if (this._subColHead != null && this._subColHead.isVisible()) {
            int subColHeadHeight;
            subColHeadR.height = subColHeadHeight = Math.min(availR.height, subUpperHeight);
            availR.y += subColHeadHeight;
            availR.height -= subColHeadHeight;
        }
        Rectangle rowHeadR = new Rectangle(0, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int rowHeadWidth = this.rowHead.getPreferredSize().width;
            if (this.upperLeft != null && this.upperLeft.isVisible()) {
                rowHeadWidth = Math.max(rowHeadWidth, this.upperLeft.getPreferredSize().width);
            }
            if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
                rowHeadWidth = Math.max(rowHeadWidth, this.lowerLeft.getPreferredSize().width);
            }
            if (this._subUpperLeft != null && this._subUpperLeft.isVisible()) {
                rowHeadWidth = Math.max(rowHeadWidth, this._subUpperLeft.getPreferredSize().width);
            }
            rowHeadR.width = rowHeadWidth;
            availR.width -= rowHeadWidth;
            rowHeadR.x = availR.x;
            availR.x += rowHeadWidth;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            vpbInsets = viewportBorder.getBorderInsets(parent);
            availR.x += vpbInsets.left;
            availR.y += vpbInsets.top;
            availR.width -= vpbInsets.left + vpbInsets.right;
            availR.height -= vpbInsets.top + vpbInsets.bottom;
        } else {
            vpbInsets = new Insets(0, 0, 0, 0);
        }
        Rectangle rowFootR = new Rectangle(0, 0, 0, 0);
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            int rowFootWidth = this._rowFoot.getPreferredSize().width;
            if (this.upperRight != null && this.upperRight.isVisible()) {
                rowFootWidth = Math.max(rowFootWidth, this.upperRight.getPreferredSize().width);
            }
            if (this._subUpperRight != null && this._subUpperRight.isVisible()) {
                rowFootWidth = Math.max(rowFootWidth, this._subUpperRight.getPreferredSize().width);
            }
            if (this.lowerRight != null && this.lowerRight.isVisible()) {
                rowFootWidth = Math.max(rowFootWidth, this.lowerRight.getPreferredSize().width);
            }
            rowFootR.width = rowFootWidth;
            availR.width -= rowFootWidth;
            rowFootR.x = availR.x + availR.width;
        }
        Rectangle colFootR = new Rectangle(0, availR.y, 0, 0);
        int lowerHeight = this.getLowerHeight();
        if (this._colFoot != null && this._colFoot.isVisible()) {
            int colFootHeight;
            colFootR.height = colFootHeight = Math.min(availR.height, lowerHeight);
            availR.height -= colFootHeight;
            colFootR.y = availR.y + availR.height;
        }
        Component view = this.viewport != null ? this.viewport.getView() : null;
        Dimension viewPrefSize = view != null ? view.getPreferredSize() : new Dimension(0, 0);
        Dimension extentSize = this.viewport != null ? this.viewport.toViewCoordinates(availR.getSize()) : new Dimension(0, 0);
        boolean viewTracksViewportWidth = false;
        boolean viewTracksViewportHeight = false;
        boolean bl2 = isEmpty = availR.width < 0 || availR.height < 0;
        if (!isEmpty && view instanceof Scrollable && !flatLayout) {
            sv = (Scrollable)((Object)view);
            viewTracksViewportWidth = sv.getScrollableTracksViewportWidth();
            viewTracksViewportHeight = sv.getScrollableTracksViewportHeight();
        } else {
            sv = null;
        }
        Rectangle vsbR = new Rectangle(0, this.isVsbCoversWholeHeight(scrollPane) ? insets.top : availR.y - vpbInsets.top, 0, 0);
        if (this.vsbPolicy == 22) {
            vsbNeeded = true;
        } else if (this.vsbPolicy == 21) {
            vsbNeeded = false;
        } else if (isEmpty) {
            vsbNeeded = false;
        } else {
            boolean bl3 = vsbNeeded = !viewTracksViewportHeight && (viewPrefSize.height > extentSize.height || this.rowHead != null && this.rowHead.getView() != null && this.rowHead.getView().getPreferredSize().height > extentSize.height);
            if (!vsbNeeded && scrollPane instanceof JideScrollPane && ((JideScrollPane)scrollPane).isKeepCornerVisible() && (this._vBottom != null || this._vTop != null)) {
                vsbNeeded = true;
            }
        }
        if (flatLayout) {
            vsbNeeded = false;
        }
        if (this.vsb != null && vsbNeeded) {
            this.adjustForVSB(true, availR, vsbR, vpbInsets, true);
            extentSize = this.viewport.toViewCoordinates(availR.getSize());
        }
        Rectangle hsbR = new Rectangle(this.isHsbCoversWholeWidth(scrollPane) ? insets.left : availR.x - vpbInsets.left, 0, 0, 0);
        if (this.hsbPolicy == 32) {
            hsbNeeded = true;
        } else if (this.hsbPolicy == 31) {
            hsbNeeded = false;
        } else if (isEmpty) {
            hsbNeeded = false;
        } else {
            boolean bl4 = hsbNeeded = !viewTracksViewportWidth && (viewPrefSize.width > extentSize.width || this.colHead != null && this.colHead.getView() != null && this.colHead.getView().getPreferredSize().width > extentSize.width);
            if (!hsbNeeded && scrollPane instanceof JideScrollPane && ((JideScrollPane)scrollPane).isKeepCornerVisible() && (this._hLeft != null || this._hRight != null)) {
                hsbNeeded = true;
            }
        }
        if (flatLayout) {
            hsbNeeded = false;
        }
        if (this.hsb != null && hsbNeeded) {
            this.adjustForHSB(true, availR, hsbR, vpbInsets);
            if (this.vsb != null && !vsbNeeded && this.vsbPolicy != 21) {
                extentSize = this.viewport.toViewCoordinates(availR.getSize());
                boolean bl5 = vsbNeeded = viewPrefSize.height > extentSize.height;
                if (!vsbNeeded && scrollPane instanceof JideScrollPane && ((JideScrollPane)scrollPane).isKeepCornerVisible() && (this._vBottom != null || this._vTop != null)) {
                    vsbNeeded = true;
                }
                if (vsbNeeded) {
                    this.adjustForVSB(true, availR, vsbR, vpbInsets, true);
                }
            }
        }
        boolean ltr = scrollPane.getComponentOrientation().isLeftToRight();
        if (this.viewport != null) {
            this.viewport.setBounds(this.adjustBounds(parent, availR, ltr));
            if (sv != null) {
                extentSize = this.viewport.toViewCoordinates(availR.getSize());
                boolean oldHSBNeeded = hsbNeeded;
                boolean oldVSBNeeded = vsbNeeded;
                viewTracksViewportWidth = sv.getScrollableTracksViewportWidth();
                viewTracksViewportHeight = sv.getScrollableTracksViewportHeight();
                if (this.vsb != null && this.vsbPolicy == 20 && !flatLayout) {
                    boolean newVSBNeeded;
                    boolean bl6 = newVSBNeeded = !viewTracksViewportHeight && (viewPrefSize.height > extentSize.height || this.rowHead != null && this.rowHead.getView() != null && this.rowHead.getView().getPreferredSize().height > extentSize.height);
                    if (!newVSBNeeded && scrollPane instanceof JideScrollPane && ((JideScrollPane)scrollPane).isKeepCornerVisible() && (this._vBottom != null || this._vTop != null)) {
                        newVSBNeeded = true;
                    }
                    if (newVSBNeeded != vsbNeeded) {
                        vsbNeeded = newVSBNeeded;
                        this.adjustForVSB(vsbNeeded, availR, vsbR, vpbInsets, true);
                        extentSize = this.viewport.toViewCoordinates(availR.getSize());
                    }
                }
                if (this.hsb != null && this.hsbPolicy == 30 && !flatLayout) {
                    boolean newHSBbNeeded;
                    boolean bl7 = newHSBbNeeded = !viewTracksViewportWidth && (viewPrefSize.width > extentSize.width || this.colHead != null && this.colHead.getView() != null && this.colHead.getView().getPreferredSize().width > extentSize.width);
                    if (!newHSBbNeeded && scrollPane instanceof JideScrollPane && ((JideScrollPane)scrollPane).isKeepCornerVisible() && (this._hLeft != null || this._hRight != null)) {
                        newHSBbNeeded = true;
                    }
                    if (newHSBbNeeded != hsbNeeded) {
                        hsbNeeded = newHSBbNeeded;
                        this.adjustForHSB(hsbNeeded, availR, hsbR, vpbInsets);
                        if (this.vsb != null && !vsbNeeded && this.vsbPolicy != 21) {
                            extentSize = this.viewport.toViewCoordinates(availR.getSize());
                            boolean bl8 = vsbNeeded = viewPrefSize.height > extentSize.height;
                            if (!vsbNeeded && scrollPane instanceof JideScrollPane && ((JideScrollPane)scrollPane).isKeepCornerVisible() && (this._vBottom != null || this._vTop != null)) {
                                vsbNeeded = true;
                            }
                            if (vsbNeeded) {
                                this.adjustForVSB(true, availR, vsbR, vpbInsets, true);
                            }
                        }
                        if (this._rowFoot != null && this._rowFoot.isVisible()) {
                            vsbR.x += rowFootR.width;
                        }
                    }
                }
                if (oldHSBNeeded != hsbNeeded || oldVSBNeeded != vsbNeeded) {
                    this.viewport.setBounds(this.adjustBounds(parent, availR, ltr));
                }
            }
        }
        vsbR.height = this.isVsbCoversWholeHeight(scrollPane) ? scrollPane.getHeight() - insets.bottom - insets.top : availR.height + vpbInsets.top + vpbInsets.bottom;
        hsbR.width = this.isHsbCoversWholeWidth(scrollPane) ? scrollPane.getWidth() - vsbR.width - insets.left - insets.right : availR.width + vpbInsets.left + vpbInsets.right;
        rowHeadR.height = availR.height + vpbInsets.top + vpbInsets.bottom;
        rowHeadR.y = availR.y - vpbInsets.top;
        colHeadR.width = availR.width + vpbInsets.left + vpbInsets.right;
        colHeadR.x = availR.x - vpbInsets.left;
        subColHeadR.width = colHeadR.width;
        subColHeadR.x = colHeadR.x;
        colFootR.x = availR.x;
        colFootR.y = rowHeadR.y + rowHeadR.height;
        colFootR.width = availR.width;
        rowFootR.x = availR.x + availR.width;
        rowFootR.y = availR.y;
        rowFootR.height = availR.height;
        vsbR.x += rowFootR.width;
        hsbR.y += colFootR.height;
        if (this.rowHead != null) {
            this.rowHead.setBounds(this.adjustBounds(parent, rowHeadR, ltr));
        }
        if (this._rowFoot != null) {
            this._rowFoot.setBounds(this.adjustBounds(parent, rowFootR, ltr));
        }
        int n2 = this.isColumnHeadersHeightUnified(scrollPane) ? Math.max(colHeadR.height, Math.max(this.upperLeft == null ? 0 : this.upperLeft.getPreferredSize().height, this.upperRight == null ? 0 : this.upperRight.getPreferredSize().height)) : (columnHeaderHeight = 0);
        int n3 = this.isColumnFootersHeightUnified(scrollPane) ? Math.max(colFootR.height, Math.max(this.lowerLeft == null ? 0 : this.lowerLeft.getPreferredSize().height, this.lowerRight == null ? 0 : this.lowerRight.getPreferredSize().height)) : (columnFooterHeight = 0);
        if (this.colHead != null) {
            height = this.isColumnHeadersHeightUnified(scrollPane) ? columnHeaderHeight : Math.min(colHeadR.height, this.colHead.getPreferredSize().height);
            this.colHead.setBounds(this.adjustBounds(parent, new Rectangle(colHeadR.x, colHeadR.y + colHeadR.height - height, colHeadR.width, height), ltr));
        }
        if (this._subColHead != null) {
            this._subColHead.setBounds(this.adjustBounds(parent, subColHeadR, ltr));
        }
        if (this._colFoot != null) {
            height = this.isColumnFootersHeightUnified(scrollPane) ? columnFooterHeight : Math.min(colFootR.height, this._colFoot.getPreferredSize().height);
            this._colFoot.setBounds(this.adjustBounds(parent, new Rectangle(colFootR.x, colFootR.y, colFootR.width, height), ltr));
        } else if (this.isColumnFootersHeightUnified(scrollPane)) {
            columnFooterHeight = hsbR.height;
        }
        if (this.vsb != null) {
            if (vsbNeeded) {
                this.vsb.setVisible(true);
                if (this.vsbPolicy == 20 && !isEmpty && (viewTracksViewportHeight || viewPrefSize.height <= extentSize.height && (this.rowHead == null || this.rowHead.getView() == null || this.rowHead.getView().getPreferredSize().height <= extentSize.height))) {
                    this.vsb.setVisible(false);
                }
                if (this._vTop == null && this._vBottom == null) {
                    this.vsb.setBounds(this.adjustBounds(parent, vsbR, ltr));
                } else {
                    Rectangle rect = new Rectangle(vsbR);
                    if (this._vTop != null) {
                        dim = this._vTop.getPreferredSize();
                        rect.y += dim.height;
                        rect.height -= dim.height;
                        this._vTop.setVisible(true);
                        this._vTop.setBounds(this.adjustBounds(parent, new Rectangle(vsbR.x, vsbR.y, vsbR.width, dim.height), ltr));
                    }
                    if (this._vBottom != null) {
                        dim = this._vBottom.getPreferredSize();
                        rect.height -= dim.height;
                        this._vBottom.setVisible(true);
                        this._vBottom.setBounds(this.adjustBounds(parent, new Rectangle(vsbR.x, vsbR.y + vsbR.height - dim.height, vsbR.width, dim.height), ltr));
                    }
                    this.vsb.setBounds(this.adjustBounds(parent, rect, ltr));
                }
            } else {
                if (viewPrefSize.height > extentSize.height && !flatLayout) {
                    this.vsb.setVisible(true);
                    this.vsb.setBounds(this.adjustBounds(parent, new Rectangle(vsbR.x, vsbR.y, 0, vsbR.height), ltr));
                } else {
                    this.vsb.setVisible(false);
                }
                if (this._vTop != null) {
                    this._vTop.setVisible(false);
                }
                if (this._vBottom != null) {
                    this._vBottom.setVisible(false);
                }
            }
        }
        if (this.hsb != null) {
            if (hsbNeeded) {
                this.hsb.setVisible(true);
                if (this.hsbPolicy == 30 && !isEmpty && (viewTracksViewportWidth || viewPrefSize.width <= extentSize.width && (this.colHead == null || this.colHead.getView() == null || this.colHead.getView().getPreferredSize().width <= extentSize.width))) {
                    this.hsb.setVisible(false);
                }
                if (this._hLeft == null && this._hRight == null) {
                    this.hsb.setBounds(this.adjustBounds(parent, hsbR, ltr));
                } else {
                    Rectangle rect = new Rectangle(hsbR);
                    if (this._hLeft != null) {
                        dim = this._hLeft.getPreferredSize();
                        rect.x += dim.width;
                        rect.width -= dim.width;
                        this._hLeft.setVisible(true);
                        this._hLeft.setBounds(this.adjustBounds(parent, new Rectangle(hsbR.x, hsbR.y, dim.width, hsbR.height), ltr));
                        this._hLeft.doLayout();
                    }
                    if (this._hRight != null) {
                        dim = this._hRight.getPreferredSize();
                        rect.width -= dim.width;
                        this._hRight.setVisible(true);
                        this._hRight.setBounds(this.adjustBounds(parent, new Rectangle(hsbR.x + hsbR.width - dim.width, hsbR.y, dim.width, hsbR.height), ltr));
                    }
                    this.hsb.setBounds(this.adjustBounds(parent, rect, ltr));
                }
            } else {
                if (viewPrefSize.width > extentSize.width && !flatLayout) {
                    this.hsb.setVisible(true);
                    this.hsb.setBounds(this.adjustBounds(parent, new Rectangle(hsbR.x, hsbR.y, hsbR.width, 0), ltr));
                } else {
                    this.hsb.setVisible(false);
                }
                if (this._hLeft != null) {
                    this._hLeft.setVisible(false);
                }
                if (this._hRight != null) {
                    this._hRight.setVisible(false);
                }
            }
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            int height2 = this.isColumnFootersHeightUnified(scrollPane) ? columnFooterHeight : Math.min(this.lowerLeft.getPreferredSize().height, colFootR.height);
            this.lowerLeft.setBounds(this.adjustBounds(parent, new Rectangle(rowHeadR.x, colFootR.y != 0 ? colFootR.y : hsbR.y, rowHeadR.width, height2), ltr));
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            int height3 = this.isColumnFootersHeightUnified(scrollPane) ? columnFooterHeight : Math.min(this.lowerRight.getPreferredSize().height, colFootR.height);
            this.lowerRight.setBounds(this.adjustBounds(parent, new Rectangle(rowFootR.x, colFootR.y != 0 ? colFootR.y : hsbR.y, rowFootR.width + (this.isVsbCoversWholeHeight(scrollPane) || rowFootR.width != 0 ? 0 : vsbR.width), height3), ltr));
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            int height4 = this.isColumnHeadersHeightUnified(scrollPane) ? columnHeaderHeight : Math.min(this.upperLeft.getPreferredSize().height, colHeadR.height);
            this.upperLeft.setBounds(this.adjustBounds(parent, new Rectangle(rowHeadR.x, colHeadR.y + colHeadR.height - height4, rowHeadR.width, height4), ltr));
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            int height5 = this.isColumnHeadersHeightUnified(scrollPane) ? columnHeaderHeight : Math.min(this.upperRight.getPreferredSize().height, colHeadR.height);
            this.upperRight.setBounds(this.adjustBounds(parent, new Rectangle(rowFootR.x, colHeadR.y + colHeadR.height - height5, rowFootR.width + (this.isVsbCoversWholeHeight(scrollPane) || rowFootR.width != 0 ? 0 : vsbR.width), height5), ltr));
        }
        if (this._subUpperLeft != null && this._subUpperLeft.isVisible()) {
            int height6 = Math.min(this._subUpperLeft.getPreferredSize().height, this.getSubUpperHeight());
            this._subUpperLeft.setBounds(this.adjustBounds(parent, new Rectangle(rowHeadR.x, subColHeadR.y + subColHeadR.height - height6, rowHeadR.width, height6), ltr));
        }
        if (this._subUpperRight != null && this._subUpperRight.isVisible()) {
            int height7 = Math.min(this._subUpperRight.getPreferredSize().height, this.getSubUpperHeight());
            this._subUpperRight.setBounds(this.adjustBounds(parent, new Rectangle(rowFootR.x, subColHeadR.y + subColHeadR.height - height7, rowFootR.width + (this.isVsbCoversWholeHeight(scrollPane) || rowFootR.width != 0 ? 0 : vsbR.width), height7), ltr));
        }
    }

    private Rectangle adjustBounds(Container container, Rectangle rect, boolean ltr) {
        if (ltr) {
            return rect;
        }
        Rectangle r2 = new Rectangle(rect);
        int w2 = container.getWidth();
        r2.x = w2 - (rect.x + rect.width);
        return r2;
    }

    private void adjustForVSB(boolean wantsVSB, Rectangle available, Rectangle vsbR, Insets vpbInsets, boolean leftToRight) {
        int oldWidth = vsbR.width;
        if (wantsVSB) {
            int vsbWidth = Math.max(0, this.vsb.getPreferredSize().width);
            available.width -= vsbWidth;
            vsbR.width = vsbWidth;
            if (leftToRight) {
                vsbR.x = available.x + available.width + vpbInsets.right;
            } else {
                vsbR.x = available.x - vpbInsets.left;
                available.x += vsbWidth;
            }
        } else {
            available.width += oldWidth;
        }
    }

    private void adjustForHSB(boolean wantsHSB, Rectangle available, Rectangle hsbR, Insets vpbInsets) {
        int oldHeight = hsbR.height;
        if (wantsHSB) {
            int hsbHeight = Math.max(0, this.hsb.getPreferredSize().height);
            available.height -= hsbHeight;
            hsbR.y = available.y + available.height + vpbInsets.bottom;
            hsbR.height = hsbHeight;
        } else {
            available.height += oldHeight;
        }
    }

    static class UIResource
    extends JideScrollPaneLayout
    implements javax.swing.plaf.UIResource {
        private static final long serialVersionUID = 1057343395078846689L;

        UIResource() {
        }
    }
}

